/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.web.controller.archive;

import com.suncode.cuf.archive.DocumentHelper;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.web.util.JsonMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"cuf/document"})
public class DocumentController {
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    @Autowired
    private DocumentHelper helper;
    @Autowired
    private FileService fs;

    @RequestMapping(value={"description/change"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonMessage changeDescription(@RequestParam Long fileId, @RequestParam String description) {
        log.debug("Changing file description: fileId=[{}] description=[{}]", (Object)fileId, (Object)description);
        this.helper.changeDescription(fileId, description);
        return new JsonMessage();
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonMessage deleteDocuments(@RequestParam List<Long> fileIds) {
        log.debug("Deleting documents: fileIds=[{}]", fileIds);
        for (Long id : fileIds) {
            this.fs.deleteFile(id);
        }
        return new JsonMessage();
    }
}

