/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.database.dataFileSync.ListConf;
import com.plusmpm.CUF.database.dataFileSync.ListConfManager;
import com.plusmpm.CUF.util.extension.DBService;
import com.plusmpm.CUF.util.extension.ExcelWriter;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;

public class ExportDBTableToXls {
    private Logger log = Logger.getLogger(ExportDBTableToXls.class);

    @AdvancedTask(name="exportDBTableToXls", description="exportDBTableToXls_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void exportToXls(@TaskParam(name="Nazwa konfiguracji", description="Nazwa konfiguracji") String configName, @TaskParam(name="\u015acie\u017cka do pliku Excel", description="\u015acie\u017cka do pliku Excel") String filePath) throws HibernateException, Exception {
        ListConf lc = ListConfManager.getListConfByName(configName);
        String tableName = lc.getTableName();
        String[] types = lc.getColumnsTypesTab();
        String[] cols = lc.getColumnsTab();
        Map<String, Class<?>> excelTypes = this.convertTypes(types, cols);
        DBService dbs = new DBService();
        List<Map<String, Object>> data = dbs.getDataFromTable(tableName);
        ExcelWriter ew = new ExcelWriter();
        File file = new File(filePath);
        FileOutputStream fos = new FileOutputStream(file);
        ew.setExtension("xls");
        ew.setHeaders(cols);
        ew.setExcelTypes(excelTypes);
        ew.generateExcel(data, fos);
    }

    private Map<String, Class<?>> convertTypes(String[] types, String[] cols) {
        HashMap exTypes = new HashMap();
        for (int i = 0; i < cols.length; ++i) {
            if (types[i].equals("integer")) {
                exTypes.put(cols[i], Integer.class);
                continue;
            }
            if (types[i].equals("float")) {
                exTypes.put(cols[i], Double.class);
                continue;
            }
            if (types[i].equals("timestamp")) {
                exTypes.put(cols[i], Date.class);
                continue;
            }
            exTypes.put(cols[i], String.class);
        }
        return exTypes;
    }
}

