/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.archive.internal;

import com.suncode.cuf.archive.ProcessDocumentHelper;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessDocumentHelperImpl
implements ProcessDocumentHelper {
    @Autowired
    private FileFinder fs;
    @Autowired
    private DocumentFinder df;

    @Override
    public List<WfDocument> getDocumentsAttachedInStage(String processId, String activityDefId, String ... joins) {
        DetachedCriteria dc = DetachedCriteria.forClass(WfFile.class);
        dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        dc.createAlias("activityDocuments", "activityDocuments");
        dc.createAlias("activityDocuments.process", "process");
        dc.add((Criterion)Restrictions.eq((String)"process.processId", (Object)processId));
        dc.createAlias("activityDocuments.activity", "activity");
        dc.add((Criterion)Restrictions.eq((String)"activity.activityDefinitionId", (Object)activityDefId));
        dc.add((Criterion)Restrictions.eq((String)"activityDocuments.addedHere", (Object)true));
        dc.createAlias("version", "version", JoinType.LEFT_OUTER_JOIN);
        dc.createAlias("version.file", "version.file", JoinType.LEFT_OUTER_JOIN);
        dc.createAlias("version.newestFile", "version.newestFile", JoinType.LEFT_OUTER_JOIN);
        dc.add((Criterion)Restrictions.eqProperty((String)"version.file.id", (String)"version.newestFile.id"));
        for (String join : joins) {
            dc.setFetchMode(join, FetchMode.JOIN);
        }
        List files = this.fs.findByCriteria(dc);
        List<WfDocument> documents = this.convertFilesToDocuments(files);
        return documents;
    }

    protected List<WfDocument> convertFilesToDocuments(List<WfFile> files) {
        ArrayList<WfDocument> documents = new ArrayList<WfDocument>();
        for (WfFile wfFile : files) {
            WfDocument doc = this.df.findByFileId(Long.valueOf(wfFile.getId()), wfFile.getDocumentClass().getId());
            documents.add(doc);
        }
        return documents;
    }

    @Override
    public List<WfDocument> getDocumentsAttachedInActivity(String processId, String activityId, String ... joins) {
        DetachedCriteria dc = DetachedCriteria.forClass(WfFile.class);
        dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        dc.createAlias("activityDocuments", "activityDocuments");
        dc.createAlias("activityDocuments.process", "process");
        dc.add((Criterion)Restrictions.eq((String)"process.processId", (Object)processId));
        dc.createAlias("activityDocuments.activity", "activity");
        dc.add((Criterion)Restrictions.eq((String)"activity.activityId", (Object)activityId));
        dc.add((Criterion)Restrictions.eq((String)"activityDocuments.addedHere", (Object)true));
        dc.createAlias("version", "version", JoinType.LEFT_OUTER_JOIN);
        dc.createAlias("version.file", "version.file", JoinType.LEFT_OUTER_JOIN);
        dc.createAlias("version.newestFile", "version.newestFile", JoinType.LEFT_OUTER_JOIN);
        dc.add((Criterion)Restrictions.eqProperty((String)"version.file.id", (String)"version.newestFile.id"));
        for (String join : joins) {
            dc.setFetchMode(join, FetchMode.JOIN);
        }
        List files = this.fs.findByCriteria(dc);
        List<WfDocument> documents = this.convertFilesToDocuments(files);
        return documents;
    }
}

