/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.web.controller.form;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.CUF.database.formTemplate.FormTemplate;
import com.plusmpm.CUF.database.formTemplate.FormTemplateException;
import com.plusmpm.CUF.database.formTemplate.FromTemplateService;
import com.suncode.cuf.web.dto.form.FormTemplateDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.SessionUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"cuf/form"}, produces={"application/json"})
public class FormTemplateController {
    private static final String CATEGORY_CONST = "::";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ResponseBody
    @RequestMapping(value={"/templates"}, method={RequestMethod.POST})
    public ResponseEntity<RestResult> saveTemplate(@RequestBody FormTemplateDto templateDto) throws Exception {
        Assert.isTrue((!templateDto.getName().contains(CATEGORY_CONST) ? 1 : 0) != 0);
        FromTemplateService templateService = new FromTemplateService();
        templateDto.setOwner(SessionUtils.getLoggedUserName());
        templateDto.setVersion(2);
        FormTemplate template = this.convert(templateDto);
        template.setVersion(2);
        templateService.save(template);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @ResponseBody
    @RequestMapping(value={"/templates"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateTemplate(@RequestBody FormTemplateDto template) throws Exception {
        if (!SessionUtils.getLoggedUserName().equals(template.getOwner())) {
            throw new SecurityException("User [" + SessionUtils.getLoggedUserName() + "] is not template owner");
        }
        FromTemplateService templateService = new FromTemplateService();
        if (template.isDefaultTemplate()) {
            this.logger.debug("Setting user [{}] default template {}", (Object)template.getOwner(), (Object)template.getName());
            templateService.setDefault(template.getActivityType(), template.getProcessType(), template.getOwner(), template.getCategory(), template.getName());
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ResponseBody
    @RequestMapping(value={"/templates/{processType}/{activityType}/{user}/{templateName}"}, method={RequestMethod.GET})
    public ResponseEntity<FormTemplateDto> getTemplate(@PathVariable String user, @PathVariable String processType, @PathVariable String activityType, @PathVariable String templateName) throws Exception {
        return this.getTemplate(user, processType, activityType, templateName, null);
    }

    @ResponseBody
    @RequestMapping(value={"/templates/{processType}/{activityType}/{user}/{templateName}/{category}"}, method={RequestMethod.GET})
    public ResponseEntity<FormTemplateDto> getTemplate(@PathVariable String user, @PathVariable String processType, @PathVariable String activityType, @PathVariable String templateName, @PathVariable String category) throws Exception {
        FromTemplateService templateService = new FromTemplateService();
        FormTemplate template = templateService.get(activityType, processType, user = this.unescapeUser(user), category, templateName);
        if (template == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.convert(template), HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(value={"/templates/default/{processType}/{activityType}/{user}"}, method={RequestMethod.GET})
    public ResponseEntity<FormTemplateDto> getDefaultTemplate(@PathVariable String user, @PathVariable String processType, @PathVariable String activityType) throws Exception {
        return this.getDefaultTemplate(user, processType, activityType, null);
    }

    @ResponseBody
    @RequestMapping(value={"/templates/default/{processType}/{activityType}/{user}/{category}"}, method={RequestMethod.GET})
    public ResponseEntity<FormTemplateDto> getDefaultTemplate(@PathVariable String user, @PathVariable String processType, @PathVariable String activityType, @PathVariable String category) throws Exception {
        FromTemplateService templateService = new FromTemplateService();
        FormTemplate template = templateService.getDefault(activityType, processType, user = this.unescapeUser(user), category);
        if (template == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.convert(template), HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(value={"/templates/{processType}/{activityType}/{user}/{templateName}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteTemplate(@PathVariable String user, @PathVariable String processType, @PathVariable String activityType, @PathVariable String templateName) throws Exception {
        return this.deleteTemplate(user, processType, activityType, templateName, null);
    }

    @ResponseBody
    @RequestMapping(value={"/templates/{processType}/{activityType}/{user}/{category}/{templateName}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteTemplate(@PathVariable String user, @PathVariable String processType, @PathVariable String activityType, @PathVariable String templateName, @PathVariable String category) throws Exception {
        user = this.unescapeUser(user);
        if (!SessionUtils.getLoggedUserName().equals(user)) {
            throw new SecurityException("User [" + user + "] is not template owner");
        }
        FormTemplate template = new FormTemplate();
        template.setTemplateName(templateName);
        template.setUserId(user);
        template.setProcessDefId(processType);
        template.setActivityDefId(activityType);
        FromTemplateService templateService = new FromTemplateService();
        templateService.delete(template);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ResponseBody
    @RequestMapping(value={"/templates/query"}, method={RequestMethod.GET})
    public List<FormTemplateDto> queryTemplate(@RequestParam(required=false) String user, @RequestParam(required=false) String process, @RequestParam(required=false) String activity, @RequestParam(required=false) String category) throws Exception {
        FromTemplateService templateService = new FromTemplateService();
        List<FormTemplate> templates = templateService.findByAny(process, activity, user, category);
        ArrayList<FormTemplateDto> result = new ArrayList<FormTemplateDto>();
        for (FormTemplate template : templates) {
            try {
                result.add(this.convert(template));
            }
            catch (Exception e) {
                this.logger.warn("Form template ({}:{}:{}:{}:{}) could not be converted to DTO", new Object[]{template.getUserId(), template.getProcessDefId(), template.getActivityDefId(), template.getTemplateName(), template.getCategory(), e});
            }
        }
        return result;
    }

    @ExceptionHandler(value={FormTemplateException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleFormTemplateException(FormTemplateException exception) {
        this.logger.error("Form template exception occured:", (Throwable)exception);
        return new RestResult(false, exception.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public RestResult handleError(Exception exception) {
        this.logger.error("Unexpected error occured:", (Throwable)exception);
        return new RestResult(false);
    }

    private String unescapeUser(String user) {
        return user.replace("+", "/");
    }

    private FormTemplate convert(FormTemplateDto templateDto) throws JsonProcessingException {
        if (templateDto == null) {
            return null;
        }
        FormTemplate template = new FormTemplate();
        template.setTemplateName(templateDto.getName());
        template.setCategory(templateDto.getCategory());
        template.setProcessDefId(templateDto.getProcessType());
        template.setActivityDefId(templateDto.getActivityType());
        template.setDefault(templateDto.isDefaultTemplate());
        template.setUserId(SessionUtils.getLoggedUserName());
        ObjectMapper mapper = new ObjectMapper();
        template.setData(mapper.writeValueAsString((Object)templateDto));
        this.logger.debug("Serialized template JSON: {}", (Object)template.getData());
        template.setVersion(templateDto.getVersion());
        return template;
    }

    private FormTemplateDto convert(FormTemplate template) throws Exception {
        if (template == null) {
            return null;
        }
        this.logger.debug("Deserializing template JSON: {}", (Object)template.getData());
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        FormTemplateDto dto = (FormTemplateDto)mapper.readValue(template.getData(), FormTemplateDto.class);
        dto.setName(template.getTemplateName());
        dto.setCategory(template.getCategory());
        dto.setProcessType(template.getProcessDefId());
        dto.setActivityType(template.getActivityDefId());
        dto.setOwner(template.getUserId());
        dto.setVersion(template.getVersion());
        dto.setDefaultTemplate(template.getDefault());
        return dto;
    }
}

