/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.SheetDefinition;
import com.suncode.cuf.util.collection.map.MapUtils;
import java.util.List;
import java.util.Map;

public class StructureData {
    private List<Map<String, String>> users;
    private List<Map<String, String>> positions;
    private List<Map<String, String>> orgUnits;
    private List<Map<String, String>> groups;

    public StructureData(List<SheetDefinition> sheets) {
        this.groups = MapUtils.valuesToString(this.getSheet(sheets, "Grupy"));
        this.orgUnits = MapUtils.valuesToString(this.getSheet(sheets, "Jednostki organizacyjne"));
        this.positions = MapUtils.valuesToString(this.getSheet(sheets, "Stanowiska"));
        this.users = MapUtils.valuesToString(this.getSheet(sheets, "U\u017cytkownicy"));
    }

    private List<Map<String, Object>> getSheet(List<SheetDefinition> struct, String name) {
        for (SheetDefinition excelSheet : struct) {
            if (!excelSheet.getName().equals(name)) continue;
            return excelSheet.getData();
        }
        throw new CUFServiceException("Sheet with name " + name + " not found");
    }

    public List<Map<String, String>> getUsers() {
        return this.users;
    }

    public void setUsers(List<Map<String, String>> users) {
        this.users = users;
    }

    public List<Map<String, String>> getPositions() {
        return this.positions;
    }

    public void setPositions(List<Map<String, String>> positions) {
        this.positions = positions;
    }

    public List<Map<String, String>> getOrgUnits() {
        return this.orgUnits;
    }

    public void setOrgUnits(List<Map<String, String>> orgUnits) {
        this.orgUnits = orgUnits;
    }

    public List<Map<String, String>> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Map<String, String>> groups) {
        this.groups = groups;
    }
}

