/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.hibernate.HibernateUtil;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CUFHibernateUtil {
    public static Logger log = Logger.getLogger(CUFHibernateUtil.class);
    private static String CUF_HIBERNATE = "CUFHibernate.cfg.xml";
    private static Configuration configuration = new Configuration();
    private static SessionFactory sessionFactory;
    private static final ThreadLocal threadLocal;

    private CUFHibernateUtil() {
    }

    public static void initSessionFactory() {
        log.trace((Object)"************* initSessionFactory() **************");
        try {
            sessionFactory = null;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebuildSessionFactory() {
        log.trace((Object)"************* rebuildSessionFactory() **************");
        InputStream is = null;
        String xmlContent = "";
        Document xmlFile = null;
        try {
            String dialectProperty = "";
            Dialect dialect = HibernateUtil.getDialect();
            if (dialect != null) {
                dialectProperty = dialect.toString();
                String sJarFilePath = CUFHibernateUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                if (sJarFilePath != null) {
                    if (sJarFilePath.endsWith(".jar") || sJarFilePath.endsWith(".JAR")) {
                        log.info((Object)("Poczatkowa sciezka do pliku hibernate biblioteki Common Used Functions: " + sJarFilePath));
                        JarFile jarFile = new JarFile(sJarFilePath);
                        JarEntry jarEntry = jarFile.getJarEntry(CUF_HIBERNATE);
                        is = jarFile.getInputStream(jarEntry);
                        xmlContent = CUFTools.convertXMLFileToStringFromInputStream(is);
                        xmlFile = CUFTools.convertStringToXMLFile(xmlContent);
                        if (xmlFile != null) {
                            xmlFile = CUFHibernateUtil.setDialectInHibernate(xmlFile, dialectProperty);
                            configuration.configure(xmlFile);
                            log.info((Object)("Ustawiono dialekt na " + dialectProperty));
                        } else {
                            configuration.configure(CUF_HIBERNATE);
                            log.warn((Object)"Ustawiono domyslny dialekt dla Postgres. Moze to spowodowac niepoprawne dzialanie biblioteki Common Used Functions");
                        }
                    } else {
                        String filePath = "";
                        int pos = sJarFilePath.lastIndexOf("com/plusmpm");
                        if (pos != -1) {
                            sJarFilePath = sJarFilePath.substring(0, pos);
                            log.info((Object)("Poczatkowa sciezka do pliku hibernate biblioteki Common Used Functions: " + sJarFilePath));
                            filePath = sJarFilePath.endsWith("/") ? sJarFilePath + CUF_HIBERNATE : sJarFilePath + "/" + CUF_HIBERNATE;
                            xmlContent = CUFTools.convertXMLFileToStringFromFilePath(filePath);
                            xmlFile = CUFTools.convertStringToXMLFile(xmlContent);
                            if (xmlFile != null) {
                                xmlFile = CUFHibernateUtil.setDialectInHibernate(xmlFile, dialectProperty);
                                configuration.configure(xmlFile);
                                log.info((Object)("Ustawiono dialekt na " + dialectProperty));
                            } else {
                                configuration.configure(CUF_HIBERNATE);
                                log.warn((Object)"Ustawiono domyslny dialekt dla Postgres. Moze to spowodowac niepoprawne dzialanie biblioteki Common Used Functions");
                            }
                        } else {
                            configuration.configure(CUF_HIBERNATE);
                            log.warn((Object)"Ustawiono domyslny dialekt dla Postgres. Moze to spowodowac niepoprawne dzialanie biblioteki Common Used Functions");
                        }
                    }
                } else {
                    configuration.configure(CUF_HIBERNATE);
                    log.warn((Object)"Ustawiono domyslny dialekt dla Postgres. Moze to spowodowac niepoprawne dzialanie biblioteki Common Used Functions");
                }
            } else {
                configuration.configure(CUF_HIBERNATE);
                log.warn((Object)"Ustawiono domyslny dialekt dla Postgres. Moze to spowodowac niepoprawne dzialanie biblioteki Common Used Functions");
            }
            sessionFactory = configuration.buildSessionFactory();
            log.info((Object)("Stworzono konfiguracje Hibernate dla biblioteki Common Used Functions z pliku " + CUF_HIBERNATE));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static synchronized SessionFactory getSessionFactory() {
        log.trace((Object)"************* getSessionFactory() **************");
        try {
            if (sessionFactory == null) {
                CUFHibernateUtil.rebuildSessionFactory();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sessionFactory;
    }

    public static synchronized Session getSession() throws HibernateException {
        log.trace((Object)"************* getSession() **************");
        Object session = null;
        try {
            session = (Session)threadLocal.get();
            if (session == null || !session.isOpen()) {
                if (sessionFactory == null) {
                    CUFHibernateUtil.rebuildSessionFactory();
                }
                session = sessionFactory != null ? sessionFactory.openSession() : null;
                threadLocal.set(session);
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
        return session;
    }

    public static void closeSession() throws HibernateException {
        log.trace((Object)"************* closeSession() **************");
        try {
            Session session = (Session)threadLocal.get();
            threadLocal.set(null);
            if (session != null) {
                session.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static Document setDialectInHibernate(Document hibernateFile, String dialectProperty) {
        String dialectPropertyName = "dialect";
        try {
            NodeList sessionFactoryList = hibernateFile.getElementsByTagName("session-factory");
            Node oneSessionFactory = sessionFactoryList.item(0);
            Element sessionFactoryElem = (Element)oneSessionFactory;
            NodeList propetryList = sessionFactoryElem.getElementsByTagName("property");
            for (int i = 0; i < propetryList.getLength(); ++i) {
                Element propertyElem = (Element)propetryList.item(i);
                String propertyName = propertyElem.getAttribute("name");
                if (!propertyName.equalsIgnoreCase(dialectPropertyName)) continue;
                NodeList propertyValue = propertyElem.getChildNodes();
                propertyValue.item(0).setNodeValue(dialectProperty);
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return hibernateFile;
    }

    static {
        threadLocal = new ThreadLocal();
    }
}

