/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.ExcelWriter;
import com.suncode.cuf.io.office.model.ExportSheetDefinition;
import com.suncode.cuf.plannedtask.administration.structure.helper.ExportStructureBuilder;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.GroupMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.OrgUnitMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.PositionMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.UserMappings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StructureExporter {
    private static final Logger log = LoggerFactory.getLogger(StructureExporter.class);
    @Autowired
    ExportStructureBuilder structureBuilder;

    public void exportStructure(String path) {
        log.info("Export strucutre to Excel File: {}", (Object)path);
        List<ExportSheetDefinition> sheets = this.readStructure();
        this.write(sheets, path);
    }

    private List<ExportSheetDefinition> readStructure() {
        List<Map<String, Object>> users = this.structureBuilder.buildUsersMap();
        log.debug("Builded usersData. Size: {}", (Object)users.size());
        List<Map<String, Object>> positions = this.structureBuilder.buildPositionsMap();
        log.debug("Builded positionsData. Size: {}", (Object)positions.size());
        List<Map<String, Object>> orgUnits = this.structureBuilder.buildOrgUnitsMap();
        log.debug("Builded orgUnitsData. Size: {}", (Object)orgUnits.size());
        List<Map<String, Object>> groups = this.structureBuilder.buildGroupsMap();
        log.debug("Builded groupsData. Size: {}", (Object)groups.size());
        ArrayList<ExportSheetDefinition> sheets = new ArrayList<ExportSheetDefinition>();
        ExportSheetDefinition usersSheet = new ExportSheetDefinition("U\u017cytkownicy", users);
        UserMappings um = UserMappings.getInstance();
        usersSheet.setMappings(um.getColumnMappings());
        usersSheet.setKeysOrder(um.getColumnNames());
        ExportSheetDefinition positionsSheet = new ExportSheetDefinition("Stanowiska", positions);
        PositionMappings pm = PositionMappings.getInstance();
        positionsSheet.setMappings(pm.getColumnMappings());
        positionsSheet.setKeysOrder(pm.getColumnNames());
        ExportSheetDefinition orgUnitsSheet = new ExportSheetDefinition("Jednostki organizacyjne", orgUnits);
        OrgUnitMappings om = OrgUnitMappings.getInstance();
        orgUnitsSheet.setMappings(om.getColumnMappings());
        orgUnitsSheet.setKeysOrder(om.getColumnNames());
        ExportSheetDefinition groupsSheet = new ExportSheetDefinition("Grupy", groups);
        GroupMappings gm = GroupMappings.getInstance();
        groupsSheet.setMappings(gm.getColumnMappings());
        groupsSheet.setKeysOrder(gm.getColumnNames());
        sheets.addAll(Arrays.asList(usersSheet, positionsSheet, orgUnitsSheet, groupsSheet));
        return sheets;
    }

    private void write(List<ExportSheetDefinition> sheets, String path) {
        FileOutputStream os = null;
        try {
            log.info("Writing...");
            os = new FileOutputStream(new File(path));
            ExcelWriter ew = new ExcelWriter();
            ew.write(sheets, (OutputStream)os);
        }
        catch (Exception e) {
            try {
                throw new CUFServiceException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }
}

