/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.mail;

import com.suncode.cuf.mail.MailConfiguration;
import org.enhydra.shark.Shark;

public class SystemMailConfiguration
extends MailConfiguration {
    private static SystemMailConfiguration instance;

    private SystemMailConfiguration() {
        this.setHost(this.getProperty("SMTPMailServer"));
        this.setSmtpPort(this.getProperty("SMTPPortNo"));
        this.setUser(this.getProperty("SMTPUser"));
        this.setPassword(this.getProperty("UserPassword"));
        this.setSmtpAuthEnabled(this.getBoolProperty("SMTPAuth"));
        this.setSourceMail(this.getProperty("Email"));
        this.setSslEnabled(this.getBoolProperty("UseSSL"));
        this.setTlsEnabled(this.getBoolProperty("UseSTARTTLS"));
    }

    private boolean getBoolProperty(String name) {
        return Boolean.valueOf(this.getProperty(name));
    }

    String getProperty(String name) {
        return Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler." + name);
    }

    public static SystemMailConfiguration getInstance() {
        if (instance == null) {
            instance = new SystemMailConfiguration();
        }
        return instance;
    }

    static void setInstance(SystemMailConfiguration instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Instance can't be null");
        }
        SystemMailConfiguration.instance = instance;
    }

    @Override
    public void setSslEnabled(boolean sslEnabled) {
        this.throwEx();
        super.setSslEnabled(sslEnabled);
    }

    @Override
    public void setTlsEnabled(boolean tlsEnabled) {
        this.throwEx();
        super.setTlsEnabled(tlsEnabled);
    }

    @Override
    public void setSourceMail(String sourceMail) {
        this.throwEx();
        super.setSourceMail(sourceMail);
    }

    @Override
    public void setUser(String user) {
        this.throwEx();
        super.setUser(user);
    }

    @Override
    public void setPassword(String password) {
        this.throwEx();
        super.setPassword(password);
    }

    @Override
    public void setHost(String host) {
        this.throwEx();
        super.setHost(host);
    }

    @Override
    public void setSmtpPort(String smtpPort) {
        this.throwEx();
        super.setSmtpPort(smtpPort);
    }

    private void throwEx() {
        if (instance != null) {
            throw new IllegalStateException("System configuration is read-only");
        }
    }

    @Override
    public void setSmtpAuthEnabled(boolean smtpAuthEnabled) {
        this.throwEx();
        super.setSmtpAuthEnabled(smtpAuthEnabled);
    }
}

