/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class GetAvailableDocClasses
extends HttpServlet {
    public static Logger log = Logger.getLogger(GetAvailableDocClasses.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* GetAvailableDocClasses Servlet ****************************");
        PrintWriter printWriter = null;
        JSONObject answer = null;
        JSONArray searchIn = null;
        JSONArray addTo = null;
        JSONObject availableClass = null;
        boolean bSuccess = false;
        String answerMessage = "";
        String userId = "";
        Long lDocClassId = null;
        String docClassId = "";
        String docClassName = "";
        int iHasRight = -1;
        boolean bCanSearch = false;
        boolean bCanAdd = false;
        DBManagement dbm = new DBManagement();
        Connection con = null;
        try {
            searchIn = new JSONArray();
            addTo = new JSONArray();
            userId = request.getParameter("userId");
            String skipGroupCheck = request.getParameter("skipGroupCheck");
            boolean bSkipGroupCheck = false;
            String[] searchInClassProtections = new String[]{"delete", "modify", "read"};
            String[] addToClassProtections = new String[]{"release"};
            if (Tools.isNullOrEmpty((String)userId)) {
                throw new CUFException("Brak loginu u\u017cytkownika.");
            }
            ArrayList docClasses = dbm.GetAllDocClasses();
            if (docClasses == null) throw new CUFException("Brak klas dokument\u00f3w w systemie.");
            if (docClasses.size() == 0) {
                throw new CUFException("Brak klas dokument\u00f3w w systemie.");
            }
            con = InternalDataBase.connect();
            if (con == null) {
                throw new CUFException("Brak po\u0142\u0105czenia z wewn\u0119trzn\u0105 baz\u0105 danych.");
            }
            if (!Tools.isNullOrEmpty((String)skipGroupCheck)) {
                bSkipGroupCheck = Boolean.parseBoolean(skipGroupCheck);
            }
            Iterator i$ = docClasses.iterator();
            while (true) {
                int len$;
                String[] arr$;
                DocClassTable docClass;
                if (i$.hasNext()) {
                    docClass = (DocClassTable)i$.next();
                    if (docClass == null || (lDocClassId = docClass.getId()) == null) continue;
                    bCanSearch = false;
                    bCanAdd = false;
                    docClassId = lDocClassId.toString();
                    arr$ = searchInClassProtections;
                    len$ = arr$.length;
                } else {
                    bSuccess = true;
                    answerMessage = "Pobrano klasy dokument\u00f3w dost\u0119pne dla u\u017cytkownika " + userId + ".";
                    log.info((Object)"");
                    try {
                        InternalDataBase.distconnect(con);
                    }
                    catch (SQLException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        answer = new JSONObject();
                        answer.put("success", bSuccess);
                        answer.put("message", (Object)answerMessage);
                        answer.put("searchIn", (Object)searchIn);
                        answer.put("addTo", (Object)addTo);
                        response.setContentType("application/json; charset=UTF-8");
                        printWriter = response.getWriter();
                        printWriter.print(answer);
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    if (printWriter == null) return;
                    printWriter.close();
                    return;
                }
                for (int i$2 = 0; i$2 < len$; ++i$2) {
                    String searchInClassProtection = arr$[i$2];
                    iHasRight = Authorization.checkRight((Connection)con, (String)("System.Archive.DocClasses." + docClassId + "." + searchInClassProtection), (String)userId, (boolean)false, (boolean)bSkipGroupCheck);
                    if (iHasRight == -1) continue;
                    bCanSearch = true;
                    break;
                }
                for (String addToClassProtection : addToClassProtections) {
                    iHasRight = Authorization.checkRight((Connection)con, (String)("System.Archive.DocClasses." + docClassId + "." + addToClassProtection), (String)userId, (boolean)false, (boolean)bSkipGroupCheck);
                    if (iHasRight == -1) continue;
                    bCanAdd = true;
                    break;
                }
                if (!bCanSearch && !bCanAdd) continue;
                docClassName = docClass.getDocClassName();
                if (Tools.isNullOrEmpty((String)docClassName)) {
                    docClassName = docClassId;
                }
                availableClass = new JSONObject();
                availableClass.put("docClassName", (Object)docClassName);
                if (bCanSearch) {
                    searchIn.put((Object)availableClass);
                }
                if (!bCanAdd) continue;
                addTo.put((Object)availableClass);
            }
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception e2) {
                bSuccess = false;
                answerMessage = "B\u0142\u0105d weryfikacji klas dokument\u00f3w dost\u0119pnych dla u\u017cytkownika " + userId + ".";
                log.error((Object)e2.getMessage(), (Throwable)e2);
                return;
            }
        }
        finally {
            try {
                InternalDataBase.distconnect(con);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                answer = new JSONObject();
                answer.put("success", bSuccess);
                answer.put("message", (Object)answerMessage);
                answer.put("searchIn", (Object)searchIn);
                answer.put("addTo", (Object)addTo);
                response.setContentType("application/json; charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(answer);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

