/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.database.dataFileSync.ListConf;
import com.plusmpm.CUF.database.dataFileSync.ListConfManager;
import com.plusmpm.CUF.util.PlannedExternalTask.QueryDataChooserManagement;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;

public class DataFileSync
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(DataFileSync.class);
    private boolean hasOwnConnection = true;

    public void Sync(@TaskParam(name="GetDataConfName", description="Nazwa konfiguracji synchronizacji") String sGetDataConfName, @TaskParam(name="FilePath", description="Sciezka do pliku z danymi") String sFilePath, @TaskParam(name="Separator", description="Separator kolumnowy dla plikow csv i txt") String sSeparator, @TaskParam(name="CheckLastModification", description="TRUE je\u017celi sprawdza\u0107, czy plik zosta\u0142 zmodyfikowany od ostatniej synchronizacji. Je\u017celi nie je\u017celi nie to synchronizacja nie wykona si\u0119") boolean checkLastModification) throws Exception {
        this.hasOwnConnection = false;
        this.Sync(sGetDataConfName, sFilePath, sSeparator, checkLastModification, true, "UTF-8", "", "");
    }

    public void Sync(@TaskParam(name="GetDataConfName", description="Nazwa konfiguracji synchronizacji") String sGetDataConfName, @TaskParam(name="FilePath", description="Sciezka do pliku z danymi") String sFilePath, @TaskParam(name="Separator", description="Separator kolumnowy dla plikow csv i txt") String sSeparator, @TaskParam(name="CheckLastModification", description="TRUE je\u017celi sprawdza\u0107, czy plik zosta\u0142 zmodyfikowany od ostatniej synchronizacji. Je\u017celi nie je\u017celi nie to synchronizacja nie wykona si\u0119") boolean checkLastModification, @TaskParam(name="Header", description="TRUE je\u017celi mam pomin\u0105\u0107 pierwszy wiersz wczytuj\u0105c plik csv") boolean bHeader, @TaskParam(name="Coding", description="Kodowanie znatk\u00f3w np. UTF-8") String sCoding) throws Exception {
        this.hasOwnConnection = false;
        this.Sync(sGetDataConfName, sFilePath, sSeparator, checkLastModification, bHeader, sCoding, "", "");
    }

    public void Sync(@TaskParam(name="GetDataConfName", description="Nazwa konfiguracji synchronizacji") String sGetDataConfName, @TaskParam(name="FilePath", description="Sciezka do pliku z danymi") String sFilePath, @TaskParam(name="Separator", description="Separator kolumnowy dla plikow csv i txt") String sSeparator, @TaskParam(name="CheckLastModification", description="TRUE je\u017celi sprawdza\u0107, czy plik zosta\u0142 zmodyfikowany od ostatniej synchronizacji. Je\u017celi nie je\u017celi nie to synchronizacja nie wykona si\u0119") boolean checkLastModification, @TaskParam(name="Header", description="TRUE je\u017celi mam pomin\u0105\u0107 pierwszy wiersz wczytuj\u0105c plik csv") boolean bHeader, @TaskParam(name="Coding", description="Kodowanie znatk\u00f3w np. UTF-8") String sCoding, @TaskParam(name="QueryDcName", description="Nazwa zapytania dla ExecuteQueryDataChooser, je\u017celi jest podana, tworzona jest definicja Data Choosera i wpis zapytania w wewn\u0119trznej bazie danych (nale\u017cy si\u0119 upewni\u0107, czy taka nazwa ju\u017c nie istnieje)") String sQueryDCName, @TaskParam(name="ProcessVariables", description="identyfikatory zmiennych na formularzu, kt\u00f3re maj\u0105 zosta\u0107 zamapowane warto\u015bciami z Data Choosera po wybraniu rekordu.") String sProcessVariables) throws Exception {
        this.hasOwnConnection = false;
        this.Sync(sGetDataConfName, sFilePath, sSeparator, checkLastModification, bHeader, sCoding, sQueryDCName, sProcessVariables, DBManagement.ConnectToDB());
    }

    public void Sync(@TaskParam(name="GetDataConfName", description="Nazwa konfiguracji synchronizacji") String sGetDataConfName, @TaskParam(name="FilePath", description="Sciezka do pliku z danymi") String sFilePath, @TaskParam(name="Separator", description="Separator kolumnowy dla plikow csv i txt") String sSeparator, @TaskParam(name="CheckLastModification", description="TRUE je\u017celi sprawdza\u0107, czy plik zosta\u0142 zmodyfikowany od ostatniej synchronizacji. Je\u017celi nie je\u017celi nie to synchronizacja nie wykona si\u0119") boolean checkLastModification, @TaskParam(name="Header", description="TRUE je\u017celi mam pomin\u0105\u0107 pierwszy wiersz wczytuj\u0105c plik csv") boolean bHeader, @TaskParam(name="Coding", description="Kodowanie znatk\u00f3w np. UTF-8") String sCoding, @TaskParam(name="QueryDcName", description="Nazwa zapytania dla ExecuteQueryDataChooser, je\u017celi jest podana, tworzona jest definicja Data Choosera i wpis zapytania w wewn\u0119trznej bazie danych (nale\u017cy si\u0119 upewni\u0107, czy taka nazwa ju\u017c nie istnieje)") String sQueryDCName, @TaskParam(name="ProcessVariables", description="identyfikatory zmiennych na formularzu, kt\u00f3re maj\u0105 zosta\u0107 zamapowane warto\u015bciami z Data Choosera po wybraniu rekordu.") String sProcessVariables, @TaskParam(name="SheetName", description="Nazwa arkusza Excel") String sheetName) throws Exception {
        this.hasOwnConnection = false;
        this.Sync(sGetDataConfName, sFilePath, sSeparator, checkLastModification, bHeader, sCoding, sQueryDCName, sProcessVariables, DBManagement.ConnectToDB(), sheetName);
    }

    public void Sync(@TaskParam(name="GetDataConfName", description="Nazwa konfiguracji synchronizacji") String sGetDataConfName, @TaskParam(name="FilePath", description="Sciezka do pliku z danymi") String sFilePath, @TaskParam(name="Separator", description="Separator kolumnowy dla plikow csv i txt") String sSeparator, @TaskParam(name="CheckLastModification", description="TRUE je\u017celi sprawdza\u0107, czy plik zosta\u0142 zmodyfikowany od ostatniej synchronizacji. Je\u017celi nie je\u017celi nie to synchronizacja nie wykona si\u0119") boolean checkLastModification, @TaskParam(name="Header", description="TRUE je\u017celi mam pomin\u0105\u0107 pierwszy wiersz wczytuj\u0105c plik csv") boolean bHeader, @TaskParam(name="Coding", description="Kodowanie znatk\u00f3w np. UTF-8") String sCoding, @TaskParam(name="QueryDcName", description="Nazwa zapytania dla ExecuteQueryDataChooser, je\u017celi jest podana, tworzona jest definicja Data Choosera i wpis zapytania w wewn\u0119trznej bazie danych (nale\u017cy si\u0119 upewni\u0107, czy taka nazwa ju\u017c nie istnieje)") String sQueryDCName, @TaskParam(name="ProcessVariables", description="identyfikatory zmiennych na formularzu, kt\u00f3re maj\u0105 zosta\u0107 zamapowane warto\u015bciami z Data Choosera po wybraniu rekordu.") String sProcessVariables, @TaskParam(name="Connection", description="Obiekt Connection") Connection con) throws Exception {
        this.Sync(sGetDataConfName, sFilePath, sSeparator, checkLastModification, bHeader, sCoding, sQueryDCName, sProcessVariables, con, null);
    }

    public void Sync(@TaskParam(name="GetDataConfName", description="Nazwa konfiguracji synchronizacji") String sGetDataConfName, @TaskParam(name="FilePath", description="Sciezka do pliku z danymi") String sFilePath, @TaskParam(name="Separator", description="Separator kolumnowy dla plikow csv i txt") String sSeparator, @TaskParam(name="CheckLastModification", description="TRUE je\u017celi sprawdza\u0107, czy plik zosta\u0142 zmodyfikowany od ostatniej synchronizacji. Je\u017celi nie je\u017celi nie to synchronizacja nie wykona si\u0119") boolean checkLastModification, @TaskParam(name="Header", description="TRUE je\u017celi mam pomin\u0105\u0107 pierwszy wiersz wczytuj\u0105c plik csv") boolean bHeader, @TaskParam(name="Coding", description="Kodowanie znatk\u00f3w np. UTF-8") String sCoding, @TaskParam(name="QueryDcName", description="Nazwa zapytania dla ExecuteQueryDataChooser, je\u017celi jest podana, tworzona jest definicja Data Choosera i wpis zapytania w wewn\u0119trznej bazie danych (nale\u017cy si\u0119 upewni\u0107, czy taka nazwa ju\u017c nie istnieje)") String sQueryDCName, @TaskParam(name="ProcessVariables", description="identyfikatory zmiennych na formularzu, kt\u00f3re maj\u0105 zosta\u0107 zamapowane warto\u015bciami z Data Choosera po wybraniu rekordu.") String sProcessVariables, @TaskParam(name="Connection", description="Obiekt Connection") Connection con, @TaskParam(name="SheetName", description="Nazwa arkusza Excel") String sheetName) throws Exception {
        if (checkLastModification) {
            try {
                String path = CUFTools.convertBackslashesToSlashes(sFilePath);
                File file = new File(path);
                if (file == null || !file.exists()) {
                    throw new CUFException("Plik z danymi nie istnieje w lokalizacji " + sFilePath);
                }
                ListConf oList = ListConfManager.getListConfByName(sGetDataConfName);
                if (oList == null) {
                    throw new CUFException("Konfiguracja aktualizowanej listy o nazwie " + sGetDataConfName + " nie istnieje");
                }
                Long lastModification = oList.getLastModification();
                log.debug((Object)("Data ostatniej modyfikacji pliku z danymi: " + new Date(file.lastModified())));
                if (lastModification == null) {
                    log.debug((Object)"Plik nie by\u0142 jeszcze synchronizowany");
                } else {
                    log.debug((Object)("Data ostatniej synchronizacji pliku: " + new Date(lastModification)));
                }
                if (lastModification == null || file.lastModified() > lastModification) {
                    oList.setLastModification(file.lastModified());
                    ListConfManager.update(oList);
                    this.Sync(sGetDataConfName, sFilePath, sSeparator, bHeader, sCoding, sQueryDCName, sProcessVariables, con, sheetName);
                }
                log.info((Object)"Synchronizacja nie zosta\u0142a wykonana, poniewa\u017c plik z danymi nie zosta\u0142 zmodyfikowany");
            }
            catch (CUFException e) {
                log.warn((Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        } else {
            this.Sync(sGetDataConfName, sFilePath, sSeparator, bHeader, sCoding, sQueryDCName, sProcessVariables, con, sheetName);
        }
    }

    @AdvancedTask(name="DataFileSync", description="DataFileSync_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void Sync(@TaskParam(name="GetDataConfName", description="Nazwa konfiguracji synchronizacji") String sGetDataConfName, @TaskParam(name="FilePath", description="Sciezka do pliku z danymi") String sFilePath, @TaskParam(name="Separator", description="Separator kolumnowy dla plikow csv i txt") String sSeparator) throws Exception {
        this.hasOwnConnection = false;
        this.Sync(sGetDataConfName, sFilePath, sSeparator, true, "UTF-8");
    }

    public void Sync(@TaskParam(name="GetDataConfName", description="Nazwa konfiguracji synchronizacji") String sGetDataConfName, @TaskParam(name="FilePath", description="Sciezka do pliku z danymi") String sFilePath, @TaskParam(name="Separator", description="Separator kolumnowy dla plikow csv i txt") String sSeparator, @TaskParam(name="Header", description="TRUE je\u017celi mam pomin\u0105\u0107 pierwszy wiersz wczytuj\u0105c plik csv") boolean bHeader, @TaskParam(name="Coding", description="Kodowanie znatk\u00f3w np. UTF-8") String sCoding) throws Exception {
        this.hasOwnConnection = false;
        this.Sync(sGetDataConfName, sFilePath, sSeparator, bHeader, sCoding, "", "", DBManagement.ConnectToDB(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Sync(String sGetDataConfName, String sFilePath, String sSeparator, boolean bHeader, String sCoding, String sQueryDCName, String sProcessVariables, Connection con, String sheetName) throws Exception {
        long startTime;
        block51: {
            log.info((Object)("************ Sync(sGetDataConfName=" + sGetDataConfName + "sFilePath=" + sFilePath + ", sSeparator=" + sSeparator + ", bHeader=" + String.valueOf(bHeader) + ", sCoding=" + sCoding + ", sQueryDCName=" + sQueryDCName + ", sProcessVariables=" + sProcessVariables + ") ************"));
            startTime = new Date().getTime();
            String sExt = "";
            Connection internalCon = null;
            Statement statement = null;
            String dbName = null;
            ArrayList<HashMap<String, String>> inputData = null;
            try {
                sFilePath = CUFTools.convertBackslashesToSlashes(sFilePath);
                File file = new File(sFilePath);
                if (file == null || !file.exists()) {
                    throw new CUFException("Plik z danymi nie istnieje w lokalizacji " + sFilePath);
                }
                ListConf oList = ListConfManager.getListConfByName(sGetDataConfName);
                if (oList == null) {
                    throw new CUFException("Konfiguracja aktualizowanej listy o nazwie " + sGetDataConfName + " nie istnieje");
                }
                String sFileName = file.getName();
                int dotPos = sFileName.lastIndexOf(".");
                sExt = sFileName.substring(dotPos + 1, sFileName.length());
                if (sSeparator != null && sSeparator.equalsIgnoreCase("semicolon")) {
                    sSeparator = ";";
                }
                if (sExt.equalsIgnoreCase("xls")) {
                    log.info((Object)"Pobieranie danych z arkusza Excel xls");
                    inputData = this.getDataFromXls(file, oList, sheetName);
                } else if (sExt.equalsIgnoreCase("csv")) {
                    log.info((Object)"Pobieranie danych z arkusza csv");
                    inputData = this.getDataFromTxt(file, oList, sSeparator, bHeader, sCoding);
                } else if (sExt.equalsIgnoreCase("txt")) {
                    log.info((Object)"Pobieranie danych z pliku tekstowego");
                    inputData = this.getDataFromTxt(file, oList, sSeparator, true, null);
                } else {
                    throw new CUFException("Rozszerzenie " + sExt + " pliku z danymi nie jest akceptowane");
                }
                if (inputData == null || inputData.size() == 0) {
                    throw new CUFException("Plik z danymi z lokalizacji " + sFilePath + " jest pusty lub nie uzyskano z niego danych");
                }
                dbName = HibernateUtil.getDatabaseVendor().name();
                log.info((Object)("Nazwa wewnetrznej bazy danych: " + dbName));
                String sTableName = oList.getTableName();
                String[] columnNames = oList.getColumnsTab();
                String[] columnsTypes = oList.getColumnsTypesTab();
                String sCriteria = oList.getCriteria();
                boolean deleteNeeded = false;
                internalCon = con;
                if (internalCon != null) {
                    DatabaseMetaData databaseMetaData = internalCon.getMetaData();
                    if (databaseMetaData.supportsTransactionIsolationLevel(1) && con.getTransactionIsolation() != 1) {
                        con.setTransactionIsolation(1);
                    }
                    ResultSet tables = databaseMetaData.getTables(null, null, sTableName, null);
                    statement = null;
                    if (tables.next()) {
                        log.info((Object)("Tabela " + sTableName + " istnieje w bazie danych "));
                        log.info((Object)"Sprawdzanie zgodnosci ilosci kolumn");
                        deleteNeeded = true;
                        statement = internalCon.createStatement();
                        ResultSet allFromTable = statement.executeQuery("SELECT * FROM " + sTableName);
                        ResultSetMetaData checkColumnsData = allFromTable.getMetaData();
                        boolean columnExists = false;
                        for (int l = 0; l < columnNames.length; ++l) {
                            columnExists = false;
                            for (int k = 1; k < checkColumnsData.getColumnCount() + 1; ++k) {
                                if (!checkColumnsData.getColumnName(k).equalsIgnoreCase(columnNames[l])) continue;
                                columnExists = true;
                                break;
                            }
                            if (columnExists) continue;
                            String thisColumnType = "";
                            thisColumnType = dbName.equalsIgnoreCase("MicrosoftSQLServer") ? (columnsTypes[l].equals("integer") || columnsTypes[l].equals("int") ? "int" : (columnsTypes[l].equals("float") || columnsTypes[l].equals("double") ? "float" : (columnsTypes[l].equals("timestamp") ? "datetime" : "varchar(1024)"))) : columnsTypes[l];
                            log.info((Object)("Dodawanie nowej kolumny " + columnNames[l] + " typu " + thisColumnType + " do tabeli " + sTableName));
                            String createColumnQuery = "ALTER TABLE " + sTableName + " ADD COLUMN " + columnNames[l] + " " + thisColumnType;
                            statement.addBatch(createColumnQuery);
                            log.info((Object)("Query: " + createColumnQuery));
                        }
                        statement.executeBatch();
                    } else {
                        log.info((Object)("Tabela " + sTableName + " nie istnieje w bazie danych "));
                        log.info((Object)("Tworzenie tabeli " + sTableName));
                        deleteNeeded = false;
                        try {
                            statement = internalCon.createStatement();
                            String[] batchQueries = null;
                            batchQueries = dbName.equalsIgnoreCase("MicrosoftSQLServer") ? this.getCreateTableQueriesMSSQL(sTableName, columnNames, columnsTypes) : this.getCreateTableQueriesPostgreSQL(sTableName, columnNames, columnsTypes);
                            for (String createQuery : batchQueries) {
                                statement.addBatch(createQuery);
                                log.info((Object)("Query: " + createQuery));
                            }
                            statement.executeBatch();
                        }
                        catch (SQLException sqle) {
                            taskLog.error((Object)sqle.getMessage());
                            log.error((Object)sqle.getMessage(), (Throwable)sqle);
                            throw sqle;
                        }
                    }
                    inputData = this.lowerCase(inputData);
                    long time = this.addResults(internalCon, inputData, columnNames, columnsTypes, sTableName, sCriteria, sGetDataConfName, dbName);
                    if (deleteNeeded) {
                        boolean state = false;
                        if (time != -1L) {
                            state = this.deleteResults(internalCon, sTableName, sGetDataConfName, time);
                        } else {
                            log.warn((Object)"Rekordy nie beda usuwane, gdyz wystapil blad w funkcji dodawania rekordow (funkcja addResults)");
                        }
                        if (state) {
                            log.info((Object)"Proces usuwania nieaktualnych rekordow zakonczony powodzeniem");
                        } else {
                            log.warn((Object)("Proces usuwania nieaktualnych rekordow zakonczony niepowodzeniem. Mozliwosc wystepowania niepoprawnych danych w tabeli " + sTableName));
                        }
                    }
                    if (Tools.isNullOrEmpty((String)sQueryDCName)) break block51;
                    log.info((Object)"Generowanie zapytania QueryDataChooser i definicji Data Choosera");
                    String comaSql = ", ";
                    String orSql = " or ";
                    String enter = System.getProperty("line.separator");
                    String dcDef = "";
                    String sQuery = "select ";
                    String sParameters = "";
                    String sCountQuery = "select count(1) ";
                    String sExternalDB = "false";
                    String sConfName = "";
                    String sClassName = "";
                    int iNoOfMapping = 1;
                    if (sProcessVariables == null || sProcessVariables.equalsIgnoreCase("NULL")) {
                        sProcessVariables = "";
                    }
                    String[] procVarMappingTable = sProcessVariables.split(",", -1);
                    dcDef = dcDef + "class=com.plusmpm.CUF.util.DataChoosers.ExecuteQueryDataChooser" + enter;
                    dcDef = dcDef + "formCriteria=" + enter;
                    for (String columnName : columnNames) {
                        sQuery = sQuery + columnName + comaSql;
                        sParameters = sParameters + "DCKEY,";
                        String procVarMapping = "";
                        try {
                            procVarMapping = procVarMappingTable[iNoOfMapping - 1];
                        }
                        catch (Exception e) {
                            taskLog.error((Object)e.getMessage());
                            procVarMapping = "";
                        }
                        dcDef = dcDef + "mapping" + iNoOfMapping + "=" + columnName + ";" + procVarMapping + ";" + columnName + enter;
                        ++iNoOfMapping;
                    }
                    dcDef = dcDef + "type=combobox" + enter;
                    dcDef = dcDef + "comboForceSelection=true" + enter;
                    dcDef = dcDef + "NameForQuery=" + sQueryDCName;
                    log.info((Object)("Definicja Data Choosera:" + enter + dcDef));
                    if (sQuery.endsWith(comaSql)) {
                        sQuery = sQuery.substring(0, sQuery.length() - comaSql.length());
                    }
                    if (sParameters.endsWith(",")) {
                        sParameters = sParameters.substring(0, sParameters.length() - 1);
                    }
                    sQuery = sQuery + " from " + sTableName + " where ";
                    sCountQuery = sCountQuery + " from " + sTableName + " where ";
                    for (String columnName : columnNames) {
                        String condition;
                        if (dbName.equalsIgnoreCase("MicrosoftSQLServer")) {
                            condition = "upper(" + columnName + ")" + " like upper('%' + ? + '%')" + orSql;
                            sQuery = sQuery + condition;
                            sCountQuery = sCountQuery + condition;
                            continue;
                        }
                        condition = "upper(" + columnName + ")" + " like upper('%' || ? || '%')" + orSql;
                        sQuery = sQuery + condition;
                        sCountQuery = sCountQuery + condition;
                    }
                    if (sQuery.endsWith(orSql)) {
                        sQuery = sQuery.substring(0, sQuery.length() - orSql.length());
                    }
                    if (sCountQuery.endsWith(orSql)) {
                        sCountQuery = sCountQuery.substring(0, sCountQuery.length() - orSql.length());
                    }
                    log.info((Object)("Wygenerowane zapytanie dla QueryDataChooser: " + sQuery));
                    log.info((Object)("Wygenerowane zapytanie dla ilosci wynikow dla QueryDataChooser: " + sCountQuery));
                    QueryDataChooserManagement.AddQueryDataChooser(sQueryDCName, sQuery, sParameters, sCountQuery, sExternalDB, sConfName, sClassName);
                    break block51;
                }
                log.warn((Object)"Brak polaczenia z wewnetrzna baza danych");
            }
            catch (CUFException e) {
                taskLog.error((Object)e.getMessage());
                log.warn((Object)e.getMessage());
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (!this.hasOwnConnection && internalCon != null && !internalCon.isClosed()) {
                        internalCon.close();
                    }
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                this.hasOwnConnection = true;
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego Sync: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private ArrayList<HashMap<String, String>> getDataFromXls(File file, ListConf oList) throws Exception {
        return this.getDataFromXls(file, oList, null);
    }

    private ArrayList<HashMap<String, String>> getDataFromXls(File file, ListConf oList, String sSheetName) throws Exception {
        log.trace((Object)"******************* getDataFromXls() ******************* ");
        ArrayList<HashMap<String, String>> results = new ArrayList<HashMap<String, String>>();
        int coulumnCount = oList.getColumnsCount();
        String[] columnNames = oList.getColumnsTab();
        File xls = file;
        Workbook w = null;
        try {
            int i;
            WorkbookSettings wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            w = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = null;
            sheet = Tools.isNullOrEmpty((String)sSheetName) ? w.getSheet(0) : w.getSheet(sSheetName);
            if (sheet == null) {
                throw new Exception("Arkusz o podanej nazwie nie istnieje.");
            }
            HashMap<String, Integer> header = new HashMap<String, Integer>();
            for (i = 0; i < coulumnCount; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    HashMap<String, String> singleRow = new HashMap<String, String>();
                    for (int j = 0; j < coulumnCount; ++j) {
                        String cellContent;
                        if (!header.containsKey(columnNames[j]) || (cellContent = sheet.getCell(((Integer)header.get(columnNames[j])).intValue(), i).getContents()) == null) continue;
                        cellContent = cellContent.trim();
                        singleRow.put(columnNames[j], cellContent);
                    }
                    results.add(singleRow);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<HashMap<String, String>> getDataFromTxt(File file, ListConf oList, String sSeparator, boolean header, String sCoding) {
        ArrayList<HashMap<String, String>> results = new ArrayList<HashMap<String, String>>();
        BufferedReader in = null;
        int iLineNr = 0;
        int headerRow = 0;
        int coulumnCount = oList.getColumnsCount();
        String[] columnNames = oList.getColumnsTab();
        try {
            String sLine;
            if (Tools.isNullOrEmpty((String)sCoding)) {
                sCoding = "UTF-8";
            }
            if (header) {
                headerRow = 1;
            }
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), sCoding));
            while ((sLine = in.readLine()) != null) {
                byte[] lineBytes = sLine.getBytes("UTF-8");
                sLine = new String(lineBytes, "UTF-8");
                if (++iLineNr <= headerRow) continue;
                String[] tempTab = null;
                tempTab = this.readLineFromFile(sLine, sSeparator, coulumnCount);
                HashMap<String, String> singleRow = new HashMap<String, String>();
                for (int i = 0; i < coulumnCount; ++i) {
                    String cellContent = tempTab[i];
                    if (cellContent == null) continue;
                    cellContent = cellContent.trim();
                    singleRow.put(columnNames[i], cellContent);
                }
                results.add(singleRow);
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return results;
    }

    private String[] readLineFromFile(String sLine, String sSeparation, int iTokensNr) throws Exception {
        StringTokenizer t = new StringTokenizer(sLine, sSeparation);
        String[] sTab = null;
        sTab = iTokensNr <= 0 ? this.getTokens(sLine, sSeparation) : this.getTokens(sLine, t, iTokensNr, sSeparation);
        return sTab;
    }

    private String[] getTokens(String sLine, StringTokenizer t, int iTokenNr, String sSepartor) throws Exception {
        String[] sTab = new String[iTokenNr];
        String[] sTabTemp = this.getTokens(sLine, sSepartor);
        if (sTabTemp.length != sTab.length) {
            int i;
            for (i = 0; i < sTabTemp.length; ++i) {
                if (i >= sTab.length) continue;
                sTab[i] = sTabTemp[i];
            }
            for (i = sTabTemp.length; i < iTokenNr; ++i) {
                if (i >= sTab.length) continue;
                sTab[i] = "";
            }
        } else {
            return sTabTemp;
        }
        return sTab;
    }

    private String[] getTokens(String sLine, String sSeparation) throws Exception {
        String[] sTab = null;
        if (sLine != null && sLine.length() > 0) {
            sTab = sLine.split(sSeparation);
        }
        return sTab;
    }

    private String[] getCreateTableQueriesPostgreSQL(String tableName, String[] columnNames, String[] columnTypes) throws IllegalArgumentException {
        log.trace((Object)"************************* getCreateTableQueriesPostgreSQL(String, String[], String[]) ********************");
        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("Rozmiar tablicy z nazwami kolumn jest inny ni\u017c rozmiar tablicy z typami.");
        }
        String[] result = new String[2];
        StringBuilder sequenceCreateQuery = new StringBuilder("CREATE SEQUENCE ");
        sequenceCreateQuery.append(tableName);
        sequenceCreateQuery.append("_id_seq");
        result[0] = sequenceCreateQuery.toString();
        StringBuilder tableCreateQuery = new StringBuilder();
        tableCreateQuery.append("CREATE TABLE ");
        tableCreateQuery.append(tableName);
        tableCreateQuery.append(" (id int8 DEFAULT nextval('");
        tableCreateQuery.append(tableName);
        tableCreateQuery.append("_id_seq') PRIMARY KEY");
        for (int i = 0; i < columnNames.length; ++i) {
            tableCreateQuery.append(", ");
            tableCreateQuery.append(columnNames[i]);
            if (columnTypes[i].equals("integer") || columnTypes[i].equals("int8")) {
                tableCreateQuery.append(" int8");
                continue;
            }
            if (columnTypes[i].equals("float") || columnTypes[i].equals("float8")) {
                tableCreateQuery.append(" float8");
                continue;
            }
            if (columnTypes[i].equals("double") || columnTypes[i].equals("double8")) {
                tableCreateQuery.append(" double8");
                continue;
            }
            if (columnTypes[i].equals("timestamp")) {
                tableCreateQuery.append(" timestamp");
                continue;
            }
            tableCreateQuery.append(" varchar(1024)");
        }
        tableCreateQuery.append(", criteria varchar(1024), dateofrecordcheck timestamp, confname varchar(1024))");
        result[1] = tableCreateQuery.toString();
        return result;
    }

    private String[] getCreateTableQueriesMSSQL(String tableName, String[] columnNames, String[] columnTypes) throws IllegalArgumentException {
        log.trace((Object)"************************* getCreateTableQueriesMSSQL(String, String[], String[]) ********************");
        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("Rozmiar tablicy z nazwami kolumn jest inny ni\u017c rozmiar tablicy z typami.");
        }
        String[] result = new String[1];
        StringBuilder tableCreateQuery = new StringBuilder("CREATE TABLE ");
        tableCreateQuery.append(tableName);
        tableCreateQuery.append(" ( id int IDENTITY(1,1) PRIMARY KEY");
        for (int i = 0; i < columnNames.length; ++i) {
            tableCreateQuery.append(", ");
            tableCreateQuery.append(columnNames[i]);
            if (columnTypes[i].equals("integer") || columnTypes[i].equals("int")) {
                tableCreateQuery.append(" int");
                continue;
            }
            if (columnTypes[i].equals("float") || columnTypes[i].equals("double")) {
                tableCreateQuery.append(" float");
                continue;
            }
            if (columnTypes[i].equals("timestamp")) {
                tableCreateQuery.append(" datetime");
                continue;
            }
            tableCreateQuery.append(" varchar(1024)");
        }
        tableCreateQuery.append(", criteria varchar(1024), dateofrecordcheck datetime, confname varchar(1024))");
        result[0] = tableCreateQuery.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addResults(Connection con, ArrayList<HashMap<String, String>> newResults, String[] columnNames, String[] columnTypes, String sTableName, String sCriteria, String confName, String dbName) throws SQLException {
        log.trace((Object)"************************* addResults(Connection, ArrayList<HashMap<String, String>>, String[], String[], String, String, String, String) ********************");
        Statement statement = null;
        ArrayList<HashMap<String, String>> oldResults = null;
        Date date = new Date();
        long time = date.getTime();
        try {
            int i;
            int i2;
            log.info((Object)"Dodawanie i uaktualnianie rekordow");
            for (int i3 = 0; i3 < columnNames.length; ++i3) {
                columnNames[i3] = columnNames[i3].toLowerCase();
            }
            StringBuilder insertQuery = new StringBuilder();
            insertQuery.append("INSERT INTO ");
            insertQuery.append(sTableName);
            insertQuery.append(" (");
            for (i2 = 0; i2 < newResults.get(0).size() + 1; ++i2) {
                if (i2 != newResults.get(0).size()) {
                    insertQuery.append(columnNames[i2] + ", ");
                    continue;
                }
                insertQuery.append("criteria, dateofrecordcheck, confname)");
            }
            insertQuery.append(" VALUES (");
            for (i2 = 0; i2 < newResults.get(0).size() + 1; ++i2) {
                if (i2 != newResults.get(0).size()) {
                    insertQuery.append("?, ");
                    continue;
                }
                insertQuery.append("?, ?, ?)");
            }
            String sqlInsert = insertQuery.toString();
            log.info((Object)("INSERT query: " + sqlInsert));
            StringBuilder updateQuery = new StringBuilder();
            updateQuery.append("UPDATE ");
            updateQuery.append(sTableName);
            updateQuery.append(" SET ");
            for (int i4 = 0; i4 < newResults.get(0).size() + 1; ++i4) {
                if (i4 != newResults.get(0).size()) {
                    updateQuery.append(columnNames[i4] + "=?, ");
                    continue;
                }
                updateQuery.append("criteria=?, dateofrecordcheck=?, confname=?");
            }
            updateQuery.append(" WHERE ");
            String[] criteriaSplit = sCriteria.split(";");
            for (i = 0; i < criteriaSplit.length; ++i) {
                criteriaSplit[i] = criteriaSplit[i].toLowerCase();
            }
            for (i = 0; i < criteriaSplit.length; ++i) {
                updateQuery.append(criteriaSplit[i]);
                if (i != criteriaSplit.length - 1) {
                    updateQuery.append("=? AND ");
                    continue;
                }
                updateQuery.append("=?");
            }
            String sqlUpdate = updateQuery.toString();
            log.info((Object)("UPDATE query: " + sqlUpdate));
            String oldQuery = "SELECT * FROM " + sTableName;
            oldResults = InternalDataBase.executeQuery(con, oldQuery);
            oldResults = this.lowerCase(oldResults);
            statement = con.prepareStatement(sqlInsert);
            for (int i5 = 0; i5 < newResults.size(); ++i5) {
                int recordExists = 0;
                int range = newResults.get(i5).size() + 1;
                if (oldResults != null && oldResults.size() > 0) {
                    for (int k = 0; k < oldResults.size(); ++k) {
                        recordExists = 0;
                        for (int w = 0; w < criteriaSplit.length; ++w) {
                            if (!oldResults.get(k).get(criteriaSplit[w]).equals(newResults.get(i5).get(criteriaSplit[w]))) continue;
                            ++recordExists;
                        }
                        if (recordExists == criteriaSplit.length) break;
                    }
                    statement = recordExists == criteriaSplit.length ? con.prepareStatement(sqlUpdate) : con.prepareStatement(sqlInsert);
                }
                for (int j = 0; j < range; ++j) {
                    if (j < newResults.get(i5).size()) {
                        if (columnTypes[j].equals("integer") || columnTypes[j].equals("int8") || columnTypes[j].equals("int")) {
                            statement.setInt(j + 1, Integer.valueOf(newResults.get(i5).get(columnNames[j])));
                            continue;
                        }
                        if (columnTypes[j].equals("float") || columnTypes[j].equals("float8")) {
                            statement.setFloat(j + 1, Float.valueOf(newResults.get(i5).get(columnNames[j])).floatValue());
                            continue;
                        }
                        if (columnTypes[j].equals("double") || columnTypes[j].equals("double8")) {
                            if (dbName.equalsIgnoreCase("MicrosoftSQLServer")) {
                                statement.setFloat(j + 1, Float.valueOf(newResults.get(i5).get(columnNames[j])).floatValue());
                                continue;
                            }
                            statement.setDouble(j + 1, Double.valueOf(newResults.get(i5).get(columnNames[j])));
                            continue;
                        }
                        if (columnTypes[j].equals("timestamp")) {
                            statement.setTimestamp(j + 1, Timestamp.valueOf(newResults.get(i5).get(columnNames[j])));
                            continue;
                        }
                        statement.setString(j + 1, newResults.get(i5).get(columnNames[j]));
                        continue;
                    }
                    statement.setString(j + 1, sCriteria);
                    statement.setTimestamp(j + 2, new Timestamp(time));
                    statement.setString(j + 3, confName);
                    if (recordExists != criteriaSplit.length) continue;
                    for (int z = 0; z < criteriaSplit.length; ++z) {
                        String criteriaType = "";
                        for (int e = 0; e < columnNames.length; ++e) {
                            if (!criteriaSplit[z].equals(columnNames[e])) continue;
                            criteriaType = columnTypes[e];
                            break;
                        }
                        if (criteriaType.equals("integer") || criteriaType.equals("int8") || criteriaType.equals("int")) {
                            statement.setInt(j + 4 + z, Integer.valueOf(newResults.get(i5).get(criteriaSplit[z])));
                            continue;
                        }
                        if (criteriaType.equals("float") || criteriaType.equals("float8")) {
                            statement.setFloat(j + 4 + z, Float.valueOf(newResults.get(i5).get(criteriaSplit[z])).floatValue());
                            continue;
                        }
                        if (criteriaType.equals("double") || criteriaType.equals("double8")) {
                            if (dbName.equalsIgnoreCase("MicrosoftSQLServer")) {
                                statement.setFloat(j + 4 + z, Float.valueOf(newResults.get(i5).get(criteriaSplit[z])).floatValue());
                                continue;
                            }
                            statement.setDouble(j + 4 + z, Double.valueOf(newResults.get(i5).get(criteriaSplit[z])));
                            continue;
                        }
                        if (criteriaType.equals("timestamp")) {
                            statement.setTimestamp(j + 4 + z, Timestamp.valueOf(newResults.get(i5).get(criteriaSplit[z])));
                            continue;
                        }
                        statement.setString(j + 4 + z, newResults.get(i5).get(criteriaSplit[z]));
                    }
                }
                statement.execute();
                statement.clearParameters();
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            long l = -1L;
            return l;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteResults(Connection con, String sTableName, String confName, Long time) {
        log.trace((Object)"************************* deleteResults(Connection, String, String, Long, String) ********************");
        boolean state = false;
        Statement statement = null;
        try {
            Timestamp timestamp = new Timestamp(time);
            StringBuilder deleteQuery = new StringBuilder();
            deleteQuery.append("DELETE FROM ");
            deleteQuery.append(sTableName);
            deleteQuery.append(" WHERE dateofrecordcheck<? AND confname=?");
            String sqlDelete = deleteQuery.toString();
            log.info((Object)sqlDelete);
            statement = con.prepareStatement(sqlDelete);
            statement.setTimestamp(1, timestamp);
            statement.setString(2, confName);
            statement.execute();
            state = true;
        }
        catch (Exception e) {
            state = false;
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return state;
    }

    private ArrayList<HashMap<String, String>> lowerCase(ArrayList<HashMap<String, String>> list) {
        log.trace((Object)"************ lowerCase(ArrayList<HashMap<String, String>>) ************");
        ArrayList<HashMap<String, String>> results = new ArrayList<HashMap<String, String>>();
        try {
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> oneHashMap = list.get(i);
                HashMap<String, String> oneRow = new HashMap<String, String>();
                for (String key : oneHashMap.keySet()) {
                    String value = oneHashMap.get(key);
                    key = key.toLowerCase();
                    oneRow.put(key, value);
                }
                results.add(oneRow);
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return results;
    }
}

