/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper;

import com.suncode.cuf.plannedtask.administration.structure.helper.ImportStructureMode;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import java.util.List;
import java.util.Map;

public class StructureImporter {
    private ImportStructureMode mode;

    public void setMode(ImportStructureMode mode) {
        this.mode = mode;
    }

    private void importGroups(List<Map<String, String>> groups) {
        for (Map<String, String> map : groups) {
            String name = map.get("name");
            String desc = map.get("description");
            this.mode.importGroup(name, desc);
        }
    }

    public void importStructure(StructureData sd, ImportStructureMode mode) {
        this.mode = mode;
        this.importGroups(sd.getGroups());
        this.importOrgUnits(sd.getOrgUnits());
        this.importPositons(sd.getPositions());
        this.importOrgUnitsAssotiations(sd.getOrgUnits());
        this.importUsers(sd.getUsers());
        mode.clean();
    }

    private void importOrgUnitsAssotiations(List<Map<String, String>> orgUnits) {
        for (Map<String, String> map : orgUnits) {
            String symbol = map.get("symbol");
            String higherOrgUnit = map.get("higherOrgUnit");
            String directorPosition = map.get("directorPosition");
            this.mode.importOrgUnitAssotiations(symbol, higherOrgUnit, directorPosition);
        }
    }

    private void importUsers(List<Map<String, String>> users) {
        for (Map<String, String> map : users) {
            String userName = map.get("userName");
            String firstName = map.get("firstName");
            String lastName = map.get("lastName");
            String password = map.get("password");
            String email = map.get("email");
            String number = map.get("number");
            String groups = map.get("groups");
            String positions = map.get("positions");
            this.mode.importUser(userName, firstName, lastName, password, email, number, groups, positions);
        }
    }

    private void importPositons(List<Map<String, String>> positions) {
        for (Map<String, String> map : positions) {
            String name = map.get("name");
            String symbol = map.get("symbol");
            String higherPosition = map.get("higherPosition");
            String orgUnit = map.get("orgUnit");
            String roles = map.get("roles");
            this.mode.importPosition(name, symbol, higherPosition, orgUnit, roles);
        }
    }

    private void importOrgUnits(List<Map<String, String>> orgUnits) {
        for (Map<String, String> map : orgUnits) {
            String name = map.get("name");
            String symbol = map.get("symbol");
            String higherOrgUnit = map.get("higherOrgUnit");
            String directorPosition = map.get("directorPosition");
            this.mode.importOrgUnit(name, symbol, higherOrgUnit, directorPosition);
        }
    }
}

