/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure;

import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.cuf.io.office.ExcelReader;
import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.io.office.model.SheetDefinition;
import com.suncode.cuf.plannedtask.administration.structure.helper.ImportStructureMode;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureImporter;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureValidator;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.GroupMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.OrgUnitMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.PositionMappings;
import com.suncode.cuf.plannedtask.administration.structure.helper.internal.UserMappings;
import com.suncode.pwfl.util.SpringContext;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

public class ImportOrgStructure {
    public static final String APPEND = "APPEND";
    public static final String STANDARD = "STANDARD";
    public static final String OVERRIDE = "OVERRIDE";

    @AdvancedTask(name="importStructure", description="importStructure", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructure(@TaskParam(name="path_to_excel_file", description="path_to_excel_file") String path, @TaskParam(name="read_mode", description="read_mode_desc") String mode) throws Exception {
        ExcelReader er = new ExcelReader();
        List<ImportSheetDefinition> defs = this.buildDefs();
        List<SheetDefinition> struct = er.read(defs, new FileInputStream(path));
        StructureData sd = new StructureData(struct);
        StructureValidator validator = (StructureValidator)SpringContext.getBean(StructureValidator.class);
        validator.validateStructure(sd);
        StructureImporter importer = new StructureImporter();
        importer.importStructure(sd, this.resolveMode(mode));
    }

    private List<ImportSheetDefinition> buildDefs() {
        ArrayList<ImportSheetDefinition> defs = new ArrayList<ImportSheetDefinition>();
        defs.add(new ImportSheetDefinition("U\u017cytkownicy", UserMappings.getInstance().getReverseColumnMappings()));
        defs.add(new ImportSheetDefinition("Grupy", GroupMappings.getInstance().getReverseColumnMappings()));
        defs.add(new ImportSheetDefinition("Stanowiska", PositionMappings.getInstance().getReverseColumnMappings()));
        defs.add(new ImportSheetDefinition("Jednostki organizacyjne", OrgUnitMappings.getInstance().getReverseColumnMappings()));
        return defs;
    }

    private ImportStructureMode resolveMode(String mode) {
        if (mode.equalsIgnoreCase(APPEND)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importOrgStructureAppendMode");
        }
        if (mode.equalsIgnoreCase(STANDARD)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importOrgStructureStandardMode");
        }
        if (mode.equalsIgnoreCase(OVERRIDE)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importOrgStructureOverrideMode");
        }
        throw new IllegalArgumentException("Nie obs\u0142ugiwany tryb importu: " + mode);
    }
}

