/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.io.office.model.SheetDefinition;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader {
    private String[] keys;
    private String[] headers;
    private static final Logger log = LoggerFactory.getLogger(ExcelReader.class);
    private FormulaEvaluator evaluator;

    public SheetDefinition readFirstSheet(InputStream is) {
        Workbook wb = this.buildWorkbook(is);
        Sheet sheet = wb.getSheetAt(0);
        return this.readSheet(sheet, null);
    }

    public SheetDefinition readSheet(String name, InputStream is) {
        Workbook wb = this.buildWorkbook(is);
        Sheet sheet = wb.getSheet(name);
        return this.readSheet(sheet, null);
    }

    public List<SheetDefinition> read(List<ImportSheetDefinition> importDef, InputStream is) {
        ArrayList<SheetDefinition> sheets = new ArrayList<SheetDefinition>();
        Workbook wb = this.buildWorkbook(is);
        for (ImportSheetDefinition def : importDef) {
            String sheetName = def.getName();
            SheetDefinition sheetData = this.readSheet(wb.getSheet(sheetName), def.getMappings());
            sheets.add(sheetData);
        }
        return sheets;
    }

    public List<SheetDefinition> readAllSheets(InputStream is) {
        ArrayList<SheetDefinition> sheets = new ArrayList<SheetDefinition>();
        Workbook wb = this.buildWorkbook(is);
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            String sheetName = wb.getSheetName(i);
            SheetDefinition sheetData = this.readSheet(wb.getSheet(sheetName), null);
            sheets.add(sheetData);
        }
        return sheets;
    }

    private Workbook buildWorkbook(InputStream is) {
        try {
            Workbook wb = WorkbookFactory.create((InputStream)is);
            this.evaluator = wb.getCreationHelper().createFormulaEvaluator();
            return wb;
        }
        catch (Exception e) {
            throw new CUFServiceException(e);
        }
    }

    private SheetDefinition readSheet(Sheet sheet, Map<String, String> mappings) {
        log.debug("Sheet name: {}", (Object)sheet.getSheetName());
        log.debug("Reading...");
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        int colCount = this.getColumnCount(sheet, mappings);
        int rowCount = sheet.getPhysicalNumberOfRows();
        for (int i = 1; i < rowCount; ++i) {
            Row row = sheet.getRow(i);
            if (this.isEmpty(row)) {
                log.warn("Row {} is empty. End reading.", (Object)i);
                break;
            }
            Map<String, Object> rowData = this.readRow(row, colCount);
            data.add(rowData);
        }
        log.debug("End reading form Excel. Data size: {}", (Object)data.size());
        return new SheetDefinition(sheet.getSheetName(), data, this.headers);
    }

    private boolean isEmpty(Row row) {
        return row == null;
    }

    private Map<String, Object> readRow(Row row, int colCount) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        for (int i = 0; i < colCount; ++i) {
            Cell cell = row.getCell(i);
            String key = this.keys[i];
            String header = this.headers[i];
            log.debug("Column [{}] Row [{}]", (Object)header, (Object)row.getRowNum());
            if (cell != null) {
                Object value = this.getCellValue(cell, key);
                hm.put(key, value);
                continue;
            }
            log.debug("Cell is empty");
            hm.put(key, null);
        }
        return hm;
    }

    private Object getCellValue(Cell cell, String key) {
        CellValue cellValue = this.evaluator.evaluate(cell);
        Object value = this.getCellValue(cell.getCellType(), cell, cellValue, key);
        return value;
    }

    private Object getCellValue(int type, Cell cell, CellValue cellValue, String key) {
        if (type == 0) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                log.trace("Data");
                return cell.getDateCellValue();
            }
            log.trace("Double");
            return cellValue.getNumberValue();
        }
        if (type == 4) {
            log.trace("boolean");
            return cellValue.getBooleanValue();
        }
        if (type == 1) {
            log.trace("string");
            return cellValue.getStringValue();
        }
        if (type == 2) {
            log.trace("formula");
            return this.getCellValue(cellValue.getCellType(), cell, cellValue, key);
        }
        if (type == 3) {
            log.trace("blank");
            return null;
        }
        throw new CUFServiceException("Unsupported cell type: " + cell.getCellType());
    }

    private int getColumnCount(Sheet sheet, Map<String, String> mappings) {
        Cell c;
        Row row = sheet.getRow(0);
        int columnCount = 0;
        for (int i = 0; i < row.getLastCellNum() && (c = row.getCell(i)) != null && c.getCellType() == 1 && !StringUtils.isBlank((CharSequence)c.getStringCellValue()); ++i) {
            ++columnCount;
        }
        log.debug("Column count: {}", (Object)columnCount);
        this.initHeaders(row, columnCount);
        this.initKeys(mappings);
        return columnCount;
    }

    private void initKeys(Map<String, String> mappings) {
        boolean hasMappings = mappings != null;
        this.keys = new String[this.headers.length];
        for (int i = 0; i < this.headers.length; ++i) {
            this.keys[i] = hasMappings ? mappings.get(this.headers[i]) : this.headers[i];
        }
    }

    private void initHeaders(Row row, int columnCount) {
        this.headers = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Cell c = row.getCell(i);
            this.headers[i] = c.getStringCellValue();
        }
    }
}

