/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.CUF.util.extension.JsonMessage;
import com.plusmpm.CUF.util.extension.ServletFile;
import com.plusmpm.CUF.util.extension.ServletTools;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ImportDTFromExcel
extends HttpServlet {
    public static Logger log = Logger.getLogger(ImportDTFromExcel.class);
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug((Object)"************************* ExportTable Servlet ****************************");
        log.debug((Object)"Params:");
        JsonMessage jm = new JsonMessage();
        ObjectMapper om = new ObjectMapper();
        resp.setContentType("text/html;charset=UTF-8");
        try {
            Map<String, Object> params = ServletTools.getParametersFromMultiPart(req);
            List<String> headers = this.readHeaders(req.getParameter("headers"));
            ServletFile sf = (ServletFile)params.get("file");
            ExcelReader er = new ExcelReader();
            List<Map<String, Object>> data = er.readExcel(sf.getInputStream(), headers);
            jm.setData(data);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            om.setDateFormat((DateFormat)df);
            String json = om.writeValueAsString((Object)jm);
            resp.getWriter().print(json);
            resp.getWriter().close();
        }
        catch (CUFException e) {
            log.error((Object)e, (Throwable)e);
            jm.setSuccess(false);
            jm.setErrorMsg(e.getMessage());
            String json = om.writeValueAsString((Object)jm);
            resp.getWriter().print(json);
            resp.getWriter().close();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            jm.setSuccess(false);
            jm.setErrorMsg("Nieznany b\u0142\u0105d");
            String json = om.writeValueAsString((Object)jm);
            resp.getWriter().print(json);
            resp.getWriter().close();
        }
    }

    private List<String> readHeaders(String sHeaders) throws JsonParseException, JsonMappingException, IOException {
        log.debug((Object)("headers: " + sHeaders));
        ObjectMapper om = new ObjectMapper();
        List list = (List)om.readValue(sHeaders, (TypeReference)new TypeReference<List<String>>(){});
        return list;
    }
}

