/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.database.CommentsTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.util.AdvanceSearchResult;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.workflowData.ActivityData;
import com.plusmpm.util.workflowData.ProcessData;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.util.ServiceFactory;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.timebase.UtcT;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataType;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ExportProcessToPdf {
    public static Logger log = Logger.getLogger(ExportProcessToPdf.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ExportProcess(String processId, String sClassName, String sExpirationDate, String sDevice, String sFolder, String sOtherIndecies, String sLanguage, String sPDFIds, String sPDFVariables, String sPDFHistory, String sPDFDocuments, String sPDFComments, String sTaskTemplate, String sLogin) {
        log.trace((Object)("************ ExportProcess(processId=" + processId + ", sClassName=" + sClassName + ", sExpirationDate=" + sExpirationDate + ", sDevice=" + sDevice + ", sFolder=" + sFolder + ", sOtherIndecies=" + sOtherIndecies + ", sLanguage=" + sLanguage + ", sPDFIds=" + sPDFIds + ", sPDFVariables=" + sPDFVariables + ", sPDFHistory=" + sPDFHistory + ", sPDFDocuments=" + sPDFDocuments + ", sPDFComments=" + sPDFComments + ", sTaskTemplate=" + sTaskTemplate + ", sLogin=" + sLogin + ") ************"));
        SharkTransaction st = null;
        String pdfFileId = "-1";
        try {
            st = Shark.getInstance().createTransaction();
            pdfFileId = ExportProcessToPdf.ExportProcess(st, processId, sClassName, sExpirationDate, sDevice, sFolder, sOtherIndecies, sLanguage, sPDFIds, sPDFVariables, sPDFHistory, sPDFDocuments, sPDFComments, sTaskTemplate, sLogin);
            st.commit();
        }
        catch (Throwable throwable) {
            log.error((Object)throwable.getMessage(), throwable);
            try {
                Shark.getInstance().emptyCaches(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                Shark.getInstance().unlockProcesses(st);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                st.release();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        return pdfFileId;
    }

    public static String ExportProcess(SharkTransaction st, String processId, String sClassName, String sExpirationDate, String sDevice, String sFolder, String sOtherIndecies, String sLanguage, String sPDFIds, String sPDFVariables, String sPDFHistory, String sPDFDocuments, String sPDFComments, String sTaskTemplate, String sLogin) {
        log.trace((Object)("************ ExportProcess(SharkTransaction, processId=" + processId + ", sClassName=" + sClassName + ", sExpirationDate=" + sExpirationDate + ", sDevice=" + sDevice + ", sFolder=" + sFolder + ", sOtherIndecies=" + sOtherIndecies + ", sLanguage=" + sLanguage + ", sPDFIds=" + sPDFIds + ", sPDFVariables=" + sPDFVariables + ", sPDFHistory=" + sPDFHistory + ", sPDFDocuments=" + sPDFDocuments + ", sPDFComments=" + sPDFComments + ", sTaskTemplate=" + sTaskTemplate + ", sLogin=" + sLogin + ") ************"));
        DBManagement dbm = new DBManagement();
        String pdfFileId = "-1";
        try {
            String[] activeDefVarTable;
            Object dirId;
            long nowTime = new Date().getTime();
            ProcessData processData = new ProcessData();
            AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
            String sProcessDefId = "";
            if (adminMisc != null) {
                sProcessDefId = adminMisc.getProcessDefinitionId(st, processId);
            }
            if (Tools.isNullOrEmpty((String)sProcessDefId)) {
                throw new CUFException("Niepoprawny identyfikator definicji procesu");
            }
            Map processDefIdsAndNamesMap = processData.getProcessDefIdsNames();
            if (processDefIdsAndNamesMap == null || processDefIdsAndNamesMap.size() == 0) {
                throw new CUFException("Brak identyfikatorow definicji procesow w systemie");
            }
            Iterator processDefIdIterator = processDefIdsAndNamesMap.keySet().iterator();
            boolean bProcDefIdExists = false;
            while (processDefIdIterator.hasNext()) {
                String oneProcDefId = (String)processDefIdIterator.next();
                if (!oneProcDefId.equals(sProcessDefId)) continue;
                bProcDefIdExists = true;
                break;
            }
            if (!bProcDefIdExists) {
                throw new CUFException("W systemie nie istnieje proces o identyfikatorze definicji " + sProcessDefId);
            }
            int howManyIndicies = 6;
            String[] mandatoryIndecies = new String[howManyIndicies];
            String[] mandatoryIndeciesDesc = new String[howManyIndicies];
            String[] mandatoryIndeciesTypes = new String[]{"string", "string", "date", "string", "date", "string"};
            mandatoryIndecies[0] = "processId";
            mandatoryIndeciesDesc[0] = ExportProcessToPdf.getMessageForLanguage("Identyfikator procesu", sLanguage);
            mandatoryIndecies[1] = ExportProcessToPdf.getMessageForLanguage("Nazwa procesu", sLanguage);
            mandatoryIndeciesDesc[1] = mandatoryIndecies[1];
            mandatoryIndecies[2] = ExportProcessToPdf.getMessageForLanguage("Data rozpocz\u0119cia procesu", sLanguage);
            mandatoryIndeciesDesc[2] = mandatoryIndecies[2];
            mandatoryIndecies[3] = ExportProcessToPdf.getMessageForLanguage("Czas rozpocz\u0119cia procesu", sLanguage);
            mandatoryIndeciesDesc[3] = mandatoryIndecies[3];
            mandatoryIndecies[4] = ExportProcessToPdf.getMessageForLanguage("Data archiwizacji", sLanguage);
            mandatoryIndeciesDesc[4] = mandatoryIndeciesDesc[4];
            mandatoryIndecies[5] = ExportProcessToPdf.getMessageForLanguage("Inicjator", sLanguage);
            mandatoryIndeciesDesc[5] = mandatoryIndeciesDesc[5];
            DocClassTable docClassTable = dbm.getDocClassByName(sClassName);
            String docClassId = "";
            String filesPath = "";
            ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
            if (docClassTable != null) {
                Device deviceTable;
                log.debug((Object)("Klasa " + sClassName + " istnieje juz w systemie"));
                docClassId = String.valueOf(docClassTable.getId());
                if (Tools.isNullOrEmpty((String)docClassId)) {
                    throw new CUFException("Nieznany identyfikator klasy dokumentow " + sClassName);
                }
                if (!sDevice.equalsIgnoreCase("NULL") && !sFolder.equalsIgnoreCase("NULL")) {
                    deviceTable = as.getDeviceForDocumentClass(new Long(docClassId), new String[]{"directories"});
                    if (deviceTable == null) {
                        throw new CUFException("Brak urzadzenia dla klasy dokumentow " + sClassName);
                    }
                    String deviceName = deviceTable.getDeviceName();
                    if (deviceName == null || !deviceName.equalsIgnoreCase(sDevice)) {
                        throw new CUFException("Niezgodnosc nazw urzadzenia klasy " + sClassName + " z parametrem zadania zaplanowanego");
                    }
                    String id = deviceTable.getId().toString();
                    Set allDirs = deviceTable.getDirectories();
                    boolean bFoundDir = false;
                    for (Directory oneDirTable : allDirs) {
                        String dirName;
                        if (oneDirTable == null || (dirName = oneDirTable.getDirectoryName()) == null || !sFolder.equalsIgnoreCase(dirName)) continue;
                        bFoundDir = true;
                        String path = deviceTable.getDevicePath();
                        if (Tools.isNullOrEmpty((String)path)) break;
                        filesPath = path + dirName;
                        log.debug((Object)("Klasa zapisuje dokumenty w lokalizacji: " + filesPath + ". Zgodnosc urzadzenia i katalogu klasy dokumentow " + sClassName + " z parametrami zadania zaplanowanego"));
                        break;
                    }
                    if (!bFoundDir) {
                        throw new CUFException("Folder zapisu dokumentow " + sFolder + " nie istnieje w urzadzeniu " + sDevice);
                    }
                } else {
                    Directory dirTable;
                    deviceTable = as.getDeviceForDocumentClass(new Long(docClassId), new String[0]);
                    if (deviceTable == null) {
                        throw new CUFException("Brak urzadzenia dla klasy dokumentow " + sClassName);
                    }
                    String path = deviceTable.getDevicePath();
                    dirId = docClassTable.getDocClassDirectoryId();
                    if (dirId != null && (dirTable = as.getDirectory((Long)dirId, new String[0])) != null) {
                        String dirName = dirTable.getDirectoryName();
                        if (!Tools.isNullOrEmpty((String)path) && !Tools.isNullOrEmpty((String)dirName)) {
                            filesPath = path + dirName;
                        }
                    }
                }
            } else {
                log.debug((Object)("Klasa " + sClassName + " nie istnieje w systemie. Proces tworzenia klasy rozpoczety"));
                String sClassDescr = "";
                sClassDescr = ExportProcessToPdf.getMessageForLanguage("Archiwum proces\u00f3w", sLanguage) + " " + sProcessDefId + ExportProcessToPdf.getMessageForLanguage("", sLanguage);
                String sExpireDocumentType = "dayCnt";
                if (sExpirationDate.equalsIgnoreCase("NEVER")) {
                    sExpirationDate = null;
                }
                dirId = "";
                List allDevices = as.getAllDevices(new String[]{"directories"});
                if (allDevices == null) {
                    throw new CUFException("Brak urzadzen w systemie. Nie mozna wiec zlokalizowac urzadzenia " + sDevice);
                }
                block5: for (Device oneDeviceTable : allDevices) {
                    String deviceName;
                    if (oneDeviceTable == null || (deviceName = oneDeviceTable.getDeviceName()) == null || !sDevice.equalsIgnoreCase(deviceName)) continue;
                    String id = oneDeviceTable.getId().toString();
                    Set allDirs = oneDeviceTable.getDirectories();
                    for (Directory oneDirTable : allDirs) {
                        String dirName;
                        if (oneDirTable == null || (dirName = oneDirTable.getDirectoryName()) == null || !sFolder.equalsIgnoreCase(dirName)) continue;
                        String path = oneDeviceTable.getDevicePath();
                        if (!Tools.isNullOrEmpty((String)path)) {
                            filesPath = path + dirName;
                        }
                        dirId = String.valueOf(oneDirTable.getId());
                        break block5;
                    }
                }
                if (Tools.isNullOrEmpty((String)dirId)) {
                    throw new CUFException("Nie mozna zlokalizowac w systemie katalogu " + sFolder);
                }
                log.debug((Object)("Urzadzenie " + sDevice + " oraz folder " + sFolder + " zidentyfikowane dla klasy dokumnetow " + sClassName));
                docClassTable = new DocClassTable(sClassName, sClassDescr, sExpirationDate, sExpireDocumentType, new Long((String)dirId), "false", "false");
                docClassTable.setCipherAlgorithm("");
                docClassTable.setKeyLength(new Long("0"));
                docClassTable.setDocClassIndex("true");
                docClassTable.setDocClassDirectoryName(sFolder);
                Long lMaxIdx = dbm.getMaxOrderDocClass();
                if (lMaxIdx == null) {
                    lMaxIdx = new Long(-1L);
                }
                docClassTable.setDocClassOrderId(Long.valueOf(lMaxIdx + 1L));
                dbm.addDocClass(docClassTable);
                docClassId = String.valueOf(docClassTable.getId());
                if (Tools.isNullOrEmpty((String)docClassId)) {
                    throw new CUFException("Nieznany identyfikator klasy dokumentow " + sClassName);
                }
                String sFullDirPath = Tools.GetFullDirPath((String)docClassId);
                docClassTable.setDocClassIndexPath(sFullDirPath + "indexDir_" + docClassId);
                dbm.changeDocClass(docClassTable);
                log.debug((Object)("Stworzono klase dokumentu o nazwie " + sClassName + " oraz identyfikatorze " + docClassId));
            }
            if (Tools.isNullOrEmpty((String)filesPath)) {
                throw new CUFException("Nieznana sciezka do zapisu zarchiwizowanych procesow");
            }
            log.debug((Object)("Sprawdzanie wystepowania obowiazkowych indeksow w klasie dokumentow " + sClassName));
            for (int i = 0; i < mandatoryIndecies.length && mandatoryIndecies.length == mandatoryIndeciesDesc.length; ++i) {
                Long sIndexExists = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[i]);
                if (sIndexExists == null) {
                    log.debug((Object)("Obowiazkowy indeks " + mandatoryIndecies[i] + " nie istnieje dla klasy dokumentow " + sClassName + ". Tworzenie indeksu"));
                    long indexId = ArchiveServices.CreateIndexForDocClass(docClassId, mandatoryIndecies[i], mandatoryIndeciesDesc[i], mandatoryIndeciesTypes[i], "");
                    if (indexId != -1L) {
                        log.debug((Object)("Obowiazkowy indeks o nazwie " + mandatoryIndecies[i] + " i typie " + mandatoryIndeciesTypes[i] + " stworzony poprawnie w klasie dokumentow " + sClassName));
                        continue;
                    }
                    log.debug((Object)("Blad podczas dodawania obowiazkowego indeksu o nazwie " + mandatoryIndecies[i] + " i typie " + mandatoryIndeciesTypes[i] + " w klasie dokumentow " + sClassName));
                    continue;
                }
                log.debug((Object)("Obowiazkowy indeks " + mandatoryIndecies[i] + " istnieje dla klasy dokumentow " + sClassName));
            }
            WorkflowProcess wp = null;
            Package pack = SharkFunctions.getPackageManager().getPackageByProcessId(processId);
            ArrayList<String> activeProcVar = new ArrayList<String>();
            ArrayList<String> activeDefVar = new ArrayList<String>();
            HashMap<String, String> hmAdSearchVar = new HashMap<String, String>();
            Map mAllProcVar = null;
            ArrayList process = null;
            for (String oneActDef : activeDefVarTable = new String[]{"procDescr", "procInitiator", "procStateSelect", "procStart", "procFinish", "processType"}) {
                activeDefVar.add(oneActDef);
            }
            String sProcessName = "";
            wp = pack.getWorkflowProcess(sProcessDefId);
            if (wp != null) {
                log.debug((Object)("Proces o identyfikatorze definicji " + sProcessDefId + " istnieje"));
                mAllProcVar = ProcessData.getProcessVariableIdNameMap((String)sProcessDefId);
                Iterator valuesIds = mAllProcVar.keySet().iterator();
                boolean indiciecForAllVars = false;
                if (sOtherIndecies.equalsIgnoreCase("ALL")) {
                    sOtherIndecies = "";
                    indiciecForAllVars = true;
                }
                while (valuesIds.hasNext()) {
                    String VarId = (String)valuesIds.next();
                    if (VarId == null) continue;
                    activeProcVar.add(VarId);
                    if (!indiciecForAllVars) continue;
                    if (sOtherIndecies.equalsIgnoreCase("")) {
                        sOtherIndecies = VarId;
                        continue;
                    }
                    sOtherIndecies = sOtherIndecies + "," + VarId;
                }
                Map<String, Map<String, String>> confMap = ExportProcessToPdf.prepareConfigurationMap(wp, sProcessDefId, mAllProcVar, sTaskTemplate);
                String[] namesForOtherIndecies = null;
                if (!sOtherIndecies.equalsIgnoreCase("NULL")) {
                    log.debug((Object)("Sprawdzanie wystepowania dodatkowych indeksow w klasie dokumentow " + sClassName));
                    String[] otherIndeciesTable = sOtherIndecies.split(",");
                    String[] temp = ExportProcessToPdf.sortOtherIndiciesTable(otherIndeciesTable);
                    if (temp.length == otherIndeciesTable.length) {
                        otherIndeciesTable = temp;
                    }
                    namesForOtherIndecies = new String[otherIndeciesTable.length];
                    int counterForOtherIndecies = 0;
                    howManyIndicies += otherIndeciesTable.length;
                    for (String oneOtherIndex : otherIndeciesTable) {
                        Object oOtherIndexName = mAllProcVar.get(oneOtherIndex);
                        if (oOtherIndexName != null) {
                            oneOtherIndex = ExportProcessToPdf.checkDuplicateVarViewName(mAllProcVar, oOtherIndexName.toString(), oneOtherIndex);
                        }
                        namesForOtherIndecies[counterForOtherIndecies] = oneOtherIndex;
                        Long sIndexExists = ArchiveServices.GetIndexIdForDocClass(sClassName, oneOtherIndex);
                        if (sIndexExists == null) {
                            long indexId;
                            log.debug((Object)("Dodatkowy indeks " + oneOtherIndex + " nie istnieje dla klasy dokumentow " + sClassName + ". Tworzenie indeksu"));
                            String sType = "";
                            if (confMap != null && confMap.size() > 0 && confMap.get("indeciestypes") != null && confMap.get("indeciestypes").size() > 0) {
                                sType = confMap.get("indeciestypes").get(oneOtherIndex);
                            }
                            if (Tools.isNullOrEmpty((String)sType)) {
                                sType = "string";
                            }
                            if ((indexId = ArchiveServices.CreateIndexForDocClass(docClassId, oneOtherIndex, oneOtherIndex, sType, "")) != -1L) {
                                log.debug((Object)("Dodatkowy indeks o nazwie " + oneOtherIndex + " i typie " + sType + " stworzony poprawnie w klasie dokumentow " + sClassName));
                            } else {
                                log.debug((Object)("Blad podczas dodawania dodatkowego indeksu o nazwie " + oneOtherIndex + " i typie " + sType + " w klasie dokumentow " + sClassName));
                            }
                        } else {
                            log.debug((Object)("Dodatkowy indeks " + oneOtherIndex + " istnieje dla klasy dokumentow " + sClassName));
                        }
                        ++counterForOtherIndecies;
                    }
                } else {
                    log.debug((Object)("Parametr zadania nie definiuje dodatkowych indeksow dla klasy dokumentow " + sClassName));
                }
                AdvanceSearchResult advanceSearchResult = null;
                WfProcess wfprocess = SharkFunctions.getWfProcess((SharkTransaction)st, (String)processId);
                if (wfprocess != null) {
                    String wfProcessName = wfprocess.name(st);
                    hmAdSearchVar.put("procDefId", sProcessDefId);
                    if (!Tools.isNullOrEmpty((String)wfProcessName)) {
                        sProcessName = wfProcessName;
                        hmAdSearchVar.put("procName", wfProcessName);
                    } else {
                        sProcessName = (String)processDefIdsAndNamesMap.get(sProcessDefId);
                    }
                    process = processData.search(activeProcVar, activeDefVar, hmAdSearchVar, wp);
                    if (process == null || process.size() == 0) {
                        throw new CUFException("Nie odnaleziono procesu");
                    }
                    for (AdvanceSearchResult asr : process) {
                        String processIdCheck;
                        if (asr == null || !(processIdCheck = asr.getProcessId()).equalsIgnoreCase(processId)) continue;
                        advanceSearchResult = asr;
                        break;
                    }
                    if (advanceSearchResult != null) {
                        File file = ExportProcessToPdf.preparePdf(st, confMap, mAllProcVar, filesPath, sClassName, sProcessName, advanceSearchResult, sPDFIds, sPDFVariables, sPDFHistory, sPDFDocuments, sPDFComments, sLanguage);
                        if (file != null && !file.getName().equalsIgnoreCase("ERROR")) {
                            log.debug((Object)"Plik PDF stworzony");
                            String sDescription = sProcessName + " id: " + processId;
                            String processStartTime = ExportProcessToPdf.getValueFromAdvancedSearchResult(advanceSearchResult, "procStart", "name");
                            String[] processStartTimeSplit = processStartTime.split(" ");
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            String whenArchived = sdf.format(new Date(nowTime));
                            String processInitiatorId = ExportProcessToPdf.getValueFromAdvancedSearchResult(advanceSearchResult, "procInitiator", "name");
                            String processInitiatorName = ExportProcessToPdf.getRealNameForUserId(processInitiatorId);
                            String[] asIndicies = new String[howManyIndicies];
                            asIndicies[0] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[0]) + "=" + processId;
                            asIndicies[1] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[1]) + "=" + sProcessName;
                            asIndicies[2] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[2]) + "=" + processStartTimeSplit[0];
                            asIndicies[3] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[3]) + "=" + processStartTimeSplit[1];
                            asIndicies[4] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[4]) + "=" + whenArchived;
                            asIndicies[5] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[5]) + "=" + processInitiatorName;
                            if (!sOtherIndecies.equalsIgnoreCase("NULL")) {
                                Map<String, Object> processContextMap = SharkClientFunctions.getProcessContextMap(st, processId);
                                String[] otherIndeciesTable = sOtherIndecies.split(",");
                                String[] temp = ExportProcessToPdf.sortOtherIndiciesTable(otherIndeciesTable);
                                if (temp.length == otherIndeciesTable.length) {
                                    otherIndeciesTable = temp;
                                }
                                for (int z = 6; z < otherIndeciesTable.length + 6; ++z) {
                                    Long id = ArchiveServices.GetIndexIdForDocClass(sClassName, namesForOtherIndecies[z - 6]);
                                    String value = "";
                                    Object oValue = processContextMap.get(otherIndeciesTable[z - 6]);
                                    if (oValue != null) {
                                        value = oValue.toString();
                                    }
                                    asIndicies[z] = id + "=" + value;
                                }
                            }
                            int result = ArchiveServices.AddFileToArchive(sClassName, asIndicies, file, sDescription, "TRUE", sLogin);
                            pdfFileId = String.valueOf(result);
                            if (result > 0) {
                                log.debug((Object)("Plik PDF poprawnie zapisany w archiwum w klasie dokumentow " + sClassName + " z identyfikatorem pliku " + String.valueOf(result)));
                                file.delete();
                            } else {
                                log.debug((Object)"Blad podczas zapisywania pliku PDF do archiwum");
                            }
                        } else if (file != null && file.getName().equalsIgnoreCase("ERROR")) {
                            log.debug((Object)"Blad podczas archiwizowania procesu. Plik PDF nie zostal stworzony");
                        } else {
                            log.debug((Object)"Plik PDF nie zostal stworzony");
                        }
                    }
                }
            }
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return pdfFileId;
    }

    private static File preparePdf(SharkTransaction st, Map<String, Map<String, String>> confMap, Map<String, Object> mAllProcVar, String filesPath, String sClassName, String sProcessName, AdvanceSearchResult advanceSearchResult, String sPDFIds, String sPDFVariables, String sPDFHistory, String sPDFDocuments, String sPDFComments, String sLanguage) {
        log.trace((Object)("************ preparePdf(SharkTransaction, Map<String, Map<String, String>>, Map<String, Object>, filesPath=" + filesPath + ", sClassName=" + sClassName + ", sProcessName=" + sProcessName + ", AdvanceSearchResult, sPDFIds=" + sPDFIds + ", sPDFVariables=" + sPDFVariables + ", sPDFHistory=" + sPDFHistory + ", sPDFDocuments=" + sPDFDocuments + ", sPDFComments=" + ", sLanguage=" + sLanguage + ") ************"));
        File file = null;
        DBManagement dbm = new DBManagement();
        int chapterNr = 1;
        try {
            String sProcessId;
            if (advanceSearchResult != null && !Tools.isNullOrEmpty((String)(sProcessId = advanceSearchResult.getProcessId()))) {
                Map<String, Object> processContextMap = SharkClientFunctions.getProcessContextMap(st, sProcessId);
                String[] indexes = new String[]{"processId=" + sProcessId};
                String foundFileId = ArchiveServices.CheckIfDocumentExists(sClassName, indexes);
                if (foundFileId.equalsIgnoreCase("-1")) {
                    log.debug((Object)("Proces o identyfikatorze " + sProcessId + " nie zostal jeszcze zarchiwizowany"));
                    String[] mainLabelsForProcess = new String[]{"procDefId", "procDescr", "procInitiator", "procStateSelect", "procStart", "procFinish", "processType", "procName"};
                    String[] mainLabelsValuesForProcess = ExportProcessToPdf.prepareValuesTableForMainLabels(advanceSearchResult, mainLabelsForProcess);
                    mainLabelsValuesForProcess[3] = CUFTools.getStatusNameForLanguage(mainLabelsValuesForProcess[3], sLanguage, true);
                    ArrayList advanceVariableList = advanceSearchResult.getAlVariables();
                    Document document = new Document(PageSize.A4, 50.0f, 50.0f, 50.0f, 50.0f);
                    Font font = null;
                    BaseFont baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1250", (boolean)true);
                    Paragraph paragraph = null;
                    Phrase phrase = null;
                    Table table = null;
                    Cell cell = null;
                    PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filesPath + "\\" + sProcessId + ".pdf"));
                    document.open();
                    document.addAuthor("admin");
                    document.addTitle(ExportProcessToPdf.getMessageForLanguage("Informacje o procesie", sLanguage) + " " + sProcessName + ExportProcessToPdf.getMessageForLanguage("", sLanguage));
                    document.addCreationDate();
                    font = new Font(baseFont, 20.0f, 1, new Color(0, 0, 153));
                    paragraph = new Paragraph(ExportProcessToPdf.getMessageForLanguage("Informacje o procesie", sLanguage) + " " + sProcessName + ExportProcessToPdf.getMessageForLanguage("", sLanguage), font);
                    paragraph.setAlignment(1);
                    paragraph.setSpacingAfter(30.0f);
                    document.add((Element)paragraph);
                    font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                    paragraph = new Paragraph(chapterNr + ". " + ExportProcessToPdf.getMessageForLanguage("Dane og\u00f3lne procesu", sLanguage), font);
                    ++chapterNr;
                    paragraph.setSpacingAfter(12.0f);
                    document.add((Element)paragraph);
                    paragraph = new Paragraph();
                    paragraph.setAlignment(3);
                    if (sPDFIds.equalsIgnoreCase("TRUE")) {
                        font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                        phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Identyfikator definicji procesu", sLanguage) + ": ", font);
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(mainLabelsValuesForProcess[0] + "\n", font);
                        paragraph.add((Object)phrase);
                    }
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Typ procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[6] + "\n", font);
                    paragraph.add((Object)phrase);
                    if (sPDFIds.equalsIgnoreCase("TRUE")) {
                        font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                        phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Identyfikator procesu", sLanguage) + ": ", font);
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(sProcessId + "\n", font);
                        paragraph.add((Object)phrase);
                    }
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Nazwa procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(sProcessName + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Opis procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[1] + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Inicjator procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[2] + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Status procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[3] + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Data rozpocz\u0119cia procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[4] + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Data ostatniej zmiany stanu procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[5] + "\n", font);
                    paragraph.add((Object)phrase);
                    document.add((Element)paragraph);
                    if (sPDFVariables.equalsIgnoreCase("TRUE")) {
                        document.newPage();
                        font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                        paragraph = new Paragraph(chapterNr + ". " + ExportProcessToPdf.getMessageForLanguage("Tabele zmiennych procesu", sLanguage), font);
                        ++chapterNr;
                        paragraph.setSpacingAfter(2.0f);
                        document.add((Element)paragraph);
                        if (confMap != null && confMap.get("variabletoprocess") != null && confMap.get("variabletoprocess").size() > 0 && confMap.get("variableset1") != null && confMap.get("variableset1").size() > 0) {
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            paragraph = new Paragraph(ExportProcessToPdf.getMessageForLanguage("Zmienne nietabelaryczne", sLanguage), font);
                            paragraph.setSpacingAfter(8.0f);
                            document.add((Element)paragraph);
                            font = new Font(baseFont, 14.0f, 1, new Color(255, 255, 255));
                            int nrOfCells = 0;
                            nrOfCells = sPDFIds.equalsIgnoreCase("TRUE") ? 3 : 2;
                            table = new Table(nrOfCells);
                            table.setBorderWidth(1.0f);
                            table.setWidth(100.0f);
                            table.setBorderColor(new Color(0, 0, 0));
                            table.setAlignment(1);
                            table.setPadding(4.0f);
                            table.setCellsFitPage(true);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Nazwa zmiennej procesu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Identyfikator zmiennej procesu", sLanguage), font));
                                cell.setHeader(true);
                                cell.setHorizontalAlignment(1);
                                cell.setVerticalAlignment(5);
                                cell.setBackgroundColor(new Color(0, 0, 153));
                                table.addCell(cell);
                            }
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Warto\u015b\u0107 zmiennej procesu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            table.endHeaders();
                            font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                            Map<String, String> variablesToProcessMap = confMap.get("variabletoprocess");
                            int counterForVariableToProcess = 1;
                            String sVariableToProcessId = null;
                            if (variablesToProcessMap != null && variablesToProcessMap.size() > 0) {
                                sVariableToProcessId = variablesToProcessMap.get(String.valueOf(counterForVariableToProcess));
                            } else {
                                cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Brak zmiennych poza tabelami dynamicznymi", sLanguage), font));
                                cell.setHorizontalAlignment(1);
                                cell.setColspan(nrOfCells);
                                table.addCell(cell);
                            }
                            while (sVariableToProcessId != null) {
                                String sVariableName = "";
                                Object oVariableName = mAllProcVar.get(sVariableToProcessId);
                                String sVariableValue = "";
                                Object oVariableValue = processContextMap.get(sVariableToProcessId);
                                if (oVariableName != null) {
                                    sVariableName = oVariableName.toString();
                                }
                                if (oVariableValue != null) {
                                    sVariableValue = oVariableValue.toString();
                                }
                                if (!Tools.isNullOrEmpty((String)sVariableName)) {
                                    cell = new Cell((Element)new Phrase(sVariableName, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                    if (!Tools.isNullOrEmpty((String)sVariableToProcessId)) {
                                        cell = new Cell((Element)new Phrase(sVariableToProcessId, font));
                                        cell.setHorizontalAlignment(0);
                                        table.addCell(cell);
                                    } else {
                                        cell = new Cell((Element)new Phrase("N/A", font));
                                        cell.setHorizontalAlignment(0);
                                        table.addCell(cell);
                                    }
                                }
                                if (sVariableValue == null) {
                                    sVariableValue = "";
                                }
                                cell = new Cell((Element)new Phrase(sVariableValue, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                sVariableToProcessId = variablesToProcessMap.get(String.valueOf(++counterForVariableToProcess));
                            }
                            document.add((Element)table);
                            int dynamicTableCounter = 1;
                            Map<String, String> dynamicTableMap = confMap.get("variableset" + String.valueOf(dynamicTableCounter));
                            if (dynamicTableMap != null && dynamicTableMap.size() > 0) {
                                document.newPage();
                                font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                                paragraph = new Paragraph(ExportProcessToPdf.getMessageForLanguage("Tabele dynamiczne", sLanguage), font);
                                paragraph.setSpacingAfter(2.0f);
                                document.add((Element)paragraph);
                                while (dynamicTableMap != null && dynamicTableMap.size() > 0) {
                                    document.add((Element)new Phrase("\n"));
                                    font = new Font(baseFont, 12.0f, 1, new Color(255, 255, 255));
                                    table = new Table(dynamicTableMap.size());
                                    table.setBorderWidth(1.0f);
                                    table.setWidth(100.0f);
                                    table.setBorderColor(new Color(0, 0, 0));
                                    table.setAlignment(1);
                                    table.setPadding(4.0f);
                                    table.setCellsFitPage(true);
                                    int varInTableOrder = 1;
                                    String sVariableId = dynamicTableMap.get(String.valueOf(varInTableOrder));
                                    while (sVariableId != null) {
                                        String sVariableName = "";
                                        Object oVariableName = mAllProcVar.get(sVariableId);
                                        if (oVariableName != null) {
                                            sVariableName = oVariableName.toString();
                                        }
                                        if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                            sVariableName = sVariableName.equalsIgnoreCase("") ? sVariableId : sVariableName + " (" + sVariableId + ")";
                                        }
                                        cell = new Cell((Element)new Phrase(sVariableName, font));
                                        cell.setHeader(true);
                                        cell.setHorizontalAlignment(1);
                                        cell.setVerticalAlignment(5);
                                        cell.setBackgroundColor(new Color(0, 0, 153));
                                        table.addCell(cell);
                                        sVariableId = dynamicTableMap.get(String.valueOf(++varInTableOrder));
                                    }
                                    table.endHeaders();
                                    varInTableOrder = 1;
                                    sVariableId = dynamicTableMap.get(String.valueOf(varInTableOrder));
                                    int columnNr = 0;
                                    while (sVariableId != null) {
                                        int rowNr = 1;
                                        String sVariableValue = "";
                                        Object oVariableValue = processContextMap.get(sVariableId);
                                        if (oVariableValue != null) {
                                            sVariableValue = oVariableValue.toString();
                                        }
                                        String[] variableValuesTable = sVariableValue.split(";", -1);
                                        if (varInTableOrder == 1 && variableValuesTable.length == 1 && variableValuesTable[0].equalsIgnoreCase("")) {
                                            boolean emptyTable = true;
                                            ++varInTableOrder;
                                            String sVariableIdTest = sVariableId;
                                            while (sVariableIdTest != null) {
                                                String sVariableValueTest = "";
                                                Object oVariableValueTest = processContextMap.get(sVariableIdTest);
                                                if (oVariableValueTest != null) {
                                                    sVariableValueTest = oVariableValueTest.toString();
                                                }
                                                if (!sVariableValueTest.equalsIgnoreCase("")) {
                                                    emptyTable = false;
                                                    break;
                                                }
                                                sVariableIdTest = dynamicTableMap.get(String.valueOf(++varInTableOrder));
                                            }
                                            varInTableOrder = 1;
                                            if (emptyTable) {
                                                font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                                                cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Pusta tabela", sLanguage), font));
                                                cell.setHorizontalAlignment(1);
                                                cell.setColspan(dynamicTableMap.size());
                                                table.addCell(cell);
                                                break;
                                            }
                                        } else {
                                            font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                                            for (String oneVar : variableValuesTable) {
                                                cell = new Cell((Element)new Phrase(oneVar, font));
                                                cell.setHorizontalAlignment(0);
                                                table.addCell(cell, rowNr, columnNr);
                                                ++rowNr;
                                            }
                                        }
                                        ++columnNr;
                                        sVariableId = dynamicTableMap.get(String.valueOf(++varInTableOrder));
                                    }
                                    document.add((Element)table);
                                    dynamicTableMap = confMap.get("variableset" + String.valueOf(++dynamicTableCounter));
                                }
                            }
                        } else {
                            paragraph.add((Object)"\n");
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Brak zmiennych procesu", sLanguage), font);
                            document.add((Element)phrase);
                        }
                    }
                    if (sPDFHistory.equalsIgnoreCase("TRUE")) {
                        document.newPage();
                        paragraph = new Paragraph();
                        font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                        phrase = new Phrase(chapterNr + ". " + ExportProcessToPdf.getMessageForLanguage("Historia procesu", sLanguage) + "\n", font);
                        ++chapterNr;
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Historia procesu zawiera poszczeg\u00f3lne zadania posortowane wed\u0142ug dat rozpocz\u0119cia zadania", sLanguage) + ":\n", font);
                        paragraph.add((Object)phrase);
                        paragraph.add((Object)"\n");
                        paragraph.setKeepTogether(true);
                        paragraph.setAlignment(3);
                        String[] activitiesStates = new String[]{"closed.completed", "closed.aborted", "closed.terminated", "open.not_running.not_started", "open.not_running.suspended", "open.running"};
                        WfActivity[] activitiesTable = SharkFunctions.getWfActivities((SharkTransaction)st, (String)sProcessId, (String[])activitiesStates);
                        if (activitiesTable != null && activitiesTable.length > 0) {
                            float[] help;
                            document.add((Element)paragraph);
                            font = new Font(baseFont, 13.0f, 1, new Color(255, 255, 255));
                            int nrOfCells = 0;
                            float[] widths = null;
                            if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                nrOfCells = 7;
                                widths = help = new float[]{5.0f, 17.0f, 16.0f, 17.0f, 12.0f, 16.0f, 17.0f};
                            } else {
                                nrOfCells = 6;
                                widths = help = new float[]{5.0f, 20.0f, 19.0f, 20.0f, 19.0f, 17.0f};
                            }
                            table = new Table(nrOfCells);
                            table.setBorderWidth(1.0f);
                            table.setWidth(100.0f);
                            table.setBorderColor(new Color(0, 0, 0));
                            table.setAlignment(1);
                            table.setPadding(4.0f);
                            table.setCellsFitPage(true);
                            table.setWidths(widths);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Nr", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Identyfikator zadania", sLanguage), font));
                                cell.setHeader(true);
                                cell.setHorizontalAlignment(1);
                                cell.setVerticalAlignment(5);
                                cell.setBackgroundColor(new Color(0, 0, 153));
                                table.addCell(cell);
                            }
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Nazwa zadania", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Status", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Inicjator", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Data rozpocz\u0119cia zadania", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Data zako\u0144czenia/zmiany stanu zadania", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            table.endHeaders();
                            font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                            WfActivity[] sortedActivitiesTable = ExportProcessToPdf.sortActivities(st, activitiesTable, sProcessId);
                            if (sortedActivitiesTable == null || sortedActivitiesTable.length < activitiesTable.length) {
                                sortedActivitiesTable = new WfActivity[activitiesTable.length];
                                sortedActivitiesTable = activitiesTable;
                            }
                            AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
                            int nrOfActivity = 0;
                            for (WfActivity oneActivity : sortedActivitiesTable) {
                                Long stopTime;
                                if (oneActivity == null) continue;
                                String activityId = oneActivity.key(st);
                                if (activityId == null) {
                                    activityId = "";
                                }
                                String taskName = oneActivity.name(st);
                                String taskStatus = "";
                                if (oneActivity.state(st) != null) {
                                    taskStatus = Tools.ChangeStateName((String)oneActivity.state(st), (boolean)false);
                                }
                                taskStatus = CUFTools.getStatusNameForLanguage(taskStatus, sLanguage, false);
                                String taskUser = "";
                                if (adminMisc != null) {
                                    taskUser = adminMisc.getActivityResourceUsername(st, sProcessId, activityId);
                                }
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                String taskStart = "";
                                Date startDate = null;
                                Long startTaskTime = null;
                                if (adminMisc != null) {
                                    startTaskTime = adminMisc.getActivityCreatedTime(st, sProcessId, activityId);
                                }
                                if (startTaskTime != null) {
                                    startDate = new Date(startTaskTime);
                                }
                                if (startDate != null) {
                                    taskStart = sdf.format(startDate);
                                }
                                String taskFinish = "";
                                UtcT utct = oneActivity.last_state_time(st);
                                if (utct != null && (stopTime = Long.valueOf(utct.getTime())) != null) {
                                    taskFinish = sdf.format(new Date(stopTime));
                                }
                                cell = new Cell((Element)new Phrase(String.valueOf(++nrOfActivity), font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                    cell = new Cell((Element)new Phrase(activityId, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (!Tools.isNullOrEmpty((String)taskName)) {
                                    cell = new Cell((Element)new Phrase(taskName, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (!Tools.isNullOrEmpty((String)taskStatus)) {
                                    cell = new Cell((Element)new Phrase(taskStatus, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (!Tools.isNullOrEmpty((String)taskUser)) {
                                    String userName = ExportProcessToPdf.getRealNameForUserId(taskUser);
                                    cell = new Cell((Element)new Phrase(userName, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else if (taskUser == null) {
                                    cell = new Cell((Element)new Phrase("System", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (!Tools.isNullOrEmpty((String)taskStart)) {
                                    cell = new Cell((Element)new Phrase(taskStart, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (!Tools.isNullOrEmpty((String)taskFinish)) {
                                    cell = new Cell((Element)new Phrase(taskFinish, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                    continue;
                                }
                                cell = new Cell((Element)new Phrase("N/A", font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                            }
                            document.add((Element)table);
                        } else {
                            paragraph.add((Object)"\n");
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Brak zada\u0144 w procesie", sLanguage), font);
                            paragraph.add((Object)phrase);
                            document.add((Element)paragraph);
                        }
                    }
                    if (sPDFDocuments.equalsIgnoreCase("TRUE")) {
                        document.newPage();
                        paragraph = new Paragraph();
                        font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                        phrase = new Phrase(chapterNr + ". " + ExportProcessToPdf.getMessageForLanguage("Dokumenty procesu", sLanguage) + "\n", font);
                        ++chapterNr;
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Dokumenty podpi\u0119te do procesu", sLanguage) + " " + sProcessName + ExportProcessToPdf.getMessageForLanguage("", sLanguage) + ":", font);
                        paragraph.add((Object)phrase);
                        paragraph.add((Object)"\n");
                        paragraph.setKeepTogether(true);
                        String DocIds = "";
                        Object oDocIds = processContextMap.get("DocIds");
                        if (oDocIds != null) {
                            DocIds = oDocIds.toString();
                        }
                        if (!Tools.isNullOrEmpty((String)DocIds)) {
                            String[] docIdsTable;
                            document.add((Element)paragraph);
                            font = new Font(baseFont, 14.0f, 1, new Color(255, 255, 255));
                            float[] widths = new float[]{17.0f, 18.0f, 17.0f, 17.0f, 14.0f, 17.0f};
                            table = new Table(6);
                            table.setBorderWidth(1.0f);
                            table.setWidth(100.0f);
                            table.setBorderColor(new Color(0, 0, 0));
                            table.setAlignment(1);
                            table.setPadding(4.0f);
                            table.setCellsFitPage(true);
                            table.setWidths(widths);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Nazwa dokumentu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Nazwa klasy dokument\u00f3w", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Opis dokumentu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Data dodania dokumentu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Rozmiar (bajty)", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("W\u0142a\u015bciciel", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            table.endHeaders();
                            for (String oneDocId : docIdsTable = DocIds.split(",")) {
                                FilesManager fm;
                                Files fileForDoc;
                                DocClassTable oneClass;
                                if (Tools.isNullOrEmpty((String)oneDocId)) continue;
                                String fileIdForDocId = "";
                                String classNameForDoc = "";
                                ArrayList docClassesList = dbm.GetAllDocClasses();
                                Iterator i$ = docClassesList.iterator();
                                while (i$.hasNext() && ((oneClass = (DocClassTable)i$.next()) == null || (classNameForDoc = oneClass.getDocClassName()) == null || Tools.isNullOrEmpty((String)(fileIdForDocId = ArchiveServices.GetNewestVersionDocFileId(classNameForDoc, oneDocId))))) {
                                }
                                if (Tools.isNullOrEmpty((String)fileIdForDocId) || (fileForDoc = (fm = new FilesManager()).GetFile(Long.valueOf(fileIdForDocId))) == null) continue;
                                String sFileDate = "";
                                String sFileSize = "";
                                String sFileName = fileForDoc.getOrg_name();
                                String sFileClass = classNameForDoc;
                                String sFileDesc = fileForDoc.getDescription();
                                Date fileDate = fileForDoc.getDate();
                                Long fileSize = fileForDoc.getSize();
                                String sFileUploader = fileForDoc.getUploader();
                                if (sFileName == null) {
                                    sFileName = "";
                                }
                                if (sFileClass == null) {
                                    sFileClass = "";
                                }
                                if (sFileDesc == null) {
                                    sFileDesc = "";
                                }
                                if (fileDate != null) {
                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    sFileDate = sdf.format(fileDate);
                                }
                                if (fileSize != null) {
                                    sFileSize = fileSize.toString();
                                }
                                if (sFileUploader == null) {
                                    sFileUploader = "";
                                }
                                sFileUploader = ExportProcessToPdf.getRealNameForUserId(sFileUploader);
                                font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                                cell = new Cell((Element)new Phrase(sFileName, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileClass, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileDesc, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileDate, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileSize, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileUploader, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                            }
                            document.add((Element)table);
                        } else {
                            paragraph.add((Object)"\n");
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Brak dokument\u00f3w do\u0142\u0105czonych do procesu", sLanguage), font);
                            paragraph.add((Object)phrase);
                            document.add((Element)paragraph);
                        }
                    }
                    if (sPDFComments.equalsIgnoreCase("TRUE")) {
                        document.newPage();
                        paragraph = new Paragraph();
                        font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                        phrase = new Phrase(chapterNr + ". " + ExportProcessToPdf.getMessageForLanguage("Komentarze", sLanguage) + "\n", font);
                        ++chapterNr;
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Komentarze wy\u015bwietlone w odwrotnej kolejno\u015bci dodawania", sLanguage), font);
                        paragraph.add((Object)phrase);
                        paragraph.add((Object)"\n");
                        paragraph.setKeepTogether(true);
                        ArrayList commentsList = dbm.GetAllCommentsForProcess(sProcessId);
                        if (commentsList != null && commentsList.size() > 0) {
                            document.add((Element)paragraph);
                            font = new Font(baseFont, 14.0f, 1, new Color(255, 255, 255));
                            float[] widths = new float[]{25.0f, 15.0f, 60.0f};
                            table = new Table(3);
                            table.setBorderWidth(1.0f);
                            table.setWidth(100.0f);
                            table.setBorderColor(new Color(0, 0, 0));
                            table.setAlignment(1);
                            table.setPadding(4.0f);
                            table.setCellsFitPage(true);
                            table.setWidths(widths);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("U\u017cytkownik", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Data", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(ExportProcessToPdf.getMessageForLanguage("Komentarz", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            table.endHeaders();
                            font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                            ArrayList sortedCommentsList = ExportProcessToPdf.sortComments(commentsList);
                            if (sortedCommentsList == null || sortedCommentsList.size() < commentsList.size()) {
                                sortedCommentsList = new ArrayList();
                                sortedCommentsList = commentsList;
                            }
                            for (CommentsTable oneCommentsTable : sortedCommentsList) {
                                Long time = oneCommentsTable.getTimestamp();
                                String userId = oneCommentsTable.getUserId();
                                String comment = oneCommentsTable.getComment();
                                if (time == null || userId == null || comment == null) continue;
                                String userName = ExportProcessToPdf.getRealNameForUserId(userId);
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                Date d = new Date(time);
                                String date = sdf.format(d);
                                cell = new Cell((Element)new Phrase(userName, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(date, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(comment, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                            }
                            document.add((Element)table);
                        } else {
                            paragraph.add((Object)"\n");
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            phrase = new Phrase(ExportProcessToPdf.getMessageForLanguage("Brak komentarzy w procesie", sLanguage), font);
                            paragraph.add((Object)phrase);
                            document.add((Element)paragraph);
                        }
                    }
                    document.close();
                    file = new File(filesPath + "\\" + sProcessId + ".pdf");
                } else {
                    log.debug((Object)("Proces o identyfikatorze " + sProcessId + " zostal juz zarchiwizowany"));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return file;
    }

    private static WfActivity[] sortActivities(SharkTransaction st, WfActivity[] activitiesTable, String sProcessId) {
        log.trace((Object)("************ sortActivities(SharkTransaction, WfActivity[], sProcessId=" + sProcessId + ") ************"));
        WfActivity[] sortedActivitiesTable = null;
        try {
            AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
            if (adminMisc != null && activitiesTable != null && activitiesTable.length > 0) {
                ArrayList<WfActivity> helpList = new ArrayList<WfActivity>();
                block2: for (WfActivity oneActivity : activitiesTable) {
                    if (helpList.size() == 0) {
                        helpList.add(oneActivity);
                        continue;
                    }
                    for (int counter = 0; helpList.size() >= counter; ++counter) {
                        int intListActivityId;
                        int intActivityId;
                        if (counter == helpList.size()) {
                            helpList.add(oneActivity);
                            continue block2;
                        }
                        WfActivity listWfActivity = (WfActivity)helpList.get(counter);
                        if (listWfActivity == null) continue;
                        String listActivityId = listWfActivity.key(st);
                        String activityId = oneActivity.key(st);
                        if (Tools.isNullOrEmpty((String)activityId) || Tools.isNullOrEmpty((String)listActivityId)) continue;
                        Date activityDate = new Date(adminMisc.getActivityCreatedTime(st, sProcessId, activityId));
                        Date listActivityDate = new Date(adminMisc.getActivityCreatedTime(st, sProcessId, listActivityId));
                        if (activityDate == null || listActivityDate == null || !activityDate.before(listActivityDate) && !activityDate.equals(listActivityDate) || (intActivityId = Integer.valueOf(activityId.split("_")[0]).intValue()) >= (intListActivityId = Integer.valueOf(listActivityId.split("_")[0]).intValue())) continue;
                        helpList.add(counter, oneActivity);
                        continue block2;
                    }
                }
                sortedActivitiesTable = new WfActivity[helpList.size()];
                for (int i = 0; i < helpList.size(); ++i) {
                    sortedActivitiesTable[i] = (WfActivity)helpList.get(i);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sortedActivitiesTable;
    }

    private static String getValueFromAdvancedSearchResult(AdvanceSearchResult advanceSearchResult, String searchedLabel, String typeOfLabel) {
        log.trace((Object)("************ getValueFromAdvancedSearchResult(AdvanceSearchResult, searchedLabel=" + searchedLabel + ", typeOfLabel=" + typeOfLabel + ") ************"));
        String value = "";
        try {
            ArrayList advanceVariableList = advanceSearchResult.getAlVariables();
            for (AdvanceSearchResult.AdvanceVariable oneAdvanceVariable : advanceVariableList) {
                if (typeOfLabel.equalsIgnoreCase("viewname")) {
                    String label1 = oneAdvanceVariable.getViewname();
                    if (label1 == null || !label1.equalsIgnoreCase(searchedLabel)) continue;
                    value = oneAdvanceVariable.getValue();
                } else {
                    String label2 = oneAdvanceVariable.getName();
                    if (label2 == null || !label2.equalsIgnoreCase(searchedLabel)) continue;
                    value = oneAdvanceVariable.getValue();
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return value;
    }

    private static String[] prepareValuesTableForMainLabels(AdvanceSearchResult advanceSearchResult, String[] mainLabelsTable) {
        log.trace((Object)"************ prepareValuesTableForMainLabels(AdvanceSearchResult, String[]) ************");
        String[] mainLabelsValuesTable = null;
        try {
            if (mainLabelsTable != null && mainLabelsTable.length > 0) {
                mainLabelsValuesTable = new String[mainLabelsTable.length];
                ArrayList advanceVariableList = advanceSearchResult.getAlVariables();
                if (advanceVariableList != null && advanceVariableList.size() > 0) {
                    for (int j = 0; j < mainLabelsTable.length; ++j) {
                        boolean labelFound = false;
                        for (AdvanceSearchResult.AdvanceVariable oneAdvanceVariable : advanceVariableList) {
                            String label = oneAdvanceVariable.getName();
                            if (label == null || !mainLabelsTable[j].equalsIgnoreCase(label)) continue;
                            String valueOfLabel = oneAdvanceVariable.getValue();
                            mainLabelsValuesTable[j] = !Tools.isNullOrEmpty((String)valueOfLabel) ? valueOfLabel : "";
                            labelFound = true;
                        }
                        if (labelFound) continue;
                        mainLabelsValuesTable[j] = "brak danych";
                    }
                } else {
                    for (int j = 0; j < mainLabelsTable.length; ++j) {
                        mainLabelsValuesTable[j] = "brak danych";
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return mainLabelsValuesTable;
    }

    private static String checkDuplicateVarViewName(Map<String, Object> mAllProcVar, String oneOtherIndex, String forBrackets) {
        block5: {
            log.trace((Object)("************ checkDuplicateVarViewName(Map<String, Object>, oneOtherIndex=" + oneOtherIndex + ", forBrackets=" + forBrackets + ") ************"));
            try {
                if (mAllProcVar == null || mAllProcVar.size() <= 0) break block5;
                int howManyCopies = 0;
                for (String key : mAllProcVar.keySet()) {
                    Object value = mAllProcVar.get(key);
                    String name = "";
                    if (value != null) {
                        name = value.toString();
                        if (oneOtherIndex != null && oneOtherIndex.equals(name)) {
                            ++howManyCopies;
                        }
                    }
                    if (howManyCopies <= true) continue;
                    oneOtherIndex = oneOtherIndex + " (" + forBrackets + ")";
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return oneOtherIndex;
    }

    private static String[] sortOtherIndiciesTable(String[] sIndiciesTable) {
        log.trace((Object)"************ sortOtherIndiciesTable(String[]) ************");
        String[] sortedIndicies = null;
        try {
            if (sIndiciesTable != null && sIndiciesTable.length > 0) {
                ArrayList<String> helpList = new ArrayList<String>();
                block2: for (String oneIndex : sIndiciesTable) {
                    if (helpList.size() == 0) {
                        helpList.add(oneIndex);
                        continue;
                    }
                    for (int counter = 0; helpList.size() >= counter; ++counter) {
                        if (counter == helpList.size()) {
                            helpList.add(oneIndex);
                            continue block2;
                        }
                        String listValue = (String)helpList.get(counter);
                        if (listValue == null || oneIndex.compareToIgnoreCase(listValue) >= 0) continue;
                        helpList.add(counter, oneIndex);
                        continue block2;
                    }
                }
                sortedIndicies = new String[helpList.size()];
                for (int i = 0; i < helpList.size(); ++i) {
                    sortedIndicies[i] = (String)helpList.get(i);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sortedIndicies;
    }

    private static ArrayList<CommentsTable> sortComments(ArrayList<CommentsTable> commentsList) {
        log.trace((Object)"************ sortComments(ArrayList<CommentsTable>) ************");
        ArrayList<CommentsTable> sortedCommentsList = new ArrayList<CommentsTable>();
        try {
            if (commentsList != null) {
                block2: for (CommentsTable oneCommentTable : commentsList) {
                    if (oneCommentTable == null) continue;
                    if (sortedCommentsList.size() == 0) {
                        sortedCommentsList.add(oneCommentTable);
                        continue;
                    }
                    for (int counter = 0; sortedCommentsList.size() >= counter; ++counter) {
                        if (counter == sortedCommentsList.size()) {
                            sortedCommentsList.add(oneCommentTable);
                            continue block2;
                        }
                        Long oldListValue = oneCommentTable.getTimestamp();
                        Long newListValue = sortedCommentsList.get(counter).getTimestamp();
                        if (oldListValue == null || newListValue == null) continue;
                        Timestamp oldListDate = new Timestamp(oldListValue);
                        Timestamp newListDate = new Timestamp(newListValue);
                        if (oldListDate == null || newListDate == null || !oldListDate.after(newListDate)) continue;
                        sortedCommentsList.add(counter, oneCommentTable);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sortedCommentsList;
    }

    private static String getMessageForLanguage(String sMessage, String sLanguage) {
        log.trace((Object)("************ getMessageForLanguage(sMessage=" + sMessage + ", sLanguage=" + sLanguage + ") ************"));
        try {
            if (sMessage != null && sLanguage != null) {
                if (sLanguage.equalsIgnoreCase("ENG")) {
                    if (sMessage.equalsIgnoreCase("Tabele dynamiczne")) {
                        sMessage = "Dynamic tables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Pusta tabela")) {
                        sMessage = "Empty table";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak zmiennych poza tabelami dynamicznymi")) {
                        sMessage = "No variables outside dynamic tables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Zmienne nietabelaryczne")) {
                        sMessage = "Non dynamic table variables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Informacje o procesie")) {
                        sMessage = "Informations about";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("")) {
                        sMessage = " process";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Dane og\u00f3lne procesu")) {
                        sMessage = "General process data";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Identyfikator definicji procesu")) {
                        sMessage = "Process definition ID";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Typ procesu")) {
                        sMessage = "Process type";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Identyfikator procesu")) {
                        sMessage = "Process ID";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa procesu")) {
                        sMessage = "Process name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Opis procesu")) {
                        sMessage = "Process description";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Inicjator procesu")) {
                        sMessage = "Process initiator";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Status procesu")) {
                        sMessage = "Process state";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data rozpocz\u0119cia procesu")) {
                        sMessage = "Process start date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data ostatniej zmiany stanu procesu")) {
                        sMessage = "Process last change state date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Tabele zmiennych procesu")) {
                        sMessage = "Process variables tables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa zmiennej procesu")) {
                        sMessage = "Process variable name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Identyfikator zmiennej procesu")) {
                        sMessage = "Process variable ID";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Warto\u015b\u0107 zmiennej procesu")) {
                        sMessage = "Process variable value";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak zmiennych procesu")) {
                        sMessage = "There are no process variables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Historia procesu")) {
                        sMessage = "Process history";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Historia procesu zawiera poszczeg\u00f3lne zadania posortowane wed\u0142ug dat rozpocz\u0119cia zadania")) {
                        sMessage = "Process history contains individual activities sorted by activity start date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nr")) {
                        sMessage = "No";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Identyfikator zadania")) {
                        sMessage = "Activity ID";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa zadania")) {
                        sMessage = "Activity name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Status")) {
                        sMessage = "State";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Inicjator")) {
                        sMessage = "Initiator";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data rozpocz\u0119cia zadania")) {
                        sMessage = "Activity start date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data zako\u0144czenia/zmiany stanu zadania")) {
                        sMessage = "Activity finish/state change date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak zada\u0144 w procesie")) {
                        sMessage = "There are no activities in process";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Dokumenty procesu")) {
                        sMessage = "Process documents";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Dokumenty podpi\u0119te do procesu")) {
                        sMessage = "Documents attached to";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa dokumentu")) {
                        sMessage = "Document name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa klasy dokument\u00f3w")) {
                        sMessage = "Document class name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Opis dokumentu")) {
                        sMessage = "Document description";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data dodania dokumentu")) {
                        sMessage = "Document attach date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Rozmiar (bajty)")) {
                        sMessage = "Size (bytes)";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("W\u0142a\u015bciciel")) {
                        sMessage = "Owner";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak dokument\u00f3w do\u0142\u0105czonych do procesu")) {
                        sMessage = "There are no documents attached to process";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Komentarze")) {
                        sMessage = "Comments";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Komentarze wy\u015bwietlone w odwrotnej kolejno\u015bci dodawania")) {
                        sMessage = "Comments are listed in reverse order of addition";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("U\u017cytkownik")) {
                        sMessage = "User";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data")) {
                        sMessage = "Date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Komentarz")) {
                        sMessage = "Comment";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak komentarzy w procesie")) {
                        sMessage = "There are no comments in process";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Archiwum proces\u00f3w")) {
                        sMessage = "Archive of";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Czas rozpocz\u0119cia procesu")) {
                        sMessage = "Process start time";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Czas zako\u0144czenia procesu")) {
                        sMessage = "Process stop time";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data archiwizacji")) {
                        sMessage = "Date of archive";
                        return sMessage;
                    }
                }
            } else if (sMessage == null) {
                sMessage = "";
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sMessage;
    }

    private static String getRealNameForUserId(String userId) {
        log.trace((Object)("************ getRealNameForUserId(userId=" + userId + ") ************"));
        String userName = "";
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            if (!Tools.isNullOrEmpty((String)userId)) {
                String userFirstName = uga.getUserFirstName(userId);
                String userLastName = uga.getUserLastName(userId);
                if (userFirstName != null) {
                    userName = userFirstName;
                }
                if (userLastName != null) {
                    userName = !userName.equalsIgnoreCase("") ? userName + " " + userLastName : userLastName;
                }
                if (Tools.isNullOrEmpty((String)userName)) {
                    userName = userId + " (login)";
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return userName;
    }

    private static String getVarNameForVarId(Map<String, Object> mAllProcVar, String sID) {
        String sName;
        block3: {
            log.trace((Object)("************ getVarNameForVarId(Map<String, Object>, sID=" + sID + ") ************"));
            sName = null;
            try {
                if (mAllProcVar == null || mAllProcVar.size() <= 0 || Tools.isNullOrEmpty((String)sID)) break block3;
                for (String id : mAllProcVar.keySet()) {
                    Object oName = mAllProcVar.get(id);
                    if (!id.equalsIgnoreCase(sID) || oName == null) continue;
                    sName = oName.toString();
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return sName;
    }

    private static String getVarTypeForVarId(WorkflowProcess wp, String sID, boolean bIsVariableSet) {
        log.trace((Object)("************ getVarTypeForVarId(WorkflowProcess, sID=" + sID + ", bIsVariableSet=" + String.valueOf(bIsVariableSet) + ") ************"));
        String sType = null;
        try {
            DataField dataField;
            if (wp != null && sID != null && (dataField = wp.getDataField(sID)) != null) {
                DataType dataType = dataField.getDataType();
                if (dataType != null) {
                    sType = dataType.getDataTypes().getBasicType().getType();
                }
                if (bIsVariableSet) {
                    sType = "STRING";
                } else {
                    String subType;
                    ExtendedAttribute oneExtAttr;
                    ExtendedAttributes extAttrs = dataField.getExtendedAttributes();
                    if (extAttrs != null && (oneExtAttr = extAttrs.getFirstExtendedAttributeForName("SUBTYPE")) != null && (subType = oneExtAttr.getVValue()) != null) {
                        sType = subType;
                    }
                }
            }
            if (sType != null) {
                if (sType.contains("DATE") || sType.contains("date")) {
                    sType = "DATE";
                }
                if (sType.contains("AMOUNT") || sType.contains("amount")) {
                    sType = "FLOAT";
                }
                if (!((sType = sType.toLowerCase()).equalsIgnoreCase("string") || sType.equalsIgnoreCase("date") || sType.equalsIgnoreCase("float") || sType.equalsIgnoreCase("integer"))) {
                    sType = "string";
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sType;
    }

    private static Map<String, Map<String, String>> prepareConfigurationMap(WorkflowProcess wp, String sProcDefId, Map<String, Object> mAllProcVar, String sTaskTemplate) {
        HashMap<String, Map<String, String>> configurationMap;
        block21: {
            log.trace((Object)("************ prepareConfigurationMap(WorkflowProcess, sProcDefId=" + sProcDefId + ", Map<String, Object>, sTaskTemplate=" + sTaskTemplate + ") ************"));
            configurationMap = new HashMap<String, Map<String, String>>();
            try {
                ProcessData processData = new ProcessData();
                ActivityData activityData = new ActivityData();
                HashMap activityIdAndNameMap = processData.GetProcessActivitiesDefIdsDefNamesPairs(sProcDefId);
                if (activityIdAndNameMap == null) break block21;
                Iterator iter = activityIdAndNameMap.keySet().iterator();
                HashMap<String, String> indeciesTypesMap = new HashMap<String, String>();
                configurationMap.put("indeciestypes", indeciesTypesMap);
                HashMap<String, String> variableToProcessMap = new HashMap<String, String>();
                configurationMap.put("variabletoprocess", variableToProcessMap);
                int counterForDynamicTables = 1;
                int counterForVariableToProcess = 1;
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    String name = (String)activityIdAndNameMap.get(id);
                    if (!sTaskTemplate.equalsIgnoreCase("NULL") && !sTaskTemplate.equalsIgnoreCase(id) && !sTaskTemplate.equalsIgnoreCase(name)) continue;
                    ExtendedAttributes extAttrs = null;
                    try {
                        extAttrs = activityData.GetActivityExtendedAttributesByActivityName(sProcDefId, name);
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage());
                    }
                    if (extAttrs == null) continue;
                    for (int i = 0; i < extAttrs.size(); ++i) {
                        ExtendedAttribute oneExtAttr = (ExtendedAttribute)extAttrs.get(i);
                        if (oneExtAttr == null) continue;
                        String attrName = oneExtAttr.getName();
                        String attrValue = oneExtAttr.getVValue();
                        if (attrName.equalsIgnoreCase("VARIABLE_SET") || attrName.equalsIgnoreCase("VARIABLE_SET_VIEW")) {
                            String[] enterSplit;
                            HashMap<String, String> variableSetMap = new HashMap<String, String>();
                            int nrOfVar = 1;
                            for (String oneEnter : enterSplit = attrValue.split("\n", -1)) {
                                if (Tools.isNullOrEmpty((String)oneEnter) || oneEnter.contains("DT_")) continue;
                                String sType = "string";
                                String variableName = ExportProcessToPdf.getVarNameForVarId(mAllProcVar, oneEnter);
                                if ((variableName = ExportProcessToPdf.checkDuplicateVarViewName(mAllProcVar, variableName, oneEnter)) != null && ((Map)configurationMap.get("indeciestypes")).get(variableName) == null) {
                                    indeciesTypesMap.put(variableName, sType);
                                }
                                if (Tools.isNullOrEmpty((String)attrValue)) continue;
                                variableSetMap.put(String.valueOf(nrOfVar), oneEnter);
                                ++nrOfVar;
                            }
                            if (variableSetMap == null || variableSetMap.size() <= 0) continue;
                            boolean bAdd = true;
                            Iterator variableSetMapIter = variableSetMap.keySet().iterator();
                            for (int j = 1; j <= configurationMap.size() - 2; ++j) {
                                Map helpMap = (Map)configurationMap.get("variableset" + String.valueOf(j));
                                if (helpMap != null && helpMap.size() == variableSetMap.size()) {
                                    int identityCounter = 0;
                                    while (variableSetMapIter.hasNext()) {
                                        String key = (String)variableSetMapIter.next();
                                        String valueFromHelpMap = (String)helpMap.get(key);
                                        String valueFromVariableSetMap = (String)variableSetMap.get(key);
                                        if (valueFromHelpMap == null) break;
                                        if (!valueFromVariableSetMap.equalsIgnoreCase(valueFromHelpMap)) continue;
                                        ++identityCounter;
                                    }
                                    if (identityCounter == variableSetMap.size()) {
                                        bAdd = false;
                                    }
                                }
                                if (!bAdd) break;
                            }
                            if (!bAdd) continue;
                            configurationMap.put("variableset" + String.valueOf(counterForDynamicTables), variableSetMap);
                            ++counterForDynamicTables;
                            continue;
                        }
                        if (!attrName.equalsIgnoreCase("VariableToProcess_VIEW") && !attrName.equalsIgnoreCase("VariableToProcess_UPDATE")) continue;
                        String sType = ExportProcessToPdf.getVarTypeForVarId(wp, attrValue, false);
                        String variableName = ExportProcessToPdf.getVarNameForVarId(mAllProcVar, attrValue);
                        if ((variableName = ExportProcessToPdf.checkDuplicateVarViewName(mAllProcVar, variableName, attrValue)) != null && ((Map)configurationMap.get("indeciestypes")).get(variableName) == null) {
                            indeciesTypesMap.put(variableName, sType);
                        }
                        if (Tools.isNullOrEmpty((String)attrValue)) continue;
                        boolean bAdd = true;
                        for (int j = 1; j < counterForVariableToProcess; ++j) {
                            String oldValue = (String)((Map)configurationMap.get("variabletoprocess")).get(String.valueOf(j));
                            if (Tools.isNullOrEmpty((String)oldValue) || !oldValue.equalsIgnoreCase(attrValue)) continue;
                            bAdd = false;
                            break;
                        }
                        if (!bAdd) continue;
                        variableToProcessMap.put(String.valueOf(counterForVariableToProcess), attrValue);
                        ++counterForVariableToProcess;
                    }
                }
                if (sTaskTemplate.equalsIgnoreCase("NULL")) {
                    for (String attrValue : mAllProcVar.keySet()) {
                        int j;
                        if (Tools.isNullOrEmpty((String)attrValue)) continue;
                        boolean bAdd = true;
                        for (j = 1; j < counterForVariableToProcess; ++j) {
                            String oldValue = (String)((Map)configurationMap.get("variabletoprocess")).get(String.valueOf(j));
                            if (Tools.isNullOrEmpty((String)oldValue) || !oldValue.equalsIgnoreCase(attrValue)) continue;
                            bAdd = false;
                            break;
                        }
                        if (bAdd) {
                            block12: for (j = 1; j <= configurationMap.size() - 2; ++j) {
                                Map helpMap = (Map)configurationMap.get("variableset" + String.valueOf(j));
                                if (helpMap == null) continue;
                                for (String oldID : helpMap.keySet()) {
                                    String oldValue = (String)helpMap.get(String.valueOf(oldID));
                                    if (Tools.isNullOrEmpty((String)oldValue) || !oldValue.equalsIgnoreCase(attrValue)) continue;
                                    bAdd = false;
                                    continue block12;
                                }
                            }
                        }
                        if (!bAdd) continue;
                        variableToProcessMap.put(String.valueOf(counterForVariableToProcess), attrValue);
                        ++counterForVariableToProcess;
                    }
                }
                configurationMap.put("indeciestypes", indeciesTypesMap);
                configurationMap.put("variabletoprocess", variableToProcessMap);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return configurationMap;
    }
}

