/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserSearchViewTable;
import com.plusmpm.util.Tools;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class ViewsOwnersManagement {
    public static Logger log = Logger.getLogger(ViewsOwnersManagement.class);

    public static void ChangeViewsOwner(String sFromUser, String sToUser, String sViewName) {
        log.trace((Object)("************ ChangeViewOwner(sFromUser=" + sFromUser + ", sToUser=" + sToUser + ", sViewName=" + sViewName + ") ************"));
        long startTime = new Date().getTime();
        UserGroupAdministration uga = null;
        DBManagement dbm = new DBManagement();
        String sDescrPostfix = " - widok u\u017cytkownika ";
        int iChanged = 0;
        ArrayList<UserSearchViewTable> privateViews = null;
        try {
            if (Tools.isNullOrEmpty((String)sFromUser)) {
                throw new CUFException("Brak loginu uzytkownika, ktoremu zabieramy widok");
            }
            if (Tools.isNullOrEmpty((String)sToUser)) {
                throw new CUFException("Brak loginu uzytkownika, ktory otrzymuje widok");
            }
            uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
            if (!uga.doesUserExist(sFromUser)) {
                throw new CUFException("Uzytkownik o loginie " + sFromUser + " nie istnieje w systemie");
            }
            if (!uga.doesUserExist(sToUser)) {
                throw new CUFException("Uzytkownik o loginie " + sToUser + " nie istnieje w systemie");
            }
            log.info((Object)("Przepisywanie widokow z uzytkownika " + sFromUser + " na uzytkownika " + sToUser));
            ArrayList views = dbm.GetAllUserSearchViewsForUserWithType(sFromUser, "private");
            if (views == null || views.size() == 0) {
                throw new CUFException("Uzytkownik o loginie " + sFromUser + " nie posiada zadnych prywatnych widokow");
            }
            if (sViewName.compareTo("*") == 0) {
                privateViews = new ArrayList<UserSearchViewTable>(views);
                log.info((Object)"Przenoszenie wszystkich widokow");
            } else {
                log.info((Object)("Przenoszenie widoku o nazwie " + sViewName));
                boolean bFound = false;
                for (UserSearchViewTable view : views) {
                    String sThisViewName;
                    if (view == null || (sThisViewName = view.getViewName()) == null || !sViewName.equalsIgnoreCase(sThisViewName)) continue;
                    privateViews = new ArrayList();
                    privateViews.add(view);
                    bFound = true;
                    log.info((Object)("Znaleziono widok o nazwie " + sViewName + " w widokach uzytkownika " + sFromUser));
                    break;
                }
                if (!bFound) {
                    throw new CUFException("Uzytkownik o loginie " + sFromUser + " nie posiada w swoich widokach widoku o nazwie " + sViewName);
                }
            }
            for (UserSearchViewTable privateView : privateViews) {
                if (privateView == null) continue;
                String sThisViewName = privateView.getViewName();
                String sViewDescr = privateView.getViewDescr();
                String sUserRealName = uga.getUserRealName(sFromUser);
                if (sViewDescr == null) {
                    sViewDescr = "";
                }
                if (sViewDescr.contains(sDescrPostfix)) {
                    int iPostfixPos = sViewDescr.indexOf(sDescrPostfix);
                    sViewDescr = sViewDescr.substring(0, iPostfixPos);
                } else if (sViewDescr.length() + sDescrPostfix.length() + sUserRealName.length() > 255) {
                    int iToCut = sViewDescr.length() + sDescrPostfix.length() + sUserRealName.length() - 255;
                    sViewDescr = sViewDescr.substring(0, sViewDescr.length() - iToCut);
                }
                sViewDescr = sViewDescr + sDescrPostfix + sUserRealName;
                privateView.setUserName(sToUser);
                privateView.setViewDescr(sViewDescr);
                long lRes = dbm.changeUserSearchView(privateView);
                if (lRes != -1L) {
                    ++iChanged;
                    log.info((Object)("Poprawnie przepisano widok o nazwie " + sThisViewName + " z uzytkownika " + sFromUser + " na uzytkownika " + sToUser));
                    continue;
                }
                log.warn((Object)("Wystapil blad podczas przepisywania widoku o nazwie " + sThisViewName + " z uzytkownika " + sFromUser + " na uzytkownika " + sToUser));
            }
            log.info((Object)("Zakonczono przepisywanie widokow z uzytkownika " + sFromUser + " na uzytkownika " + sToUser + ". Ilosc przepisanych widokow: " + iChanged));
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.debug((Object)("Czas wykonywania zadania zaplanowanego ChangeViewsOwner: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

