/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.LinkConnectionTable;
import com.plusmpm.database.LinkIndexTable;
import com.plusmpm.database.LinkTable;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class ImportLinks
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportLinks.class);

    @AdvancedTask(name="ImportLinksFromXLS", description="ImportLinksFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportLinksFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportLinksFromXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        DBManagement dbm = new DBManagement();
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        boolean bContinue = true;
        String helpLinkName = "";
        long linkId = -1L;
        long linkIndexId = -1L;
        long linkConnectionId = -1L;
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Zestawy dokument\u00f3w");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Zestawy dokument\u00f3w w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 12; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z zestawami dokumentow");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String linkName = sheet.getCell(((Integer)header.get("Nazwa zestawu")).intValue(), i).getContents();
                    String linkDescr = sheet.getCell(((Integer)header.get("Opis zestawu")).intValue(), i).getContents();
                    String indexName = sheet.getCell(((Integer)header.get("Nazwa indeksu")).intValue(), i).getContents();
                    String indexDescr = sheet.getCell(((Integer)header.get("Opis indeksu")).intValue(), i).getContents();
                    String indexType = sheet.getCell(((Integer)header.get("Typ indeksu")).intValue(), i).getContents();
                    String indexValues = sheet.getCell(((Integer)header.get("Warto\u015bci")).intValue(), i).getContents();
                    String docClassName = sheet.getCell(((Integer)header.get("Klasa dokument\u00f3w")).intValue(), i).getContents();
                    String linkIndexName = sheet.getCell(((Integer)header.get("Indeks z zestawu")).intValue(), i).getContents();
                    String docClassIndexName = sheet.getCell(((Integer)header.get("Powi\u0105zanie")).intValue(), i).getContents();
                    String resourceId = sheet.getCell(((Integer)header.get("Nazwa u\u017cytkownika/grupy")).intValue(), i).getContents();
                    String isGroup = sheet.getCell(((Integer)header.get("Grupa")).intValue(), i).getContents();
                    String rightLevel = sheet.getCell(((Integer)header.get("Poziom uprawnienia")).intValue(), i).getContents();
                    if (!Tools.isNullOrEmpty((String)linkName)) {
                        LinkTable linkTable;
                        helpLinkName = linkName;
                        linkId = -1L;
                        linkIndexId = -1L;
                        linkConnectionId = -1L;
                        if (ArchiveServices.DoesLinkExist(linkName)) {
                            bContinue = false;
                            throw new CUFException("Zestaw dokumentow o nazwie " + linkName + " istnieje juz w systemie");
                        }
                        if (linkDescr == null) {
                            linkDescr = "";
                        }
                        if ((linkId = dbm.addLink(linkTable = new LinkTable(linkName, linkDescr))) == -1L) {
                            bContinue = false;
                            throw new CUFException("Blad podczas dodawania zestawu dokumentow o nazwie " + linkName + " do systemu");
                        }
                        bContinue = true;
                        log.info((Object)("Poprawnie dodano zestaw dokumentow o nazwie " + linkName + " do systemu"));
                    }
                    if (!bContinue) continue;
                    try {
                        if (!Tools.isNullOrEmpty((String)indexName)) {
                            linkIndexId = -1L;
                            long checkLinkIndexId = ImportLinks.getLinkIndexId(String.valueOf(linkId), indexName);
                            if (checkLinkIndexId != -1L) {
                                throw new CUFException("Indeks o nazwie " + indexName + " istnieje dla zestawu dokumentow o nazwie " + helpLinkName + " w systemie");
                            }
                            if (indexDescr == null) {
                                indexDescr = "";
                            }
                            if (indexValues == null) {
                                indexValues = "";
                            }
                            if (Tools.isNullOrEmpty((String)indexType)) {
                                throw new CUFException("Nie podano typu indeksu o nazwie " + indexName + " dla zestawu dokumentow o nazwie " + helpLinkName + " w pliku xls");
                            }
                            if (indexType.equalsIgnoreCase("Ca\u0142kowity")) {
                                indexType = "integer";
                            } else if (indexType.equalsIgnoreCase("Zmiennoprzecinkowy")) {
                                indexType = "float";
                            } else if (indexType.equalsIgnoreCase("Tekstowy")) {
                                indexType = "string";
                            } else if (indexType.equalsIgnoreCase("Data")) {
                                indexType = "date";
                            } else if (indexType.equalsIgnoreCase("Lista warto\u015bci")) {
                                indexType = "list";
                            } else {
                                throw new CUFException("Nieznany typ indeksu o nazwie " + indexName + " dla zestawu dokumentow o nazwie " + helpLinkName + " w pliku xls");
                            }
                            LinkIndexTable linkIndexTable = new LinkIndexTable(Long.valueOf(linkId), indexName, indexDescr, indexType, indexValues);
                            linkIndexId = dbm.addLinkIndex(linkIndexTable);
                            if (linkIndexId == -1L) {
                                throw new CUFException("Blad podczas dodawania indeksu o nazwie " + indexName + " do systemu");
                            }
                            log.info((Object)("Poprawnie dodano indeks o nazwie " + indexName + " do systemu"));
                        }
                        if (!Tools.isNullOrEmpty((String)docClassName)) {
                            linkConnectionId = -1L;
                            if (Tools.isNullOrEmpty((String)linkIndexName) || Tools.isNullOrEmpty((String)docClassIndexName)) {
                                throw new CUFException("Nie podano wszystkich danych dla powiazania zestawu dokumentow o nazwie " + helpLinkName + " z klasa dokumentow o nazwie " + docClassName + " w pliku xls");
                            }
                            long docClassId = ImportLinks.getDocClassId(docClassName);
                            if (docClassId == -1L) {
                                throw new CUFException("Klasa dokumentow o nazwie " + docClassName + " nie istnieje w systemie, nie mozna utworzyc powiazania indeksow dla zestawu dokumentow " + helpLinkName);
                            }
                            long checkLinkIndexId = ImportLinks.getLinkIndexId(String.valueOf(linkId), linkIndexName);
                            if (checkLinkIndexId == -1L) {
                                throw new CUFException("Indeks o nazwie " + linkIndexName + " nie istnieje w zestawie dokumentow " + helpLinkName + ", nie mozna utworzyc powiazania dla zestawu dokuemntow o nazwie " + helpLinkName);
                            }
                            long checkDocClassIndexId = ArchiveServices.GetIndexIdForDocClass(docClassName, docClassIndexName);
                            if (checkDocClassIndexId == -1L) {
                                throw new CUFException("Indeks o nazwie " + docClassIndexName + " nie istnieje w klasie dokumentow o nazwie " + docClassName + ", nie mozna utworzyc powiazania dla zestawu dokuemntow o nazwie " + helpLinkName);
                            }
                            LinkConnectionTable linkConnectionTable = new LinkConnectionTable(Long.valueOf(linkId), Long.valueOf(checkLinkIndexId), Long.valueOf(docClassId), Long.valueOf(checkDocClassIndexId));
                            linkConnectionId = dbm.addLinkConnection(linkConnectionTable);
                            if (linkConnectionId == -1L) {
                                throw new CUFException("Blad podczas dodawania powiazania dla zestawu dokumentow nazwie " + helpLinkName + " do systemu");
                            }
                        }
                        if (Tools.isNullOrEmpty((String)resourceId)) continue;
                        if (Tools.isNullOrEmpty((String)isGroup) || Tools.isNullOrEmpty((String)rightLevel)) {
                            throw new CUFException("Nie podano wszystkich danych dla praw do zestawu dokumentow o nazwie " + helpLinkName + " w pliku xls");
                        }
                        if (!isGroup.equalsIgnoreCase("false") && !isGroup.equalsIgnoreCase("true")) {
                            throw new CUFException("Niedozwolona wartosc w kolumnie Grupa dla prawa do zestawu dokumentow o nazwie " + helpLinkName + " dla zasobu " + resourceId);
                        }
                        isGroup.toLowerCase();
                        if (isGroup.equalsIgnoreCase("false")) {
                            if (!uga.doesUserExist(resourceId)) {
                                throw new CUFException("Uzytownik " + resourceId + " nie istnieje w systemie, przerwanie dodawania praw dla zestawu dokumentow o nazwie " + helpLinkName);
                            }
                        } else if (!uga.doesUserExist(resourceId)) {
                            throw new CUFException("Grupa " + resourceId + " nie istnieje w systemie, przerwanie dodawania praw dla zestawu dokumentow o nazwie " + helpLinkName);
                        }
                        if (rightLevel.equalsIgnoreCase("Odczyt")) {
                            Authorization.addRight((String)("System.Archive.Links." + linkId + ".read"), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            log.info((Object)("Dodanie praw do odczytu zestawu dokumentow o nazwie " + helpLinkName + " dla " + resourceId));
                            continue;
                        }
                        if (rightLevel.equalsIgnoreCase("Modyfikacja")) {
                            Authorization.addRight((String)("System.Archive.Links." + linkId + ".read"), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            Authorization.addRight((String)("System.Archive.Links." + linkId + ".modify"), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            log.info((Object)("Dodanie praw do odczytu i modyfikacji zestawu dokumentow o nazwie " + helpLinkName + " dla " + resourceId));
                            continue;
                        }
                        if (rightLevel.equalsIgnoreCase("Usuwanie")) {
                            Authorization.addRight((String)("System.Archive.Links." + linkId + ".read"), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            Authorization.addRight((String)("System.Archive.Links." + linkId + ".modify"), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            Authorization.addRight((String)("System.Archive.Links." + linkId + ".delete"), (String)resourceId, (boolean)Boolean.valueOf(isGroup));
                            log.info((Object)("Dodanie praw do odczytu, modyfikacji i usuwania zestawu dokumentow o nazwie " + helpLinkName + " dla " + resourceId));
                            continue;
                        }
                        throw new CUFException("Niedozwolona wartosc w kolumnie Poziom uprawnienia dla prawa do zestawu dokumentu o nazwie " + helpLinkName + " dla zasobu " + resourceId);
                    }
                    catch (CUFException e) {
                        log.warn((Object)e.getMessage());
                    }
                    catch (Exception e) {
                        taskLog.error((Object)e.getMessage());
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                catch (CUFException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import zestawow dokumentow");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportLinksFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static long getLinkIndexId(String sLinkId, String sLinkIndexName) throws Exception {
        Long id;
        log.trace((Object)("************ getLinkIndexId(sLinkId=" + sLinkId + ", sLinkIndexName=" + sLinkIndexName + ") ************"));
        long linkIndexId = -1L;
        DBManagement dbm = new DBManagement();
        LinkIndexTable linkIndexTable = dbm.getLinkIndexByName(sLinkId, sLinkIndexName);
        if (linkIndexTable != null && (id = linkIndexTable.getId()) != null) {
            linkIndexId = id;
        }
        return linkIndexId;
    }

    private static long getDocClassId(String sDocClassName) throws Exception {
        Long id;
        log.trace((Object)("************ getDocClassId(sDocClassName=" + sDocClassName + ") ************"));
        long docClassId = -1L;
        DBManagement dbm = new DBManagement();
        DocClassTable docClassTable = dbm.getDocClassByName(sDocClassName);
        if (docClassTable != null && (id = docClassTable.getId()) != null) {
            docClassId = id;
        }
        return docClassId;
    }
}

