/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.DataChoosers;

import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooser;
import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooserManager;
import com.plusmpm.CUF.util.DataChoosers.defs.ExecuteQueryDataChooserDef;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.plusmpm.util.Tools;
import com.plusmpm.util.classLoader.PlusClassLoader;
import com.plusmpm.util.form.datachooser.DataChooser;
import com.plusmpm.util.form.datachooser.StandardDataChooser;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@StandardDataChooser(conf=ExecuteQueryDataChooserDef.class)
public class ExecuteQueryDataChooser
implements DataChooser {
    public static Logger log = Logger.getLogger(ExecuteQueryDataChooser.class);
    private static int size;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Map<String, String>> getDataChooserResult(int startItem, int limit, String orderProperty, String order, Map<String, String> criteria, Map<String, String> customKeys) {
        log.trace((Object)"************************* ExecuteQueryDataChooser ********************");
        ArrayList allResults = new ArrayList();
        ArrayList results = null;
        Connection conn = null;
        ResultSet rs = null;
        ResultSet rsCount = null;
        PreparedStatement pstmQuery = null;
        PreparedStatement pstmCountQuery = null;
        size = 0;
        try {
            String[] namesTable;
            String names = customKeys.get("NameForQuery");
            if (Tools.isNullOrEmpty((String)names)) {
                throw new CUFException("Brak pola NameForQuery w definicji Data Choosera na mapie");
            }
            for (String name : namesTable = names.split(";")) {
                log.info((Object)("Identyfikator zapytania name: " + name));
                List<QueryDataChooser> listOfQueries = QueryDataChooserManager.getQueryDataChooserForName(name);
                if (listOfQueries != null && listOfQueries.size() > 0) {
                    HashMap row = null;
                    for (int a = 0; a < listOfQueries.size(); ++a) {
                        String parameters = listOfQueries.get(a).getParameters();
                        String query = listOfQueries.get(a).getQuery();
                        String countQuery = listOfQueries.get(a).getCountQuery();
                        if (!Tools.isNullOrEmpty((String)query) && !Tools.isNullOrEmpty((String)countQuery) && query.compareToIgnoreCase(" ") != 0 && countQuery.compareToIgnoreCase(" ") != 0) {
                            block65: {
                                String externaldb = listOfQueries.get(a).getExternalDB();
                                if (externaldb != null && externaldb.compareToIgnoreCase("TRUE") == 0) {
                                    String externalDBConfName = listOfQueries.get(a).getExternalDBConfName();
                                    log.debug((Object)("Nazwa konfiguracji polaczenia z zewnetrzna baza danych: " + externalDBConfName));
                                    String sClassFullName = listOfQueries.get(a).getFullClassName();
                                    log.debug((Object)("Pelna sciezka klasy do obslugi polaczenia z zewnetrzna baza danych: " + sClassFullName));
                                    if (Tools.isNullOrEmpty((String)query) || Tools.isNullOrEmpty((String)externalDBConfName) || Tools.isNullOrEmpty((String)sClassFullName)) throw new CUFException("Brak odpowiednich parametrow do uzyskania polaczenia z zewnetrzna baza danych. Sprawdz definicje: " + name + " w tabeli pm_querydatachooser");
                                    log.info((Object)"Zapytanie wykonywane na zewnetrznej bazie danych");
                                    PlusClassLoader plusClassLoader = new PlusClassLoader();
                                    Object[] oMethodArgs = new Object[]{externalDBConfName};
                                    Class[] cMethodArgs = new Class[]{String.class};
                                    try {
                                        log.info((Object)"Proba wywolania funkcji GetExternalDBConnection w celu uzyskania polaczenia z zewnetrzna baza danych");
                                        conn = (Connection)plusClassLoader.executeClassMethod(sClassFullName, "GetExternalDBConnection", oMethodArgs, cMethodArgs);
                                        if (conn == null || conn.isClosed()) {
                                            throw new CUFException("Brak polaczania z zewnetrzna baza danych");
                                        }
                                        break block65;
                                    }
                                    catch (Exception e) {
                                        throw new CUFException("Blad w definicji klasy, metody lub brak definicji dla funkcji uzyskiwania polaczenia z zewnetrzna bazy danych");
                                    }
                                }
                                log.info((Object)"Zapytanie wykonywane na wewnetrznej bazie danych. Proba uzyskania polaczenia z wewnetrzna baza danych");
                                conn = InternalDataBase.connect();
                                if (conn == null || conn.isClosed()) {
                                    throw new CUFException("Brak polaczania z wewnetrzna baza danych");
                                }
                            }
                            String[] queryTable = query.split("[?]", -1);
                            String[] queryCountTable = countQuery.split("[?]", -1);
                            pstmQuery = conn.prepareStatement(query);
                            pstmCountQuery = conn.prepareStatement(countQuery);
                            if (queryTable.length > 1) {
                                if (Tools.isNullOrEmpty((String)parameters) || parameters.compareToIgnoreCase("NULL") == 0) throw new CUFException("Nie podano parameters w tabeli pm_querydatachooser");
                                log.debug((Object)("Parameters: " + parameters));
                                String[] parametersTableWithTypes = parameters.split(",");
                                if (queryTable.length - 1 != parametersTableWithTypes.length) throw new CUFException("Niezgodnosc ilosci podanych parametrow z iloscia parametrow w zapytaniu lub blad w zapytaniu liczenia rezultatow");
                                int indexForCountQuery = 1;
                                for (int k = 1; k < queryTable.length; ++k) {
                                    String text;
                                    String[] parametersTable = parametersTableWithTypes[k - 1].split(":");
                                    if (parametersTable[0].compareToIgnoreCase("DCKEY") == 0) {
                                        log.debug((Object)("Parametr " + k + ": query key"));
                                        text = criteria.get("GetDataChooserContentServlet_parameter_query");
                                        if (parametersTable.length == 2) {
                                            pstmQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmQuery, k, parametersTable[1], text);
                                            if (k <= queryCountTable.length) {
                                                pstmCountQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmCountQuery, indexForCountQuery, parametersTable[1], text);
                                            }
                                        } else {
                                            pstmQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmQuery, k, "string", text);
                                            if (k <= queryCountTable.length) {
                                                pstmCountQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmCountQuery, indexForCountQuery, "string", text);
                                            }
                                        }
                                    } else {
                                        text = criteria.get(parametersTable[0]);
                                        if (text != null) {
                                            log.debug((Object)("Parametr " + k + ": FormCriteria"));
                                            if (parametersTable.length == 2) {
                                                pstmQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmQuery, k, parametersTable[1], text);
                                                if (k <= queryCountTable.length) {
                                                    pstmCountQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmCountQuery, indexForCountQuery, parametersTable[1], text);
                                                }
                                            } else {
                                                pstmQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmQuery, k, "string", text);
                                                if (k <= queryCountTable.length) {
                                                    pstmCountQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmCountQuery, indexForCountQuery, "string", text);
                                                }
                                            }
                                        } else if (parametersTable[0].equals("startItem")) {
                                            log.debug((Object)("Parametr " + k + ": startItem"));
                                            pstmQuery.setInt(k, startItem);
                                            if (indexForCountQuery <= queryCountTable.length) {
                                                --indexForCountQuery;
                                            }
                                        } else if (parametersTable[0].equals("endItem")) {
                                            log.debug((Object)("Parametr " + k + ": endItem"));
                                            pstmQuery.setInt(k, startItem + limit);
                                            if (indexForCountQuery <= queryCountTable.length) {
                                                --indexForCountQuery;
                                            }
                                        } else if (parametersTable[0].equals("limit")) {
                                            log.debug((Object)("Parametr " + k + ": limit"));
                                            pstmQuery.setInt(k, limit);
                                            if (indexForCountQuery <= queryCountTable.length) {
                                                --indexForCountQuery;
                                            }
                                        } else {
                                            log.debug((Object)("Parametr " + k + ": stala wartosc"));
                                            if (parametersTable.length == 2) {
                                                pstmQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmQuery, k, parametersTable[1], parametersTable[0]);
                                                if (k <= queryCountTable.length) {
                                                    pstmCountQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmCountQuery, indexForCountQuery, parametersTable[1], parametersTable[0]);
                                                }
                                            } else {
                                                pstmQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmQuery, k, "string", parametersTable[0]);
                                                if (k <= queryCountTable.length) {
                                                    pstmCountQuery = ExecuteQueryDataChooser.SetParameterForStatement(pstmCountQuery, indexForCountQuery, "string", parametersTable[0]);
                                                }
                                            }
                                        }
                                    }
                                    ++indexForCountQuery;
                                }
                            }
                            log.debug((Object)("Query: " + query));
                            log.debug((Object)("CountQuery: " + countQuery));
                            results = new ArrayList();
                            rs = pstmQuery.executeQuery();
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int numColumns = rsmd.getColumnCount();
                            while (rs.next()) {
                                HashMap<String, String> oneRow = new HashMap<String, String>();
                                for (int i = 1; i < numColumns + 1; ++i) {
                                    String columnName = rsmd.getColumnName(i);
                                    String oneValue = rs.getString(columnName);
                                    columnName = columnName.toLowerCase();
                                    if (oneValue == null) {
                                        oneValue = "";
                                    }
                                    oneRow.put(columnName, oneValue);
                                }
                                results.add(oneRow);
                            }
                            rsCount = pstmCountQuery.executeQuery();
                            if (rsCount.next()) {
                                size += rsCount.getInt(1);
                            }
                            if (results != null && results.size() > 0) {
                                Iterator mappings = ((HashMap)results.get(0)).keySet().iterator();
                                String[] mappingsTable = new String[((HashMap)results.get(0)).size()];
                                int nrOfMappings = 0;
                                while (mappings.hasNext()) {
                                    String oneMapping = (String)mappings.next();
                                    log.debug((Object)("Mapping: " + oneMapping));
                                    mappingsTable[nrOfMappings] = oneMapping;
                                    ++nrOfMappings;
                                }
                                for (int j = 0; j < results.size(); ++j) {
                                    row = new HashMap();
                                    for (int i = 0; i < nrOfMappings; ++i) {
                                        row.put(mappingsTable[i], ((HashMap)results.get(j)).get(mappingsTable[i]));
                                    }
                                    allResults.add(row);
                                }
                                continue;
                            }
                            log.info((Object)"Brak wynikow zapytania");
                            continue;
                        }
                        log.warn((Object)("Niepoprawnie zdefiniowane zapytania dla identyfikatora " + name));
                    }
                    continue;
                }
                log.warn((Object)("Brak zapytan dla identyfikatora " + name));
            }
            log.info((Object)("Calkowita liczba wynikow: " + size));
            int nEndItem = startItem + limit;
            int nStartItem = startItem;
            if (nEndItem > allResults.size()) {
                nEndItem = allResults.size();
            }
            if (nStartItem > nEndItem) {
                nStartItem = 0;
            }
            List<Map<String, String>> list = allResults.subList(nStartItem, nEndItem);
            return list;
        }
        catch (CUFException e) {
            log.error((Object)e.getMessage());
            List<Map<String, String>> list = null;
            return list;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            List<Map<String, String>> list = null;
            return list;
        }
        finally {
            try {
                if (rsCount != null) {
                    rsCount.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public int getDataChooserResultSize(Map<String, String> criteria, Map<String, String> customKeys) {
        log.trace((Object)"************************* getDataChooserResultSize ********************");
        return size;
    }

    private static PreparedStatement SetParameterForStatement(PreparedStatement pstm, int index, String sType, String sValue) throws SQLException {
        log.debug((Object)("************ SetParameterForStatement(index=" + String.valueOf(index) + ", sType=" + sType + ", sValue=" + sValue + ") ************"));
        try {
            if (sType.compareToIgnoreCase("string") == 0) {
                pstm.setString(index, sValue);
            } else if (sType.compareToIgnoreCase("int") == 0 || sType.compareToIgnoreCase("int8") == 0 || sType.compareToIgnoreCase("integer") == 0) {
                if (!Tools.isNullOrEmpty((String)sValue)) {
                    pstm.setInt(index, Integer.valueOf(sValue));
                } else {
                    pstm.setInt(index, 0);
                }
            } else if (sType.compareToIgnoreCase("float") == 0 || sType.compareToIgnoreCase("float8") == 0) {
                if (!Tools.isNullOrEmpty((String)sValue)) {
                    pstm.setFloat(index, Float.valueOf(sValue).floatValue());
                } else {
                    pstm.setFloat(index, 0.0f);
                }
            } else if (sType.compareToIgnoreCase("double") == 0 || sType.compareToIgnoreCase("double8") == 0) {
                if (!Tools.isNullOrEmpty((String)sValue)) {
                    pstm.setDouble(index, Double.valueOf(sValue));
                } else {
                    pstm.setDouble(index, 0.0);
                }
            } else if (sType.compareToIgnoreCase("timestamp") == 0) {
                if (!Tools.isNullOrEmpty((String)sValue)) {
                    pstm.setTimestamp(index, Timestamp.valueOf(sValue));
                } else {
                    pstm.setTimestamp(index, new Timestamp(0L));
                }
            } else if (sType.compareToIgnoreCase("date") == 0) {
                if (!Tools.isNullOrEmpty((String)sValue)) {
                    pstm.setDate(index, Date.valueOf(sValue));
                } else {
                    pstm.setDate(index, new Date(0L));
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        return pstm;
    }
}

