/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.TableInfo;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.TextUtils;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;

class DynamicTablesResolver {
    private static final int DYNAMI_TABLE_ROW_COUNT = 2;
    private static final String REQUIRE_CELL_CONTENT = "T";
    private static final String HEADERLESS_MARK = "H";

    DynamicTablesResolver() {
    }

    public List<TableInfo> getTables(MainDocumentPart documentPart) throws Exception {
        ArrayList<TableInfo> tablesInfo = new ArrayList<TableInfo>();
        List<Tbl> tables = this.findTables(documentPart);
        for (Tbl table : tables) {
            tablesInfo.add(this.getTableInfo(table));
        }
        return tablesInfo;
    }

    private List<Tbl> findTables(MainDocumentPart documentPart) throws Exception {
        ArrayList<Tbl> tables = new ArrayList<Tbl>();
        List nodes = documentPart.getJAXBNodesViaXPath("//w:tbl", false);
        for (Object node : nodes) {
            Object value;
            if (!(node instanceof JAXBElement) || !((value = ((JAXBElement)node).getValue()) instanceof Tbl)) continue;
            tables.add((Tbl)value);
        }
        return tables;
    }

    private TableInfo getTableInfo(Tbl table) throws Exception {
        TableInfo info = new TableInfo();
        info.setDynamic(false);
        info.setHeaderless(false);
        List<Tr> rows = this.getRows(table);
        if (rows.size() != 2) {
            return info;
        }
        List<Tc> frCells = this.getCells(rows.get(0));
        List<Tc> srCells = this.getCells(rows.get(1));
        for (int i = 0; i < frCells.size(); ++i) {
            if (!this.containsToken(frCells.get(i))) continue;
            if (this.contentEquals(srCells.get(i), HEADERLESS_MARK)) {
                info.setDynamic(true);
                info.setHeaderless(true);
                continue;
            }
            if (!this.contentEquals(srCells.get(i), REQUIRE_CELL_CONTENT)) continue;
            info.setDynamic(true);
        }
        return info;
    }

    private boolean containsToken(Tc cell) {
        return this.getCellText(cell).matches("@(.*)@");
    }

    private boolean contentEquals(Tc cell, String string) {
        return this.getCellText(cell).equals(string);
    }

    private String getCellText(Tc cell) {
        try {
            StringWriter content = new StringWriter();
            TextUtils.extractText((Object)cell, (Writer)content);
            return content.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private List<Tr> getRows(Tbl table) {
        return this.getContent((ContentAccessor)table, Tr.class);
    }

    private List<Tc> getCells(Tr row) {
        return this.getContent((ContentAccessor)row, Tc.class);
    }

    private <T> List<T> getContent(ContentAccessor element, Class<T> type) {
        ArrayList<T> content = new ArrayList<T>();
        for (Object item : element.getContent()) {
            content.add(this.unwrap(item, type));
        }
        return content;
    }

    private <T> T unwrap(Object object, Class<T> type) {
        JAXBElement element;
        if (type.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (object instanceof JAXBElement && type.isAssignableFrom((element = (JAXBElement)object).getDeclaredType())) {
            return (T)element.getValue();
        }
        throw new IllegalStateException("Cannot extract object of type" + type.getName() + " from [" + object + "]");
    }
}

