/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.cuf.database.config.DatabaseConfig;
import com.suncode.cuf.hibernate.HibernateQueryExecutor;
import com.suncode.cuf.hibernate.SessionFactoryBuilder;
import com.suncode.cuf.plannedtask.administration.ExportStructure;
import com.suncode.cuf.plannedtask.administration.helper.ImportStructureMode;
import com.suncode.cuf.plannedtask.administration.helper.StructureImporter;
import com.suncode.cuf.plannedtask.administration.helper.StructureMappings;
import com.suncode.cuf.plannedtask.administration.helper.internal.DBMappings;
import com.suncode.cuf.plannedtask.administration.helper.internal.ExcelMappings;
import com.suncode.cuf.sql.query.SelectQuery;
import com.suncode.cuf.sql.query.type.SqlTypes;
import com.suncode.cuf.util.ContextLogger;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.util.logging.LoggerLevel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportStructure
extends AbstractAdvancedTask {
    private static final Logger taskLog = LoggerFactory.getLogger((String)"ScheduledTask");
    private volatile double progress = 0.0;
    public static final String APPEND = "APPEND";
    public static final String STANDARD = "STANDARD";
    public static final String OVERRIDE = "OVERRIDE";

    public Double getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdvancedTask(name="importStructure", description="importStructure", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructure(@TaskParam(name="path_to_excel_file", description="path_to_excel_file") String path, @TaskParam(name="read_mode", description="read_mode_desc") String mode) throws Exception {
        StructureMappings mappings = this.getExcelMappings();
        List<Map<String, Object>> struct = this.readExcel(path, mappings);
        if (struct.size() == 0) {
            throw new CUFException("W pliku nie ma struktury organizacyjnej do zaimportowania");
        }
        ContextLogger.set(taskLog, LoggerLevel.INFO);
        try {
            this.progress = 0.5;
            StructureImporter importer = (StructureImporter)SpringContext.getBean(StructureImporter.class);
            importer.importStructure(struct, mappings, this.getMode(mode));
            this.progress = 1.0;
        }
        finally {
            ContextLogger.clear();
        }
    }

    @AdvancedTask(name="importStructureFromDb", description="importStructureFromDb", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructureFromDb(@TaskParam(name="dbtype", description="dbtype_desc") String dbType, @TaskParam(name="dburl", description="dburl") String url, @TaskParam(name="dbport", description="dbport") String port, @TaskParam(name="dbname", description="dbname") String dbName, @TaskParam(name="tablename", description="tablename") String tableName, @TaskParam(name="dbusername", description="dbusername") String userName, @TaskParam(name="dbpass", description="dbpass") String password, @TaskParam(name="read_mode", description="read_mode_desc") String mode, @TaskParam(name="columns", description="columns") String columns) throws Exception {
        StructureMappings mappings = this.getDBMappings(columns);
        DatabaseConfig dbcfg = ExportStructure.buildDBConfig(dbType, url, port, dbName, userName, password);
        List<Map<String, Object>> struct = this.readData(dbcfg, tableName, mappings);
        this.progress = 0.5;
        StructureImporter importer = (StructureImporter)SpringContext.getBean(StructureImporter.class);
        importer.importStructure(struct, mappings, this.getMode(mode));
        this.progress = 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> readData(DatabaseConfig dbcfg, String tableName, StructureMappings mappings) {
        SessionFactory sf = null;
        try {
            sf = SessionFactoryBuilder.buildSessionFactory(dbcfg);
            HibernateQueryExecutor executor = new HibernateQueryExecutor();
            executor.setSessionFactory(sf);
            SelectQuery select = new SelectQuery();
            select.setQuery(this.buildQuery(mappings, tableName));
            this.buildScalars(select, mappings);
            List<Map<String, Object>> list = executor.list(select);
            return list;
        }
        finally {
            sf.close();
        }
    }

    private void buildScalars(SelectQuery select, StructureMappings mappings) {
        for (String col : mappings.getColumnNames()) {
            select.addScalar(col, SqlTypes.STRING);
        }
    }

    private String buildQuery(StructureMappings mappings, String tableName) {
        Object[] cols = mappings.getColumnNames();
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(StringUtils.join((Object[])cols, (String)","));
        sb.append(" from ");
        sb.append(tableName);
        return sb.toString();
    }

    ImportStructureMode getMode(String mode) {
        if (mode.equals(APPEND)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importStructureAppendMode");
        }
        if (mode.equals(STANDARD)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importStructureStandardMode");
        }
        if (mode.equals(OVERRIDE)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importStructureOverrideMode");
        }
        throw new IllegalArgumentException("Nie obs\u0142ugiwany tryb importu: " + mode);
    }

    StructureMappings getExcelMappings() {
        return (StructureMappings)SpringContext.getBean(ExcelMappings.class);
    }

    StructureMappings getDBMappings(String columns) {
        DBMappings mappings = new DBMappings();
        if (StringUtils.isNotBlank((CharSequence)columns)) {
            mappings.setColumnNames(columns.split(";"));
        }
        return mappings;
    }

    List<Map<String, Object>> readExcel(String path, StructureMappings mappings) throws Exception {
        String[] columnNames = mappings.getColumnNames();
        ExcelReader er = new ExcelReader();
        er.setExcelTypes(this.buildTypes(mappings.getColumnNames()));
        List<Map<String, Object>> data = er.readExcel(path, Arrays.asList(columnNames));
        taskLog.debug("Wczytano plik excel. Ilos\u0107 rekord\u00f3w: " + data.size());
        return data;
    }

    private Map<String, Class> buildTypes(String[] columnNames) {
        HashMap<String, Class> types = new HashMap<String, Class>();
        for (String col : columnNames) {
            types.put(col, String.class);
        }
        return types;
    }
}

