/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriter {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static Logger log = Logger.getLogger(ExcelWriter.class);
    private CreationHelper ch;
    private Workbook wb;
    private String extension = "xlsx";
    private String[] headers;
    private Map<String, String> headersMapping;
    private Map<Integer, String> headerIdx;
    private Map<String, Class<?>> excelTypes;

    public long generateExcel(List<Map<String, Object>> data, OutputStream os) throws IOException, ParseException {
        if (this.headers == null && !data.isEmpty()) {
            this.setHeaders(data.get(0).keySet());
        }
        this.wb = this.getExtension().equals("xls") ? new HSSFWorkbook() : new XSSFWorkbook();
        this.ch = this.wb.getCreationHelper();
        Sheet sheet = this.wb.createSheet();
        Row firstRow = sheet.createRow(0);
        this.createHeaderRow(firstRow);
        this.writeData(data, sheet);
        this.wb.write(os);
        os.close();
        CountingOutputStream cos = new CountingOutputStream(os);
        return cos.getByteCount();
    }

    private void setHeaders(Set<String> keySet) {
        this.headers = new String[keySet.size()];
        int i = 0;
        Iterator<String> i$ = keySet.iterator();
        while (i$.hasNext()) {
            String header;
            this.headers[i] = header = i$.next();
            ++i;
        }
    }

    private void writeData(List<Map<String, Object>> map, Sheet sheet) throws ParseException {
        int rowIdx = 1;
        for (Map<String, Object> row : map) {
            Row r = sheet.createRow(rowIdx);
            this.createRow(row, r);
            ++rowIdx;
        }
    }

    private void createRow(Map<String, Object> row, Row r) throws ParseException {
        for (int i = 0; i < this.getHeaders().length; ++i) {
            String field = this.getHeaders()[i];
            Cell cell = r.createCell(i);
            Class cl = String.class;
            if (this.getExcelTypes().containsKey(this.getHeaderIdx().get(i))) {
                cl = this.getExcelTypes().get(this.getHeaderIdx().get(i));
            }
            if (row.get(this.getHeaderIdx().get(i)) == null) continue;
            String value = row.get(this.getHeaderIdx().get(i)).toString();
            log.debug((Object)("wpisuje do pola " + field + " w kolumnie " + i + " wartosc " + value));
            this.setCellValue(cl, value, cell);
        }
    }

    private void setCellValue(Class cl, String value, Cell cell) throws ParseException {
        if (value.equals("undefined")) {
            value = null;
        }
        if (this.isNumeric(cl)) {
            if (!StringUtils.isEmpty((String)value)) {
                double d = Double.parseDouble(value);
                cell.setCellValue(d);
                cell.setCellType(0);
            }
        } else if (this.isDate(cl)) {
            CellStyle cellStyle = this.wb.createCellStyle();
            cellStyle.setDataFormat(this.ch.createDataFormat().getFormat("yyyy-MM-dd"));
            Date d = null;
            if (!StringUtils.isEmpty((String)value)) {
                d = this.sdf.parse(value);
                cell.setCellValue(d);
                cell.setCellStyle(cellStyle);
            }
        } else if (this.isBoolean(cl)) {
            if (!StringUtils.isEmpty((String)value)) {
                boolean b = Boolean.valueOf(value);
                cell.setCellValue(b);
                cell.setCellType(4);
            }
        } else {
            cell.setCellValue(value);
        }
    }

    private boolean isBoolean(Class cl) {
        return cl.equals(Boolean.class);
    }

    private boolean isDate(Class cl) {
        return cl.equals(Date.class);
    }

    private boolean isNumeric(Class cl) {
        return cl.equals(Integer.class) || cl.equals(Double.class) || cl.equals(Float.class) || cl.equals(BigDecimal.class) || cl.equals(BigInteger.class);
    }

    private void createHeaderRow(Row firstRow) {
        for (int i = 0; i < this.getHeaders().length; ++i) {
            String header = this.getHeaders()[i];
            Cell cell = firstRow.createCell(i);
            cell.setCellValue(header);
        }
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Map<String, String> getHeadersMapping() {
        if (this.headersMapping == null) {
            this.headersMapping = new HashMap<String, String>();
            for (String header : this.getHeaders()) {
                this.headersMapping.put(header, header);
            }
        }
        return this.headersMapping;
    }

    public void setHeadersMapping(Map<String, String> headersMapping) {
        this.headersMapping = headersMapping;
    }

    public String[] getHeaders() {
        if (this.headers == null) {
            throw new NullPointerException("Wymagane jest podanie nag\u0142\u00f3wk\u00f3w danych");
        }
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    public Map<String, Class<?>> getExcelTypes() {
        if (this.excelTypes == null) {
            this.excelTypes = new HashMap();
        }
        return this.excelTypes;
    }

    public void setExcelTypes(Map<String, Class<?>> excelTypes) {
        this.excelTypes = excelTypes;
    }

    public long generateScheme(List<String> headers, OutputStream os) throws IOException {
        this.setHeaders(headers.toArray(new String[headers.size()]));
        this.wb = this.getExtension().equals("xls") ? new HSSFWorkbook() : new XSSFWorkbook();
        this.ch = this.wb.getCreationHelper();
        Sheet sheet = this.wb.createSheet();
        Row firstRow = sheet.createRow(0);
        this.createHeaderRow(firstRow);
        this.wb.write(os);
        os.close();
        CountingOutputStream cos = new CountingOutputStream(os);
        return cos.getByteCount();
    }

    public Map<Integer, String> getHeaderIdx() {
        if (this.headerIdx == null) {
            this.headerIdx = new HashMap<Integer, String>();
            Map<String, String> map = this.getHeadersMapping();
            block0: for (int i = 0; i < this.getHeaders().length; ++i) {
                String header = this.getHeaders()[i];
                for (String key : map.keySet()) {
                    if (!header.equals(map.get(key))) continue;
                    this.headerIdx.put(i, key);
                    continue block0;
                }
            }
        }
        return this.headerIdx;
    }

    public void setHeaderIdx(Map<Integer, String> headerIdx) {
        this.headerIdx = headerIdx;
    }
}

