/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.CollectionUtils;
import com.plusmpm.CUF.util.extension.QueryUtils;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.database.hibernate.JdbcTableManager;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;

public class DBService {
    private static Logger log = Logger.getLogger(DBService.class);
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = HibernateUtil.getSessionFactory();
        }
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Deprecated
    public List<Map<String, Object>> getDataFromTable(String tableName) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = this.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery("select * from " + tableName);
            sql.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
            List data = sql.list();
            tx.commit();
            List list = data;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    @Deprecated
    public SessionFactory getCustomSessionFactory(String dbType, String url, String port, String dbName, String userName, String password) {
        Configuration cfg = new Configuration();
        if (dbType.equalsIgnoreCase("PostgreSQL")) {
            cfg.setProperty("hibernate.dialect", "org.hibernate.dialect.PostgreSQLDialect");
            cfg.setProperty("hibernate.connection.driver_class", "org.hibernate.dialect.PostgreSQLDialect");
            cfg.setProperty("hibernate.connection.url", "jdbc:postgresql://" + url + ":" + port + "/" + dbName);
        } else if (dbType.equalsIgnoreCase("MSSQL")) {
            cfg.setProperty("hibernate.dialect", "com.plusmpm.modules.dbexplorer.SQLServerDialect");
            cfg.setProperty("hibernate.connection.driver_class", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
            cfg.setProperty("hibernate.connection.url", "jdbc:sqlserver://" + url + ":" + port + ";useUnicode=true;characterEncoding=UTF-8" + ";databaseName=" + dbName);
        } else if (dbType.equalsIgnoreCase("OracleDB")) {
            cfg.setProperty("hibernate.dialect", "org.hibernate.dialect.OracleDialect");
            cfg.setProperty("hibernate.connection.driver_class", "oracle.jdbc.driver.OracleDriver");
            cfg.setProperty("hibernate.connection.url", "jdbc:oracle:thin:@" + url + ":" + port + ":" + dbName);
        }
        cfg.setProperty("hibernate.connection.username", userName);
        cfg.setProperty("hibernate.connection.password", password);
        cfg.setProperty("hibernate.hbm2ddl.auto", "update");
        cfg.setProperty("hibernate.current_session_context_class", "thread");
        return cfg.buildSessionFactory();
    }

    @Deprecated
    public void setDataInTable(List<Map<String, Object>> data, String tableName) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            if (data.isEmpty()) {
                return;
            }
            Map<String, Object> first = data.get(0);
            String[] order = CollectionUtils.keysToArray(first);
            String cols = QueryUtils.arrayToString(order, ",");
            String base = "insert into " + tableName + " (" + cols + ") values (";
            String del = "delete from " + tableName;
            hs = this.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            hs.createSQLQuery(del).executeUpdate();
            for (Map<String, Object> row : data) {
                String values = QueryUtils.mapToString(order, row, ",");
                StringBuilder query = new StringBuilder();
                query.append(base);
                query.append(values);
                query.append(")");
                SQLQuery sql = hs.createSQLQuery(query.toString());
                sql.executeUpdate();
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public boolean tableExists(String tableName) throws HibernateException {
        JdbcTableManager jdbcTableManager = new JdbcTableManager(tableName);
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            transaction = session.beginTransaction();
            session.doWork((Work)jdbcTableManager);
            transaction.commit();
        }
        catch (HibernateException he) {
            he.printStackTrace();
            try {
                transaction.rollback();
            }
            catch (HibernateException he1) {
                he1.printStackTrace();
            }
            throw he;
        }
        return jdbcTableManager.isExists();
    }

    @Deprecated
    public void executeUpdate(String query) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = this.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            hs.createSQLQuery(query).executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }
}

