/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.database.externalDBConf.ExternalDBConf;
import com.plusmpm.CUF.database.externalDBConf.ExternalDBConfManager;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class ExternalDBConfManagement
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExternalDBConfManagement.class);

    @AdvancedTask(name="AddExternalDBConf", description="AddExternalDBConf_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void AddExternalDBConf(@TaskParam(name="Names", description="nazwa konfiguracji (moze byc kilka, rozdzielone przecinkiem)") String sNames, @TaskParam(name="URLs", description="Url polaczenia (moze byc kilka, rozdzielone przecinkiem)") String sURLs, @TaskParam(name="Drivers", description="sterownik polaczenia (moze byc kilka, rozdzielone przecinkiem)") String sDrivers, @TaskParam(name="Logins", description="uzytkownik z dostepem (moze byc kilka, rozdzielone przecinkiem)") String sLogins, @TaskParam(name="Passwords", description="haslo dla podanego uzytkownika (moze byc kilka, rozdzielone przecinkiem)") String sPasswords) {
        log.info((Object)("************************ AddExternalDBConf(sNames=" + sNames + ", sURLs=" + sURLs + ", sDrivers=" + sDrivers + ", sLogins=" + sLogins + ", sPasswords) *************************"));
        long startTime = new Date().getTime();
        try {
            String[] namesTable = sNames.split(",");
            String[] urlsTable = sURLs.split(",");
            String[] driversTable = sDrivers.split(",");
            String[] loginsTable = sLogins.split(",");
            String[] passwordsTable = sPasswords.split(",");
            if (namesTable.length == urlsTable.length && namesTable.length == driversTable.length && namesTable.length == loginsTable.length && namesTable.length == passwordsTable.length) {
                for (int i = 0; i < namesTable.length; ++i) {
                    urlsTable[i] = urlsTable[i].replaceAll("[$]", ";");
                    if (ExternalDBConfManager.checkExistence(namesTable[i], urlsTable[i], driversTable[i], loginsTable[i], passwordsTable[i]) == -1L) {
                        ExternalDBConf externalDBConf = new ExternalDBConf();
                        externalDBConf.setExternalDBConfName(namesTable[i]);
                        externalDBConf.setUrl(urlsTable[i]);
                        externalDBConf.setDriver(driversTable[i]);
                        externalDBConf.setLogin(loginsTable[i]);
                        externalDBConf.setPassword(passwordsTable[i]);
                        ExternalDBConfManager.save(externalDBConf);
                        log.debug((Object)("Konfiguracja polaczenia o nazwie " + namesTable[i] + " dodana"));
                        continue;
                    }
                    log.debug((Object)("Konfiguracja polaczenia o parametrach: " + namesTable[i] + ", " + urlsTable[i] + ", " + driversTable[i] + ", " + loginsTable[i] + " i podanym hasle juz istnieje "));
                }
            } else {
                log.warn((Object)"Niepoprawnie zdefiniowane parametry zadania zaplanowanego. Sprawdz ilosc poszczegolnych parametrow rozdzielonych przecinkami");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego AddExternalDBConf: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    @AdvancedTask(name="UpdateExternalDBConf", description="UpdateExternalDBConf_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void UpdateExternalDBConf(@TaskParam(name="Names", description="nazwa konfiguracji (moze byc kilka, rozdzielone przecinkiem)") String sNames, @TaskParam(name="URLs", description="Url polaczenia (moze byc kilka, rozdzielone przecinkiem)") String sURLs, @TaskParam(name="Drivers", description="sterownik polaczenia (moze byc kilka, rozdzielone przecinkiem)") String sDrivers, @TaskParam(name="Logins", description="uzytkownik z dostepem (moze byc kilka, rozdzielone przecinkiem)") String sLogins, @TaskParam(name="Passwords", description="haslo dla podanego uzytkownika (moze byc kilka, rozdzielone przecinkiem)") String sPasswords) {
        log.info((Object)("************************ UpdateExternalDBConf(sNames=" + sNames + ", sURLs=" + sURLs + ", sDrivers=" + sDrivers + ", sLogins=" + sLogins + ", sPasswords) *************************"));
        long startTime = new Date().getTime();
        List<ExternalDBConf> conParamsList = null;
        try {
            String[] namesTable = sNames.split(",");
            String[] urlsTable = sURLs.split(",");
            String[] driversTable = sDrivers.split(",");
            String[] loginsTable = sLogins.split(",");
            String[] passwordsTable = sPasswords.split(",");
            if (namesTable.length == urlsTable.length && namesTable.length == driversTable.length && namesTable.length == loginsTable.length && namesTable.length == passwordsTable.length) {
                for (int i = 0; i < namesTable.length; ++i) {
                    urlsTable[i] = urlsTable[i].replaceAll("[$]", ";");
                    conParamsList = ExternalDBConfManager.getExternalDBConfForName(namesTable[i]);
                    if (conParamsList != null && conParamsList.size() > 0) {
                        for (int j = 0; j < conParamsList.size(); ++j) {
                            conParamsList.get(j).setUrl(urlsTable[i]);
                            conParamsList.get(j).setDriver(driversTable[i]);
                            conParamsList.get(j).setLogin(loginsTable[i]);
                            conParamsList.get(j).setPassword(passwordsTable[i]);
                            ExternalDBConfManager.update(conParamsList.get(j));
                        }
                        log.debug((Object)("Konfiguracja polaczenia o nazwie " + namesTable[i] + " zostala zaktualizowana"));
                        continue;
                    }
                    log.debug((Object)("Konfiguracja polaczenia o nazwie " + namesTable[i] + " nie istnieje "));
                }
            } else {
                log.warn((Object)"Niepoprawnie zdefiniowane parametry zadania zaplanowanego. Sprawdz ilosc poszczegolnych parametrow rozdzielonych przecinkami");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego UpdateExternalDBConf: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    @AdvancedTask(name="DeleteExternalDBConf", description="DeleteExternalDBConf_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void DeleteExternalDBConf(@TaskParam(name="Names", description="nazwa konfiguracji (moze byc kilka, rozdzielone przecinkiem)") String sNames) {
        log.info((Object)("************************ DeleteExternalDBConf(sNames=" + sNames + ") *************************"));
        long startTime = new Date().getTime();
        List<ExternalDBConf> conParamsList = null;
        try {
            String[] namesTable = sNames.split(",");
            for (int i = 0; i < namesTable.length; ++i) {
                conParamsList = ExternalDBConfManager.getExternalDBConfForName(namesTable[i]);
                if (conParamsList != null && conParamsList.size() > 0) {
                    for (int j = 0; j < conParamsList.size(); ++j) {
                        ExternalDBConfManager.delete(conParamsList.get(j));
                    }
                    log.info((Object)("Konfiguracja polaczenia o nazwie " + namesTable[i] + " usunieta"));
                    continue;
                }
                log.warn((Object)("Konfiguracja polaczenia o nazwie " + namesTable[i] + " nie istnieje "));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego DeleteExternalDBConf: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    @AdvancedTask(name="DeleteAllExternalDBConf", description="DeleteAllExternalDBConf_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void DeleteAllExternalDBConf() {
        log.info((Object)"************************ DeleteAllExternalDBConf() *************************");
        long startTime = new Date().getTime();
        ExternalDBConfManager manager = new ExternalDBConfManager();
        try {
            manager.deleteAll();
            log.info((Object)"Wszystkie konfiguracje polaczen z zewnetrzna baza danych usuniete");
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego DeleteAllExternalDBConf: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

