/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.CUF.util.extension.JsonMessage;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.util.SharkFunctions;
import com.suncode.cuf.io.office.ExcelWriter;
import com.suncode.cuf.io.office.model.ExcelFormat;
import com.suncode.cuf.io.office.model.ExportSheetDefinition;
import com.suncode.cuf.io.office.model.writer.ValueWriter;
import com.suncode.cuf.io.office.model.writer.ValueWriterResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ExportDTToExcel
extends HttpServlet {
    public static Logger log = Logger.getLogger(ExportDTToExcel.class);
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug((Object)"************************* ExportTable Servlet ****************************");
        try {
            String mode = req.getParameter("mode");
            String extension = req.getParameter("extension");
            String title = req.getParameter("title");
            if (StringUtils.isEmpty((String)title)) {
                title = "Eksport tabeli dynamicznej";
            }
            if (StringUtils.isEmpty((String)mode) || mode.equals("write")) {
                log.debug((Object)"Params:");
                log.debug((Object)("title: " + title));
                log.debug((Object)("extension: " + extension));
                Map<String, String> headerMappings = this.readHeaderMappings(req.getParameter("headerMappings"));
                List<Map<String, Object>> data = this.readData(req.getParameter("data"));
                Map<String, String> types = this.getVariableTypes(headerMappings.keySet(), req.getParameter("processId"));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (Map<String, Object> map : data) {
                    for (String key : headerMappings.keySet()) {
                        if (!"date".equals(types.get(key)) || map.get(key) == null) continue;
                        Date value = sdf.parse((String)map.get(key));
                        map.put(key, value);
                    }
                }
                ExcelWriter ew = new ExcelWriter();
                if (extension.equals("xls")) {
                    ew.setFormat(ExcelFormat.XLS);
                } else {
                    ew.setFormat(ExcelFormat.XLSX);
                }
                File tempDir = (File)req.getSession().getServletContext().getAttribute("javax.servlet.context.tempdir");
                File excelFile = File.createTempFile("excel", "." + extension, tempDir);
                log.debug((Object)("Utworzy\u0142em plik tymczasowy: " + excelFile));
                String path = excelFile.getAbsolutePath();
                ExportSheetDefinition sheet = new ExportSheetDefinition("Arkusz 1", data);
                sheet.setMappings(headerMappings);
                sheet.setKeysSource(ExportSheetDefinition.KeysSource.MAPPING);
                Map<String, Class<?>> classes = this.convertTypes(types);
                for (String key : types.keySet()) {
                    ValueWriter writer = ValueWriterResolver.getInstance().resolve(classes.get(key));
                    sheet.setValueWriter(key, writer);
                }
                FileOutputStream fileStream = new FileOutputStream(excelFile);
                ew.write(sheet, (OutputStream)fileStream);
                fileStream.close();
                File file = new File(path);
                Long size = file.length();
                JsonMessage jm = new JsonMessage();
                Object[] ret = new Object[]{path, extension, size, title};
                jm.setData(ret);
                ObjectMapper om = new ObjectMapper();
                resp.getWriter().print(om.writeValueAsString((Object)jm));
                resp.getWriter().close();
            } else {
                String filename = title + "." + extension;
                ServletOutputStream sos = resp.getOutputStream();
                resp.setContentType(this.getContentType(extension));
                String size = req.getParameter("size");
                String path = req.getParameter("path");
                File file = new File(path);
                FileInputStream fis = new FileInputStream(file);
                resp.setHeader("Content-Disposition", this.getContentDisposition(filename));
                IOUtils.copy((InputStream)fis, (OutputStream)sos);
                sos.flush();
                fis.close();
                resp.setContentLength(Integer.valueOf(size).intValue());
                log.debug((Object)("Usuwam plik: " + file));
                file.delete();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private String getContentDisposition(String filename) throws URIException {
        String filenameEncoding = URIUtil.encodeAll((String)filename);
        StringBuilder contentDisposition = new StringBuilder();
        contentDisposition.append("attachment;");
        contentDisposition.append(" filename=");
        contentDisposition.append(filenameEncoding);
        contentDisposition.append("; filename*=UTF-8''");
        contentDisposition.append(filenameEncoding);
        return contentDisposition.toString();
    }

    private Map<String, Class<?>> convertTypes(Map<String, String> types) {
        HashMap exTypes = new HashMap();
        for (String key : types.keySet()) {
            if (types.get(key).equals("integer")) {
                exTypes.put(key, Integer.class);
                continue;
            }
            if (types.get(key).equals("float")) {
                exTypes.put(key, Double.class);
                continue;
            }
            if (types.get(key).equals("date")) {
                exTypes.put(key, Date.class);
                continue;
            }
            exTypes.put(key, String.class);
        }
        return exTypes;
    }

    private Map<String, String> getVariableTypes(Iterable<String> keySet, String processId) {
        HashMap<String, String> types = new HashMap<String, String>();
        String processDefId = null;
        try {
            processDefId = Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(processId);
        }
        catch (Exception e) {
            return types;
        }
        Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(processDefId);
        WorkflowProcess wp = pack.getWorkflowProcess(processDefId);
        for (String varId : keySet) {
            String type = SharkClientFunctions.getVarTypeForVarId(wp, varId);
            types.put(varId, type);
        }
        return types;
    }

    private List<Map<String, Object>> readData(String sData) throws JsonParseException, JsonMappingException, IOException {
        log.debug((Object)("sData: " + sData));
        ObjectMapper om = new ObjectMapper();
        List data = (List)om.readValue(sData, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        return data;
    }

    private Map<String, String> readHeaderMappings(String sHeaderMappings) throws JsonParseException, JsonMappingException, IOException {
        log.debug((Object)("headerMappings: " + sHeaderMappings));
        ObjectMapper om = new ObjectMapper();
        Map map = (Map)om.readValue(sHeaderMappings, (TypeReference)new TypeReference<Map<String, String>>(){});
        return map;
    }

    private String getContentType(String extension) {
        if (extension.equals("xls")) {
            return "application/vnd.ms-excel";
        }
        return "application/vnd.ms-excel.12";
    }

    private List<String> readHeaders(String sHeaders) throws JsonParseException, JsonMappingException, IOException {
        log.debug((Object)("headers: " + sHeaders));
        ObjectMapper om = new ObjectMapper();
        List list = (List)om.readValue(sHeaders, (TypeReference)new TypeReference<List<String>>(){});
        return list;
    }
}

