/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.validation;

public class CodeValidator {
    private CodeValidator() {
    }

    public static boolean validatePESEL(String pesel) {
        pesel = pesel.replaceAll("[\\p{Punct}\\p{Space}-]*", "");
        int[] weights = new int[]{1, 3, 7, 9, 1, 3, 7, 9, 1, 3};
        if (pesel.length() != 11) {
            return false;
        }
        String[] aPesel = pesel.split("");
        int sum = 0;
        for (int i = 0; i < 10; ++i) {
            sum += Integer.valueOf(aPesel[i + 1]) * weights[i];
        }
        int lastDigit = Integer.valueOf(aPesel[11]);
        sum %= 10;
        sum = 10 - sum;
        return (sum %= 10) == lastDigit;
    }

    public static boolean validateNIP(String nip) {
        if ((nip = nip.replaceAll("[\\p{Punct}\\p{Space}-]*", "")).length() != 10) {
            return false;
        }
        int[] weights = new int[]{6, 5, 7, 2, 3, 4, 5, 6, 7};
        String[] aNip = nip.split("");
        try {
            int sum = 0;
            for (int i = 0; i < weights.length; ++i) {
                sum += Integer.parseInt(aNip[i + 1]) * weights[i];
            }
            return sum % 11 == Integer.parseInt(aNip[10]);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean validateNRB(String nrb) {
        return CodeValidator.validateIBAN("PL" + nrb);
    }

    public static boolean validateIBAN(String iban) {
        if (!(iban = iban.toUpperCase().replaceAll("[\\p{Punct}\\p{Space}-]*", "")).matches("^[A-Z]{2}[0-9]{12,}")) {
            return false;
        }
        iban = iban.substring(4, iban.length()) + iban.substring(0, 4);
        for (int i = 0; i < iban.length(); ++i) {
            char c = iban.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            int code = Character.getNumericValue(c);
            iban = iban.substring(0, i) + code + iban.substring(i + 1, iban.length());
        }
        int mod = 0;
        int isize = iban.length();
        for (int i = 0; i < isize; i += 6) {
            try {
                mod = Integer.parseInt("" + mod + iban.substring(i, i + 6), 10) % 97;
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                return false;
            }
        }
        return mod == 1;
    }
}

