/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office.model;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.util.CellReference;

public class CellValue<T> {
    private T value;
    private CellReference cellReference;
    private String sheetName;

    public CellValue(Cell cell, T value) {
        this(cell.getRowIndex(), cell.getColumnIndex(), cell.getSheet().getSheetName(), value);
    }

    public CellValue(int row, int col, String sheetName, T value) {
        this.cellReference = new CellReference(row, col);
        this.value = value;
        this.sheetName = sheetName;
    }

    public T getValue() {
        return this.value;
    }

    public String getAlias() {
        return this.cellReference.formatAsString();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String toString() {
        return this.getAlias() + "(" + this.value + ")";
    }
}

