/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.database.CommentsTable;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.database.scheduledTasks.ScheduledTasksMethods;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.util.AdvanceSearchResult;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.plusmpm.util.workflowData.ActivityData;
import com.plusmpm.util.workflowData.ProcessData;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.util.ServiceFactory;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataType;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ArchiveProcesses
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ArchiveProcesses.class);
    private volatile double progress = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdvancedTask(name="Archiwizacja_procesow", description="Archiwizacja_procesow_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void RunArchiver(@TaskParam(name="ProcessDefId", description="identyfikator definicji procesu, ktory bedzie zarchiwizowany") String sProcessDefId, @TaskParam(name="ClassName", description="nazwa klasy, gdzie beda zapisywane zarchiwizowane procesy") String sClassName, @TaskParam(name="ExpirationDate", description="ilosc dni, po ktorych wygasnie dokument (mozna ustawic na NEVER, dokumenty wtedy nie beda wygasac)") String sExpirationDate, @TaskParam(name="Device", description="nazwa urzadzenia obslugujacego klase sClassName (NULL - brak weryfikacji istnienia urzadzenia)") String sDevice, @TaskParam(name="Folder", description="nazwa katalogu, gdzie beda zapisywane zarchiwizowane dokumenty dla klasy sClassName (obslugiwany przez sDevice) (NULL - brak weryfikacji istnienia katalogu)") String sFolder, @TaskParam(name="OtherIndecies", description="dodatkowe indeksy rozdzielone przecinkiem (NULL - brak dodatkowych indeksow, ALL - wszystkie zmienne procesu jako indeksy)") String sOtherIndecies, @TaskParam(name="FinishDate", description="data zakonczenia procesu, beda szukane procesy o dacie zakonczenia pozniejszej od podanej w sFinishDate, format postaci np. 2011-06-25 14:45:56") String sFinishDate, @TaskParam(name="Language", description="wersja jezykowa (wplywa na nazwy indeksow obowiazkowych), dostepne wersje: PL, ENG") String sLanguage, @TaskParam(name="PDFIds", description="czy dodawac do PDF identyfikatory zmiennych/procesow/zadan (TRUE jesli tak)") String sPDFIds, @TaskParam(name="PDFVariables", description="czy dodawac do PDF zmienne procesu (TRUE jesli tak)") String sPDFVariables, @TaskParam(name="PDFHistory", description="czy dodawac do PDF historie procesu (TRUE jesli tak)") String sPDFHistory, @TaskParam(name="PDFDocuments", description="czy dodawac do PDF dokumenty procesu (TRUE jesli tak)") String sPDFDocuments, @TaskParam(name="PDFComments", description="czy dodawac do PDF komentarze (TRUE jesli tak)") String sPDFComments, @TaskParam(name="AllClosedStates", description="czy archiwizowac procesy o stanie closed.terminated i closed.aborted (TRUE jesli tak)") String sAllClosedStates, @TaskParam(name="DeleteProcess", description="czy usuwac zarchiwizowany proces") String sDeleteProcess, @TaskParam(name="Login", description="login uzytkownika dodajacego pliki do archiwum") String sLogin) {
        long startTime;
        block118: {
            log.info((Object)("************************ RunArchiver(sProcessDefId=" + sProcessDefId + ", sClassName=" + sClassName + ", sExpirationDate=" + sExpirationDate + ", sDevice=" + sDevice + ", sFolder=" + sFolder + ", sOtherIndecies=" + sOtherIndecies + ", sFinishDate=" + sFinishDate + ", sLanguage=" + sLanguage + ", sPDFIds=" + sPDFIds + ", sPDFVariables=" + sPDFVariables + ", sPDFHistory=" + sPDFHistory + ", sPDFDocuments=" + sPDFDocuments + ", sPDFComments=" + sPDFComments + ", sAllClosedStates=" + sAllClosedStates + ", sDeleteProcess=" + sDeleteProcess + ", sLogin=" + sLogin + ") *************************"));
            startTime = new Date().getTime();
            boolean changeParam = true;
            String lastValueOfParam = sFinishDate;
            DBManagement dbm = new DBManagement();
            SharkTransaction st = null;
            ExecutionAdministration ea = null;
            try {
                String[] activeDefVarTableForActivities;
                String[] activeDefVarTable;
                Object dirId;
                ProcessData processData = new ProcessData();
                Map processDefIdsAndNamesMap = processData.getProcessDefIdsNames();
                if (processDefIdsAndNamesMap == null || processDefIdsAndNamesMap.size() == 0) {
                    taskLog.debug((Object)"Brak identyfikatorow definicji procesow w systemie");
                    throw new CUFException("Brak identyfikatorow definicji procesow w systemie");
                }
                Iterator processDefIdIterator = processDefIdsAndNamesMap.keySet().iterator();
                boolean bProcDefIdExists = false;
                while (processDefIdIterator.hasNext()) {
                    String oneProcDefId = (String)processDefIdIterator.next();
                    if (!oneProcDefId.equals(sProcessDefId)) continue;
                    bProcDefIdExists = true;
                    break;
                }
                if (!bProcDefIdExists) {
                    taskLog.debug((Object)("W systemie nie istnieje proces o identyfikatorze definicji " + sProcessDefId));
                    throw new CUFException("W systemie nie istnieje proces o identyfikatorze definicji " + sProcessDefId);
                }
                int howManyIndicies = 8;
                String[] mandatoryIndecies = new String[howManyIndicies];
                String[] mandatoryIndeciesDesc = new String[howManyIndicies];
                String[] mandatoryIndeciesTypes = new String[]{"string", "string", "date", "string", "date", "string", "date", "string"};
                mandatoryIndecies[0] = "processId";
                mandatoryIndeciesDesc[0] = this.getMessageForLanguage("Identyfikator procesu", sLanguage);
                mandatoryIndecies[1] = this.getMessageForLanguage("Nazwa procesu", sLanguage);
                mandatoryIndeciesDesc[1] = mandatoryIndecies[1];
                mandatoryIndecies[2] = this.getMessageForLanguage("Data rozpocz\u0119cia procesu", sLanguage);
                mandatoryIndeciesDesc[2] = mandatoryIndecies[2];
                mandatoryIndecies[3] = this.getMessageForLanguage("Czas rozpocz\u0119cia procesu", sLanguage);
                mandatoryIndeciesDesc[3] = mandatoryIndecies[3];
                mandatoryIndecies[4] = this.getMessageForLanguage("Data zako\u0144czenia procesu", sLanguage);
                mandatoryIndeciesDesc[4] = mandatoryIndecies[4];
                mandatoryIndecies[5] = this.getMessageForLanguage("Czas zako\u0144czenia procesu", sLanguage);
                mandatoryIndeciesDesc[5] = mandatoryIndecies[5];
                mandatoryIndecies[6] = this.getMessageForLanguage("Data archiwizacji", sLanguage);
                mandatoryIndeciesDesc[6] = mandatoryIndeciesDesc[5];
                mandatoryIndecies[7] = this.getMessageForLanguage("Inicjator", sLanguage);
                mandatoryIndeciesDesc[7] = mandatoryIndeciesDesc[6];
                DocClassTable docClassTable = dbm.getDocClassByName(sClassName);
                String docClassId = "";
                String filesPath = "";
                ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
                if (docClassTable != null) {
                    Device deviceTable;
                    log.debug((Object)("Klasa " + sClassName + " istnieje juz w systemie"));
                    docClassId = String.valueOf(docClassTable.getId());
                    if (Tools.isNullOrEmpty((String)docClassId)) {
                        taskLog.debug((Object)("Nieznany identyfikator klasy dokumentow " + sClassName));
                        throw new CUFException("Nieznany identyfikator klasy dokumentow " + sClassName);
                    }
                    if (!sDevice.equalsIgnoreCase("NULL") && !sFolder.equalsIgnoreCase("NULL")) {
                        deviceTable = as.getDeviceForDocumentClass(new Long(docClassId), new String[]{"directories"});
                        if (deviceTable == null) {
                            taskLog.debug((Object)("Brak urzadzenia dla klasy dokumentow " + sClassName));
                            throw new CUFException("Brak urzadzenia dla klasy dokumentow " + sClassName);
                        }
                        String deviceName = deviceTable.getDeviceName();
                        if (deviceName == null || !deviceName.equalsIgnoreCase(sDevice)) {
                            taskLog.debug((Object)("Niezgodnosc nazw urzadzenia klasy " + sClassName + " z parametrem zadania zaplanowanego"));
                            throw new CUFException("Niezgodnosc nazw urzadzenia klasy " + sClassName + " z parametrem zadania zaplanowanego");
                        }
                        String id = deviceTable.getId().toString();
                        Set allDirs = deviceTable.getDirectories();
                        if (allDirs == null || allDirs.size() == 0) {
                            taskLog.debug((Object)("Brak katalogow dla urzadzenia " + sDevice));
                            throw new CUFException("Brak katalogow dla urzadzenia " + sDevice);
                        }
                        boolean bFoundDir = false;
                        for (Directory oneDirTable : allDirs) {
                            String dirName;
                            if (oneDirTable == null || (dirName = oneDirTable.getDirectoryName()) == null || !sFolder.equalsIgnoreCase(dirName)) continue;
                            bFoundDir = true;
                            String path = deviceTable.getDevicePath();
                            if (Tools.isNullOrEmpty((String)path)) break;
                            filesPath = path + dirName;
                            log.debug((Object)("Klasa zapisuje dokumenty w lokalizacji: " + filesPath + ". Zgodnosc urzadzenia i katalogu klasy dokumentow " + sClassName + " z parametrami zadania zaplanowanego"));
                            break;
                        }
                        if (!bFoundDir) {
                            taskLog.debug((Object)("Folder zapisu dokumentow " + sFolder + " nie istnieje w urzadzeniu " + sDevice));
                            throw new CUFException("Folder zapisu dokumentow " + sFolder + " nie istnieje w urzadzeniu " + sDevice);
                        }
                    } else {
                        Directory dirTable;
                        deviceTable = as.getDeviceForDocumentClass(new Long(docClassId), new String[0]);
                        if (deviceTable == null) {
                            taskLog.debug((Object)("Brak urzadzenia dla klasy dokumentow " + sClassName));
                            throw new CUFException("Brak urzadzenia dla klasy dokumentow " + sClassName);
                        }
                        String path = deviceTable.getDevicePath();
                        dirId = docClassTable.getDocClassDirectoryId();
                        if (dirId != null && (dirTable = as.getDirectory((Long)dirId, new String[0])) != null) {
                            String dirName = dirTable.getDirectoryName();
                            if (!Tools.isNullOrEmpty((String)path) && !Tools.isNullOrEmpty((String)dirName)) {
                                filesPath = path + dirName;
                            }
                        }
                    }
                } else {
                    log.debug((Object)("Klasa " + sClassName + " nie istnieje w systemie. Proces tworzenia klasy rozpoczety"));
                    String sClassDescr = "";
                    sClassDescr = this.getMessageForLanguage("Archiwum proces\u00f3w", sLanguage) + " " + sProcessDefId + this.getMessageForLanguage("", sLanguage);
                    String sExpireDocumentType = "dayCnt";
                    if (sExpirationDate.equalsIgnoreCase("NEVER")) {
                        sExpirationDate = null;
                    }
                    dirId = "";
                    List allDevices = as.getAllDevices(new String[]{"directories"});
                    if (allDevices == null) {
                        taskLog.debug((Object)("Brak urzadzen w systemie. Nie mozna wiec zlokalizowac urzadzenia " + sDevice));
                        throw new CUFException("Brak urzadzen w systemie. Nie mozna wiec zlokalizowac urzadzenia " + sDevice);
                    }
                    block45: for (Device oneDeviceTable : allDevices) {
                        String deviceName;
                        if (oneDeviceTable == null || (deviceName = oneDeviceTable.getDeviceName()) == null || !sDevice.equalsIgnoreCase(deviceName)) continue;
                        String id = oneDeviceTable.getId().toString();
                        Set allDirs = oneDeviceTable.getDirectories();
                        if (allDirs == null || allDirs.size() == 0) continue;
                        for (Directory oneDirTable : allDirs) {
                            String dirName;
                            if (oneDirTable == null || (dirName = oneDirTable.getDirectoryName()) == null || !sFolder.equalsIgnoreCase(dirName)) continue;
                            String path = oneDeviceTable.getDevicePath();
                            if (!Tools.isNullOrEmpty((String)path)) {
                                filesPath = path + dirName;
                            }
                            dirId = String.valueOf(oneDirTable.getId());
                            break block45;
                        }
                    }
                    if (Tools.isNullOrEmpty((String)dirId)) {
                        taskLog.debug((Object)("Nie mozna zlokalizowac w systemie katalogu " + sFolder));
                        throw new CUFException("Nie mozna zlokalizowac w systemie katalogu " + sFolder);
                    }
                    log.debug((Object)("Urzadzenie " + sDevice + " oraz folder " + sFolder + " zidentyfikowane dla klasy dokumnetow " + sClassName));
                    docClassTable = new DocClassTable(sClassName, sClassDescr, sExpirationDate, sExpireDocumentType, new Long((String)dirId), "false", "false");
                    docClassTable.setCipherAlgorithm("");
                    docClassTable.setKeyLength(new Long("0"));
                    docClassTable.setDocClassIndex("true");
                    docClassTable.setDocClassDirectoryName(sFolder);
                    Long lMaxIdx = dbm.getMaxOrderDocClass();
                    if (lMaxIdx == null) {
                        lMaxIdx = new Long(-1L);
                    }
                    docClassTable.setDocClassOrderId(Long.valueOf(lMaxIdx + 1L));
                    dbm.addDocClass(docClassTable);
                    docClassId = String.valueOf(docClassTable.getId());
                    if (Tools.isNullOrEmpty((String)docClassId)) {
                        taskLog.debug((Object)("Nieznany identyfikator klasy dokumentow " + sClassName));
                        throw new CUFException("Nieznany identyfikator klasy dokumentow " + sClassName);
                    }
                    String sFullDirPath = Tools.GetFullDirPath((String)docClassId);
                    docClassTable.setDocClassIndexPath(sFullDirPath + "indexDir_" + docClassId);
                    dbm.changeDocClass(docClassTable);
                    log.debug((Object)("Stworzono klase dokumentu o nazwie " + sClassName + " oraz identyfikatorze " + docClassId));
                }
                if (Tools.isNullOrEmpty((String)filesPath)) {
                    taskLog.debug((Object)"Nieznana sciezka do zapisu zarchiwizowanych procesow");
                    throw new CUFException("Nieznana sciezka do zapisu zarchiwizowanych procesow");
                }
                log.debug((Object)("Sprawdzanie wystepowania obowiazkowych indeksow w klasie dokumentow " + sClassName));
                for (int i = 0; i < mandatoryIndecies.length && mandatoryIndecies.length == mandatoryIndeciesDesc.length; ++i) {
                    Long sIndexExists = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[i]);
                    if (sIndexExists == null) {
                        log.debug((Object)("Obowiazkowy indeks " + mandatoryIndecies[i] + " nie istnieje dla klasy dokumentow " + sClassName + ". Tworzenie indeksu"));
                        long indexId = ArchiveServices.CreateIndexForDocClass(docClassId, mandatoryIndecies[i], mandatoryIndeciesDesc[i], mandatoryIndeciesTypes[i], "");
                        if (indexId != -1L) {
                            log.debug((Object)("Obowiazkowy indeks o nazwie " + mandatoryIndecies[i] + " i typie " + mandatoryIndeciesTypes[i] + " stworzony poprawnie w klasie dokumentow " + sClassName));
                            continue;
                        }
                        log.debug((Object)("Blad podczas dodawania obowiazkowego indeksu o nazwie " + mandatoryIndecies[i] + " i typie " + mandatoryIndeciesTypes[i] + " w klasie dokumentow " + sClassName));
                        continue;
                    }
                    log.debug((Object)("Obowiazkowy indeks " + mandatoryIndecies[i] + " istnieje dla klasy dokumentow " + sClassName));
                }
                WorkflowProcess wp = null;
                Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(sProcessDefId);
                ArrayList<String> activeProcVar = new ArrayList<String>();
                ArrayList<String> activeDefVar = new ArrayList<String>();
                ArrayList<String> activeDefVarForActivities = new ArrayList<String>();
                HashMap<String, String> hmAdSearchVar = new HashMap<String, String>();
                Map mAllProcVar = null;
                ArrayList<Object> processes = null;
                ArrayList activities = null;
                for (String oneActDef : activeDefVarTable = new String[]{"procDescr", "procInitiator", "procStart", "processType"}) {
                    activeDefVar.add(oneActDef);
                }
                for (String oneActDefForActivity : activeDefVarTableForActivities = new String[]{"taskName", "taskStateSelect", "taskUser", "taskStart", "taskFinish"}) {
                    activeDefVarForActivities.add(oneActDefForActivity);
                }
                String sProcessName = "";
                wp = pack.getWorkflowProcess(sProcessDefId);
                if (wp != null) {
                    log.debug((Object)("Proces o identyfikatorze definicji " + sProcessDefId + " istnieje"));
                    mAllProcVar = ProcessData.getProcessVariableIdNameMap((String)sProcessDefId);
                    Iterator valuesIds = mAllProcVar.keySet().iterator();
                    boolean indiciesForAllVars = false;
                    if (sOtherIndecies.equalsIgnoreCase("ALL")) {
                        sOtherIndecies = "";
                        indiciesForAllVars = true;
                    }
                    while (valuesIds.hasNext()) {
                        String VarId = (String)valuesIds.next();
                        if (VarId == null) continue;
                        activeProcVar.add(VarId);
                        if (!indiciesForAllVars) continue;
                        if (sOtherIndecies.equalsIgnoreCase("")) {
                            sOtherIndecies = VarId;
                            continue;
                        }
                        sOtherIndecies = sOtherIndecies + "," + VarId;
                    }
                    Map<String, Map<String, String>> confMap = this.prepareConfigurationMap(wp, sProcessDefId, mAllProcVar);
                    String[] namesForOtherIndecies = null;
                    if (!sOtherIndecies.equalsIgnoreCase("NULL")) {
                        log.debug((Object)("Sprawdzanie wystepowania dodatkowych indeksow w klasie dokumentow " + sClassName));
                        String[] otherIndeciesTable = sOtherIndecies.split(",");
                        String[] temp = this.sortOtherIndiciesTable(otherIndeciesTable);
                        if (temp.length == otherIndeciesTable.length) {
                            otherIndeciesTable = temp;
                        }
                        namesForOtherIndecies = new String[otherIndeciesTable.length];
                        int counterForOtherIndecies = 0;
                        howManyIndicies += otherIndeciesTable.length;
                        for (String oneOtherIndex : otherIndeciesTable) {
                            Object oOtherIndexName = mAllProcVar.get(oneOtherIndex);
                            if (oOtherIndexName != null) {
                                oneOtherIndex = this.checkDuplicateVarViewName(mAllProcVar, oOtherIndexName.toString(), oneOtherIndex);
                            }
                            namesForOtherIndecies[counterForOtherIndecies] = oneOtherIndex;
                            Long sIndexExists = ArchiveServices.GetIndexIdForDocClass(sClassName, oneOtherIndex);
                            if (sIndexExists == null) {
                                long indexId;
                                log.debug((Object)("Dodatkowy indeks " + oneOtherIndex + " nie istnieje dla klasy dokumentow " + sClassName + ". Tworzenie indeksu"));
                                String sType = "";
                                if (confMap != null && confMap.size() > 0 && confMap.get("indeciestypes") != null && confMap.get("indeciestypes").size() > 0) {
                                    sType = confMap.get("indeciestypes").get(oneOtherIndex);
                                }
                                if (Tools.isNullOrEmpty((String)sType)) {
                                    sType = "string";
                                }
                                if ((indexId = ArchiveServices.CreateIndexForDocClass(docClassId, oneOtherIndex, oneOtherIndex, sType, "")) != -1L) {
                                    log.debug((Object)("Dodatkowy indeks o nazwie " + oneOtherIndex + " i typie " + sType + " stworzony poprawnie w klasie dokumentow " + sClassName));
                                } else {
                                    log.debug((Object)("Blad podczas dodawania dodatkowego indeksu o nazwie " + oneOtherIndex + " i typie " + sType + " w klasie dokumentow " + sClassName));
                                }
                            } else {
                                log.debug((Object)("Dodatkowy indeks " + oneOtherIndex + " istnieje dla klasy dokumentow " + sClassName));
                            }
                            ++counterForOtherIndecies;
                        }
                    } else {
                        log.debug((Object)("Parametr zadania nie definiuje dodatkowych indeksow dla klasy dokumentow " + sClassName));
                    }
                    log.debug((Object)("Wyszukiwanie procesow dla indentyfikatora definicji: " + sProcessDefId));
                    hmAdSearchVar.put("procDefId", sProcessDefId);
                    hmAdSearchVar.put("procStateSelect", "closed.completed");
                    hmAdSearchVar.put("procFinish", sFinishDate);
                    processes = processData.search(activeProcVar, activeDefVar, hmAdSearchVar, wp);
                    if (sAllClosedStates.equalsIgnoreCase("TRUE")) {
                        hmAdSearchVar.put("procStateSelect", "closed.terminated");
                        ArrayList processesTerminated = processData.search(activeProcVar, activeDefVar, hmAdSearchVar, wp);
                        if (processesTerminated != null && processesTerminated.size() > 0) {
                            if (processes == null) {
                                processes = new ArrayList();
                            }
                            for (AdvanceSearchResult oneTerminatedProcess : processesTerminated) {
                                processes.add(oneTerminatedProcess);
                            }
                        }
                        hmAdSearchVar.put("procStateSelect", "closed.aborted");
                        ArrayList processesAborted = processData.search(activeProcVar, activeDefVar, hmAdSearchVar, wp);
                        if (processesAborted != null && processesAborted.size() > 0) {
                            if (processes == null) {
                                processes = new ArrayList();
                            }
                            for (AdvanceSearchResult oneAbortedProcess : processesAborted) {
                                processes.add(oneAbortedProcess);
                            }
                        }
                    }
                    if ((processes = this.eliminateDuplicateProcesses((ArrayList<AdvanceSearchResult>)processes)) != null && processes.size() > 0) {
                        log.debug((Object)("Znaleziono " + processes.size() + " procesow dla podanych parametrow wyszukiwania oraz dla identyfikatora definicji procesu: " + sProcessDefId));
                        try {
                            st = Shark.getInstance().createTransaction();
                        }
                        catch (Throwable throwable) {
                            taskLog.debug((Object)throwable.getMessage());
                            log.error((Object)throwable.getMessage(), throwable);
                            try {
                                Shark.getInstance().emptyCaches(st);
                            }
                            catch (Exception e1) {
                                taskLog.debug((Object)e1.getMessage());
                                log.error((Object)e1.getMessage(), (Throwable)e1);
                            }
                            try {
                                st.rollback();
                            }
                            catch (Exception e2) {
                                taskLog.debug((Object)e2.getMessage());
                                log.error((Object)e2.getMessage(), (Throwable)e2);
                            }
                        }
                        try {
                            String username = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_USERNAME").replaceAll("[\"]", "");
                            String password = Shark.getInstance().getProperties().getProperty("DEFAULT_ADMINISTRATOR_PASSWORD").replaceAll("[\"]", "");
                            ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
                            ea.connect(st, username, password, "KlientTestowy", null);
                        }
                        catch (Exception e) {
                            taskLog.debug((Object)e.getMessage());
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        for (int i = 0; i < processes.size(); ++i) {
                            try {
                                log.debug((Object)("------> Analizowanie procesu numer: " + (i + 1)));
                                AdvanceSearchResult advanceSearchResult = (AdvanceSearchResult)processes.get(i);
                                if (advanceSearchResult == null) continue;
                                String processId = advanceSearchResult.getProcessId();
                                WfProcess wfprocess = SharkFunctions.getWfProcess((SharkTransaction)st, (String)processId);
                                if (wfprocess != null) {
                                    String wfprocessName = wfprocess.name(st);
                                    if (!Tools.isNullOrEmpty((String)wfprocessName)) {
                                        sProcessName = wfprocessName;
                                        hmAdSearchVar.put("procName", wfprocessName);
                                    } else {
                                        sProcessName = (String)processDefIdsAndNamesMap.get(sProcessDefId);
                                    }
                                } else {
                                    log.debug((Object)("Brak obiektu procesu dla identyfikatora procesu " + processId));
                                    changeParam = false;
                                    continue;
                                }
                                String processState = wfprocess.state(st);
                                hmAdSearchVar.put("procStateSelect", processState);
                                activities = processData.search(activeProcVar, activeDefVarForActivities, hmAdSearchVar, wp);
                                ArrayList<AdvanceSearchResult> activitiesForProcessId = this.getActivitiesForProcessId(activities, processId);
                                File file = this.preparePdf(st, confMap, mAllProcVar, filesPath, sClassName, sProcessName, advanceSearchResult, activitiesForProcessId, sPDFIds, sPDFVariables, sPDFHistory, sPDFDocuments, sPDFComments, sLanguage);
                                if (file != null && !file.getName().equalsIgnoreCase("ERROR")) {
                                    int result;
                                    log.debug((Object)"Plik PDF stworzony");
                                    String sDescription = sProcessName + " id: " + processId;
                                    String processStartTime = this.getValueFromAdvancedSearchResult(advanceSearchResult, "procStart", "name");
                                    String[] processStartTimeSplit = processStartTime.split(" ");
                                    String processEndTime = this.getValueFromAdvancedSearchResult(advanceSearchResult, "procFinish", "name");
                                    String[] processEndTimeSplit = processEndTime.split(" ");
                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    String whenArchived = sdf.format(new Date(startTime));
                                    String processInitiatorId = this.getValueFromAdvancedSearchResult(advanceSearchResult, "procInitiator", "name");
                                    String processInitiatorName = this.getRealNameForUserId(processInitiatorId);
                                    String[] asIndicies = new String[howManyIndicies];
                                    asIndicies[0] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[0]) + "=" + processId;
                                    asIndicies[1] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[1]) + "=" + sProcessName;
                                    asIndicies[2] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[2]) + "=" + processStartTimeSplit[0];
                                    asIndicies[3] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[3]) + "=" + processStartTimeSplit[1];
                                    asIndicies[4] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[4]) + "=" + processEndTimeSplit[0];
                                    asIndicies[5] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[5]) + "=" + processEndTimeSplit[1];
                                    asIndicies[6] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[6]) + "=" + whenArchived;
                                    asIndicies[7] = ArchiveServices.GetIndexIdForDocClass(sClassName, mandatoryIndecies[7]) + "=" + processInitiatorName;
                                    if (!sOtherIndecies.equalsIgnoreCase("NULL")) {
                                        Map<String, Object> processContextMap = SharkClientFunctions.getProcessContextMap(st, processId);
                                        String[] otherIndeciesTable = sOtherIndecies.split(",");
                                        String[] temp = this.sortOtherIndiciesTable(otherIndeciesTable);
                                        if (temp.length == otherIndeciesTable.length) {
                                            otherIndeciesTable = temp;
                                        }
                                        for (int z = 8; z < otherIndeciesTable.length + 8; ++z) {
                                            Long id = ArchiveServices.GetIndexIdForDocClass(sClassName, namesForOtherIndecies[z - 8]);
                                            String value = "";
                                            Object oValue = processContextMap.get(otherIndeciesTable[z - 8]);
                                            if (oValue != null) {
                                                value = oValue.toString();
                                            }
                                            asIndicies[z] = id + "=" + value;
                                        }
                                    }
                                    if ((result = ArchiveServices.AddFileToArchive(sClassName, asIndicies, file, sDescription, "TRUE", sLogin)) > 0) {
                                        log.debug((Object)("Plik PDF poprawnie zapisany w archiwum w klasie dokumentow " + sClassName + " z identyfikatorem pliku " + String.valueOf(result)));
                                        file.delete();
                                        if (!sDeleteProcess.equalsIgnoreCase("TRUE")) continue;
                                        if (st != null && ea != null) {
                                            try {
                                                ea.deleteClosedProcess(st, processId);
                                                log.debug((Object)("Proces o identyfikatorze " + processId + " usuniety"));
                                            }
                                            catch (Exception e) {
                                                taskLog.debug((Object)("Proces o identyfikatorze " + processId + " nie zostal usuniety. Wystapil blad usuwania"));
                                                log.debug((Object)("Proces o identyfikatorze " + processId + " nie zostal usuniety. Wystapil blad usuwania"));
                                                log.error((Object)e.getMessage(), (Throwable)e);
                                            }
                                            continue;
                                        }
                                        log.debug((Object)("Proces o identyfikatorze " + processId + " nie zostanie usuniety. Brak uprawnien administratorskich"));
                                        continue;
                                    }
                                    log.debug((Object)"Blad podczas zapisywania pliku PDF do archiwum");
                                    changeParam = false;
                                    continue;
                                }
                                if (file != null && file.getName().equalsIgnoreCase("ERROR")) {
                                    log.debug((Object)"Blad podczas archiwizowania procesu. Plik PDF nie zostal stworzony");
                                    changeParam = false;
                                    continue;
                                }
                                log.debug((Object)"Plik PDF nie zostal stworzony");
                                continue;
                            }
                            catch (Exception e) {
                                taskLog.debug((Object)e.getMessage());
                                log.error((Object)e.getMessage(), (Throwable)e);
                                changeParam = false;
                            }
                        }
                        this.progress = 0.2;
                        try {
                            st.commit();
                        }
                        catch (Throwable throwable) {
                            taskLog.debug((Object)throwable.getMessage());
                            log.error((Object)throwable.getMessage(), throwable);
                            try {
                                Shark.getInstance().emptyCaches(st);
                            }
                            catch (Exception e1) {
                                taskLog.debug((Object)e1.getMessage());
                                log.error((Object)e1.getMessage(), (Throwable)e1);
                            }
                            try {
                                st.rollback();
                            }
                            catch (Exception e2) {
                                taskLog.debug((Object)e2.getMessage());
                                log.error((Object)e2.getMessage(), (Throwable)e2);
                            }
                        }
                    } else {
                        taskLog.debug((Object)("Brak procesow dla podanych parametrow wyszukiwania dla identyfikatora definicji procesu: " + sProcessDefId));
                        log.debug((Object)("Brak procesow dla podanych parametrow wyszukiwania dla identyfikatora definicji procesu: " + sProcessDefId));
                    }
                }
                if (!changeParam) break block118;
                try {
                    List ListOfScheduledTasksTable = ScheduledTasksMethods.getAllScheduledTasks();
                    ArchiveProcesses object = new ArchiveProcesses();
                    String thisFunctionName = "";
                    StackTraceElement[] e = Thread.currentThread().getStackTrace();
                    if (e != null && e.length > 1) {
                        thisFunctionName = e[1].getMethodName();
                    }
                    String thisPackageName = ((Object)((Object)object)).getClass().getPackage().getName();
                    String thisClassName = ((Object)((Object)object)).getClass().getName();
                    if (thisClassName.lastIndexOf(46) > 0) {
                        thisClassName = thisClassName.substring(thisClassName.lastIndexOf(46) + 1);
                    }
                    String thisTask = thisPackageName + "." + thisClassName + "." + thisFunctionName;
                    if (ListOfScheduledTasksTable == null) break block118;
                    for (ScheduledTasksTable scheduledTasksTable : ListOfScheduledTasksTable) {
                        if (scheduledTasksTable == null) continue;
                        String className = scheduledTasksTable.getClass_name();
                        String methodName = scheduledTasksTable.getMethod_name();
                        String task = className + "." + methodName;
                        boolean processing = scheduledTasksTable.getIs_processing();
                        if (!processing || !thisTask.equalsIgnoreCase(task)) continue;
                        long taskId = scheduledTasksTable.getId();
                        List<ScheduledTasksParametersTable> ListOfParams = this.getListOfParams(taskId);
                        if (ListOfParams != null) {
                            for (ScheduledTasksParametersTable scheduledTasksParametersTable : ListOfParams) {
                                if (scheduledTasksParametersTable == null) continue;
                                int pos = scheduledTasksParametersTable.getParameter_position();
                                String value = scheduledTasksParametersTable.getParameter_value();
                                if (value == null || !value.equalsIgnoreCase(lastValueOfParam) || pos != 6) continue;
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                String oneParamValue = sdf.format(new Date(startTime));
                                scheduledTasksParametersTable.setParameter_value(oneParamValue);
                                ScheduledTasksMethods.changeScheduledTaskParameter((ScheduledTasksParametersTable)scheduledTasksParametersTable);
                                log.debug((Object)("Zmieniono parametr wykonywania zadania zaplanowanego RunArchiver. Parametr od kiedy szukac zakonczone procesy zmieniony na czas rozpoczecia wykonywania zadania: " + oneParamValue));
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    taskLog.debug((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (CUFException e) {
                taskLog.debug((Object)e.getMessage());
                log.error((Object)e.getMessage());
            }
            catch (Exception e) {
                taskLog.debug((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (st != null && ea != null) {
                        ea.disconnect(st);
                    }
                }
                catch (Exception e1) {
                    taskLog.debug((Object)e1.getMessage());
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                try {
                    if (st != null) {
                        SharkFunctions.ClearSharkTransaction(st);
                    }
                }
                catch (Exception e2) {
                    taskLog.debug((Object)e2.getMessage());
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        long stopTime = new Date().getTime();
        log.debug((Object)("Czas wykonywania zadania zaplanowanego RunArchiver: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private List<ScheduledTasksParametersTable> getListOfParams(long id) {
        log.trace((Object)("************ getListOfParams(id=" + String.valueOf(id) + ") ************"));
        List result = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            result = session.createQuery("from ScheduledTasksParametersTable where scheduled_task_id=:ident").setParameter("ident", (Object)id).list();
            transaction.commit();
            List list = result;
            return list;
        }
        catch (HibernateException e) {
            taskLog.debug((Object)e.getMessage());
            throw e;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private File preparePdf(SharkTransaction st, Map<String, Map<String, String>> confMap, Map<String, Object> mAllProcVar, String filesPath, String sClassName, String sProcessName, AdvanceSearchResult advanceSearchResult, ArrayList<AdvanceSearchResult> activitiesForProcessId, String sPDFIds, String sPDFVariables, String sPDFHistory, String sPDFDocuments, String sPDFComments, String sLanguage) {
        log.trace((Object)("************ preparePdf(SharkTransaction, Map<String, Map<String, String>>, Map<String, Object>, filesPath=" + filesPath + ", sClassName=" + sClassName + ", sProcessName=" + sProcessName + ", AdvanceSearchResult, ArrayList<AdvanceSearchResult>, sPDFIds=" + sPDFIds + ", sPDFVariables=" + sPDFVariables + ", sPDFHistory=" + sPDFHistory + ", sPDFDocuments=" + sPDFDocuments + ", sPDFComments=" + sPDFComments + ", sLanguage=" + sLanguage + " ************"));
        File file = null;
        DBManagement dbm = new DBManagement();
        int chapterNr = 1;
        try {
            String sProcessId;
            if (advanceSearchResult != null && !Tools.isNullOrEmpty((String)(sProcessId = advanceSearchResult.getProcessId()))) {
                Map<String, Object> processContextMap = SharkClientFunctions.getProcessContextMap(st, sProcessId);
                String[] indexes = new String[]{"processId=" + sProcessId};
                String foundFileId = ArchiveServices.CheckIfDocumentExists(sClassName, indexes);
                if (foundFileId.equalsIgnoreCase("-1")) {
                    float[] widths;
                    int nrOfCells;
                    log.debug((Object)("Proces o identyfikatorze " + sProcessId + " nie zostal jeszcze zarchiwizowany"));
                    String[] mainLabelsForProcess = new String[]{"procDefId", "procDescr", "procInitiator", "procStateSelect", "procStart", "procFinish", "processType"};
                    String[] mainLabelsValuesForProcess = this.prepareValuesTableForMainLabels(advanceSearchResult, mainLabelsForProcess);
                    mainLabelsValuesForProcess[3] = CUFTools.getStatusNameForLanguage(mainLabelsValuesForProcess[3], sLanguage, true);
                    Document document = new Document(PageSize.A4, 50.0f, 50.0f, 50.0f, 50.0f);
                    Font font = null;
                    BaseFont baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1250", (boolean)true);
                    Paragraph paragraph = null;
                    Phrase phrase = null;
                    Table table = null;
                    Cell cell = null;
                    PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filesPath + "\\" + sProcessId + ".pdf"));
                    document.open();
                    document.addAuthor("admin");
                    document.addTitle(this.getMessageForLanguage("Informacje o procesie", sLanguage) + " " + sProcessName + this.getMessageForLanguage("", sLanguage));
                    document.addCreationDate();
                    font = new Font(baseFont, 20.0f, 1, new Color(0, 0, 153));
                    paragraph = new Paragraph(this.getMessageForLanguage("Informacje o procesie", sLanguage) + " " + sProcessName + this.getMessageForLanguage("", sLanguage), font);
                    paragraph.setAlignment(1);
                    paragraph.setSpacingAfter(30.0f);
                    document.add((Element)paragraph);
                    font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                    paragraph = new Paragraph(chapterNr + ". " + this.getMessageForLanguage("Dane og\u00f3lne procesu", sLanguage), font);
                    ++chapterNr;
                    paragraph.setSpacingAfter(12.0f);
                    document.add((Element)paragraph);
                    paragraph = new Paragraph();
                    paragraph.setAlignment(3);
                    if (sPDFIds.equalsIgnoreCase("TRUE")) {
                        font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                        phrase = new Phrase(this.getMessageForLanguage("Identyfikator definicji procesu", sLanguage) + ": ", font);
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(mainLabelsValuesForProcess[0] + "\n", font);
                        paragraph.add((Object)phrase);
                    }
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(this.getMessageForLanguage("Typ procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[6] + "\n", font);
                    paragraph.add((Object)phrase);
                    if (sPDFIds.equalsIgnoreCase("TRUE")) {
                        font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                        phrase = new Phrase(this.getMessageForLanguage("Identyfikator procesu", sLanguage) + ": ", font);
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(sProcessId + "\n", font);
                        paragraph.add((Object)phrase);
                    }
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(this.getMessageForLanguage("Nazwa procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(sProcessName + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(this.getMessageForLanguage("Opis procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[1] + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(this.getMessageForLanguage("Inicjator procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[2] + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(this.getMessageForLanguage("Status procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[3] + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(this.getMessageForLanguage("Data rozpocz\u0119cia procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[4] + "\n", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 1, new Color(0, 0, 0));
                    phrase = new Phrase(this.getMessageForLanguage("Data zako\u0144czenia procesu", sLanguage) + ": ", font);
                    paragraph.add((Object)phrase);
                    font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                    phrase = new Phrase(mainLabelsValuesForProcess[5] + "\n", font);
                    paragraph.add((Object)phrase);
                    document.add((Element)paragraph);
                    if (sPDFVariables.equalsIgnoreCase("TRUE")) {
                        document.newPage();
                        font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                        paragraph = new Paragraph(chapterNr + ". " + this.getMessageForLanguage("Tabele zmiennych procesu", sLanguage), font);
                        ++chapterNr;
                        paragraph.setSpacingAfter(2.0f);
                        document.add((Element)paragraph);
                        if (confMap != null && confMap.get("variabletoprocess") != null && confMap.get("variabletoprocess").size() > 0 && confMap.get("variableset1") != null && confMap.get("variableset1").size() > 0) {
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            paragraph = new Paragraph(this.getMessageForLanguage("Zmienne nietabelaryczne", sLanguage), font);
                            paragraph.setSpacingAfter(8.0f);
                            document.add((Element)paragraph);
                            font = new Font(baseFont, 14.0f, 1, new Color(255, 255, 255));
                            nrOfCells = 0;
                            nrOfCells = sPDFIds.equalsIgnoreCase("TRUE") ? 3 : 2;
                            table = new Table(nrOfCells);
                            table.setBorderWidth(1.0f);
                            table.setWidth(100.0f);
                            table.setBorderColor(new Color(0, 0, 0));
                            table.setAlignment(1);
                            table.setPadding(4.0f);
                            table.setCellsFitPage(true);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Nazwa zmiennej procesu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Identyfikator zmiennej procesu", sLanguage), font));
                                cell.setHeader(true);
                                cell.setHorizontalAlignment(1);
                                cell.setVerticalAlignment(5);
                                cell.setBackgroundColor(new Color(0, 0, 153));
                                table.addCell(cell);
                            }
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Warto\u015b\u0107 zmiennej procesu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            table.endHeaders();
                            font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                            Map<String, String> variablesToProcessMap = confMap.get("variabletoprocess");
                            int counterForVariableToProcess = 1;
                            String sVariableToProcessId = null;
                            if (variablesToProcessMap != null && variablesToProcessMap.size() > 0) {
                                sVariableToProcessId = variablesToProcessMap.get(String.valueOf(counterForVariableToProcess));
                            } else {
                                cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Brak zmiennych poza tabelami dynamicznymi", sLanguage), font));
                                cell.setHorizontalAlignment(1);
                                cell.setColspan(nrOfCells);
                                table.addCell(cell);
                            }
                            while (sVariableToProcessId != null) {
                                String sVariableName = "";
                                Object oVariableName = mAllProcVar.get(sVariableToProcessId);
                                String sVariableValue = "";
                                Object object = processContextMap.get(sVariableToProcessId);
                                if (oVariableName != null) {
                                    sVariableName = oVariableName.toString();
                                }
                                if (object != null) {
                                    sVariableValue = object.toString();
                                }
                                if (!Tools.isNullOrEmpty((String)sVariableName)) {
                                    cell = new Cell((Element)new Phrase(sVariableName, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                    if (!Tools.isNullOrEmpty((String)sVariableToProcessId)) {
                                        cell = new Cell((Element)new Phrase(sVariableToProcessId, font));
                                        cell.setHorizontalAlignment(0);
                                        table.addCell(cell);
                                    } else {
                                        cell = new Cell((Element)new Phrase("N/A", font));
                                        cell.setHorizontalAlignment(0);
                                        table.addCell(cell);
                                    }
                                }
                                if (sVariableValue == null) {
                                    sVariableValue = "";
                                }
                                cell = new Cell((Element)new Phrase(sVariableValue, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                sVariableToProcessId = variablesToProcessMap.get(String.valueOf(++counterForVariableToProcess));
                            }
                            document.add((Element)table);
                            int dynamicTableCounter = 1;
                            Map<String, String> dynamicTableMap = confMap.get("variableset" + String.valueOf(dynamicTableCounter));
                            if (dynamicTableMap != null && dynamicTableMap.size() > 0) {
                                document.newPage();
                                font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                                paragraph = new Paragraph(this.getMessageForLanguage("Tabele dynamiczne", sLanguage), font);
                                paragraph.setSpacingAfter(2.0f);
                                document.add((Element)paragraph);
                                while (dynamicTableMap != null && dynamicTableMap.size() > 0) {
                                    void var39_64;
                                    void var39_61;
                                    document.add((Element)new Phrase("\n"));
                                    font = new Font(baseFont, 12.0f, 1, new Color(255, 255, 255));
                                    table = new Table(dynamicTableMap.size());
                                    table.setBorderWidth(1.0f);
                                    table.setWidth(100.0f);
                                    table.setBorderColor(new Color(0, 0, 0));
                                    table.setAlignment(1);
                                    table.setPadding(4.0f);
                                    table.setCellsFitPage(true);
                                    int varInTableOrder = 1;
                                    String string = dynamicTableMap.get(String.valueOf(varInTableOrder));
                                    while (var39_61 != null) {
                                        Object sVariableName = "";
                                        Object oVariableName = mAllProcVar.get(var39_61);
                                        if (oVariableName != null) {
                                            sVariableName = oVariableName.toString();
                                        }
                                        if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                            sVariableName = sVariableName.equalsIgnoreCase("") ? var39_61 : sVariableName + " (" + (String)var39_61 + ")";
                                        }
                                        cell = new Cell((Element)new Phrase(sVariableName, font));
                                        cell.setHeader(true);
                                        cell.setHorizontalAlignment(1);
                                        cell.setVerticalAlignment(5);
                                        cell.setBackgroundColor(new Color(0, 0, 153));
                                        table.addCell(cell);
                                        String string2 = dynamicTableMap.get(String.valueOf(++varInTableOrder));
                                    }
                                    table.endHeaders();
                                    varInTableOrder = 1;
                                    String string3 = dynamicTableMap.get(String.valueOf(varInTableOrder));
                                    int columnNr = 0;
                                    while (var39_64 != null) {
                                        int rowNr = 1;
                                        String sVariableValue = "";
                                        Object oVariableValue = processContextMap.get(var39_64);
                                        if (oVariableValue != null) {
                                            sVariableValue = oVariableValue.toString();
                                        }
                                        String[] variableValuesTable = sVariableValue.split(";", -1);
                                        if (varInTableOrder == 1 && variableValuesTable.length == 1 && variableValuesTable[0].equalsIgnoreCase("")) {
                                            boolean emptyTable = true;
                                            ++varInTableOrder;
                                            String sVariableIdTest = var39_64;
                                            while (sVariableIdTest != null) {
                                                String sVariableValueTest = "";
                                                Object oVariableValueTest = processContextMap.get(sVariableIdTest);
                                                if (oVariableValueTest != null) {
                                                    sVariableValueTest = oVariableValueTest.toString();
                                                }
                                                if (!sVariableValueTest.equalsIgnoreCase("")) {
                                                    emptyTable = false;
                                                    break;
                                                }
                                                sVariableIdTest = dynamicTableMap.get(String.valueOf(++varInTableOrder));
                                            }
                                            varInTableOrder = 1;
                                            if (emptyTable) {
                                                font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                                                cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Pusta tabela", sLanguage), font));
                                                cell.setHorizontalAlignment(1);
                                                cell.setColspan(dynamicTableMap.size());
                                                table.addCell(cell);
                                                break;
                                            }
                                        } else {
                                            font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                                            for (String oneVar : variableValuesTable) {
                                                cell = new Cell((Element)new Phrase(oneVar, font));
                                                cell.setHorizontalAlignment(0);
                                                table.addCell(cell, rowNr, columnNr);
                                                ++rowNr;
                                            }
                                        }
                                        ++columnNr;
                                        String string4 = dynamicTableMap.get(String.valueOf(++varInTableOrder));
                                    }
                                    document.add((Element)table);
                                    dynamicTableMap = confMap.get("variableset" + String.valueOf(++dynamicTableCounter));
                                }
                            }
                        } else {
                            paragraph.add((Object)"\n");
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            phrase = new Phrase(this.getMessageForLanguage("Brak zmiennych procesu", sLanguage), font);
                            document.add((Element)phrase);
                        }
                    }
                    this.progress = 0.5;
                    if (sPDFHistory.equalsIgnoreCase("TRUE")) {
                        document.newPage();
                        paragraph = new Paragraph();
                        font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                        phrase = new Phrase(chapterNr + ". " + this.getMessageForLanguage("Historia procesu", sLanguage) + "\n", font);
                        ++chapterNr;
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(this.getMessageForLanguage("Historia procesu zawiera poszczeg\u00f3lne zadania posortowane wed\u0142ug dat rozpocz\u0119cia zadania", sLanguage) + ":\n", font);
                        paragraph.add((Object)phrase);
                        paragraph.add((Object)"\n");
                        paragraph.setKeepTogether(true);
                        paragraph.setAlignment(3);
                        if (activitiesForProcessId != null && activitiesForProcessId.size() > 0) {
                            float[] help;
                            document.add((Element)paragraph);
                            font = new Font(baseFont, 13.0f, 1, new Color(255, 255, 255));
                            nrOfCells = 0;
                            widths = null;
                            if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                nrOfCells = 7;
                                help = new float[]{5.0f, 17.0f, 16.0f, 17.0f, 12.0f, 16.0f, 17.0f};
                                widths = help;
                            } else {
                                nrOfCells = 6;
                                help = new float[]{5.0f, 19.0f, 19.0f, 19.0f, 19.0f, 19.0f};
                                widths = help;
                            }
                            table = new Table(nrOfCells);
                            table.setBorderWidth(1.0f);
                            table.setWidth(100.0f);
                            table.setBorderColor(new Color(0, 0, 0));
                            table.setAlignment(1);
                            table.setPadding(4.0f);
                            table.setCellsFitPage(true);
                            table.setWidths(widths);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Nr", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Identyfikator zadania", sLanguage), font));
                                cell.setHeader(true);
                                cell.setHorizontalAlignment(1);
                                cell.setVerticalAlignment(5);
                                cell.setBackgroundColor(new Color(0, 0, 153));
                                table.addCell(cell);
                            }
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Nazwa zadania", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Status", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Inicjator", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Data rozpocz\u0119cia zadania", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Data zako\u0144czenia zadania", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            table.endHeaders();
                            font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                            String[] mainLabelsForActivity = new String[]{"taskName", "taskStateSelect", "taskUser", "taskStart", "taskFinish"};
                            String[] mainLabelsValuesForActivity = new String[mainLabelsForActivity.length];
                            ArrayList<Object> sortedActivitiesForProcessId = this.sortActivities(activitiesForProcessId, "taskStart");
                            if (sortedActivitiesForProcessId == null || sortedActivitiesForProcessId.size() < activitiesForProcessId.size()) {
                                sortedActivitiesForProcessId = new ArrayList();
                                sortedActivitiesForProcessId = activitiesForProcessId;
                            }
                            int nrOfActivity = 0;
                            for (AdvanceSearchResult advanceSearchResult2 : sortedActivitiesForProcessId) {
                                if (advanceSearchResult2 == null) continue;
                                mainLabelsValuesForActivity = this.prepareValuesTableForMainLabels(advanceSearchResult2, mainLabelsForActivity);
                                String activityId = advanceSearchResult2.getActivityId();
                                if (activityId == null) {
                                    activityId = "";
                                }
                                cell = new Cell((Element)new Phrase(String.valueOf(++nrOfActivity), font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                if (sPDFIds.equalsIgnoreCase("TRUE")) {
                                    cell = new Cell((Element)new Phrase(activityId, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (!Tools.isNullOrEmpty((String)mainLabelsValuesForActivity[0])) {
                                    cell = new Cell((Element)new Phrase(mainLabelsValuesForActivity[0], font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                mainLabelsValuesForActivity[1] = CUFTools.getStatusNameForLanguage(mainLabelsValuesForActivity[1], sLanguage, false);
                                if (!Tools.isNullOrEmpty((String)mainLabelsValuesForActivity[1])) {
                                    cell = new Cell((Element)new Phrase(mainLabelsValuesForActivity[1], font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (!Tools.isNullOrEmpty((String)mainLabelsValuesForActivity[2])) {
                                    String userName = this.getRealNameForUserId(mainLabelsValuesForActivity[2]);
                                    cell = new Cell((Element)new Phrase(userName, font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else if (mainLabelsValuesForActivity[2] != null && mainLabelsValuesForActivity[2].equalsIgnoreCase("")) {
                                    cell = new Cell((Element)new Phrase("System", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (!Tools.isNullOrEmpty((String)mainLabelsValuesForActivity[3])) {
                                    cell = new Cell((Element)new Phrase(mainLabelsValuesForActivity[3], font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                } else {
                                    cell = new Cell((Element)new Phrase("N/A", font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                }
                                if (!Tools.isNullOrEmpty((String)mainLabelsValuesForActivity[4])) {
                                    cell = new Cell((Element)new Phrase(mainLabelsValuesForActivity[4], font));
                                    cell.setHorizontalAlignment(0);
                                    table.addCell(cell);
                                    continue;
                                }
                                cell = new Cell((Element)new Phrase("N/A", font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                            }
                            document.add((Element)table);
                        } else {
                            paragraph.add((Object)"\n");
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            phrase = new Phrase(this.getMessageForLanguage("Brak zada\u0144 w procesie", sLanguage), font);
                            paragraph.add((Object)phrase);
                            document.add((Element)paragraph);
                        }
                    }
                    if (sPDFDocuments.equalsIgnoreCase("TRUE")) {
                        document.newPage();
                        paragraph = new Paragraph();
                        font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                        phrase = new Phrase(chapterNr + ". " + this.getMessageForLanguage("Dokumenty procesu", sLanguage) + "\n", font);
                        ++chapterNr;
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(this.getMessageForLanguage("Dokumenty podpi\u0119te do procesu", sLanguage) + " " + sProcessName + this.getMessageForLanguage("", sLanguage) + ":", font);
                        paragraph.add((Object)phrase);
                        paragraph.add((Object)"\n");
                        paragraph.setKeepTogether(true);
                        String DocIds = "";
                        Object oDocIds = processContextMap.get("DocIds");
                        if (oDocIds != null) {
                            DocIds = oDocIds.toString();
                        }
                        if (!Tools.isNullOrEmpty((String)DocIds)) {
                            String[] docIdsTable;
                            document.add((Element)paragraph);
                            font = new Font(baseFont, 14.0f, 1, new Color(255, 255, 255));
                            float[] widths2 = new float[]{17.0f, 18.0f, 17.0f, 17.0f, 14.0f, 17.0f};
                            table = new Table(6);
                            table.setBorderWidth(1.0f);
                            table.setWidth(100.0f);
                            table.setBorderColor(new Color(0, 0, 0));
                            table.setAlignment(1);
                            table.setPadding(4.0f);
                            table.setCellsFitPage(true);
                            table.setWidths(widths2);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Nazwa dokumentu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Nazwa klasy dokument\u00f3w", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Opis dokumentu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Data dodania dokumentu", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Rozmiar (bajty)", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("W\u0142a\u015bciciel", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            table.endHeaders();
                            for (String string : docIdsTable = DocIds.split(",")) {
                                FilesManager fm;
                                Files fileForDoc;
                                DocClassTable oneClass;
                                if (Tools.isNullOrEmpty((String)string)) continue;
                                String fileIdForDocId = "";
                                String classNameForDoc = "";
                                ArrayList docClassesList = dbm.GetAllDocClasses();
                                Iterator i$ = docClassesList.iterator();
                                while (i$.hasNext() && ((oneClass = (DocClassTable)i$.next()) == null || (classNameForDoc = oneClass.getDocClassName()) == null || Tools.isNullOrEmpty((String)(fileIdForDocId = ArchiveServices.GetNewestVersionDocFileId(classNameForDoc, string))))) {
                                }
                                if (Tools.isNullOrEmpty((String)fileIdForDocId) || (fileForDoc = (fm = new FilesManager()).GetFile(Long.valueOf(fileIdForDocId))) == null) continue;
                                String sFileDate = "";
                                String sFileSize = "";
                                String sFileName = fileForDoc.getOrg_name();
                                String sFileClass = classNameForDoc;
                                String sFileDesc = fileForDoc.getDescription();
                                Date fileDate = fileForDoc.getDate();
                                Long fileSize = fileForDoc.getSize();
                                String sFileUploader = fileForDoc.getUploader();
                                if (sFileName == null) {
                                    sFileName = "";
                                }
                                if (sFileClass == null) {
                                    sFileClass = "";
                                }
                                if (sFileDesc == null) {
                                    sFileDesc = "";
                                }
                                if (fileDate != null) {
                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    sFileDate = sdf.format(fileDate);
                                }
                                if (fileSize != null) {
                                    sFileSize = fileSize.toString();
                                }
                                if (sFileUploader == null) {
                                    sFileUploader = "";
                                }
                                sFileUploader = this.getRealNameForUserId(sFileUploader);
                                font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                                cell = new Cell((Element)new Phrase(sFileName, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileClass, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileDesc, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileDate, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileSize, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(sFileUploader, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                            }
                            document.add((Element)table);
                        } else {
                            paragraph.add((Object)"\n");
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            phrase = new Phrase(this.getMessageForLanguage("Brak dokument\u00f3w do\u0142\u0105czonych do procesu", sLanguage), font);
                            paragraph.add((Object)phrase);
                            document.add((Element)paragraph);
                        }
                    }
                    this.progress = 0.8;
                    if (sPDFComments.equalsIgnoreCase("TRUE")) {
                        document.newPage();
                        paragraph = new Paragraph();
                        font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 153));
                        phrase = new Phrase(chapterNr + ". " + this.getMessageForLanguage("Komentarze", sLanguage) + "\n", font);
                        ++chapterNr;
                        paragraph.add((Object)phrase);
                        font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                        phrase = new Phrase(this.getMessageForLanguage("Komentarze wy\u015bwietlone w odwrotnej kolejno\u015bci dodawania", sLanguage), font);
                        paragraph.add((Object)phrase);
                        paragraph.add((Object)"\n");
                        paragraph.setKeepTogether(true);
                        ArrayList commentsList = dbm.GetAllCommentsForProcess(sProcessId);
                        if (commentsList != null && commentsList.size() > 0) {
                            document.add((Element)paragraph);
                            font = new Font(baseFont, 14.0f, 1, new Color(255, 255, 255));
                            widths = new float[]{25.0f, 15.0f, 60.0f};
                            table = new Table(3);
                            table.setBorderWidth(1.0f);
                            table.setWidth(100.0f);
                            table.setBorderColor(new Color(0, 0, 0));
                            table.setAlignment(1);
                            table.setPadding(4.0f);
                            table.setCellsFitPage(true);
                            table.setWidths(widths);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("U\u017cytkownik", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Data", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            cell = new Cell((Element)new Phrase(this.getMessageForLanguage("Komentarz", sLanguage), font));
                            cell.setHeader(true);
                            cell.setHorizontalAlignment(1);
                            cell.setVerticalAlignment(5);
                            cell.setBackgroundColor(new Color(0, 0, 153));
                            table.addCell(cell);
                            table.endHeaders();
                            font = new Font(baseFont, 12.0f, 0, new Color(0, 0, 0));
                            ArrayList sortedCommentsList = this.sortComments(commentsList);
                            if (sortedCommentsList == null || sortedCommentsList.size() < commentsList.size()) {
                                sortedCommentsList = new ArrayList();
                                sortedCommentsList = commentsList;
                            }
                            for (CommentsTable oneCommentsTable : sortedCommentsList) {
                                Long time = oneCommentsTable.getTimestamp();
                                String userId = oneCommentsTable.getUserId();
                                String string = oneCommentsTable.getComment();
                                if (time == null || userId == null || string == null) continue;
                                String userName = this.getRealNameForUserId(userId);
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                Date d = new Date(time);
                                String date = sdf.format(d);
                                cell = new Cell((Element)new Phrase(userName, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(date, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                                cell = new Cell((Element)new Phrase(string, font));
                                cell.setHorizontalAlignment(0);
                                table.addCell(cell);
                            }
                            document.add((Element)table);
                        } else {
                            paragraph.add((Object)"\n");
                            font = new Font(baseFont, 14.0f, 1, new Color(0, 0, 0));
                            phrase = new Phrase(this.getMessageForLanguage("Brak komentarzy w procesie", sLanguage), font);
                            paragraph.add((Object)phrase);
                            document.add((Element)paragraph);
                        }
                    }
                    document.close();
                    file = new File(filesPath + "\\" + sProcessId + ".pdf");
                } else {
                    log.debug((Object)("Proces o identyfikatorze " + sProcessId + " zostal juz zarchiwizowany"));
                }
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            file = new File("ERROR");
        }
        this.progress = 1.0;
        return file;
    }

    private ArrayList<AdvanceSearchResult> eliminateDuplicateProcesses(ArrayList<AdvanceSearchResult> processes) {
        log.trace((Object)"************ eliminateDuplicateProcesses(ArrayList<AdvanceSearchResult>) ************");
        ArrayList<AdvanceSearchResult> newProcesses = null;
        try {
            if (processes != null && processes.size() > 0) {
                newProcesses = new ArrayList<AdvanceSearchResult>();
                for (AdvanceSearchResult asr : processes) {
                    if (asr == null) continue;
                    boolean bAdd = true;
                    if (newProcesses.size() == 0) {
                        newProcesses.add(asr);
                        continue;
                    }
                    String asrProcessId = asr.getProcessId();
                    for (AdvanceSearchResult newASR : newProcesses) {
                        if (newASR == null) continue;
                        String newASRProcessId = newASR.getProcessId();
                        if (Tools.isNullOrEmpty((String)asrProcessId) || Tools.isNullOrEmpty((String)newASRProcessId) || !asrProcessId.equalsIgnoreCase(newASRProcessId)) continue;
                        bAdd = false;
                        break;
                    }
                    if (!bAdd) continue;
                    newProcesses.add(asr);
                }
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return newProcesses;
    }

    private ArrayList<AdvanceSearchResult> sortActivities(ArrayList<AdvanceSearchResult> activitiesForProcessId, String label) {
        log.trace((Object)("************ sortActivities(ArrayList<AdvanceSearchResult>, label=" + label + ") ************"));
        ArrayList<AdvanceSearchResult> sortedActivitiesForProcessId = new ArrayList<AdvanceSearchResult>();
        try {
            if (activitiesForProcessId != null && activitiesForProcessId.size() > 0) {
                block2: for (AdvanceSearchResult advanceSearchResult : activitiesForProcessId) {
                    if (advanceSearchResult == null) continue;
                    if (sortedActivitiesForProcessId.size() == 0) {
                        sortedActivitiesForProcessId.add(advanceSearchResult);
                        continue;
                    }
                    for (int counter = 0; sortedActivitiesForProcessId.size() >= counter; ++counter) {
                        int intNewActivityId;
                        int intOldActivityId;
                        String thisLabel;
                        if (counter == sortedActivitiesForProcessId.size()) {
                            sortedActivitiesForProcessId.add(advanceSearchResult);
                            continue block2;
                        }
                        ArrayList advanceVariableList = advanceSearchResult.getAlVariables();
                        ArrayList advanceVariableListFromSorted = sortedActivitiesForProcessId.get(counter).getAlVariables();
                        if (advanceVariableList == null || advanceVariableList.size() <= 0 || advanceVariableListFromSorted == null || advanceVariableListFromSorted.size() <= 0) continue;
                        String oldListValue = "";
                        String newListValue = "";
                        for (AdvanceSearchResult.AdvanceVariable oneAdvanceVariable : advanceVariableList) {
                            oldListValue = oneAdvanceVariable.getValue();
                            thisLabel = oneAdvanceVariable.getName();
                            if (thisLabel == null || !thisLabel.equalsIgnoreCase(label)) continue;
                            break;
                        }
                        for (AdvanceSearchResult.AdvanceVariable oneAdvanceVariableFromSorted : advanceVariableListFromSorted) {
                            newListValue = oneAdvanceVariableFromSorted.getValue();
                            thisLabel = oneAdvanceVariableFromSorted.getName();
                            if (thisLabel == null || !thisLabel.equalsIgnoreCase(label)) continue;
                            break;
                        }
                        if (Tools.isNullOrEmpty((String)oldListValue) || Tools.isNullOrEmpty((String)newListValue)) continue;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date oldListDate = sdf.parse(oldListValue);
                        Date newListDate = sdf.parse(newListValue);
                        if (oldListDate == null || newListDate == null || !oldListDate.before(newListDate) && !oldListDate.equals(newListDate)) continue;
                        String oldActivityId = advanceSearchResult.getActivityId();
                        String newActivityId = sortedActivitiesForProcessId.get(counter).getActivityId();
                        if (Tools.isNullOrEmpty((String)oldActivityId) || Tools.isNullOrEmpty((String)newActivityId) || (intOldActivityId = Integer.valueOf(oldActivityId.split("_")[0]).intValue()) >= (intNewActivityId = Integer.valueOf(newActivityId.split("_")[0]).intValue())) continue;
                        sortedActivitiesForProcessId.add(counter, advanceSearchResult);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sortedActivitiesForProcessId;
    }

    private String getValueFromAdvancedSearchResult(AdvanceSearchResult advanceSearchResult, String searchedLabel, String typeOfLabel) {
        log.trace((Object)("************ getValueFromAdvancedSearchResult(AdvanceSearchResult, searchedLabel=" + searchedLabel + ", typeOfLabel=" + typeOfLabel + ") ************"));
        String value = "";
        try {
            ArrayList advanceVariableList = advanceSearchResult.getAlVariables();
            for (AdvanceSearchResult.AdvanceVariable oneAdvanceVariable : advanceVariableList) {
                if (typeOfLabel.equalsIgnoreCase("viewname")) {
                    String label1 = oneAdvanceVariable.getViewname();
                    if (label1 == null || !label1.equalsIgnoreCase(searchedLabel)) continue;
                    value = oneAdvanceVariable.getValue();
                } else {
                    String label2 = oneAdvanceVariable.getName();
                    if (label2 == null || !label2.equalsIgnoreCase(searchedLabel)) continue;
                    value = oneAdvanceVariable.getValue();
                }
                break;
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return value;
    }

    private ArrayList<AdvanceSearchResult> getActivitiesForProcessId(ArrayList<AdvanceSearchResult> activities, String processId) {
        log.trace((Object)("************ getActivitiesForProcessId(ArrayList<AdvanceSearchResult>, processId=" + processId + ") ************"));
        ArrayList<AdvanceSearchResult> activitiesForProcessId = null;
        try {
            if (activities != null && activities.size() > 0 && !Tools.isNullOrEmpty((String)processId)) {
                activitiesForProcessId = new ArrayList<AdvanceSearchResult>();
                for (AdvanceSearchResult oneActivity : activities) {
                    String activityId;
                    if (oneActivity == null || Tools.isNullOrEmpty((String)(activityId = oneActivity.getActivityId())) || !activityId.contains(processId)) continue;
                    boolean addOrNot = true;
                    for (AdvanceSearchResult asr : activitiesForProcessId) {
                        String onListActivityId = asr.getActivityId();
                        if (Tools.isNullOrEmpty((String)onListActivityId) || !onListActivityId.equalsIgnoreCase(activityId)) continue;
                        addOrNot = false;
                        break;
                    }
                    if (!addOrNot) continue;
                    activitiesForProcessId.add(oneActivity);
                }
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return activitiesForProcessId;
    }

    private String[] prepareValuesTableForMainLabels(AdvanceSearchResult advanceSearchResult, String[] mainLabelsTable) {
        log.trace((Object)"************ prepareValuesTableForMainLabels(AdvanceSearchResult, String[]) ************");
        String[] mainLabelsValuesTable = null;
        try {
            if (mainLabelsTable != null && mainLabelsTable.length > 0) {
                mainLabelsValuesTable = new String[mainLabelsTable.length];
                ArrayList advanceVariableList = advanceSearchResult.getAlVariables();
                if (advanceVariableList != null && advanceVariableList.size() > 0) {
                    for (int j = 0; j < mainLabelsTable.length; ++j) {
                        boolean labelFound = false;
                        for (AdvanceSearchResult.AdvanceVariable oneAdvanceVariable : advanceVariableList) {
                            String label = oneAdvanceVariable.getName();
                            if (label == null || !mainLabelsTable[j].equalsIgnoreCase(label)) continue;
                            String valueOfLabel = oneAdvanceVariable.getValue();
                            mainLabelsValuesTable[j] = !Tools.isNullOrEmpty((String)valueOfLabel) ? valueOfLabel : "";
                            labelFound = true;
                        }
                        if (labelFound) continue;
                        mainLabelsValuesTable[j] = "N/A";
                    }
                } else {
                    for (int j = 0; j < mainLabelsTable.length; ++j) {
                        mainLabelsValuesTable[j] = "N/A";
                    }
                }
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return mainLabelsValuesTable;
    }

    private String checkDuplicateVarViewName(Map<String, Object> mAllProcVar, String oneOtherIndex, String forBrackets) {
        block5: {
            log.trace((Object)("************ checkDuplicateVarViewName(Map<String, Object>, oneOtherIndex=" + oneOtherIndex + ", forBrackets=" + forBrackets + ") ************"));
            try {
                if (mAllProcVar == null || mAllProcVar.size() <= 0) break block5;
                int howManyCopies = 0;
                for (String key : mAllProcVar.keySet()) {
                    Object value = mAllProcVar.get(key);
                    String name = "";
                    if (value != null) {
                        name = value.toString();
                        if (oneOtherIndex != null && oneOtherIndex.equals(name)) {
                            ++howManyCopies;
                        }
                    }
                    if (howManyCopies <= true) continue;
                    oneOtherIndex = oneOtherIndex + " (" + forBrackets + ")";
                    break;
                }
            }
            catch (Exception e) {
                taskLog.debug((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return oneOtherIndex;
    }

    private String[] sortOtherIndiciesTable(String[] sIndiciesTable) {
        log.trace((Object)"************ sortOtherIndiciesTable(String[]) ************");
        String[] sortedIndicies = null;
        try {
            if (sIndiciesTable != null && sIndiciesTable.length > 0) {
                ArrayList<String> helpList = new ArrayList<String>();
                block2: for (String oneIndex : sIndiciesTable) {
                    if (helpList.size() == 0) {
                        helpList.add(oneIndex);
                        continue;
                    }
                    for (int counter = 0; helpList.size() >= counter; ++counter) {
                        if (counter == helpList.size()) {
                            helpList.add(oneIndex);
                            continue block2;
                        }
                        String listValue = (String)helpList.get(counter);
                        if (listValue == null || oneIndex.compareToIgnoreCase(listValue) >= 0) continue;
                        helpList.add(counter, oneIndex);
                        continue block2;
                    }
                }
                sortedIndicies = new String[helpList.size()];
                for (int i = 0; i < helpList.size(); ++i) {
                    sortedIndicies[i] = (String)helpList.get(i);
                }
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sortedIndicies;
    }

    private ArrayList<CommentsTable> sortComments(ArrayList<CommentsTable> commentsList) {
        log.trace((Object)"************ sortComments(ArrayList<CommentsTable>) ************");
        ArrayList<CommentsTable> sortedCommentsList = new ArrayList<CommentsTable>();
        try {
            if (commentsList != null) {
                block2: for (CommentsTable oneCommentTable : commentsList) {
                    if (oneCommentTable == null) continue;
                    if (sortedCommentsList.size() == 0) {
                        sortedCommentsList.add(oneCommentTable);
                        continue;
                    }
                    for (int counter = 0; sortedCommentsList.size() >= counter; ++counter) {
                        if (counter == sortedCommentsList.size()) {
                            sortedCommentsList.add(oneCommentTable);
                            continue block2;
                        }
                        Long oldListValue = oneCommentTable.getTimestamp();
                        Long newListValue = sortedCommentsList.get(counter).getTimestamp();
                        if (oldListValue == null || newListValue == null) continue;
                        Timestamp oldListDate = new Timestamp(oldListValue);
                        Timestamp newListDate = new Timestamp(newListValue);
                        if (oldListDate == null || newListDate == null || !oldListDate.after(newListDate)) continue;
                        sortedCommentsList.add(counter, oneCommentTable);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sortedCommentsList;
    }

    private String getMessageForLanguage(String sMessage, String sLanguage) {
        log.trace((Object)("************ getMessageForLanguage(sMessage=" + sMessage + ", sLanguage=" + sLanguage + ") ************"));
        try {
            if (sMessage != null && sLanguage != null) {
                if (sLanguage.equalsIgnoreCase("ENG")) {
                    if (sMessage.equalsIgnoreCase("Tabele dynamiczne")) {
                        sMessage = "Dynamic tables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Pusta tabela")) {
                        sMessage = "Empty table";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak zmiennych poza tabelami dynamicznymi")) {
                        sMessage = "No variables outside dynamic tables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Zmienne nietabelaryczne")) {
                        sMessage = "Non dynamic table variables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Informacje o procesie")) {
                        sMessage = "Informations about";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("")) {
                        sMessage = " process";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Dane og\u00f3lne procesu")) {
                        sMessage = "General process data";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Identyfikator definicji procesu")) {
                        sMessage = "Process definition ID";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Typ procesu")) {
                        sMessage = "Process type";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Identyfikator procesu")) {
                        sMessage = "Process ID";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa procesu")) {
                        sMessage = "Process name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Opis procesu")) {
                        sMessage = "Process description";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Inicjator procesu")) {
                        sMessage = "Process initiator";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Status procesu")) {
                        sMessage = "Process state";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data rozpocz\u0119cia procesu")) {
                        sMessage = "Process start date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data zako\u0144czenia procesu")) {
                        sMessage = "Process finish date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Tabele zmiennych procesu")) {
                        sMessage = "Process variables tables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa zmiennej procesu")) {
                        sMessage = "Process variable name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Identyfikator zmiennej procesu")) {
                        sMessage = "Process variable ID";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Warto\u015b\u0107 zmiennej procesu")) {
                        sMessage = "Process variable value";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak zmiennych procesu")) {
                        sMessage = "There are no process variables";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Historia procesu")) {
                        sMessage = "Process history";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Historia procesu zawiera poszczeg\u00f3lne zadania posortowane wed\u0142ug dat rozpocz\u0119cia zadania")) {
                        sMessage = "Process history contains individual activities sorted by activity start date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nr")) {
                        sMessage = "No";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Identyfikator zadania")) {
                        sMessage = "Activity ID";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa zadania")) {
                        sMessage = "Activity name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Status")) {
                        sMessage = "State";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Inicjator")) {
                        sMessage = "Initiator";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data rozpocz\u0119cia zadania")) {
                        sMessage = "Activity start date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data zako\u0144czenia zadania")) {
                        sMessage = "Activity finish date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak zada\u0144 w procesie")) {
                        sMessage = "There are no activities in process";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Dokumenty procesu")) {
                        sMessage = "Process documents";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Dokumenty podpi\u0119te do procesu")) {
                        sMessage = "Documents attached to";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa dokumentu")) {
                        sMessage = "Document name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Nazwa klasy dokument\u00f3w")) {
                        sMessage = "Document class name";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Opis dokumentu")) {
                        sMessage = "Document description";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data dodania dokumentu")) {
                        sMessage = "Document attach date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Rozmiar (bajty)")) {
                        sMessage = "Size (bytes)";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("W\u0142a\u015bciciel")) {
                        sMessage = "Owner";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak dokument\u00f3w do\u0142\u0105czonych do procesu")) {
                        sMessage = "There are no documents attached to process";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Komentarze")) {
                        sMessage = "Comments";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Komentarze wy\u015bwietlone w odwrotnej kolejno\u015bci dodawania")) {
                        sMessage = "Comments are listed in reverse order of addition";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("U\u017cytkownik")) {
                        sMessage = "User";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data")) {
                        sMessage = "Date";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Komentarz")) {
                        sMessage = "Comment";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Brak komentarzy w procesie")) {
                        sMessage = "There are no comments in process";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Archiwum proces\u00f3w")) {
                        sMessage = "Archive of";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Czas rozpocz\u0119cia procesu")) {
                        sMessage = "Process start time";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Czas zako\u0144czenia procesu")) {
                        sMessage = "Process stop time";
                        return sMessage;
                    }
                    if (sMessage.equalsIgnoreCase("Data archiwizacji")) {
                        sMessage = "Date of archive";
                        return sMessage;
                    }
                }
            } else if (sMessage == null) {
                sMessage = "";
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sMessage;
    }

    private String getRealNameForUserId(String userId) {
        log.trace((Object)("************ getRealNameForUserId(userId=" + userId + ") ************"));
        String userName = "";
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            if (!Tools.isNullOrEmpty((String)userId)) {
                String userFirstName = uga.getUserFirstName(userId);
                String userLastName = uga.getUserLastName(userId);
                if (userFirstName != null) {
                    userName = userFirstName;
                }
                if (userLastName != null) {
                    userName = !userName.equalsIgnoreCase("") ? userName + " " + userLastName : userLastName;
                }
                if (Tools.isNullOrEmpty((String)userName)) {
                    userName = userId + " (login)";
                }
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return userName;
    }

    private String getVarNameForVarId(Map<String, Object> mAllProcVar, String sID) {
        String sName;
        block3: {
            log.trace((Object)("************ getVarNameForVarId(Map<String, Object>, sID=" + sID + ") ************"));
            sName = null;
            try {
                if (mAllProcVar == null || mAllProcVar.size() <= 0 || Tools.isNullOrEmpty((String)sID)) break block3;
                for (String id : mAllProcVar.keySet()) {
                    Object oName = mAllProcVar.get(id);
                    if (!id.equalsIgnoreCase(sID) || oName == null) continue;
                    sName = oName.toString();
                    break;
                }
            }
            catch (Exception e) {
                taskLog.debug((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return sName;
    }

    private String getVarTypeForVarId(WorkflowProcess wp, String sID, boolean bIsVariableSet) {
        log.trace((Object)("************ getVarTypeForVarId(WorkflowProcess, sID=" + sID + ", bIsVariableSet=" + String.valueOf(bIsVariableSet) + ") ************"));
        String sType = null;
        try {
            DataField dataField;
            if (wp != null && sID != null && (dataField = wp.getDataField(sID)) != null) {
                DataType dataType = dataField.getDataType();
                if (dataType != null) {
                    sType = dataType.getDataTypes().getBasicType().getType();
                }
                if (bIsVariableSet) {
                    sType = "STRING";
                } else {
                    String subType;
                    ExtendedAttribute oneExtAttr;
                    ExtendedAttributes extAttrs = dataField.getExtendedAttributes();
                    if (extAttrs != null && (oneExtAttr = extAttrs.getFirstExtendedAttributeForName("SUBTYPE")) != null && (subType = oneExtAttr.getVValue()) != null) {
                        sType = subType;
                    }
                }
            }
            if (sType != null) {
                if (sType.contains("DATE") || sType.contains("date")) {
                    sType = "DATE";
                }
                if (sType.contains("AMOUNT") || sType.contains("amount")) {
                    sType = "FLOAT";
                }
                if (!((sType = sType.toLowerCase()).equalsIgnoreCase("string") || sType.equalsIgnoreCase("date") || sType.equalsIgnoreCase("float") || sType.equalsIgnoreCase("integer"))) {
                    sType = "string";
                }
            }
        }
        catch (Exception e) {
            taskLog.debug((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sType;
    }

    private Map<String, Map<String, String>> prepareConfigurationMap(WorkflowProcess wp, String sProcDefId, Map<String, Object> mAllProcVar) {
        HashMap<String, Map<String, String>> configurationMap;
        block20: {
            log.trace((Object)("************ prepareConfigurationMap(WorkflowProcess, sProcDefId=" + sProcDefId + ", Map<String, Object>) ************"));
            configurationMap = new HashMap<String, Map<String, String>>();
            try {
                ProcessData processData = new ProcessData();
                ActivityData activityData = new ActivityData();
                HashMap activityIdAndNameMap = processData.GetProcessActivitiesDefIdsDefNamesPairs(sProcDefId);
                if (activityIdAndNameMap == null) break block20;
                Iterator iter = activityIdAndNameMap.keySet().iterator();
                HashMap<String, String> indeciesTypesMap = new HashMap<String, String>();
                configurationMap.put("indeciestypes", indeciesTypesMap);
                HashMap<String, String> variableToProcessMap = new HashMap<String, String>();
                configurationMap.put("variabletoprocess", variableToProcessMap);
                int counterForDynamicTables = 1;
                int counterForVariableToProcess = 1;
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    String name = (String)activityIdAndNameMap.get(id);
                    ExtendedAttributes extAttrs = null;
                    try {
                        extAttrs = activityData.GetActivityExtendedAttributesByActivityName(sProcDefId, name);
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage());
                    }
                    if (extAttrs == null) continue;
                    for (int i = 0; i < extAttrs.size(); ++i) {
                        ExtendedAttribute oneExtAttr = (ExtendedAttribute)extAttrs.get(i);
                        if (oneExtAttr == null) continue;
                        String attrName = oneExtAttr.getName();
                        String attrValue = oneExtAttr.getVValue();
                        if (attrName.equalsIgnoreCase("VARIABLE_SET") || attrName.equalsIgnoreCase("VARIABLE_SET_VIEW")) {
                            String[] enterSplit;
                            HashMap<String, String> variableSetMap = new HashMap<String, String>();
                            int nrOfVar = 1;
                            for (String oneEnter : enterSplit = attrValue.split("\n", -1)) {
                                if (Tools.isNullOrEmpty((String)oneEnter) || oneEnter.contains("DT_")) continue;
                                String sType = "string";
                                String variableName = this.getVarNameForVarId(mAllProcVar, oneEnter);
                                if ((variableName = this.checkDuplicateVarViewName(mAllProcVar, variableName, oneEnter)) != null && ((Map)configurationMap.get("indeciestypes")).get(variableName) == null) {
                                    indeciesTypesMap.put(variableName, sType);
                                }
                                if (Tools.isNullOrEmpty((String)attrValue)) continue;
                                variableSetMap.put(String.valueOf(nrOfVar), oneEnter);
                                ++nrOfVar;
                            }
                            if (variableSetMap == null || variableSetMap.size() <= 0) continue;
                            boolean bAdd = true;
                            Iterator variableSetMapIter = variableSetMap.keySet().iterator();
                            for (int j = 1; j <= configurationMap.size() - 2; ++j) {
                                Map helpMap = (Map)configurationMap.get("variableset" + String.valueOf(j));
                                if (helpMap != null && helpMap.size() == variableSetMap.size()) {
                                    int identityCounter = 0;
                                    while (variableSetMapIter.hasNext()) {
                                        String key = (String)variableSetMapIter.next();
                                        String valueFromHelpMap = (String)helpMap.get(key);
                                        String valueFromVariableSetMap = (String)variableSetMap.get(key);
                                        if (valueFromHelpMap == null) break;
                                        if (!valueFromVariableSetMap.equalsIgnoreCase(valueFromHelpMap)) continue;
                                        ++identityCounter;
                                    }
                                    if (identityCounter == variableSetMap.size()) {
                                        bAdd = false;
                                    }
                                }
                                if (!bAdd) break;
                            }
                            if (!bAdd) continue;
                            configurationMap.put("variableset" + String.valueOf(counterForDynamicTables), variableSetMap);
                            ++counterForDynamicTables;
                            continue;
                        }
                        if (!attrName.equalsIgnoreCase("VariableToProcess_VIEW") && !attrName.equalsIgnoreCase("VariableToProcess_UPDATE")) continue;
                        String sType = this.getVarTypeForVarId(wp, attrValue, false);
                        String variableName = this.getVarNameForVarId(mAllProcVar, attrValue);
                        if ((variableName = this.checkDuplicateVarViewName(mAllProcVar, variableName, attrValue)) != null && ((Map)configurationMap.get("indeciestypes")).get(variableName) == null) {
                            indeciesTypesMap.put(variableName, sType);
                        }
                        if (Tools.isNullOrEmpty((String)attrValue)) continue;
                        boolean bAdd = true;
                        for (int j = 1; j < counterForVariableToProcess; ++j) {
                            String oldValue = (String)((Map)configurationMap.get("variabletoprocess")).get(String.valueOf(j));
                            if (Tools.isNullOrEmpty((String)oldValue) || !oldValue.equalsIgnoreCase(attrValue)) continue;
                            bAdd = false;
                            break;
                        }
                        if (!bAdd) continue;
                        variableToProcessMap.put(String.valueOf(counterForVariableToProcess), attrValue);
                        ++counterForVariableToProcess;
                    }
                }
                for (String attrValue : mAllProcVar.keySet()) {
                    int j;
                    if (Tools.isNullOrEmpty((String)attrValue)) continue;
                    boolean bAdd = true;
                    for (j = 1; j < counterForVariableToProcess; ++j) {
                        String oldValue = (String)((Map)configurationMap.get("variabletoprocess")).get(String.valueOf(j));
                        if (Tools.isNullOrEmpty((String)oldValue) || !oldValue.equalsIgnoreCase(attrValue)) continue;
                        bAdd = false;
                        break;
                    }
                    if (bAdd) {
                        block12: for (j = 1; j <= configurationMap.size() - 2; ++j) {
                            Map helpMap = (Map)configurationMap.get("variableset" + String.valueOf(j));
                            if (helpMap == null) continue;
                            for (String oldID : helpMap.keySet()) {
                                String oldValue = (String)helpMap.get(String.valueOf(oldID));
                                if (Tools.isNullOrEmpty((String)oldValue) || !oldValue.equalsIgnoreCase(attrValue)) continue;
                                bAdd = false;
                                continue block12;
                            }
                        }
                    }
                    if (!bAdd) continue;
                    variableToProcessMap.put(String.valueOf(counterForVariableToProcess), attrValue);
                    ++counterForVariableToProcess;
                }
                configurationMap.put("indeciestypes", indeciesTypesMap);
                configurationMap.put("variabletoprocess", variableToProcessMap);
            }
            catch (Exception e) {
                taskLog.debug((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return configurationMap;
    }

    public Double getProgress() {
        return this.progress;
    }
}

