/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper;

import com.suncode.cuf.io.office.model.CellValue;
import com.suncode.cuf.plannedtask.administration.structure.helper.ImportStructureMode;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.util.ContextLogger;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class StructureImporter {
    private ImportStructureMode mode;
    private static final Logger log = ContextLogger.getLogger(StructureImporter.class);

    public void setMode(ImportStructureMode mode) {
        this.mode = mode;
    }

    private void importGroups(List<Map<String, CellValue<String>>> list) {
        for (Map<String, CellValue<String>> map : list) {
            String name = map.get("name").getValue();
            String desc = map.get("description").getValue();
            this.mode.importGroup(name, desc);
        }
        log.info("Zaimportowano grupy: " + list.size());
    }

    public void importStructure(StructureData sd, ImportStructureMode mode) {
        this.mode = mode;
        this.importGroups(sd.getGroups());
        this.importOrgUnits(sd.getOrgUnits());
        this.importPositons(sd.getPositions());
        this.importOrgUnitsAssotiations(sd.getOrgUnits());
        this.importUsers(sd.getUsers());
        mode.clean();
        log.info("Zako\u0144czono importowanie struktury.");
    }

    private void importOrgUnitsAssotiations(List<Map<String, CellValue<String>>> list) {
        for (Map<String, CellValue<String>> map : list) {
            String symbol = map.get("symbol").getValue();
            String higherOrgUnit = map.get("higherOrgUnit").getValue();
            String directorPosition = map.get("directorPosition").getValue();
            this.mode.importOrgUnitAssotiations(symbol, higherOrgUnit, directorPosition);
        }
        log.info("Zaimportowano powi\u0105zania jednostek organizacyjnych: " + list.size());
    }

    private void importUsers(List<Map<String, CellValue<String>>> list) {
        for (Map<String, CellValue<String>> map : list) {
            String userName = this.prepareUserName(map.get("userName").getValue());
            String firstName = map.get("firstName").getValue();
            String lastName = map.get("lastName").getValue();
            String password = map.get("password").getValue();
            String email = map.get("email").getValue();
            String number = map.get("number").getValue();
            String groups = map.get("groups").getValue();
            String positions = map.get("positions").getValue();
            this.mode.importUser(userName, firstName, lastName, password, email, number, groups, positions);
        }
        log.info("Zaimportowano u\u017cytkownik\u00f3w: " + list.size());
    }

    private String prepareUserName(String userName) {
        String[] splitted = userName.split("/");
        if (splitted.length == 2) {
            return splitted[0] + "/" + splitted[1].toLowerCase();
        }
        return userName.toLowerCase();
    }

    private void importPositons(List<Map<String, CellValue<String>>> list) {
        for (Map<String, CellValue<String>> map : list) {
            String name = map.get("name").getValue();
            String symbol = map.get("symbol").getValue();
            String higherPosition = map.get("higherPosition").getValue();
            String orgUnit = map.get("orgUnit").getValue();
            String roles = map.get("roles").getValue();
            this.mode.importPosition(name, symbol, higherPosition, orgUnit, roles);
        }
        log.info("Zaimportowano stanowiska: " + list.size());
    }

    private void importOrgUnits(List<Map<String, CellValue<String>>> list) {
        for (Map<String, CellValue<String>> map : list) {
            String name = map.get("name").getValue();
            String symbol = map.get("symbol").getValue();
            String higherOrgUnit = map.get("higherOrgUnit").getValue();
            String directorPosition = map.get("directorPosition").getValue();
            this.mode.importOrgUnit(name, symbol, higherOrgUnit, directorPosition);
        }
        log.info("Zaimportowano jednostki organizacyjne: " + list.size());
    }
}

