/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.template;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.plusmpm.database.DocumentTemplateTable;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.File;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WordTemplateService {
    @Autowired
    private ProcessService processService;
    @Autowired
    private DocumentTemplateService templateService;

    public void generateForProcess(File output, String templateName, String processId, OutputFormat format) {
        DocumentTemplateTable template = this.templateService.getByName(templateName, new String[0]);
        if (template == null) {
            throw new IllegalArgumentException("Document template with name [" + templateName + "] not found");
        }
        String templatePath = template.getTemplatePath();
        String outputPath = output.getAbsolutePath();
        Map context = this.processService.getProcessContext(processId);
        PrepeareDoc.prepareDocument(templatePath, outputPath, context, null, "@", processId, null, null, format == OutputFormat.PDF);
    }

    public static enum OutputFormat {
        PDF,
        DOCX;

    }
}

