/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.NotificationDefTable;
import com.plusmpm.database.NotificationProcActTable;
import com.plusmpm.database.NotificationRecipientTable;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class ExportNotifications
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportNotifications.class);

    @AdvancedTask(name="ExportNotificationsToXLS", description="ExportNotificationsToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportNotificationsToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportNotificationsToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        DBManagement dbm = new DBManagement();
        ArrayList notifications = null;
        ArrayList recipients = null;
        ArrayList activities = null;
        ArrayList<String> activitiesNamesList = null;
        int columnPos = 0;
        int rowPos = 0;
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet notificationsSheet = workbook.createSheet("Powiadomienia", 0);
            log.info((Object)"Utworzono arkusz do eksportu powiadomien");
            String[] colIDsNotification = new String[]{"Nazwa procesu", "Nazwa powiadomienia", "Temat", "\u015acie\u017cka szablonu", "Typ warunku wys\u0142ania", "Warto\u015b\u0107 warunku wys\u0142ania", "Zmienna", "Tylko w\u0142asne zadania"};
            String[] colIDsRecipient = new String[]{"Typ odbiorcy", "Odbiorca", "Wykluczony"};
            String[] colIDsActivity = new String[]{"Nazwa zadania"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (i = 0; i < colIDsNotification.length; ++i) {
                CUFTools.addCellToXLSSheet(notificationsSheet, columnPos, 0, colIDsNotification[i], times12format, cellView);
                ++columnPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.YELLOW);
            for (i = 0; i < colIDsRecipient.length; ++i) {
                CUFTools.addCellToXLSSheet(notificationsSheet, columnPos, 0, colIDsRecipient[i], times12format, cellView);
                ++columnPos;
            }
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.ORANGE);
            for (i = 0; i < colIDsActivity.length; ++i) {
                CUFTools.addCellToXLSSheet(notificationsSheet, columnPos, 0, colIDsActivity[i], times12format, cellView);
                ++columnPos;
            }
            log.info((Object)"Pobieranie powiadomien z systemu");
            notifications = dbm.GetAllNotificationDefs();
            if (notifications != null && notifications.size() > 0) {
                for (NotificationDefTable oneNotification : notifications) {
                    if (oneNotification == null) continue;
                    columnPos = 0;
                    ++rowPos;
                    Long notificationId = oneNotification.getId();
                    String notificationName = oneNotification.getName();
                    String notificationSubject = oneNotification.getSubject();
                    String notificationTemplatePath = oneNotification.getTemplatePath();
                    String notificationCondType = oneNotification.getConditionType();
                    String notificationCondVal = oneNotification.getConditionVal();
                    String notificationCondVar = oneNotification.getConditionVarName();
                    boolean bPcipientPerformer = oneNotification.getRecipientPerformer();
                    String recipientPerformer = "";
                    String processName = "";
                    activities = dbm.getNotificationProcActByNotificationDefId(notificationId.toString());
                    if (activities != null && activities.size() > 0) {
                        activitiesNamesList = new ArrayList<String>();
                        for (NotificationProcActTable oneActivity : activities) {
                            if (oneActivity == null) continue;
                            String processDefId = oneActivity.getProcessDefId();
                            String activityDefId = oneActivity.getActivityDefId();
                            String activityName = "";
                            if (Tools.isNullOrEmpty((String)processName)) {
                                processName = CUFTools.getProcessNameForProcDefId(processDefId);
                            }
                            activityName = !Tools.isNullOrEmpty((String)activityDefId) ? CUFTools.getActivityNameForActDefId(processDefId, activityDefId) : "brak";
                            activitiesNamesList.add(activityName);
                        }
                    } else {
                        log.info((Object)("Brak zadan dla powiadomienia " + notificationName));
                        continue;
                    }
                    CUFTools.addCellToXLSSheet(notificationsSheet, columnPos, rowPos, processName, null, cellView);
                    CUFTools.addCellToXLSSheet(notificationsSheet, ++columnPos, rowPos, notificationName, null, cellView);
                    CUFTools.addCellToXLSSheet(notificationsSheet, ++columnPos, rowPos, notificationSubject, null, cellView);
                    CUFTools.addCellToXLSSheet(notificationsSheet, ++columnPos, rowPos, notificationTemplatePath, null, cellView);
                    ++columnPos;
                    if (notificationCondType.equalsIgnoreCase("create")) {
                        notificationCondType = "Utworzenie";
                    } else if (notificationCondType.equalsIgnoreCase("end")) {
                        notificationCondType = "Zako\u0144czenie";
                    } else if (notificationCondType.equalsIgnoreCase("deadline")) {
                        notificationCondType = "Przekroczenie terminu";
                    }
                    CUFTools.addCellToXLSSheet(notificationsSheet, columnPos, rowPos, notificationCondType, null, cellView);
                    CUFTools.addCellToXLSSheet(notificationsSheet, ++columnPos, rowPos, notificationCondVal, null, cellView);
                    CUFTools.addCellToXLSSheet(notificationsSheet, ++columnPos, rowPos, notificationCondVar, null, cellView);
                    recipientPerformer = bPcipientPerformer ? "tak" : "nie";
                    CUFTools.addCellToXLSSheet(notificationsSheet, ++columnPos, rowPos, recipientPerformer, null, cellView);
                    ++columnPos;
                    recipients = dbm.getNotificationRecipientByNotificationDefId(notificationId.toString());
                    if (recipients != null && recipients.size() > 0) {
                        for (NotificationRecipientTable oneRecipient : recipients) {
                            if (oneRecipient == null) continue;
                            ++rowPos;
                            columnPos = colIDsNotification.length;
                            String recipientType = oneRecipient.getRecipientType();
                            String recipientValue = oneRecipient.getRecipientVal();
                            String recipientExcluded = oneRecipient.getRecipientExcluded();
                            if (recipientType.equalsIgnoreCase("user")) {
                                recipientType = "U\u017cytkownik";
                            } else if (recipientType.equalsIgnoreCase("group")) {
                                recipientType = "Grupa";
                            } else if (recipientType.equalsIgnoreCase("position")) {
                                recipientType = "Stanowisko";
                            } else if (recipientType.equalsIgnoreCase("participanthigherposition")) {
                                recipientType = "Prze\u0142o\u017cony";
                            } else if (recipientType.equalsIgnoreCase("participant")) {
                                recipientType = "Wykonawca";
                            }
                            CUFTools.addCellToXLSSheet(notificationsSheet, columnPos, rowPos, recipientType, null, cellView);
                            CUFTools.addCellToXLSSheet(notificationsSheet, ++columnPos, rowPos, recipientValue, null, cellView);
                            ++columnPos;
                            if (recipientExcluded.equalsIgnoreCase("true")) {
                                recipientExcluded = "tak";
                            } else if (recipientExcluded.equalsIgnoreCase("false")) {
                                recipientExcluded = "nie";
                            }
                            CUFTools.addCellToXLSSheet(notificationsSheet, columnPos, rowPos, recipientExcluded, null, cellView);
                            ++columnPos;
                        }
                    } else {
                        log.info((Object)("Brak odbiorcow dla powiadomienia " + notificationName));
                    }
                    if (activitiesNamesList != null && activitiesNamesList.size() > 0) {
                        for (String activityName : activitiesNamesList) {
                            columnPos = colIDsNotification.length + colIDsRecipient.length;
                            CUFTools.addCellToXLSSheet(notificationsSheet, columnPos, ++rowPos, activityName, null, cellView);
                            ++columnPos;
                        }
                        continue;
                    }
                    log.info((Object)("Brak zadan dla powiadomienia " + notificationName));
                }
            } else {
                log.info((Object)"Brak powiadomien zdefiniowanych w systemie");
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport powiadomien do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania powiadomien. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportNotificationsToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

