/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.scheduledTasks.ScheduledTasksMethods;
import com.plusmpm.util.Tools;
import com.plusmpm.util.classLoader.PlusClassLoader;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.ScheduledTasks;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;

public class ImportPlannedExternalTasks
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportPlannedExternalTasks.class);

    @AdvancedTask(name="ImportScheduledTasksFromXLS", description="ImportScheduledTasksFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportScheduledTasksFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportScheduledTasksFromXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        boolean bContinue = true;
        String helpTaskName = "";
        String helpClassName = "";
        String helpMethodName = "";
        String helpNumberOfParams = "";
        long taskId = -1L;
        int actualParamNr = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Zadania zaplanowane");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Zadania zaplanowane w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 12; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z zadaniami zaplanowanymi");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String taskName = sheet.getCell(((Integer)header.get("Nazwa zadania")).intValue(), i).getContents();
                    String taskDescr = sheet.getCell(((Integer)header.get("Opis")).intValue(), i).getContents();
                    String className = sheet.getCell(((Integer)header.get("Klasa")).intValue(), i).getContents();
                    String methodName = sheet.getCell(((Integer)header.get("Metoda")).intValue(), i).getContents();
                    String isActive = sheet.getCell(((Integer)header.get("Aktywne")).intValue(), i).getContents();
                    boolean bIsActive = false;
                    String periodAmount = sheet.getCell(((Integer)header.get("Okres - ilo\u015b\u0107")).intValue(), i).getContents();
                    long lPeriodAmount = new Long(-1L);
                    String periodUnit = sheet.getCell(((Integer)header.get("Okres - jednostka")).intValue(), i).getContents();
                    Long lPeriod = null;
                    String firstRun = sheet.getCell(((Integer)header.get("Data pierwszego uruchomienia")).intValue(), i).getContents();
                    Date dFirstRun = null;
                    String nextRun = sheet.getCell(((Integer)header.get("Data nast\u0119pnego uruchomienia")).intValue(), i).getContents();
                    Date dNextRun = null;
                    String numberOfParams = sheet.getCell(((Integer)header.get("Liczba parametr\u00f3w")).intValue(), i).getContents();
                    String parameterType = sheet.getCell(((Integer)header.get("Typ parametru")).intValue(), i).getContents();
                    String parameterValue = sheet.getCell(((Integer)header.get("Warto\u015b\u0107 parametru")).intValue(), i).getContents();
                    if (!Tools.isNullOrEmpty((String)taskName)) {
                        taskId = -1L;
                        actualParamNr = 0;
                        helpTaskName = taskName;
                        if (Tools.isNullOrEmpty((String)className)) {
                            bContinue = false;
                            throw new CUFException("Nie podano klasy dla zadania zaplanowanego o nazwie " + taskName);
                        }
                        helpClassName = className;
                        if (Tools.isNullOrEmpty((String)methodName)) {
                            bContinue = false;
                            throw new CUFException("Nie podano metody dla zadania zaplanowanego o nazwie " + taskName);
                        }
                        helpMethodName = methodName;
                        if (isActive != null && isActive.equalsIgnoreCase("tak")) {
                            bIsActive = true;
                        }
                        if (bIsActive && Tools.isNullOrEmpty((String)nextRun)) {
                            bContinue = false;
                            throw new CUFException("Zadanie zaplanowane o nazwie " + taskName + " jest zadaniem aktywnym, nalezy wiec zdefiniowac dla niego date nastepnego uruchomienia");
                        }
                        if (Tools.isNullOrEmpty((String)periodAmount) || Tools.isNullOrEmpty((String)periodUnit)) {
                            bContinue = false;
                            throw new CUFException("Nie podano wszystkich danych odnosnie okresu uruchamiania zadania zaplanowanego o nazwie " + taskName);
                        }
                        try {
                            lPeriodAmount = Long.parseLong(periodAmount);
                            if (lPeriodAmount <= 0L) {
                                bContinue = false;
                                throw new CUFException("Pole Okres - ilo\u015b\u0107 dla zadania zaplanowanego o nazwie " + taskName + " nie zawiera oczekiwanej wartosci dodatniej");
                            }
                        }
                        catch (NumberFormatException e) {
                            bContinue = false;
                            throw new CUFException("Pole Okres - ilo\u015b\u0107 dla zadania zaplanowanego o nazwie " + taskName + " nie zawiera wartosci liczbowej");
                        }
                        lPeriod = periodUnit.compareToIgnoreCase("minuty") == 0 ? Long.valueOf(lPeriodAmount * 1000L * 60L) : (periodUnit.compareToIgnoreCase("godziny") == 0 ? Long.valueOf(lPeriodAmount * 1000L * 3600L) : (periodUnit.compareToIgnoreCase("dni") == 0 ? Long.valueOf(lPeriodAmount * 1000L * 3600L * 24L) : (periodUnit.compareToIgnoreCase("miesi\u0105ce") == 0 ? Long.valueOf(lPeriodAmount * 1000L * 3600L * 24L * 30L) : Long.valueOf(86400000L))));
                        if (Tools.isNullOrEmpty((String)firstRun)) {
                            bContinue = false;
                            throw new CUFException("Nie podano daty pierwszego uruchomienia dla zadania zaplanowanego o nazwie " + taskName);
                        }
                        try {
                            dFirstRun = sdf.parse(firstRun);
                        }
                        catch (ParseException e) {
                            bContinue = false;
                            throw new CUFException("Data pierwszego uruchomienia dla zadania zaplanowanego o nazwie " + taskName + " ma niepoprawny format");
                        }
                        if (!Tools.isNullOrEmpty((String)nextRun)) {
                            try {
                                dNextRun = sdf.parse(nextRun);
                            }
                            catch (ParseException e) {
                                bContinue = false;
                                throw new CUFException("Data nastepnego uruchomienia dla zadania zaplanowanego o nazwie " + taskName + " ma niepoprawny format");
                            }
                        }
                        if (Tools.isNullOrEmpty((String)numberOfParams)) {
                            bContinue = false;
                            throw new CUFException("Nie podano ilosci parametrow dla zadania zaplanowanego o nazwie " + taskName);
                        }
                        try {
                            int no = Integer.parseInt(numberOfParams);
                            if (no < 0) {
                                bContinue = false;
                                throw new CUFException("Ilosc parametrow dla zadania zaplanowanego o nazwie " + taskName + " nie przyjmuje wartosci liczbowej");
                            }
                        }
                        catch (NumberFormatException e) {
                            bContinue = false;
                            throw new CUFException("Ilosc parametrow dla zadania zaplanowanego o nazwie " + taskName + " nie przyjmuje oczekiwanej wartosci nieujemnej");
                        }
                        helpNumberOfParams = numberOfParams;
                        taskId = ScheduledTasksMethods.addScheduledTask((String)taskName, (String)taskDescr, (Boolean)bIsActive, (String)className, (String)methodName, (Date)dFirstRun, (Date)dNextRun, null, (Long)lPeriod);
                        if (bIsActive) {
                            ScheduledTasks.createScheduledTaskTimer((long)taskId);
                        }
                        if (taskId == -1L) {
                            bContinue = false;
                            throw new CUFException("Blad podczas dodawania do systemu zadania zaplanowanego o nazwie " + taskName);
                        }
                        bContinue = true;
                        log.info((Object)("Poprawnie dodano do systemu zadanie zaplanowane o nazwie " + taskName));
                    }
                    if (!bContinue || Tools.isNullOrEmpty((String)parameterType) || Tools.isNullOrEmpty((String)parameterValue)) continue;
                    try {
                        boolean res = ImportPlannedExternalTasks.addParameterForScheduledTask(taskId, parameterValue, parameterType, actualParamNr, helpClassName, helpMethodName, helpNumberOfParams);
                        if (!res) {
                            throw new Exception("Nie dodano parametru");
                        }
                        ++actualParamNr;
                    }
                    catch (Exception e) {
                        log.warn((Object)e.getMessage());
                        log.info((Object)("Usuwanie zadania zaplanowanego o nazwie " + helpTaskName));
                        ScheduledTasksMethods.deleteScheduledTasksById((Long)taskId);
                        bContinue = false;
                    }
                    continue;
                }
                catch (CUFException e) {
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import zadan zaplanowanych");
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportScheduledTasksFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static boolean addParameterForScheduledTask(Long scheduledTaskId, String sParameter, String sParameterType, int actualParamNr, String sClassName, String sMethodName, String sMethodOverride) throws CUFException, Exception {
        log.trace((Object)("************ addParameterForScheduledTask(scheduledTaskId=" + String.valueOf(scheduledTaskId) + ", sParameter=" + sParameter + ", sParameterType=" + sParameterType + ", actualParamNr=" + String.valueOf(actualParamNr) + ", sClassName=" + sClassName + ", sMethodName=" + ", sMethodOverride=" + sMethodOverride + ") ************"));
        boolean res = false;
        ArrayList allMethodParametersTypes = null;
        PlusClassLoader plusClassLoader = new PlusClassLoader();
        try {
            allMethodParametersTypes = plusClassLoader.getClassMethodParametersTypes(sClassName, sMethodName);
            int howManyParams = Integer.valueOf(sMethodOverride);
            boolean equalParams = false;
            for (String[] oneTable : allMethodParametersTypes) {
                if (howManyParams != oneTable.length) continue;
                equalParams = true;
                break;
            }
            if (equalParams) {
                if (actualParamNr > howManyParams - 1) {
                    throw new Exception("Zbyt wiele argumentow dla podanej funkcji. Sprawdz plik xls");
                }
                Class parameterType = plusClassLoader.forName(sParameterType);
                ScheduledTasksMethods.addScheduledTaskParameter((Long)scheduledTaskId, (Class)parameterType, (String)sParameter, (Integer)actualParamNr);
                res = true;
                log.info((Object)("Dodawanie parametru numer " + (actualParamNr + 1) + " o wartosci " + sParameter));
            }
        }
        catch (CUFException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return res;
    }
}

