/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.suncode.cuf.search.hibernate.GroupHibernateFilter;
import com.suncode.cuf.search.hibernate.SimpleHibernateFilter;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterTypeIdResolver
implements TypeIdResolver {
    private static final Logger log = LoggerFactory.getLogger(FilterTypeIdResolver.class);
    private JavaType baseType;

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromBaseType() {
        return this.idFromValueAndType(null, this.baseType.getRawClass());
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromValueAndType(Object obj, Class<?> clazz) {
        try {
            Field field = clazz.getDeclaredField("group");
            field.setAccessible(true);
            Boolean group = (Boolean)field.get(obj);
            if (group.booleanValue()) {
                return "true";
            }
            return "false";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void init(JavaType baseType) {
        this.baseType = baseType;
    }

    public JavaType typeFromId(String group) {
        Class clazz = null;
        clazz = group.equalsIgnoreCase("false") ? SimpleHibernateFilter.class : GroupHibernateFilter.class;
        return TypeFactory.defaultInstance().constructSpecializedType(this.baseType, clazz);
    }
}

