/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension.DocTemplates2Pdf;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.DynamicTablesResolver;
import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.TableInfo;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.workflowData.ProcessData;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.util.PDFTextStripper;
import org.docx4j.Docx4J;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.fonts.BestMatchingMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.jaxb.Context;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Document;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.springframework.transaction.TransactionStatus;

public class PrepeareDoc {
    public static Logger log = Logger.getLogger(PrepeareDoc.class);
    public static final String TAB_TO_PROC_STR = "TABLE_TO_PROCESS_MARKER";
    public static final String TAB_NOT_TO_PROC_STR = "TABLE_NOT_TO_PROCESS_MARKER";
    public static final String TAB_WOUT_HDS_STRING = "TABLE_WITHOUT_HEADERS_MARKER";
    public static final String VARIABLE_MARKER = "@";
    private static final SecureRandom random = new SecureRandom();

    private static String fitTextToColumn(String txt, int colWidth, String font, int fontSize, boolean isBold, boolean isItalic) {
        log.trace((Object)("***fitTextToColumn(txt=" + txt + ",colWidth=" + colWidth + ",font=" + font + ",fontSize=" + fontSize + ",isBold=" + isBold + ",isItalic=" + isItalic + ")****"));
        AffineTransform af = new AffineTransform();
        FontRenderContext fr = new FontRenderContext(af, true, true);
        int style = 0;
        if (isBold && isItalic) {
            style = 3;
        } else if (isBold) {
            style = 1;
        } else if (isItalic) {
            style = 2;
        }
        Font f = new Font(font, style, fontSize);
        String newTxt = "";
        log.debug((Object)("Szerokosc kolumny: " + (colWidth -= 100)));
        String[] words = txt.split(" ");
        double scale = 25.0;
        scale -= (double)(colWidth / 1000);
        for (int i = 0; i < words.length; ++i) {
            String w = words[i];
            log.debug((Object)("s\u0142owo: " + w));
            double width = f.getStringBounds(w, fr).getWidth() * scale;
            log.debug((Object)("szeroko\u015b\u0107 s\u0142owa: " + width));
            if (width > (double)colWidth) {
                log.debug((Object)"s\u0142owo si\u0119 nie miesci w kolumnie");
                int lines = (int)Math.ceil(width / (double)colWidth);
                log.debug((Object)("S\u0142owo zostanie rozbite na okolo " + lines + " linii"));
                int len = w.length();
                int offset = 0;
                for (int k = 0; k < lines; ++k) {
                    int endLine;
                    String line = w.substring(offset, Math.min(w.length(), len / lines + offset));
                    double lw = f.getStringBounds(line, fr).getWidth() * scale;
                    while (lw > (double)colWidth) {
                        line = line.substring(0, line.length() - 1);
                        lw = f.getStringBounds(line, fr).getWidth() * scale;
                    }
                    do {
                        if (!((lw = f.getStringBounds(line = w.substring(offset, endLine = Math.min(line.length() + 1 + offset, w.length())), fr).getWidth() * scale) > (double)colWidth)) continue;
                        line = line.substring(0, line.length() - 1);
                        break;
                    } while (endLine != w.length());
                    log.debug((Object)("dodaje linie: " + line));
                    newTxt = newTxt + line + "\n";
                    if (k + 1 != lines || (offset += line.length()) >= w.length() || Tools.isNullOrEmpty((String)line)) continue;
                    --k;
                }
                continue;
            }
            if (Tools.isNullOrEmpty((String)w)) continue;
            log.debug((Object)"s\u0142owo miesci sie w kolumnie");
            newTxt = newTxt + w + " ";
        }
        return newTxt;
    }

    public static File prepeareWordDocument(String sInputFilePathOldDocx, String sOutputFilePathPdf, Map<String, Object> mMappings, List<Map<String, String>> lTables, String sVariablesMarker, String sProcessId, List<Boolean> lWhichTables, List<Boolean> lWhichHeaders) {
        return PrepeareDoc.prepareDocument(sInputFilePathOldDocx, sOutputFilePathPdf, mMappings, lTables, sVariablesMarker, sProcessId, lWhichTables, lWhichHeaders, true);
    }

    public static File prepareDocument(String sInputFilePathOldDocx, String sOutputFilePathPdf, Map<String, Object> mMappings, List<Map<String, String>> lTables, String sVariablesMarker, final String sProcessId, List<Boolean> lWhichTables, List<Boolean> lWhichHeaders, boolean pdf) {
        block52: {
            log.trace((Object)"************************* prepareDocument() ********************");
            String sOutputFilePathNewDocx = "";
            try {
                int i;
                log.debug((Object)"Pobieranie WMLPackage dla pliku: ".concat(sInputFilePathOldDocx));
                WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(sInputFilePathOldDocx));
                log.debug((Object)"Pobieranie WMLPackage powiodlo sie.");
                log.debug((Object)"Pobieranie MainDocumentPart.");
                MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
                log.debug((Object)"Pobieranie MainDocumentPart powiodlo sie.");
                log.debug((Object)"Pobieranie JAXBElement - DocumentElement.");
                Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
                log.debug((Object)"Pobieranie JAXBElement powiodlo sie.");
                log.debug((Object)"Pobieranie wezlow table z dokumentu.");
                List lNodes = documentPart.getJAXBNodesViaXPath("//w:tbl", false);
                if (lNodes == null) break block52;
                log.debug((Object)"Pobieranie wezlow z tabelami powiodlo sie.");
                ArrayList<Tbl> lTbls = new ArrayList<Tbl>();
                ArrayList<Boolean> lWhichTablesTmp = new ArrayList<Boolean>();
                ArrayList<Boolean> lWhichHeadersTmp = new ArrayList<Boolean>();
                ArrayList<String> lTableValues = null;
                if (lWhichTables == null && lWhichHeaders == null) {
                    lWhichTables = new ArrayList<Boolean>();
                    lWhichHeaders = new ArrayList<Boolean>();
                    DynamicTablesResolver resolver = new DynamicTablesResolver();
                    List<TableInfo> tablesInfo = resolver.getTables(documentPart);
                    for (TableInfo tbls : tablesInfo) {
                        lWhichTables.add(tbls.isDynamic());
                        lWhichHeaders.add(!tbls.isHeaderless());
                    }
                }
                for (i = 0; i < lNodes.size(); ++i) {
                    log.debug((Object)"Pobieranie w\u0119z\u0142a dla i = ".concat(String.valueOf(i)));
                    JAXBElement jaxbeTmp = (JAXBElement)lNodes.get(i);
                    JAXBElement elem = null;
                    if (jaxbeTmp != null && jaxbeTmp.getDeclaredType().toString().equalsIgnoreCase("class org.docx4j.wml.Tbl")) {
                        log.debug((Object)"Wezel jest tabela.");
                        elem = (JAXBElement)lNodes.get(i);
                    }
                    log.debug((Object)"Pobieranie wartosci wezla tabeli.");
                    Tbl tbl = (Tbl)elem.getValue();
                    lTbls.add(tbl);
                    log.debug((Object)"Pobieranie wezla tabeli powiodlo sie.");
                }
                for (i = 0; i < lTbls.size(); ++i) {
                    lWhichTablesTmp.add(null);
                    lWhichHeadersTmp.add(null);
                    log.debug((Object)"Pobranie wierszy z tabeli.");
                    List lCurrentTableRows = ((Tbl)lTbls.get(i)).getContent();
                    if (lCurrentTableRows != null && lCurrentTableRows.size() > 0) {
                        log.debug((Object)"Pobieranie wierszy z tabeli powiod\u0142o si\u0119, liczba wierszy = ".concat(String.valueOf(lCurrentTableRows.size())));
                        if (lCurrentTableRows.size() >= 2) {
                            log.debug((Object)"Liczba wierszy >= 2.");
                            for (int j = 0; j < 2; ++j) {
                                Tr tr = null;
                                try {
                                    log.debug((Object)"Pobieranie obiektu Tr dla wiersza j = ".concat(String.valueOf(j)));
                                    tr = (Tr)lCurrentTableRows.get(j);
                                }
                                catch (ClassCastException cce) {
                                    // empty catch block
                                }
                                if (tr != null) {
                                    log.debug((Object)"Pobieranie obiektu Tr powiod\u0142o si\u0119.");
                                    log.debug((Object)"Pobieranie warto\u015bci kom\u00f3rek dla wiersza j = ".concat(String.valueOf(j)));
                                    List cells = tr.getContent();
                                    if (cells.size() == 1 && cells.get(0) != null) {
                                        log.debug((Object)"Pierwszy wiersz posiada tylko jedn\u0105 kolumn\u0119, mo\u017ce by\u0107 znacznikiem.");
                                        log.debug((Object)"Pobieranie elementu kom\u00f3rki.");
                                        JAXBElement tcElem = (JAXBElement)cells.get(0);
                                        Tc tc = null;
                                        if (tcElem != null) {
                                            log.debug((Object)"Pobieranie elementu kom\u00f3rki powiod\u0142o si\u0119.");
                                            log.debug((Object)"Pobieranie listy warto\u015bci kom\u00f3rki.");
                                            tc = (Tc)tcElem.getValue();
                                        } else {
                                            log.debug((Object)"B\u0141\u0104D - Problem z pobraniem elementu kom\u00f3rki.");
                                        }
                                        String sCellValue = null;
                                        if (tc != null) {
                                            log.debug((Object)"Pobieranie listy warto\u015bci kom\u00f3rki powiod\u0142o si\u0119.");
                                            List lCellValues = tc.getContent();
                                            if (lCellValues != null && lCellValues.size() > 0 && lCellValues.get(0) != null) {
                                                log.debug((Object)"Pobieranie pierwszej warto\u015bci z listy powiod\u0142o si\u0119.");
                                                sCellValue = String.valueOf(lCellValues.get(0));
                                                log.debug((Object)"sCellValue = ".concat(sCellValue));
                                                if (sCellValue.compareTo(TAB_TO_PROC_STR) == 0) {
                                                    log.debug((Object)"sCellValue to znacznik przetwarzania tabeli.");
                                                    lWhichTablesTmp.remove(lWhichTablesTmp.size() - 1);
                                                    lWhichTablesTmp.add(true);
                                                }
                                                if (sCellValue.compareTo(TAB_NOT_TO_PROC_STR) == 0) {
                                                    log.debug((Object)"sCellValue to znacznik wy\u0142\u0105czaj\u0105cy domy\u015blne przetwarzanie tabeli.");
                                                    lWhichTablesTmp.remove(lWhichTablesTmp.size() - 1);
                                                    lWhichTablesTmp.add(false);
                                                }
                                                if (sCellValue.compareTo(TAB_WOUT_HDS_STRING) != 0) continue;
                                                log.debug((Object)"sCellValue to znacznik usuni\u0119cia nag\u0142\u00f3wka.");
                                                lWhichHeadersTmp.remove(lWhichHeadersTmp.size() - 1);
                                                lWhichHeadersTmp.add(false);
                                                continue;
                                            }
                                            log.debug((Object)"B\u0141\u0104D - problem z pobraniem pierwszej warto\u015bci z listy.");
                                            continue;
                                        }
                                        log.debug((Object)"B\u0141\u0104D - Problem z pobraniem warto\u015bci kom\u00f3rki.");
                                        continue;
                                    }
                                    log.debug((Object)"Pierwszy wiersz posiada wi\u0119cej ni\u017c jedn\u0105 kolumn\u0119, nie jest znacznikiem.");
                                    continue;
                                }
                                log.debug((Object)"Problem z pobraniem obiektu Tr dla wiersza.");
                            }
                        } else {
                            log.debug((Object)"Tabela posiada tylko jeden wiersz.");
                        }
                    } else {
                        log.debug((Object)"B\u0141\u0104D - Problem z pobieraniem wierszy tabeli.");
                    }
                    log.debug((Object)"Usuwanie wierszy znacznikowych.");
                    if (lWhichTablesTmp.get(i) != null) {
                        log.debug((Object)"Wiersz znacznikowy przetwarzania tabeli - usuni\u0119ty.");
                        lCurrentTableRows.remove(0);
                    }
                    if (lWhichHeadersTmp.get(i) != null && !((Boolean)lWhichHeadersTmp.get(i)).booleanValue()) {
                        log.debug((Object)"Wiersz znacznikowy usuni\u0119cia nag\u0142\u00f3wka tabeli - usuni\u0119ty.");
                        lCurrentTableRows.remove(0);
                    }
                    log.debug((Object)"Usuwanie wierszy znacznikowych powiod\u0142o si\u0119.");
                }
                log.debug((Object)"Ustawianie flag wszystkich tabel.");
                boolean bTablesToProcessMarkers = true;
                if (lWhichTables == null) {
                    log.debug((Object)"lWhichTables = null.");
                    if (lWhichTablesTmp.contains(true) || lWhichTablesTmp.contains(false)) {
                        bTablesToProcessMarkers = false;
                    }
                    for (int i2 = 0; i2 < lNodes.size(); ++i2) {
                        if (lWhichTablesTmp.get(i2) != null) continue;
                        lWhichTablesTmp.remove(i2);
                        lWhichTablesTmp.add(i2, bTablesToProcessMarkers);
                    }
                } else {
                    log.debug((Object)"lWhichTables != null.");
                    log.debug((Object)"Przepisanie warto\u015bci z lWhichTables do lWhichTablesTmp.");
                    lWhichTablesTmp.clear();
                    lWhichTablesTmp.addAll(lWhichTables);
                    log.debug((Object)"Przepisanie warto\u015bci powiod\u0142o si\u0119.");
                }
                if (lWhichHeaders == null) {
                    log.debug((Object)"lWhichHeaders = null.");
                    for (int i3 = 0; i3 < lNodes.size(); ++i3) {
                        if (lWhichHeadersTmp.get(i3) != null) continue;
                        lWhichHeadersTmp.remove(i3);
                        lWhichHeadersTmp.add(i3, true);
                    }
                } else {
                    log.debug((Object)"lWhichHeaders != null.");
                    log.debug((Object)"Przepisanie warto\u015bci z lWhichHeaders do lWhichHeadersTmp.");
                    lWhichHeadersTmp.clear();
                    lWhichHeadersTmp.addAll(lWhichHeaders);
                    log.debug((Object)"Przepisanie warto\u015bci powiod\u0142o si\u0119.");
                }
                log.debug((Object)"Ustawianie flag powiodlo sie.");
                log.debug((Object)"lWhichTablesTmp: ");
                log.debug(lWhichTablesTmp);
                log.debug((Object)"lWhichHeadersTmp: ");
                log.debug(lWhichHeadersTmp);
                if (lWhichTablesTmp.size() == lNodes.size()) {
                    if (lWhichHeadersTmp.size() == lNodes.size()) {
                        log.debug((Object)"Przygotowanie wartosci do uzpelnienia tabel.");
                        for (int i4 = 0; i4 < lTbls.size(); ++i4) {
                            if (((Boolean)lWhichTablesTmp.get(i4)).booleanValue()) {
                                log.debug((Object)"Ustawianie formatowania wierszy w tabeli.");
                                ArrayList<Map<String, Object>> lParagraphsProperties = new ArrayList<Map<String, Object>>();
                                TrPr rowProperties = null;
                                log.debug((Object)"Pobieranie wierszy z tabeli i = ".concat(String.valueOf(i4)));
                                List lCurrentTableRows = ((Tbl)lTbls.get(i4)).getContent();
                                log.debug((Object)"Pobieranie wierszy z tabeli powiod\u0142o si\u0119.");
                                if (lCurrentTableRows != null && lCurrentTableRows.size() > 0) {
                                    log.debug((Object)"Tabla nie jest pusta.");
                                    int whichRow = 0;
                                    int iDefaultRowNo = 1;
                                    if (lCurrentTableRows.size() > 1) {
                                        log.debug((Object)"Formatowanie wierszy jest pobierane z drugiego wiersza tabeli (nie z nag\u0142\u00f3wka).");
                                        whichRow = 1;
                                        log.debug((Object)"Pobieranie paragraf\u00f3w tekstowych(kolumn) z wiersza definiujacego formatowanie.");
                                        List lParagraphs = documentPart.getJAXBNodesViaXPath("./w:tc/w:p", lCurrentTableRows.get(whichRow), false);
                                        if (lParagraphs != null && lParagraphs.size() > 0) {
                                            log.debug((Object)"Pobieranie paragraf\u00f3w tekstowych (kolumn) powiodlo sie. Liczba kolumn: ".concat(String.valueOf(lParagraphs.size())));
                                            log.debug((Object)"Pobieranie formatowania poszczegolnych kolumn.");
                                            for (int j = 0; j < lParagraphs.size(); ++j) {
                                                HashMap<String, PPr> mParagraphProperties = new HashMap<String, PPr>();
                                                P pParagraph = (P)lParagraphs.get(j);
                                                PPr paragraph_pPr = pParagraph.getPPr();
                                                mParagraphProperties.put("pPr", paragraph_pPr);
                                                lParagraphsProperties.add(mParagraphProperties);
                                            }
                                            log.debug((Object)"Pobieranie formatowania dla poszczegolnych kolumn powiodlo sie.");
                                            log.debug(lParagraphsProperties);
                                        }
                                        log.debug((Object)"Pobieranie w\u0142a\u015bciwo\u015bci wiersza z wiersza definiujacego formatowanie.");
                                        rowProperties = ((Tr)lCurrentTableRows.get(whichRow)).getTrPr();
                                    }
                                    log.debug((Object)"Pobieranie wartosci do uzpelnienia tabeli.");
                                    if (!Tools.isNullOrEmpty((String)sProcessId)) {
                                        log.debug((Object)"sProcessId rozne od null i nie jest puste.");
                                        log.debug((Object)"Pobieranie wezlow z wartosciami komorek z tabeli, dla wiersza: ".concat(String.valueOf(i4)));
                                        log.debug((Object)"Pobieranie wezlow z wartosciami komorek powiodlo sie.");
                                        String sTableHeaders = "";
                                        Tr tr = (Tr)lCurrentTableRows.get(0);
                                        List lTcElements = tr.getContent();
                                        int iColumnsCount = 0;
                                        log.debug((Object)"Pobieranie naglowkow.");
                                        for (int j = 0; j < lTcElements.size(); ++j) {
                                            Tc tc = null;
                                            try {
                                                JAXBElement tcElem = (JAXBElement)lTcElements.get(j);
                                                tc = (Tc)tcElem.getValue();
                                                ++iColumnsCount;
                                            }
                                            catch (ClassCastException cce) {
                                                // empty catch block
                                            }
                                            if (tc == null) continue;
                                            sTableHeaders = sTableHeaders.concat(String.valueOf(tc.getEGBlockLevelElts().get(0)));
                                        }
                                        log.debug((Object)"Pobieranie naglowkow powiodlo sie.");
                                        log.debug((Object)sTableHeaders);
                                        log.debug((Object)"lWhichHeadersTmp dla i = ".concat(String.valueOf(i4).concat(" = ").concat(String.valueOf(lWhichHeadersTmp.get(i4)))));
                                        if (!((Boolean)lWhichHeadersTmp.get(i4)).booleanValue()) {
                                            log.debug((Object)"W tabeli o indeksie ".concat(String.valueOf(i4)).concat(" nag\u0142\u00f3wek ma zosta\u0107 usuni\u0119ty."));
                                            iDefaultRowNo = 0;
                                        }
                                        log.debug((Object)"Usuwanie wiersza z nag\u0142\u00f3wkiem.");
                                        while (lCurrentTableRows.size() > iDefaultRowNo) {
                                            lCurrentTableRows.remove(lCurrentTableRows.size() - 1);
                                        }
                                        log.debug((Object)"Usuwanie wierszy powiodlo sie.");
                                        String sProcDefId = (String)new SharkTransactionTemplate().execute((SharkTransactionCallback)new SharkTransactionCallback<String>(){

                                            public String doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                                                return Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(transaction, sProcessId);
                                            }
                                        });
                                        ProcessData pd = new ProcessData();
                                        sTableHeaders = sTableHeaders.substring(1, sTableHeaders.length() - 1);
                                        log.debug((Object)"Usuniecie nadmiarowych znacznikow zmiennych.");
                                        log.debug((Object)sTableHeaders);
                                        sTableHeaders = sTableHeaders.replace(sVariablesMarker.concat(sVariablesMarker), sVariablesMarker);
                                        log.debug((Object)"Usuniecie nadmiarowych znacznikow zmiennych powiodlo sie.");
                                        log.debug((Object)sTableHeaders);
                                        log.debug((Object)"Splitowanie zmiennych.");
                                        String[] saTableHeadersAsProcessVariables = sTableHeaders.split(sVariablesMarker);
                                        log.debug((Object)"Splitowanie zmiennych powiodlo sie.");
                                        log.debug((Object)saTableHeadersAsProcessVariables);
                                        log.debug((Object)"Ustawianie naglowkow.");
                                        try {
                                            lTableValues = new ArrayList<String>();
                                            for (int j = 0; j < saTableHeadersAsProcessVariables.length; ++j) {
                                                if (j >= iColumnsCount) continue;
                                                if (saTableHeadersAsProcessVariables[j].contains("|")) {
                                                    String[] tmp = saTableHeadersAsProcessVariables[j].split("\\|");
                                                    Object o = mMappings.get(tmp[0]);
                                                    if (o == null) continue;
                                                    lTableValues.add(mMappings.get(tmp[0]).toString());
                                                    mMappings.put(saTableHeadersAsProcessVariables[j], tmp[1]);
                                                    continue;
                                                }
                                                if (mMappings.get(saTableHeadersAsProcessVariables[j]) == null) continue;
                                                lTableValues.add(mMappings.get(saTableHeadersAsProcessVariables[j]).toString());
                                                mMappings.put(saTableHeadersAsProcessVariables[j], ProcessData.getProcessVariableIdNameMap((String)sProcDefId).get(saTableHeadersAsProcessVariables[j]).toString());
                                            }
                                        }
                                        catch (Exception e) {
                                            log.debug((Object)"B\u0141\u0104D - problem z ustawianiem nag\u0142\u00f3wk\u00f3w.");
                                            log.error((Object)e.getMessage(), (Throwable)e);
                                            return null;
                                        }
                                        log.debug((Object)"Ustawianie naglowkow powiodlo sie.");
                                        log.debug(mMappings);
                                        log.debug((Object)"Tworzenie tabel z wypelnionymi wartosciami.");
                                        PrepeareDoc.createTableWithValues(documentPart, (Tbl)lTbls.get(i4), lTableValues, lParagraphsProperties, rowProperties);
                                        log.debug((Object)"Tworzenie tabel z wypelnionymi wartosciami powiodlo sie.");
                                        continue;
                                    }
                                    log.debug((Object)"sProcessId = null");
                                    log.debug((Object)"Tworzenie tabel z wypelnionymi wartosciami.");
                                    PrepeareDoc.createTableWithValues(documentPart, i4, (Tbl)lTbls.get(i4), lTables.get(i4), lParagraphsProperties);
                                    log.debug((Object)"Tworzenie tabel z wypelnionymi wartosciami powiodlo sie.");
                                    continue;
                                }
                                log.error((Object)"B\u0141\u0104D - tabela nr".concat(String.valueOf(i4 + 1)).concat(" w szablonie ").concat(sInputFilePathOldDocx).concat(" nie zawiera wierszy."));
                                continue;
                            }
                            log.debug((Object)"Tabla o indeksie: ".concat(String.valueOf(i4)).concat(" nie ma byc uzupelniana"));
                        }
                        log.debug((Object)"MarshalToString.");
                        String xml = XmlUtils.marshaltoString((Object)wmlDocumentEl, (boolean)true);
                        log.debug((Object)"MarshalToString powiodlo sie.");
                        log.debug((Object)"Uzupe\u0142nianie zmiennych w szablonie.");
                        String tmp = PrepeareDoc.replaceVariablesInTemplate(xml, mMappings, sVariablesMarker);
                        log.debug((Object)"Uzupelnianie zmiennych w szablonie powiodlo sie.");
                        log.debug((Object)"UnmarshalString");
                        Object obj = XmlUtils.unmarshalString((String)tmp);
                        log.debug((Object)"UnmarshalString powiodlo sie.");
                        log.debug((Object)"Ustawianie elementu JAXB na uzupelniony wartosciami.");
                        documentPart.setJaxbElement((Object)((Document)obj));
                        log.debug((Object)"Ustawianie elementu JAXB powiodlo sie.");
                        log.debug((Object)"Zapis to pliku docx.");
                        SaveToZipFile saver = new SaveToZipFile((OpcPackage)wordMLPackage);
                        if (!pdf) {
                            saver.save(sOutputFilePathPdf);
                            return new File(sOutputFilePathPdf);
                        }
                        sOutputFilePathNewDocx = sInputFilePathOldDocx.replace(".docx", "_" + String.valueOf(System.currentTimeMillis()) + Math.abs(random.nextInt()) + ".docx");
                        saver.save(sOutputFilePathNewDocx);
                        log.debug((Object)("Zapis do pliku docx powiodl sie: " + sOutputFilePathNewDocx));
                        File f = new File(sOutputFilePathNewDocx);
                        log.debug((Object)f.getAbsolutePath());
                        if (f.exists()) {
                            log.debug((Object)"Wygenerowanie pliku .pdf");
                            File tmpFile = PrepeareDoc.doc2PdfWithoutOO(sOutputFilePathNewDocx, sOutputFilePathPdf);
                            log.debug((Object)"Wygenerowanie pliku .pdf powiodlo sie: ".concat(sOutputFilePathPdf));
                            log.debug((Object)"Usuniecie uzupelnionego szablonu docx: ".concat(sOutputFilePathNewDocx));
                            if (!f.delete()) {
                                log.error((Object)" - problem z usuni\u0119ciem pliku.");
                            }
                            return tmpFile;
                        }
                        log.error((Object)"B\u0141\u0104D - nowy dokument si\u0119 nie utworzy\u0142, nie ma uzupelnionego szablonu .docx: ".concat(sOutputFilePathNewDocx));
                        break block52;
                    }
                    log.error((Object)"B\u0141\u0104D - liczba tabel na liscie lWhichHeaders jest r\u00f3\u017cna od liczby tabel w dokumencie");
                    break block52;
                }
                log.error((Object)"B\u0141\u0104D - liczba tabel do uzupelnienia na liscie lWhichTables jest r\u00f3\u017cna od liczby tabel w dokumencie");
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.debug((Object)"B\u0141\u0104D - przy pobieraniu w\u0119z\u0142\u00f3w z tabelami (z pliku XML - XPath)");
            }
        }
        return null;
    }

    public static void createTableWithValues(MainDocumentPart mdp, int iTableNr, Tbl table, Map<String, String> mValues, List<Map<String, Object>> lParagraphProperties) {
        int i;
        log.trace((Object)"************************* createTableWithValues() ********************");
        log.debug((Object)"Tworzenie tabeli nr: ".concat(String.valueOf(iTableNr)));
        int iSize = mValues.size();
        log.debug((Object)"mValues.size() = ".concat(String.valueOf(iSize)));
        int iRowsNr = 0;
        ArrayList<String[]> alColumns = new ArrayList<String[]>();
        log.debug((Object)"Przygotowanie wartosci tabelarycznych.");
        for (i = 0; i < iSize; ++i) {
            alColumns.add(mValues.get("t" + String.valueOf(iTableNr + 1) + "c" + String.valueOf(i + 1)).split(";", -1));
        }
        log.debug((Object)"Przygotowanie wartosci tabelarycznych powiodlo sie.");
        log.debug(alColumns);
        iRowsNr = ((String[])alColumns.get(0)).length;
        log.debug((Object)"Uzupe\u0142nianie warto\u015bci tabelarycznych.");
        for (i = 0; i < iRowsNr; ++i) {
            Tr tr = Context.getWmlObjectFactory().createTr();
            table.getEGContentRowContent().add(tr);
            for (int j = 0; j < iSize; ++j) {
                Tc tc = Context.getWmlObjectFactory().createTc();
                tr.getEGContentCellContent().add(tc);
                TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
                tc.setTcPr(tcPr);
                TblWidth cellWidth = Context.getWmlObjectFactory().createTblWidth();
                tcPr.setTcW(cellWidth);
                cellWidth.setType("dxa");
                cellWidth.setW(BigInteger.valueOf(2L));
                P p = mdp.createParagraphOfText(((String[])alColumns.get(j))[i]);
                try {
                    PPr pPr = null;
                    if (lParagraphProperties.size() > j) {
                        pPr = (PPr)lParagraphProperties.get(j).get("pPr");
                    }
                    p.setPPr(pPr);
                    ObjectFactory factory = Context.getWmlObjectFactory();
                    R r = (R)p.getContent().get(0);
                    Text t = (Text)r.getContent().get(0);
                    log.debug((Object)t.getValue());
                    String[] rows = t.getValue().split("\n");
                    int index = 0;
                    p.getContent().remove(r);
                    for (String row : rows) {
                        R run = factory.createR();
                        Text text = factory.createText();
                        text.setValue(row);
                        run.getContent().add(text);
                        p.getContent().add(run);
                        if (pPr != null) {
                            RPr rPr = StyleUtil.apply((ParaRPr)pPr.getRPr(), (RPr)factory.createRPr());
                            run.setRPr(rPr);
                        }
                        if (index < rows.length - 1) {
                            R brRun = factory.createR();
                            brRun.getContent().add(factory.createBr());
                            p.getContent().add(brRun);
                        }
                        ++index;
                    }
                }
                catch (Exception e) {
                    p = mdp.createParagraphOfText(((String[])alColumns.get(j))[i]);
                }
                tc.getEGBlockLevelElts().add(p);
            }
        }
        log.debug((Object)"Uzupe\u0142nienie warto\u015bci tabelarycznych powiod\u0142o si\u0119.");
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties) {
        PrepeareDoc.createTableWithValues(mdp, table, lValues, lParagraphProperties, null);
    }

    public static void createTableWithValues(MainDocumentPart mdp, Tbl table, List<String> lValues, List<Map<String, Object>> lParagraphProperties, TrPr rowProperties) {
        int i;
        log.trace((Object)"************************* createTableWithValues() ********************");
        for (int i2 = 0; i2 < lValues.size(); ++i2) {
            lValues.set(i2, lValues.get(i2).replaceAll(VARIABLE_MARKER, "Xsuncode-atX"));
        }
        int iSize = lValues.size();
        log.debug((Object)"mValues.size() = ".concat(String.valueOf(iSize)));
        int iRowsNr = 0;
        ArrayList<String[]> alColumns = new ArrayList<String[]>();
        log.debug((Object)"Splitowanie wartosci tabelarycznych.");
        for (i = 0; i < iSize; ++i) {
            alColumns.add(lValues.get(i).split(";", -1));
            int tmpLength = ((String[])alColumns.get(i)).length;
            if (tmpLength <= iRowsNr) continue;
            iRowsNr = tmpLength;
        }
        log.debug((Object)"Splitowanie wartosci tabelarycznych powiodlo sie.");
        log.debug(alColumns);
        log.debug((Object)"Uzupe\u0142nianie warto\u015bci tabelarycznych.");
        for (i = 0; i < iRowsNr; ++i) {
            Tr tr = Context.getWmlObjectFactory().createTr();
            if (rowProperties != null) {
                TrPr trPr = (TrPr)XmlUtils.deepCopy((Object)rowProperties, (JAXBContext)mdp.getJAXBContext());
                tr.setTrPr(trPr);
            }
            table.getEGContentRowContent().add(tr);
            for (int j = 0; j < iSize; ++j) {
                Tc tc = Context.getWmlObjectFactory().createTc();
                tr.getEGContentCellContent().add(tc);
                TcPr tcPr = Context.getWmlObjectFactory().createTcPr();
                tc.setTcPr(tcPr);
                TblWidth cellWidth = Context.getWmlObjectFactory().createTblWidth();
                tcPr.setTcW(cellWidth);
                cellWidth.setType("dxa");
                TblGridCol tgc = (TblGridCol)table.getTblGrid().getGridCol().get(j);
                int colWidth = tgc.getW().intValue();
                cellWidth.setW(BigInteger.valueOf(colWidth));
                P p = null;
                if (i < ((String[])alColumns.get(j)).length) {
                    String txt = ((String[])alColumns.get(j))[i];
                    String font = "Times New Roman";
                    boolean isBold = false;
                    boolean isItalic = false;
                    int size = 12;
                    PPr ppr = null;
                    if (j < lParagraphProperties.size()) {
                        ppr = (PPr)lParagraphProperties.get(j).get("pPr");
                        try {
                            font = ppr.getRPr().getRFonts().getAscii();
                        }
                        catch (Exception e) {
                            log.debug((Object)"nie mozna wczytac czcionki");
                        }
                        try {
                            isBold = ppr.getRPr().getB().isVal();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            isItalic = ppr.getRPr().getI().isVal();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            log.debug((Object)ppr.getRPr().getSz().getVal().doubleValue());
                            size = (int)Math.ceil(ppr.getRPr().getSz().getVal().doubleValue() / 2.0);
                        }
                        catch (Exception e) {
                            log.error((Object)e, (Throwable)e);
                        }
                        log.debug((Object)colWidth);
                    }
                    String newTxt = PrepeareDoc.fitTextToColumn(txt, colWidth, font, size, isBold, isItalic);
                    try {
                        p = mdp.createParagraphOfText(newTxt);
                        p.setPPr(ppr);
                        ObjectFactory factory = Context.getWmlObjectFactory();
                        R r = (R)p.getContent().get(0);
                        Text t = (Text)r.getContent().get(0);
                        log.debug((Object)t.getValue());
                        String[] rows = t.getValue().split("\n");
                        int index = 0;
                        p.getContent().remove(r);
                        for (String row : rows) {
                            R run = factory.createR();
                            Text text = factory.createText();
                            text.setValue(row);
                            run.getContent().add(text);
                            p.getContent().add(run);
                            if (ppr != null) {
                                RPr rPr = StyleUtil.apply((ParaRPr)ppr.getRPr(), (RPr)factory.createRPr());
                                run.setRPr(rPr);
                            }
                            if (index < rows.length - 1) {
                                R brRun = factory.createR();
                                brRun.getContent().add(factory.createBr());
                                p.getContent().add(brRun);
                            }
                            ++index;
                        }
                    }
                    catch (Exception e) {
                        p = mdp.createParagraphOfText(newTxt);
                    }
                } else {
                    p = mdp.createParagraphOfText("");
                }
                if (p != null) {
                    if (j < lParagraphProperties.size()) {
                        p.setPPr((PPr)lParagraphProperties.get(j).get("pPr"));
                    }
                    tc.getContent().add(p);
                    continue;
                }
                log.debug((Object)"B\u0141\u0104D - problem z utworzeniem komorki tesktowej.");
            }
        }
        log.debug((Object)"Uzupe\u0142nienie warto\u015bci tabelarycznych powiod\u0142o si\u0119.");
    }

    public static String replaceVariablesInTemplate(String sTemplate, Map<String, Object> mVariables, String sVariablesMarker) {
        log.trace((Object)"************************* replaceVariablesInTemplate() ********************");
        String newTemplate = sTemplate;
        log.debug((Object)"Scalanie wez\u0142\u00f3w tekstowych.");
        newTemplate = PrepeareDoc.mergeVariablesTextNodes(newTemplate, sVariablesMarker);
        log.debug((Object)"Scalanie w\u0119z\u0142\u00f3w tesktowych powiod\u0142o si\u0119.");
        log.debug(mVariables);
        log.debug((Object)"Podstawianie zmiennych.");
        for (String s : mVariables.keySet()) {
            Object value = mVariables.get(s);
            if (value == null) continue;
            String tmp = value.toString();
            tmp = tmp.replace("&", "&amp;");
            tmp = tmp.replace("<", "&lt;");
            if ((tmp = tmp.replace(">", "&gt;")).contains("\r\n")) {
                tmp = tmp.replace("\r\n", "</w:t><w:br/><w:t>");
                newTemplate = newTemplate.replace("<w:t>" + sVariablesMarker + s + sVariablesMarker + "</w:t>", "<w:t>" + tmp + "</w:t>");
                continue;
            }
            newTemplate = newTemplate.replace(sVariablesMarker + s + sVariablesMarker, tmp);
        }
        log.debug((Object)"Podstawianie zmiennych powiodlo sie.");
        return newTemplate.replaceAll("Xsuncode-atX", VARIABLE_MARKER);
    }

    public static String mergeVariablesTextNodes(String sTemplate, String sVariablesMarker) {
        log.trace((Object)"************************* mergeVariablesTextNodes(String template, String variablesMarker) ********************");
        StringBuffer mergedString = new StringBuffer(sTemplate);
        int lastIndexOfMarker = 0;
        log.debug((Object)"Wyszukiwanie i scalanie wezlow, kt\u00f3re zosta\u0142y podzielone.");
        while (mergedString.indexOf(sVariablesMarker, lastIndexOfMarker) > 0) {
            int startIndex = mergedString.indexOf(sVariablesMarker, lastIndexOfMarker);
            lastIndexOfMarker = startIndex + 1;
            int endIndex = mergedString.indexOf(sVariablesMarker, lastIndexOfMarker);
            StringBuffer tmp = new StringBuffer(mergedString.substring(startIndex, endIndex + 1));
            while (tmp.indexOf("<") > 0) {
                int newStartIndex = tmp.indexOf("<");
                tmp.deleteCharAt(newStartIndex);
                int newEndIndex = tmp.indexOf(">");
                tmp.deleteCharAt(newEndIndex);
                tmp.delete(newStartIndex, newEndIndex);
            }
            mergedString.replace(startIndex, endIndex + 1, tmp.toString());
            lastIndexOfMarker = mergedString.indexOf(sVariablesMarker, lastIndexOfMarker) + 1;
        }
        log.debug((Object)"Wyszukiwanie i scalanie wezlow, kt\u00f3re zosta\u0142y podzielone powiodlo sie.");
        return mergedString.toString();
    }

    public static File doc2PdfWithoutOO(String sInputFilePathDocx, String sOutputFilePathPdf) {
        log.trace((Object)"************************* doc2PdfWithout(String sInputFilePathDocx, String sOutputFilePathPdf) ********************");
        try {
            log.debug((Object)"\u0141adowanie WMLPackage z pliku: ".concat(sInputFilePathDocx));
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(sInputFilePathDocx));
            if (wordMLPackage != null) {
                log.debug((Object)"\u0141adowanie WMLPackage powiod\u0142o si\u0119.");
                log.debug((Object)"WMLPackage conversion");
                BestMatchingMapper fontMapper = new BestMatchingMapper();
                try {
                    wordMLPackage.setFontMapper((Mapper)fontMapper);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.debug((Object)"B\u0141\u0104D - problem z mapperem!");
                }
                log.debug((Object)"WMLPackage conversion powiod\u0142o si\u0119.");
                log.debug((Object)"Tworzenie pliku .fo");
                File tmp = new File(sInputFilePathDocx + ".fo");
                log.debug((Object)"Tworzenie pliku .fo powiod\u0142o si\u0119.");
                log.debug((Object)"SetSaveFO pliku .fo");
                FOSettings foSettings = Docx4J.createFOSettings();
                foSettings.setFoDumpFile(tmp);
                foSettings.setWmlPackage((OpcPackage)wordMLPackage);
                log.debug((Object)"SetSaveFO powiod\u0142o si\u0119.");
                File outputFilePdf = new File(sOutputFilePathPdf);
                try {
                    log.debug((Object)"Stworzenie FileOutputStream dla pliku: ".concat(sOutputFilePathPdf));
                    FileOutputStream os = new FileOutputStream(outputFilePdf);
                    try {
                        log.debug((Object)"Ustawienie FileOutputStream.");
                        Docx4J.toFO((FOSettings)foSettings, (OutputStream)os, (int)1);
                        log.debug((Object)"Ustawienie FileOutputStream powiod\u0142o si\u0119.");
                    }
                    catch (Throwable e) {
                        log.error((Object)e.getMessage(), e);
                        log.debug((Object)"B\u0141\u0104D - brak pliku, problem z utworzeniem pliku .pdf");
                    }
                    PrepeareDoc.removeBlankPages(sOutputFilePathPdf);
                    log.debug((Object)("Zapisano do " + sOutputFilePathPdf));
                }
                catch (FileNotFoundException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.debug((Object)"B\u0141\u0104D - brak pliku, problem z utworzeniem pliku .pdf");
                }
                if (!tmp.delete()) {
                    log.debug((Object)"B\u0141\u0104D - problem z usuni\u0119ciem pliku .fo");
                }
                return outputFilePdf;
            }
            log.error((Object)"B\u0141\u0104D - przy tworzeniu PdfConversion");
        }
        catch (Docx4JException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)"B\u0141\u0104D - przy tworzeniu wordMLPackage z pliku .docx");
        }
        return null;
    }

    private static void removeBlankPages(String sFilePathPdf) {
        File input = new File(sFilePathPdf);
        try {
            PDDocument doc = PDDocument.load((File)input);
            List list = doc.getDocumentCatalog().getAllPages();
            for (int i = list.size(); i > 0; --i) {
                PDFTextStripper reader = new PDFTextStripper();
                reader.setStartPage(i);
                reader.setEndPage(i);
                String pageText = reader.getText(doc).replaceAll("\\s+", "");
                if (pageText.length() != 0) break;
                doc.removePage((PDPage)list.get(i - 1));
            }
            doc.save(sFilePathPdf);
            log.debug((Object)"Deleting blank pages completed");
        }
        catch (IOException e) {
            log.debug((Object)"ERROR - problem while deleting blank pages from a PDF file");
        }
        catch (COSVisitorException e) {
            log.debug((Object)"ERROR - problem while deleting blank pages from a PDF file");
        }
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters) {
        return PrepeareDoc.createDocAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, lTables, mOptionalParameters, true);
    }

    public static Long createDocAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, HashMap<String, String> hmMappings, List<Map<String, String>> lTables, Map<String, Object> mOptionalParameters, boolean pdf) {
        log.trace((Object)"************************* Long createDocAndSaveInArchive() ********************");
        Calendar c = Calendar.getInstance();
        Long archivePdfFileId = new Long(-1L);
        File f = null;
        try {
            String sVariablesMarker = "";
            log.debug((Object)"Pobieranie znacznika zmiennych - variablesMarker");
            if (mOptionalParameters.containsKey("variablesMarker")) {
                log.debug((Object)"Znacznik zmiennych znajduje si\u0119 w mapie.");
                sVariablesMarker = mOptionalParameters.get("variablesMarker").toString();
                if (!Tools.isNullOrEmpty((String)sVariablesMarker)) {
                    log.debug((Object)"Pobieranie variablesMarker powiod\u0142o si\u0119.");
                    log.debug((Object)"Ustawianie nazwy pliku wyj\u015bciowego");
                    String sOutputFilePath = sInputFilePathOldDocx.replace(".docx", "_" + String.valueOf(c.getTimeInMillis()) + Math.abs(random.nextInt()));
                    sOutputFilePath = sOutputFilePath + (pdf ? ".pdf" : ".docx");
                    String sProcessId = "";
                    if (mOptionalParameters.containsKey("processId")) {
                        sProcessId = (String)mOptionalParameters.get("processId");
                        log.debug((Object)"ProcessId znajduje si\u0119 w mapie mOptionalParameters.");
                        log.debug((Object)sProcessId);
                    }
                    List lWhichTables = null;
                    if (mOptionalParameters.containsKey("whichTables")) {
                        lWhichTables = (List)mOptionalParameters.get("whichTables");
                        log.debug((Object)"lWhichTables znajduje si\u0119 w mapie mOptionalParameters.");
                        log.debug((Object)lWhichTables);
                    }
                    List lWhichHeaders = null;
                    if (mOptionalParameters.containsKey("whichHeaders")) {
                        lWhichHeaders = (List)mOptionalParameters.get("whichHeaders");
                        log.debug((Object)"lWhichHeaders znajduje si\u0119 w mapie mOptionalParameters.");
                        log.debug((Object)lWhichHeaders);
                    }
                    HashMap<String, Object> mMappingsTmp = new HashMap<String, Object>();
                    mMappingsTmp.putAll(hmMappings);
                    log.debug(mMappingsTmp);
                    log.debug((Object)"Generowanie dokumentu z szablonu .docx");
                    f = PrepeareDoc.prepareDocument(sInputFilePathOldDocx, sOutputFilePath, mMappingsTmp, lTables, sVariablesMarker, sProcessId, lWhichTables, lWhichHeaders, pdf);
                    log.debug((Object)"Generowanie dokumentu z szablonu .docx powiod\u0142o si\u0119.");
                    if (f != null && f.length() > 0L) {
                        log.debug((Object)"Dokumentu wygenerowa\u0142 si\u0119.");
                        String documentNewVersion = "FALSE";
                        if (mOptionalParameters.containsKey("documentNewVersion")) {
                            documentNewVersion = mOptionalParameters.get("documentNewVersion").toString();
                            log.debug((Object)"documentNewVersion znajduje si\u0119 w mapie mOptionalParameters.");
                            log.debug((Object)documentNewVersion);
                        }
                        String documentDescription = sOutputDocClassName;
                        if (mOptionalParameters.containsKey("documentDescription")) {
                            documentDescription = mOptionalParameters.get("documentDescription").toString();
                            log.debug((Object)"documentDescription znajduje si\u0119 w mapie mOptionalParameters.");
                            log.debug((Object)documentDescription);
                        }
                        String[] asIndices = new String[]{};
                        if (mOptionalParameters.containsKey("documentIndices")) {
                            asIndices = (String[])mOptionalParameters.get("documentIndices");
                            log.debug((Object)"documentIndices znajduje si\u0119 w mapie mOptionalParameters.");
                            log.debug((Object)asIndices);
                        }
                        log.debug((Object)"Pod\u0142\u0105czanie dokumentu do archiwum.");
                        archivePdfFileId = new Long(ArchiveServices.AddFileToArchive(sOutputDocClassName, asIndices, f, documentDescription, documentNewVersion, "admin"));
                        if (archivePdfFileId >= 0L) {
                            log.debug((Object)"Pod\u0142\u0105czenie dokumentu powiod\u0142o si\u0119. Id = ".concat(String.valueOf(archivePdfFileId)));
                        } else {
                            log.error((Object)"Problem z pod\u0142\u0105czeniem dokumentu do archiwum (id < 0)");
                        }
                        if (!f.delete()) {
                            log.error((Object)"B\u0141\u0104D - Problem z usuni\u0119ciem pliku - mo\u017ce jest otwarty");
                        }
                    } else {
                        log.error((Object)"B\u0141\u0104D - Nie utworzy\u0142 si\u0119 plik .pdf");
                        if (f != null) {
                            f.delete();
                        }
                    }
                } else {
                    log.error((Object)"B\u0141\u0104D - variablesMarker jest null lub jest pusty");
                }
            } else {
                log.error((Object)"B\u0141\u0104D - mapa optionalParameters nie posiada koniecznego klucza: variablesMarker");
            }
        }
        catch (Exception e) {
            FileUtils.deleteQuietly(f);
            archivePdfFileId = new Long(-1L);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return archivePdfFileId;
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, final String sProcessId, Map<String, Object> mOptionalParameters) {
        HashMap<String, String> hmMappings = new HashMap<String, String>();
        Long lDocId = new Long(-1L);
        try {
            if (!Tools.isNullOrEmpty((String)sProcessId)) {
                log.debug((Object)"Dodawanie sProcessId do mapy mOptionalParameters. sProcessId = ".concat(sProcessId));
                mOptionalParameters.put("processId", sProcessId);
                log.debug((Object)"Pobieranie mapy kontekstowej procesu - GetProcessContextMap.");
                Map mContextMap = (Map)new SharkTransactionTemplate().execute((SharkTransactionCallback)new SharkTransactionCallback<Map<String, Object>>(){

                    public Map<String, Object> doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                        return SharkClientFunctions.getProcessContextMap(transaction, sProcessId);
                    }
                });
                if (mContextMap != null && mContextMap.size() > 0) {
                    for (String key : mContextMap.keySet()) {
                        hmMappings.put(key, String.valueOf(mContextMap.get(key)));
                    }
                    lDocId = PrepeareDoc.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, null, mOptionalParameters);
                } else {
                    log.error((Object)"B\u0141AD - problem z pobieraniem mapy konekstowej procesu - mapa jest r\u00f3wna null lub nie zawiera element\u00f3w.");
                }
            } else {
                log.error((Object)"B\u0141\u0104D - sProcessId jest r\u00f3wne null lub puste.");
            }
        }
        catch (Exception e) {
            lDocId = new Long(-1L);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return lDocId;
    }

    public static Long createPdfAndSaveInArchive(String sInputFilePathOldDocx, String sOutputDocClassName, Map<String, Object> mMappings, String sProcessId, Map<String, Object> mOptionalParameters) {
        HashMap<String, String> hmMappings = new HashMap<String, String>();
        Long lDocId = new Long(-1L);
        try {
            if (!Tools.isNullOrEmpty((String)sProcessId)) {
                log.debug((Object)"Dodawanie sProcessId do mapy mOptionalParameters. sProcessId = ".concat(sProcessId));
                mOptionalParameters.put("processId", sProcessId);
                for (String key : mMappings.keySet()) {
                    hmMappings.put(key, String.valueOf(mMappings.get(key)));
                }
                lDocId = PrepeareDoc.createPdfAndSaveInArchive(sInputFilePathOldDocx, sOutputDocClassName, hmMappings, null, mOptionalParameters);
            } else {
                log.error((Object)"B\u0141\u0104D - sProcessId jest r\u00f3wne null lub puste.");
            }
        }
        catch (Exception e) {
            lDocId = new Long(-1L);
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return lDocId;
    }
}

