/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure.helper;

import com.suncode.cuf.plannedtask.administration.structure.exception.StructureValidationException;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.util.CUFFactory;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.exception.ServiceException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class StructureValidator {
    @Autowired
    private UserService us;
    @Autowired
    private OrganizationalUnitFinder ouFinder;
    @Autowired
    private PositionFinder posFinder;
    Set<String> usersExisting = new HashSet<String>();
    Set<String> groupsExisting = new HashSet<String>();
    Set<String> ouExisting = new HashSet<String>();
    Set<String> posExisting = new HashSet<String>();
    Set<String> dirPos = new HashSet<String>();

    public void validateStructure(StructureData sd) {
        int i = 1;
        try {
            this.validateGroups(sd.getGroups());
            this.validateOrgUnits(sd.getOrgUnits());
            this.validatePosition(sd.getPositions());
            this.validateUsers(sd.getUsers());
        }
        catch (ServiceException e) {
            throw new ServiceException("Wiersz: " + i, (Throwable)e);
        }
    }

    private void validateUsers(List<Map<String, String>> users) {
        for (Map<String, String> map : users) {
            String userName = map.get("userName");
            String groups = map.get("groups");
            String positions = map.get("positions");
            if (StringUtils.isBlank((String)userName)) {
                throw new StructureValidationException("UserName can't be null");
            }
            if (StringUtils.isBlank((String)groups)) {
                throw new StructureValidationException("User groups can't be empty");
            }
            this.checkGroups(groups);
            if (!StringUtils.isNotBlank((String)positions)) continue;
            this.checkPositions(positions);
        }
    }

    private void checkPositions(String positions) {
        String[] symbols;
        for (String symbol : symbols = positions.split(";")) {
            if (this.positionExist(symbol)) continue;
            throw new StructureValidationException("Position not found: " + symbol);
        }
    }

    private void validatePosition(List<Map<String, String>> positions) {
        HashSet<String> hpos = new HashSet<String>();
        for (Map<String, String> map : positions) {
            String symbol = map.get("symbol");
            String higherPosition = map.get("higherPosition");
            String orgUnit = map.get("orgUnit");
            String roles = map.get("roles");
            if (StringUtils.isBlank((String)symbol)) {
                throw new StructureValidationException("Position symbol can't be null");
            }
            if (StringUtils.isNotBlank((String)higherPosition)) {
                hpos.add(higherPosition);
            }
            if (StringUtils.isNotBlank((String)orgUnit) && !this.ouExist(orgUnit)) {
                throw new StructureValidationException("OrgUnit not found: " + orgUnit);
            }
            this.checkRole(roles);
            this.posExisting.add(symbol);
        }
        for (String hou : hpos) {
            if (this.positionExist(hou)) continue;
            throw new StructureValidationException("Higher position not found: " + hou);
        }
    }

    private boolean positionExist(String symbol) {
        return this.posExisting.contains(symbol) || this.posFinder.findBySymbol(symbol, new String[0]) != null;
    }

    private boolean ouExist(String symbol) {
        return this.ouExisting.contains(symbol) || this.ouFinder.findBySymbol(symbol, new String[0]) != null;
    }

    private void validateOrgUnits(List<Map<String, String>> orgUnits) {
        HashSet<String> hous = new HashSet<String>();
        for (Map<String, String> map : orgUnits) {
            String symbol = map.get("symbol");
            String higherOrgUnit = map.get("higherOrgUnit");
            String directorPosition = map.get("directorPosition");
            if (StringUtils.isBlank((String)symbol)) {
                throw new StructureValidationException("OrgUnit symbol can't be null");
            }
            if (StringUtils.isNotBlank((String)higherOrgUnit)) {
                hous.add(higherOrgUnit);
            }
            if (StringUtils.isNotBlank((String)directorPosition)) {
                this.dirPos.add(directorPosition);
            }
            this.ouExisting.add(symbol);
        }
        for (String hou : hous) {
            if (this.ouExist(hou)) continue;
            throw new StructureValidationException("Higher OrgUnit not found: " + hou);
        }
    }

    private void validateGroups(List<Map<String, String>> list) {
        for (Map<String, String> map : list) {
            String name = map.get("name");
            if (StringUtils.isBlank((String)name)) {
                throw new StructureValidationException("Group name can't be null");
            }
            this.groupsExisting.add(name);
        }
    }

    private void checkGroups(String groups) {
        String[] roles;
        for (String role : roles = groups.split(";")) {
            if (this.groupExist(role)) continue;
            throw new StructureValidationException("Group not found: " + role);
        }
    }

    private boolean groupExist(String groupName) {
        if (this.groupsExisting.contains(groupName)) {
            return true;
        }
        UserGroup u = this.us.getGroup(groupName, new String[0]);
        return u != null;
    }

    private void checkRole(String sRoles) {
        if (!StringUtils.isEmpty((String)sRoles)) {
            String[] roles;
            for (String role : roles = sRoles.split(";")) {
                Role r = this.getRole(role);
                if (r != null) continue;
                throw new ServiceException("Rola o id: " + role + " nie istnieje w systemie.");
            }
        }
    }

    private Role getRole(String roleId) {
        return CUFFactory.getRoleHelper().getRole(roleId);
    }
}

