/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.DuplicatedColumnException;
import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.io.office.model.SheetDefinition;
import com.suncode.cuf.io.office.model.reader.ValueReader;
import com.suncode.cuf.io.office.model.reader.ValueReaderResolver;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader {
    private String[] keys;
    private String[] headers;
    private static final Logger log = LoggerFactory.getLogger(ExcelReader.class);
    private FormulaEvaluator evaluator;
    private boolean skipEmptyRows = true;

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.skipEmptyRows = skipEmptyRows;
    }

    public SheetDefinition readFirstSheet(InputStream is) {
        Workbook wb = this.buildWorkbook(is);
        Sheet sheet = wb.getSheetAt(0);
        return this.readSheet(sheet, new ImportSheetDefinition(sheet.getSheetName()));
    }

    public SheetDefinition readSheet(String name, InputStream is) {
        Workbook wb = this.buildWorkbook(is);
        Sheet sheet = wb.getSheet(name);
        return this.readSheet(sheet, new ImportSheetDefinition(name));
    }

    public List<SheetDefinition> read(List<ImportSheetDefinition> importDef, InputStream is) {
        ArrayList<SheetDefinition> sheets = new ArrayList<SheetDefinition>();
        Workbook wb = this.buildWorkbook(is);
        for (ImportSheetDefinition def : importDef) {
            String sheetName = def.getName();
            SheetDefinition sheetData = this.readSheet(wb.getSheet(sheetName), def);
            sheets.add(sheetData);
        }
        return sheets;
    }

    public List<SheetDefinition> readAllSheets(InputStream is) {
        ArrayList<SheetDefinition> sheets = new ArrayList<SheetDefinition>();
        Workbook wb = this.buildWorkbook(is);
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            String sheetName = wb.getSheetName(i);
            SheetDefinition sheetData = this.readSheet(wb.getSheet(sheetName), new ImportSheetDefinition(sheetName));
            sheets.add(sheetData);
        }
        return sheets;
    }

    private Workbook buildWorkbook(InputStream is) {
        try {
            Workbook wb = WorkbookFactory.create((InputStream)is);
            this.evaluator = wb.getCreationHelper().createFormulaEvaluator();
            return wb;
        }
        catch (Exception e) {
            throw new CUFServiceException(e);
        }
    }

    private SheetDefinition readSheet(Sheet sheet, ImportSheetDefinition importSheet) {
        log.debug("Sheet name: {}", (Object)sheet.getSheetName());
        log.debug("Reading...");
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        int colCount = this.getColumnCount(sheet, importSheet.getMappings());
        int rowCount = sheet.getPhysicalNumberOfRows();
        for (int i = 1; i < rowCount; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                log.warn("Row {} is null. End reading.", (Object)i);
                break;
            }
            Map<String, Object> rowData = this.readRow(row, colCount, importSheet);
            if (this.skipEmptyRows && this.isEmpty(rowData)) {
                log.debug("Row {} is empty and property 'skipEmptyRows' is true: skipping", (Object)i);
                continue;
            }
            data.add(rowData);
        }
        log.debug("End reading form Excel. Data size: {}", (Object)data.size());
        return new SheetDefinition(sheet.getSheetName(), data, this.headers);
    }

    private boolean isEmpty(Map<String, Object> row) {
        for (Object value : row.values()) {
            if (this.isCellEmpty(value)) continue;
            return false;
        }
        return true;
    }

    private boolean isCellEmpty(Object cellValue) {
        if (cellValue == null) {
            return true;
        }
        return cellValue instanceof String && StringUtils.isBlank((CharSequence)((String)cellValue));
    }

    private Map<String, Object> readRow(Row row, int colCount, ImportSheetDefinition importSheet) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        for (int i = 0; i < colCount; ++i) {
            Cell cell = row.getCell(i);
            String key = this.keys[i];
            String header = this.headers[i];
            if (hm.containsKey(key)) {
                throw new DuplicatedColumnException(key, header);
            }
            log.debug("Column [{}] Row [{}]", (Object)header, (Object)row.getRowNum());
            if (cell != null) {
                ValueReader reader = importSheet.getValueReaders().get(header);
                if (reader == null) {
                    reader = ValueReaderResolver.getInstance().resolve(cell.getCellType(), cell);
                }
                Object value = reader.readCellValue(cell.getCellType(), cell, this.evaluator.evaluate(cell), reader);
                hm.put(key, value);
                continue;
            }
            log.debug("Cell is empty");
            hm.put(key, null);
        }
        return hm;
    }

    private int getColumnCount(Sheet sheet, Map<String, String> mappings) {
        Cell c;
        Row row = sheet.getRow(0);
        int columnCount = 0;
        for (int i = 0; i < row.getLastCellNum() && (c = row.getCell(i)) != null && c.getCellType() == 1 && !StringUtils.isBlank((CharSequence)c.getStringCellValue()); ++i) {
            ++columnCount;
        }
        log.debug("Column count: {}", (Object)columnCount);
        this.initHeaders(row, columnCount);
        this.initKeys(mappings);
        return columnCount;
    }

    private void initKeys(Map<String, String> mappings) {
        boolean hasMappings = mappings != null;
        this.keys = new String[this.headers.length];
        for (int i = 0; i < this.headers.length; ++i) {
            this.keys[i] = hasMappings ? mappings.get(this.headers[i]) : this.headers[i];
        }
    }

    private void initHeaders(Row row, int columnCount) {
        this.headers = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Cell c = row.getCell(i);
            this.headers[i] = c.getStringCellValue();
        }
    }
}

