/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.plusmpm.database.hibernate.HibernateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class ProcessFinder {
    private static Logger log = Logger.getLogger(ProcessFinder.class);
    private final String objIdCol = NativeDatabase.getSharkObjectIdColumnName();

    private String createWhere(Map<String, Object> params) {
        String where = "where p.state<1000006 ";
        if (params.containsKey("processDefId")) {
            where = where + "and pd.processdefinitionid=:processDefId ";
        }
        if (params.containsKey("version")) {
            where = where + "and pd.processdefinitionversion=:version ";
        }
        return where;
    }

    public List<String> findByProcessDefId(Map<String, Object> params) throws Exception {
        ArrayList<String> ids = new ArrayList();
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            String query = "select distinct p.id from processdefinitions pd ";
            query = query + "join processes p on p.processdefinition=pd." + this.objIdCol + " ";
            query = query + this.createWhere(params);
            SQLQuery sql = hs.createSQLQuery(query);
            sql.addScalar("p.id", (Type)StandardBasicTypes.STRING);
            List<String> sqlParams = Arrays.asList(sql.getNamedParameters());
            for (String key : params.keySet()) {
                if (!sqlParams.contains(key)) continue;
                sql.setParameter(key, params.get(key));
            }
            ids = sql.list();
            tx.commit();
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public List<String> getProcessIdByName(String processName) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery("select id from processes where name=:name");
            sql.addScalar("id", (Type)StandardBasicTypes.STRING);
            sql.setString("name", processName);
            List processes = sql.list();
            tx.commit();
            List list = processes;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public List<String> getActivityIdByName(String processId, String activityName) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery("select id from activities where name=:name and processid=:processId ");
            sql.setString("name", activityName);
            sql.setString("processId", processId);
            List acts = sql.list();
            tx.commit();
            List list = acts;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public List<String> findProcessesByIndexes(Map<String, Object> indexes, String processDefId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            String query = "select processid from pm_idx_" + processDefId + " where ";
            String where = this.generateWhereFromIndexes(indexes);
            query = query + where;
            log.debug((Object)("query: " + query));
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery(query);
            List processes = sql.list();
            tx.commit();
            List list = processes;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public Map<String, Object> getProcessContextByIndexes(Map<String, Object> indexes, String processDefId) throws Exception {
        List<String> processes = this.findProcessesByIndexes(indexes, processDefId);
        if (processes.isEmpty()) {
            return null;
        }
        String processId = processes.get(0);
        Map<String, Object> ctx = SharkClientFunctions.getProcessContextMap(processId);
        return ctx;
    }

    private String generateWhereFromIndexes(Map<String, Object> indexes) {
        String where = "";
        for (String id : indexes.keySet()) {
            where = where + " " + id + " = '" + indexes.get(id) + "' and ";
        }
        if (!where.isEmpty()) {
            where = where.substring(0, where.length() - 4);
        }
        return where;
    }
}

