/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.helper.internal;

import com.suncode.cuf.administartion.structure.RoleHelper;
import com.suncode.cuf.plannedtask.administration.helper.ImportStructureMode;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupAlreadyExistException;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.exception.UserAlreadyExistException;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component(value="importStructureOverrideMode")
@Scope(value="prototype")
public class OverrideMode
implements ImportStructureMode {
    private static final Logger log = LoggerFactory.getLogger(OverrideMode.class);
    @Autowired
    private StructureService ss;
    @Autowired
    protected UserService userService;
    @Autowired
    private RoleService rs;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    protected OrganizationalUnitFinder ouFinder;
    @Autowired
    protected PositionFinder positionFinder;
    @Autowired
    private RoleHelper roleHelper;
    @Autowired
    private UserGroupFinder groupFinder;
    private Set<String> userNames = new HashSet<String>();
    private Set<String> positionSymbols = new HashSet<String>();
    private Set<String> ouSymbols = new HashSet<String>();
    private Set<String> groupNames = new HashSet<String>();

    @Override
    public User buildUser(Map<String, String> row, int i, List<Map<String, String>> structure) throws UserNotFoundException, GroupNotFoundException, UserAlreadyExistException, GroupAlreadyExistException {
        List<UserGroup> groups = this.initGroups(row);
        String userName = row.get("userName");
        User user = this.userFinder.findByUserName(userName, false, new String[0]);
        if (user != null) {
            this.setUserData(user, row);
            user = this.updateUser(user, row, groups);
            this.changePassword(user, row.get("password"));
        } else {
            user = new User(userName, this.getPassword(row.get("password")));
            this.setUserData(user, row);
            user = this.createUser(user, groups);
        }
        List<Position> positions = this.buildPositions(user, i, structure);
        this.assignPositionToUser(user, positions);
        user = this.userFinder.findByUserName(userName, new String[]{"positions"});
        return user;
    }

    private String getPassword(String pass) {
        if (StringUtils.isBlank((CharSequence)pass)) {
            return "";
        }
        return pass;
    }

    @Override
    public User updateUser(User user, Map<String, String> data, List<UserGroup> groups) throws UserNotFoundException, GroupNotFoundException {
        this.userNames.add(user.getUserName());
        this.userService.updateUser(user);
        this.userService.addUserToGroups(user.getUserName(), this.toNames(groups));
        this.removeUserFromOtherGroups(user.getUserName(), groups);
        return user;
    }

    @Override
    public void removeUnusedElements() throws GroupNotFoundException {
        this.removeUnusedUsers();
        this.removeUnusedGroups();
        this.removeUnusedPositions();
        this.removeUnuserdOus();
    }

    private void removeUnuserdOus() {
        DetachedCriteria dc = DetachedCriteria.forClass(OrganizationalUnit.class);
        dc.add(Restrictions.not((Criterion)Restrictions.in((String)"symbol", this.positionSymbols)));
        List ous = this.ouFinder.findByCriteria(dc);
        for (OrganizationalUnit ou : ous) {
            this.ss.deleteOrganizationalUnit(ou.getSymbol());
        }
    }

    private void removeUnusedPositions() {
        DetachedCriteria dc = DetachedCriteria.forClass(Position.class);
        dc.add(Restrictions.not((Criterion)Restrictions.in((String)"symbol", this.positionSymbols)));
        List pos = this.positionFinder.findByCriteria(dc);
        for (Position position : pos) {
            this.ss.deletePosition(position.getSymbol());
        }
    }

    private void removeUnusedGroups() throws GroupNotFoundException {
        DetachedCriteria dc = DetachedCriteria.forClass(UserGroup.class);
        dc.add(Restrictions.not((Criterion)Restrictions.in((String)"name", this.groupNames)));
        List groups = this.groupFinder.findByCriteria(dc);
        for (UserGroup userGroup : groups) {
            this.userService.deleteGroup(userGroup.getName());
        }
    }

    private void removeUnusedUsers() {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        dc.add(Restrictions.not((Criterion)Restrictions.in((String)"userName", this.userNames)));
        List users = this.userFinder.findByCriteria(dc);
        for (User user : users) {
            this.userService.deleteUser(user.getUserName());
        }
    }

    void removeUserFromOtherGroups(String userName, List<UserGroup> groups) {
        User user = this.userFinder.findByUserName(userName, new String[]{"groups"});
        ArrayList<String> toRemove = new ArrayList<String>();
        for (UserGroup actual : user.getGroups()) {
            boolean remove = true;
            for (UserGroup ug : groups) {
                if (!actual.getName().equals(ug.getName())) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            toRemove.add(actual.getName());
        }
        this.userService.removeUserFromGroups(userName, toRemove);
    }

    @Override
    public User createUser(User user, List<UserGroup> groups) throws UserAlreadyExistException, GroupNotFoundException {
        this.userNames.add(user.getUserName());
        log.debug("USERNAME: " + user.getUserName());
        this.userService.createUser(user, groups.get(0).getName());
        if (groups.size() > 1) {
            this.userService.addUserToGroups(user.getUserName(), this.toNames(groups.subList(1, groups.size())));
        }
        return user;
    }

    protected List<String> toNames(List<UserGroup> subList) {
        ArrayList<String> names = new ArrayList<String>();
        for (UserGroup ug : subList) {
            names.add(ug.getName());
        }
        this.groupNames.addAll(names);
        return names;
    }

    @Override
    public Position createPosition(String name, String symbol) {
        this.positionSymbols.add(symbol);
        Position p = new Position(name, symbol);
        this.ss.createPosition(p);
        return p;
    }

    @Override
    public OrganizationalUnit createOrganizationalUnit(String name, String symbol) {
        this.ouSymbols.add(symbol);
        OrganizationalUnit ou = new OrganizationalUnit(name, symbol);
        this.ss.createOrganizationalUnit(ou);
        return ou;
    }

    @Override
    public void updatePosition(Position p) {
        this.positionSymbols.add(p.getSymbol());
        this.ss.updatePosition(p);
    }

    @Override
    @Transactional
    public void assignPositionToUser(User user, List<Position> positions) {
        for (Position position : positions) {
            this.ss.addPositionToUser(user.getUserName(), position.getId());
        }
    }

    @Override
    public void changePassword(User user, String pass) {
        if (StringUtils.isNotBlank((CharSequence)pass)) {
            this.userService.changeUserPassword(user.getUserName(), pass);
        }
    }

    @Override
    public UserGroup createGroup(String groupName) throws GroupAlreadyExistException {
        this.groupNames.add(groupName);
        UserGroup ug = new UserGroup(groupName);
        this.userService.createGroup(ug);
        return ug;
    }

    @Override
    @Transactional
    public void addRoles(Position p, List<Role> roles) {
        this.rs.detachAllRoles(p.getId());
        for (Role role : roles) {
            this.rs.addRole(p.getId(), role.getId());
        }
    }

    private void setUserData(User user, Map<String, String> data) {
        user.setEmail(data.get("email"));
        user.setFirstName(data.get("firstName"));
        user.setLastName(data.get("lastName"));
        user.setNumber(data.get("number"));
    }

    private List<UserGroup> initGroups(Map<String, String> row) throws GroupAlreadyExistException {
        String[] groups = row.get("groups").split(";");
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>();
        for (String groupName : groups) {
            UserGroup ug = this.userService.getGroup(groupName, new String[0]);
            if (ug == null) {
                ug = this.createGroup(groupName);
            }
            userGroups.add(ug);
        }
        return userGroups;
    }

    private List<Position> buildPositions(User user, int i, List<Map<String, String>> structure) {
        List<Map<String, String>> userPositions = this.getPositionsForUser(user, i, structure);
        ArrayList<Position> pos = new ArrayList<Position>();
        for (Map<String, String> map : userPositions) {
            Position p;
            if (!this.hasPosition(map) || (p = this.initAssotiations(map)) == null) continue;
            pos.add(p);
        }
        return pos;
    }

    private boolean hasPosition(Map<String, String> map) {
        return !StringUtils.isBlank((CharSequence)map.get("positionSymbol"));
    }

    private Position initAssotiations(Map<String, String> map) {
        OrganizationalUnit ou = this.buildOu(map);
        Position p = this.buildPosition(map, ou);
        this.setRoles(p, map);
        return p;
    }

    Position buildPosition(Map<String, String> map, OrganizationalUnit ou) {
        Position p = this.initPosition(map.get("positionName"), map.get("positionSymbol"));
        Position hp = this.initPosition("", map.get("higherPositionSymbol"));
        p.setHigherPosition(hp);
        p.setOrganizationalUnit(ou);
        this.updatePosition(p);
        return p;
    }

    private void setRoles(Position p, Map<String, String> map) {
        if (p == null) {
            return;
        }
        List<Role> roles = this.getRoles(map.get("roles"));
        if (!roles.isEmpty()) {
            this.addRoles(p, roles);
        }
    }

    private List<Role> getRoles(String sRoles) {
        if (StringUtils.isBlank((CharSequence)sRoles)) {
            return new ArrayList<Role>();
        }
        String[] roleIds = sRoles.split(";");
        ArrayList<Role> roles = new ArrayList<Role>();
        for (String roleId : roleIds) {
            Role r = this.roleHelper.getRole(roleId);
            Assert.notNull((Object)r, (String)"Rola nie mo\u017ce by\u0107 pusta");
            roles.add(r);
        }
        return roles;
    }

    OrganizationalUnit buildOu(Map<String, String> map) {
        OrganizationalUnit ou = this.initOrganizationalUnit(map.get("organizationalUnitName"), map.get("organizationalUnitSymbol"));
        if (ou != null) {
            Position dp = this.initPosition("", map.get("directorPositionSymbol"));
            OrganizationalUnit hou = this.initOrganizationalUnit("", map.get("higherOrganizationalUnitSymbol"));
            ou.setHigherOrganizationalUnit(hou);
            ou.setDirectorPosition(dp);
            this.ss.updateOrganizationalUnit(ou);
        }
        return ou;
    }

    private Position initPosition(String name, String symbol) {
        if (StringUtils.isBlank((CharSequence)symbol)) {
            return null;
        }
        Position p = this.positionFinder.findBySymbol(symbol, new String[0]);
        if (p == null) {
            p = this.createPosition(name, symbol);
        } else {
            this.positionSymbols.add(symbol);
        }
        return p;
    }

    private OrganizationalUnit initOrganizationalUnit(String name, String symbol) {
        if (StringUtils.isBlank((CharSequence)symbol)) {
            return null;
        }
        OrganizationalUnit ou = this.ouFinder.findBySymbol(symbol, new String[0]);
        if (ou == null) {
            ou = this.createOrganizationalUnit(name, symbol);
        } else {
            this.ouSymbols.add(symbol);
        }
        return ou;
    }

    private List<Map<String, String>> getPositionsForUser(User user, int i, List<Map<String, String>> structure) {
        ArrayList<Map<String, String>> userPositions = new ArrayList<Map<String, String>>();
        while (structure.size() > i && structure.get(i).get("userName").equals(user.getUserName())) {
            userPositions.add(structure.get(i));
            ++i;
        }
        return userPositions;
    }
}

