/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.form.datachooser;

import com.plusmpm.util.form.datachooser.DataChooser;
import com.plusmpm.util.form.datachooser.StandardDataChooser;
import com.suncode.cuf.form.datachooser.definition.UserChooserDef;
import com.suncode.cuf.form.datachooser.internal.UserCriteria;
import com.suncode.cuf.form.datachooser.internal.UserObjDef;
import com.suncode.cuf.util.CUFFactory;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.FinderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.DetachedCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StandardDataChooser(conf=UserChooserDef.class)
public class UserChooser
implements DataChooser {
    private static final Logger log = LoggerFactory.getLogger(UserChooser.class);
    private int size;

    public int getDataChooserResultSize(Map<String, String> mCriteria, Map<String, String> mCustomKeys) {
        return this.size;
    }

    public List<Map<String, String>> getDataChooserResult(int start, int limit, String orderProperty, String orderDir, Map<String, String> mCriteria, Map<String, String> mCustomKeys) {
        List<UserObjDef> users = this.findUsers(start, limit, orderProperty, orderDir, mCriteria, mCustomKeys);
        List<Map<String, String>> convertedUsers = this.convertUsers(users);
        return convertedUsers;
    }

    private List<Map<String, String>> convertUsers(List<UserObjDef> users) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (UserObjDef user : users) {
            HashMap<String, String> map = new HashMap<String, String>();
            User u = user.getUser();
            map.put("userName", u.getUserName());
            map.put("firstName", u.getFirstName());
            map.put("lastName", u.getLastName());
            map.put("fullName", StringUtils.trimToEmpty((String)u.getFullName()));
            map.put("reverseName", this.reverseName(u));
            map.put("email", u.getEmail());
            if (user.getOus() != null) {
                map.put("orgUnit", this.toString(user.getOus()));
            }
            if (user.getSuperiors() != null) {
                this.addSuperiors(map, user.getSuperiors());
            }
            list.add(map);
        }
        return list;
    }

    private String reverseName(User u) {
        String s = StringUtils.trimToEmpty((String)u.getLastName()) + " " + StringUtils.trimToEmpty((String)u.getFirstName());
        return StringUtils.trimToEmpty((String)s);
    }

    private void addSuperiors(Map<String, String> map, List<User> superiors) {
        StringBuilder logins = new StringBuilder();
        StringBuilder names = new StringBuilder();
        for (User user : superiors) {
            logins.append(user.getUserName());
            logins.append(";");
            names.append(StringUtils.trimToEmpty((String)user.getFullName()));
            names.append(",");
        }
        if (logins.length() > 0) {
            logins.setLength(logins.length() - 1);
        }
        if (names.length() > 0) {
            names.setLength(names.length() - 1);
        }
        map.put("superiors", logins.toString());
        map.put("superiorsNames", names.toString());
    }

    private String toString(List<OrganizationalUnit> ous) {
        if (ous == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (OrganizationalUnit ou : ous) {
            sb.append(ou.getName());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private List<UserObjDef> findUsers(int start, int limit, String orderProperty, String orderDir, Map<String, String> mCriteria, Map<String, String> mCustomKeys) {
        UserCriteria uc = new UserCriteria(mCriteria, mCustomKeys);
        DetachedCriteria dc = uc.buildCriteria(new Sorter(orderProperty, SortDirection.valueOf((String)orderDir.toUpperCase())));
        List users = FinderFactory.getUserFinder().findByCriteria(dc, Integer.valueOf(start), Integer.valueOf(limit));
        List<UserObjDef> us = this.toUserObjDef(users);
        this.attachOu(us, uc);
        this.attachSuperiors(us, uc);
        dc = uc.buildCriteria();
        this.size = (int)FinderFactory.getUserFinder().count(dc);
        return us;
    }

    private List<UserObjDef> toUserObjDef(List<User> users) {
        ArrayList<UserObjDef> list = new ArrayList<UserObjDef>();
        for (User user : users) {
            list.add(new UserObjDef(user));
        }
        return list;
    }

    private void attachOu(List<UserObjDef> users, UserCriteria uc) {
        if (!uc.isJoinOrgUnits()) {
            return;
        }
        for (UserObjDef userObjDef : users) {
            String userName = userObjDef.getUser().getUserName();
            List ous = FinderFactory.getOrganizationalUnitFinder().findByUserName(userName, new String[0]);
            log.debug("Znaleziono " + ous.size() + " jednostek dla u\u017cytkownika: " + userName);
            userObjDef.setOus(ous);
        }
    }

    private void attachSuperiors(List<UserObjDef> users, UserCriteria uc) {
        if (!uc.isJoinSuperiors()) {
            return;
        }
        for (UserObjDef userObjDef : users) {
            String userName = userObjDef.getUser().getUserName();
            List<User> superiors = CUFFactory.getUserHelper().findSuperiors(userName);
            log.debug("Znaleziono " + superiors.size() + " prze\u0142o\u017conych dla u\u017cytkownika: " + userName);
            userObjDef.setSuperiors(superiors);
        }
    }
}

