/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.administartion.user.internal;

import com.suncode.cuf.administartion.user.UserHelper;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.util.QueryExecutor;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class UserHelperImpl
implements UserHelper {
    @Autowired
    private QueryExecutor qu;
    @Autowired
    private UserFinder userFinder;

    @Override
    @Transactional
    public List<String> getUsersInOusWithRoles(List<Long> ouIds, List<String> roleIds) {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        dc.createAlias("positions", "positions");
        dc.createAlias("positions.organizationalUnit", "positions.organizationalUnit");
        dc.createAlias("positions.roles", "positions.roles");
        dc.add(Restrictions.in((String)"positions.roles.roleId", roleIds));
        dc.add(Restrictions.in((String)"positions.organizationalUnit.id", ouIds));
        ProjectionList pl = Projections.projectionList();
        pl = pl.add((Projection)Projections.property((String)"userId"));
        dc.setProjection(Projections.distinct((Projection)pl));
        dc.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List ouNames = this.qu.findByCriteria(dc);
        return ouNames;
    }

    @Override
    @Transactional
    public List<User> findSuperiors(String userName) {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class, (String)"superior");
        dc.createAlias("superior.positions", "position");
        dc.createAlias("position.subPositions", "subposition");
        dc.createAlias("subposition.user", "user");
        dc.add((Criterion)Restrictions.eq((String)"user.userName", (Object)userName));
        return this.userFinder.findByCriteria(dc);
    }
}

