/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.google.gson.Gson;
import com.plusmpm.CUF.database.currencyExchangeRates.CurrencyExchangeRate;
import com.plusmpm.CUF.database.currencyExchangeRates.CurrencyExchangeRateManager;
import com.plusmpm.util.Tools;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CurrencyRateCalculator
extends HttpServlet {
    public static Logger log = Logger.getLogger(CurrencyRateCalculator.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void init() throws ServletException {
        super.init();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String dateFormat = req.getParameter("dateFormat");
        String sDate = req.getParameter("date");
        String code = req.getParameter("code");
        String sAmount = req.getParameter("amount");
        String sDayBefore = req.getParameter("dayBefore");
        boolean dayBefore = Boolean.valueOf(sDayBefore);
        JsonMsg msg = new JsonMsg();
        if (Tools.isNullOrEmpty((String)dateFormat)) {
            dateFormat = "yyyy-MM-dd";
        }
        sAmount = sAmount.replace(",", ".");
        PrintWriter pw = resp.getWriter();
        Gson gson = new Gson();
        try {
            double amount = Double.valueOf(sAmount);
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            try {
                Date date = format.parse(sDate);
                if (dayBefore) {
                    date = new Date(date.getTime() - TimeUnit.DAYS.toMillis(1L));
                }
                try {
                    CurrencyExchangeRate cer = CurrencyExchangeRateManager.getCurrencyRate(date, new Date(date.getTime() + TimeUnit.DAYS.toMillis(1L)), code);
                    if (cer != null) {
                        double result = amount * (double)cer.getConversion() * cer.getRate();
                        msg.status = 0;
                        msg.msg = "Warto\u015b\u0107 zosta\u0142a wyliczona pomy\u015blnie";
                        msg.value = result;
                        msg.date = format.format(cer.getDate());
                        msg.conversion = cer.getConversion();
                        msg.rate = cer.getRate();
                        pw.print(gson.toJson((Object)msg));
                    } else {
                        log.error((Object)"Nie znaleziono kursu o podanych parametrach.");
                        msg.status = (byte)-1;
                        msg.msg = "Nie znaleziono kursu o podanych parametrach.";
                        msg.value = amount;
                        pw.print(gson.toJson((Object)msg));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"B\u0142\u0105d podczas pobierania kursu.");
                    log.error((Object)e);
                    msg.status = (byte)-2;
                    msg.msg = "B\u0142\u0105d podczas pobierania kursu.";
                    msg.value = amount;
                    pw.print(gson.toJson((Object)msg));
                }
            }
            catch (ParseException e) {
                log.error((Object)"Nieprawid\u0142owy format daty.");
                log.error((Object)e);
                msg.status = (byte)-3;
                msg.msg = "Nieprawid\u0142owy format daty.";
                msg.value = amount;
                pw.print(gson.toJson((Object)msg));
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"Podana kwota nie jest liczb\u0105.");
            log.error((Object)e);
            msg.status = (byte)-4;
            msg.msg = "Podana kwota nie jest liczb\u0105.";
            msg.value = 0.0;
            pw.print(gson.toJson((Object)msg));
        }
    }

    class JsonMsg {
        byte status;
        String msg;
        double value;
        String date;
        double rate;
        double conversion;
    }
}

