/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.cuf.automatictask.mail.SendMailReceiver;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityEntity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.internal.toolagent.AppParameter;

public class SendMail {
    private static Logger logger = Logger.getLogger(SendMail.class);
    private static Map<String, String> smtpConf = null;

    public static void execute(AppParameter subject, AppParameter template, AppParameter json, AppParameter attachments, AppParameter processId) throws Exception {
        smtpConf = SendMail.getSmtpConfiguration();
        String sSubject = subject.the_value.toString();
        String sTemplate = template.the_value.toString();
        String sJson = json.the_value.toString();
        Boolean bAttachments = Boolean.valueOf(attachments.the_value.toString());
        ProcessService processService = ServiceFactory.getProcessService();
        Process process = processService.getProcess(processId.the_value.toString(), new String[]{"processDefinition"});
        Map processContext = processService.getProcessContext(process.getProcessId());
        ArrayList<WfDocument> listAttachments = new ArrayList();
        if (bAttachments.booleanValue()) {
            DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
            listAttachments = documentFinder.getDocumentsFromProcess(process.getProcessId(), new String[0]);
        }
        Collection collectionReceivers = null;
        try {
            collectionReceivers = (Collection)new ObjectMapper().readValue(sJson, (TypeReference)new TypeReference<Collection<SendMailReceiver>>(){});
        }
        catch (IOException e) {
            throw new IllegalArgumentException("B\u0142\u0119dna lista adresat\u00f3w: " + sJson);
        }
        String sParsedContent = SendMail.replaceExpressions(SendMail.getHtmlFromTemplate(sTemplate), processContext);
        String sParsedSubject = SendMail.replaceExpressions(sSubject, processContext);
        ArrayList<String> listMailsCompleted = new ArrayList<String>();
        for (SendMailReceiver receiver : collectionReceivers) {
            switch (receiver.getType()) {
                case EMAIL: {
                    SendMail.sendToAddress(receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case USER: {
                    SendMail.sendToUser(receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case GROUP: {
                    SendMail.sendToGroup(receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case ROLE: {
                    SendMail.sendToRole(process.getProcessDefinition().getPackageId(), process.getProcessDefinition().getProcessDefinitionId(), receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case POSITION_BY_NAME: {
                    SendMail.sendToPositionByName(receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case POSITION_BY_SYMBOL: {
                    SendMail.sendToPositionBySymbol(receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case EXECUTOR: {
                    SendMail.sendToExecutor(process.getProcessId(), receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case OU_BY_NAME: {
                    SendMail.sendToOuByName(receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case OU_BY_SYMBOL: {
                    SendMail.sendToOuBySymbol(receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case VAR_EMAIL: {
                    SendMail.sendToEmailsInVariable(process.getProcessId(), receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                    break;
                }
                case VAR_USER: {
                    SendMail.sendToUsersInVariable(process.getProcessId(), receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted);
                }
            }
        }
    }

    private static Map<String, String> getSmtpConfiguration() {
        String[] parameters;
        HashMap<String, String> smtpConf = new HashMap<String, String>();
        for (String param : parameters = new String[]{"SMTPMailServer", "SMTPPortNo", "SMTPAuth", "UseSTARTTLS", "Email", "UserPassword"}) {
            smtpConf.put(param, Shark.getInstance().getProperties().getProperty("DefaultMailMessageHandler." + param));
        }
        return smtpConf;
    }

    private static String getHtmlFromTemplate(String sTemplate) throws FileNotFoundException {
        String htmlContent = null;
        try {
            htmlContent = new Scanner(new File(sTemplate)).useDelimiter("\\Z").next();
        }
        catch (IOException e) {
            throw new FileNotFoundException("Niepoprawna \u015bcie\u017cka do szablonu: " + sTemplate);
        }
        return htmlContent;
    }

    private static String replaceExpressions(String sData, Map<String, Object> mapProcessContext) {
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        ActivityService activityService = ServiceFactory.getActivityService();
        ProcessService processService = ServiceFactory.getProcessService();
        Activity activity = activityService.getActivity(mapProcessContext.get("ProccessId").toString(), mapProcessContext.get("ActivityId").toString(), new String[0]);
        Process process = processService.getProcess(mapProcessContext.get("ProccessId").toString(), new String[]{"processDefinition"});
        List listActivities = activityFinder.findByProcessId(process.getProcessId(), new String[0]);
        Date processStartTime = null;
        for (Activity act : listActivities) {
            if (processStartTime != null && !act.getLastStateTime().after(processStartTime) || !act.getState().equals((Object)ActivityState.COMPLETED)) continue;
            processStartTime = act.getLastStateTime();
            activity = act;
        }
        HashMap<String, Object> mapExpressions = new HashMap<String, Object>();
        mapExpressions.put("processname", process.getDescription());
        mapExpressions.put("processdescription", process.getDescription());
        mapExpressions.put("processtype", process.getProcessDefinition().getProcessDefinitionId());
        mapExpressions.put("processstarttime", new SimpleDateFormat("HH:mm").format(processStartTime));
        mapExpressions.put("processstartday", new SimpleDateFormat("dd-MM-yyy").format(processStartTime));
        mapExpressions.put("activityname", activity.getName());
        mapExpressions.put("activitystarttime", new SimpleDateFormat("HH:mm").format(activity.getCreatedTime()));
        mapExpressions.put("activitystartday", new SimpleDateFormat("dd-MM-yyyy").format(activity.getCreatedTime()));
        mapExpressions.putAll(SendMail.getRealUsersName(sData, process.getProcessId()));
        mapExpressions.putAll(SendMail.getTaskUsers(sData, process.getProcessId()));
        mapExpressions.putAll(SendMail.getLinks(sData, process.getProcessId()));
        mapExpressions.putAll(mapProcessContext);
        for (String str : mapExpressions.keySet()) {
            sData = sData.replaceAll("@" + str + "@", mapExpressions.get(str).toString());
        }
        return sData;
    }

    private static Map<String, String> getRealUsersName(String sData, String sProcessId) {
        ProcessService processService = ServiceFactory.getProcessService();
        UserService userService = ServiceFactory.getUserService();
        Map mapProcessContext = processService.getProcessContext(sProcessId);
        HashMap<String, String> mapRealUsersName = new HashMap<String, String>();
        int fromIndex = 0;
        while (sData.indexOf("@realusername#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@realusername#", fromIndex) + "@realusername#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sProcessVariable = sData.substring(beginIndex, endIndex);
            try {
                String sUserName = mapProcessContext.get(sProcessVariable).toString();
                if (sUserName.length() <= 0) continue;
                try {
                    String sUserFullName = userService.getUser(sUserName, new String[0]).getFullName();
                    mapRealUsersName.put("realusername#" + sProcessVariable, sUserFullName);
                }
                catch (NullPointerException e) {
                    mapRealUsersName.put("realusername#" + sProcessVariable, "@u\u017cytkownik nie istnieje!@");
                }
            }
            catch (NullPointerException e) {
                mapRealUsersName.put("realusername#" + sProcessVariable, "@realusername#" + sProcessVariable + ": (brak zmiennej w procesie)@");
            }
        }
        return mapRealUsersName;
    }

    private static Map<String, String> getTaskUsers(String sData, String sProcessId) {
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        ActivityService activityService = (ActivityService)SpringContext.getBean(ActivityService.class);
        UserService userService = ServiceFactory.getUserService();
        List listActivity = activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapTaskUsers = new HashMap<String, String>();
        int fromIndex = 0;
        while (sData.indexOf("@taskuser#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@taskuser#", fromIndex) + "@taskuser#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sActivityDefId = sData.substring(beginIndex, endIndex);
            String sActivityId = null;
            for (Activity activity : listActivity) {
                if (!activity.getActivityDefinitionId().equals(sActivityDefId)) continue;
                sActivityId = activity.getActivityId();
                break;
            }
            ActivityEntity activity = (ActivityEntity)activityService.getActivity(sProcessId, sActivityId, new String[0]);
            User user = userService.getUser(activity.getResourceId(), new String[0]);
            mapTaskUsers.put("taskuser#" + sActivityDefId, user.getFullName());
        }
        return mapTaskUsers;
    }

    private static Map<String, String> getLinks(String sData, String sProcessId) {
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        List listActivity = activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapLinks = new HashMap<String, String>();
        String sHttpLink = Shark.getInstance().getProperties().getProperty("HTTPLink");
        int fromIndex = 0;
        while (sData.indexOf("@link#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@link#", fromIndex) + "@link#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sActivityDefId = sData.substring(beginIndex, endIndex);
            String sActivityId = null;
            for (Activity activity : listActivity) {
                if (!activity.getActivityDefinitionId().equals(sActivityDefId)) continue;
                sActivityId = activity.getActivityId();
                break;
            }
            mapLinks.put("link#" + sActivityDefId, sHttpLink + "/ShowDetailHistory.do?histActivityId=" + sActivityId + "&ProcessId=" + sProcessId);
        }
        String sHistoryLink = sHttpLink + "/ShowProcessHistory.do?ProcessId=" + sProcessId;
        mapLinks.put("historylink", sHistoryLink);
        return mapLinks;
    }

    private static void sendToUser(String sUserName, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        UserService userService = ServiceFactory.getUserService();
        User user = userService.getUser(sUserName, new String[0]);
        if (!listMailsCompleted.contains(user.getEmail())) {
            SendMail.sendMail(user.getEmail(), sSubject, sContent, listAttachments);
            listMailsCompleted.add(user.getEmail());
        }
    }

    private static void sendToGroup(String sGroupName, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        UserService userService = ServiceFactory.getUserService();
        for (User user : userService.getGroup(sGroupName, new String[]{"users"}).getUsers()) {
            if (listMailsCompleted.contains(user.getEmail())) continue;
            SendMail.sendMail(user.getEmail(), sSubject, sContent, listAttachments);
            listMailsCompleted.add(user.getEmail());
        }
    }

    private static void sendToRole(String sPackageId, String sProcessDefId, String sRoleId, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        RoleService roleService = ServiceFactory.getRoleService();
        UserFinder userFinder = FinderFactory.getUserFinder();
        Role role = roleService.getRole(sPackageId, sProcessDefId, sRoleId);
        for (User user : userFinder.getAll(new String[0])) {
            if (!roleService.doesUserHasRole(user.getUserName(), role.getId()) || listMailsCompleted.contains(user.getEmail())) continue;
            SendMail.sendMail(user.getEmail(), sSubject, sContent, listAttachments);
            listMailsCompleted.add(user.getEmail());
        }
    }

    private static void sendToPositionByName(String sPositionName, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        PositionFinder positionFinder = FinderFactory.getPositionFinder();
        for (Position position : positionFinder.findByName(sPositionName, new String[]{"user"})) {
            SendMail.sendToPosition(position, sSubject, sContent, listAttachments, listMailsCompleted);
        }
    }

    private static void sendToPositionBySymbol(String sPositionSymbol, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        PositionFinder positionFinder = FinderFactory.getPositionFinder();
        Position position = positionFinder.findBySymbol(sPositionSymbol, new String[]{"user"});
        SendMail.sendToPosition(position, sSubject, sContent, listAttachments, listMailsCompleted);
    }

    private static void sendToPosition(Position position, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        User user = position.getUser();
        if (!listMailsCompleted.contains(user.getEmail())) {
            SendMail.sendMail(user.getEmail(), sSubject, sContent, listAttachments);
            listMailsCompleted.add(user.getEmail());
        }
    }

    private static void sendToExecutor(String sProcessId, String sActivityDefId, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        Activity activity2;
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        List listActivity = activityFinder.findByProcessId(sProcessId, new String[0]);
        String sActivityId = null;
        for (Activity activity2 : listActivity) {
            if (!activity2.getActivityDefinitionId().equals(sActivityDefId)) continue;
            sActivityId = activity2.getActivityId();
            break;
        }
        ActivityService activityService = (ActivityService)SpringContext.getBean(ActivityService.class);
        activity2 = (ActivityEntity)activityService.getActivity(sProcessId, sActivityId, new String[0]);
        UserService userService = ServiceFactory.getUserService();
        User user = userService.getUser(activity2.getResourceId(), new String[0]);
        if (!listMailsCompleted.contains(user.getEmail())) {
            SendMail.sendMail(user.getEmail(), sSubject, sContent, listAttachments);
            listMailsCompleted.add(user.getEmail());
        }
    }

    private static void sendToOuByName(String sUnitName, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        OrganizationalUnitFinder ouFinder = FinderFactory.getOrganizationalUnitFinder();
        for (OrganizationalUnit ou : ouFinder.findByName(sUnitName, new String[0])) {
            SendMail.sendToOu(ou, sSubject, sContent, listAttachments, listMailsCompleted);
        }
    }

    private static void sendToOuBySymbol(String sUnitSymbol, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        StructureService structureService = ServiceFactory.getStructureService();
        OrganizationalUnit organizationalUnit = structureService.getOrganizationalUnit(sUnitSymbol, new String[0]);
        SendMail.sendToOu(organizationalUnit, sSubject, sContent, listAttachments, listMailsCompleted);
    }

    private static void sendToOu(OrganizationalUnit organizationalUnit, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        PositionFinder positionFinder = FinderFactory.getPositionFinder();
        for (Position position : positionFinder.getAll(new String[]{"organizationalUnit", "user"})) {
            User user;
            if (!position.getOrganizationalUnit().equals((Object)organizationalUnit) || listMailsCompleted.contains((user = position.getUser()).getEmail())) continue;
            SendMail.sendMail(user.getEmail(), sSubject, sContent, listAttachments);
            listMailsCompleted.add(user.getEmail());
        }
    }

    private static void sendToEmailsInVariable(String sProcessId, String sVariableId, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        String[] receivers;
        ProcessService processService = ServiceFactory.getProcessService();
        Map processContext = processService.getProcessContext(sProcessId);
        for (String sAddress : receivers = processContext.get(sVariableId).toString().split(";")) {
            if (sAddress.split("@").length > 1) {
                if (listMailsCompleted.contains(sAddress)) continue;
                SendMail.sendMail(sAddress, sSubject, sContent, listAttachments);
                listMailsCompleted.add(sAddress);
                continue;
            }
            logger.error((Object)"Niepoprawny adres email");
        }
    }

    private static void sendToUsersInVariable(String sProcessId, String sVariableId, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        String[] receivers;
        ProcessService processService = ServiceFactory.getProcessService();
        UserService userService = ServiceFactory.getUserService();
        Map processContext = processService.getProcessContext(sProcessId);
        for (String sUserName : receivers = processContext.get(sVariableId).toString().split(";")) {
            User user = userService.getUser(sUserName, new String[0]);
            if (listMailsCompleted.contains(user.getEmail())) continue;
            SendMail.sendMail(user.getEmail(), sSubject, sContent, listAttachments);
            listMailsCompleted.add(user.getEmail());
        }
    }

    private static void sendToAddress(String sAddress, String sSubject, String sContent, List<WfDocument> listAttachments, List<String> listMailsCompleted) {
        if (sAddress.split("@").length > 1) {
            if (!listMailsCompleted.contains(sAddress)) {
                SendMail.sendMail(sAddress, sSubject, sContent, listAttachments);
                listMailsCompleted.add(sAddress);
            }
        } else {
            logger.error((Object)"Niepoprawny adres email");
        }
    }

    private static void sendMail(String sReceiverAddress, String sSubject, String sContent, List<WfDocument> listAttachments) {
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", smtpConf.get("SMTPMailServer"));
        properties.setProperty("mail.smtp.port", smtpConf.get("SMTPPortNo"));
        properties.setProperty("mail.smtp.auth", smtpConf.get("SMTPAuth"));
        properties.setProperty("mail.smtp.starttls.enable", smtpConf.get("UseSTARTTLS"));
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication((String)smtpConf.get("Email"), (String)smtpConf.get("UserPassword"));
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(smtpConf.get("Email")));
            message.addRecipients(Message.RecipientType.TO, sReceiverAddress);
            message.setSubject(sSubject);
            if (!listAttachments.isEmpty()) {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Object)sContent, "text/html; charset=utf-8");
                multipart.addBodyPart((BodyPart)messageBodyPart);
                for (WfDocument attachment : listAttachments) {
                    FileDataSource dataSource = new FileDataSource(attachment.getFile().getFullPath());
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                    messageBodyPart.setFileName(attachment.getFile().getFileName());
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                message.setContent((Multipart)multipart);
            } else {
                message.setContent((Object)sContent, "text/html; charset=utf-8");
            }
            Transport.send((Message)message);
            logger.debug((Object)("Wys\u0142ano wiadomo\u015b\u0107 email na adres " + sReceiverAddress));
        }
        catch (MessagingException e) {
            logger.error((Object)"B\u0142\u0105d podczas tworzenia wiadomo\u015bci do wys\u0142ania");
        }
    }
}

