/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.services.CUF;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.objects.DocumentVersions;
import com.plusmpm.CUF.util.objects.PlusWorkflowDocument;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.DomainTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.database.files.FileVersions;
import com.plusmpm.database.files.FileVersionsAccess;
import com.plusmpm.database.files.FileVersionsManager;
import com.plusmpm.database.files.Files;
import com.plusmpm.database.files.FilesManager;
import com.plusmpm.ini.INIFile;
import com.plusmpm.ldap.LDAPManager;
import com.plusmpm.services.CUF.IArchiveServices;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.FullTextSearch.IndexFiles;
import com.plusmpm.util.PlusWorkflow;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.FileSaver;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.enhydra.shark.Shark;

public class ArchiveServicesImpl
implements IArchiveServices {
    public static Logger log = Logger.getLogger(ArchiveServicesImpl.class);
    public static int CONST_INT_WS_OK = 0;
    public static int CONST_INT_WS_IP_ERROR = -1;
    public static int CONST_INT_WS_LOGIN_ERROR = -2;
    public static int CONST_INT_WS_AUTHORIZATION_ERROR = -3;
    public static int CONST_INT_WS_UNKNOWN_ERROR = -4;
    public static int CONST_INT_WS_REMOVE_DOCUMENT_ERROR = -5;
    public static int CONST_INT_WS_NO_DOCUMENT_ERROR = -6;

    @Override
    public boolean ValidateLogin(String userName, String password) {
        log.trace((Object)("************ ValidateLogin(userName=" + userName + ", password) ************"));
        return this.ValidateLoginWithDomain(userName, password, null);
    }

    @Override
    public boolean ValidateLoginWithDomain(String userName, String password, String domain) {
        log.trace((Object)("************ ValidateLoginWithDomain(userName=" + userName + ", password, domain=" + domain + ") ************"));
        boolean validateSuccess = false;
        try {
            log.debug((Object)("ValidateLoginWithDomain:" + userName + " " + domain));
            this.InitializeShark();
            if (domain == null || domain.compareToIgnoreCase("Plus Workflow") == 0 || domain.compareToIgnoreCase("") == 0) {
                domain = "plusworkflow";
            }
            if (domain.compareTo("plusworkflow") == 0) {
                validateSuccess = Shark.getInstance().validateUser(userName, password);
            } else {
                DBManagement dbm = new DBManagement();
                LDAPManager ldap = new LDAPManager();
                DomainTable domainObj = dbm.getDomainByName(domain);
                validateSuccess = ldap.AuthorizeUserInDomain(userName, password, domainObj.getId().toString());
            }
            log.debug((Object)("validateSuccess: " + validateSuccess));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return validateSuccess;
    }

    public void InitializeShark() {
        log.trace((Object)"************ InitializeShark() ************");
        if (!PlusWorkflow.isSystemConfigured()) {
            log.debug((Object)"InitializeShark:");
            String sINIFile = "..//conf//releaseConfig.ini";
            String sConfFile = "";
            File f = new File(sINIFile);
            INIFile objINI = null;
            if (f.exists()) {
                objINI = new INIFile(sINIFile);
                sConfFile = objINI.getStringProperty("Files", "SharkConfFile");
            }
            Shark.configure((String)sConfFile);
        }
    }

    @Override
    public int SaveIndeciesInArchive(String userName, String password, String docClassId, String fileId, String[] asIndicies, String newVersion) {
        log.trace((Object)("************ SaveIndeciesInArchive(userName=" + userName + ", password, docClassId=" + docClassId + ", fileId=" + fileId + ", String[], newVersion=" + newVersion + ") ************"));
        return this.SaveIndeciesInArchiveWithDomain(userName, password, "", docClassId, fileId, asIndicies, newVersion);
    }

    @Override
    public int SaveIndeciesInArchiveWithDomain(String userName, String password, String domain, String docClassId, String fileId, String[] asIndicies, String newVersion) {
        log.trace((Object)("************ SaveIndeciesInArchiveWithDomain(userName=" + userName + ", password, domain=" + domain + ", docClassId=" + docClassId + ", fileId=" + fileId + ", String[], newVersion=" + newVersion + ") ************"));
        try {
            Date dt = new Date();
            NDC.push((String)("SaveIndInArch_" + dt.toLocaleString()));
            log.debug((Object)("SaveIndeciesInArchive: " + userName + ":" + docClassId + " fileId:" + fileId + " idx:" + asIndicies));
            log.debug((Object)"SaveIndeciesInArchive input values:");
            for (int i = 0; i < asIndicies.length; ++i) {
                log.debug((Object)("SaveIndeciesInArchive value [" + i + "]:" + asIndicies[i]));
            }
            DBManagement dbManagament = new DBManagement();
            DocClassTable docClassTable = DBManagement.getDocClass((String)docClassId);
            HashMap<String, Object> hmMapping = new HashMap<String, Object>();
            for (int i = 0; i < asIndicies.length; ++i) {
                String sIndex = Tools.decodeJavaUTF8String((String)asIndicies[i]);
                String[] sSet = sIndex.split("=", 2);
                if (sSet.length != 2) continue;
                IndexTable index = DBManagement.getIndex((String)sSet[0]);
                if (index.getIndexType().compareToIgnoreCase("integer") == 0) {
                    Long LValue = null;
                    LValue = sSet[1].equalsIgnoreCase("") ? new Long(0L) : new Long(sSet[1]);
                    hmMapping.put(sSet[0], LValue);
                    continue;
                }
                if (index.getIndexType().compareToIgnoreCase("float") == 0) {
                    Float FValue = null;
                    if (sSet[1].equalsIgnoreCase("")) {
                        FValue = new Float(0.0f);
                    } else {
                        String sVariableValue = sSet[1].replaceAll("[\\\\]", "");
                        sVariableValue = sVariableValue.replaceAll("[,]", ".");
                        sVariableValue = sVariableValue.replaceAll("[ ]", "");
                        FValue = new Float(sVariableValue);
                    }
                    hmMapping.put(sSet[0], FValue);
                    continue;
                }
                if (index.getIndexType().compareToIgnoreCase("date") == 0) {
                    Date DValue = null;
                    if (sSet[1].equalsIgnoreCase("")) {
                        DValue = new Date(0L);
                    } else {
                        try {
                            String sDate = sSet[1];
                            sDate = sDate.replaceAll("[\\\\]", "/");
                            sDate = sDate.replaceAll("[-]", "/");
                            sDate = sDate.replaceAll("[.]", "/");
                            long time = Date.parse(sDate);
                            DValue = new Date(time);
                        }
                        catch (Exception e) {
                            DValue = new Date(0L);
                        }
                    }
                    hmMapping.put(sSet[0], DValue);
                    continue;
                }
                String sValue = "";
                if (sSet.length == 2) {
                    sValue = sSet[1];
                }
                hmMapping.put(sSet[0], sValue);
            }
            boolean bNewVersion = false;
            if (newVersion.equalsIgnoreCase("NEWVERSION") || newVersion.equalsIgnoreCase("ALLVERSIONS") || newVersion.equalsIgnoreCase("TRUE")) {
                bNewVersion = true;
            }
            hmMapping.put("fileID", fileId);
            Tools.EncryptFile((String)fileId, (String)docClassId);
            log.debug((Object)"SaveIndeciesInArchive saveIndexesOrNewVersion");
            Long iDocID = FileVersionsManager.saveIndexesOrNewVersion((long)Long.valueOf(fileId), (String)userName, (String)docClassId, hmMapping, (DocClassTable)docClassTable, (boolean)bNewVersion).getDocumentId();
            log.debug((Object)"SaveIndeciesInArchive OK");
            if (docClassTable.getDocClassIndex().compareTo("true") == 0) {
                log.debug((Object)"Indeksowanie pe\u0142notekstowe");
                FilesManager fm = new FilesManager();
                Files file = fm.GetFile(new Long(fileId));
                if (file != null) {
                    String sFullDirPath = file.getPath();
                    String newFileName = file.getName();
                    IndexFiles.addFile((String)docClassTable.getDocClassIndexPath(), (String)(sFullDirPath + "/" + newFileName), (String)fileId.toString(), (String)String.valueOf(iDocID), (String)docClassId);
                    DBManagement.getNextSequenceValue((String)("ssequencer_indexedfiles_" + docClassId));
                    log.debug((Object)"Indeksowanie pe\u0142notekstowe OK");
                }
            }
            NDC.pop();
            NDC.remove();
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage());
            return CONST_INT_WS_UNKNOWN_ERROR;
        }
        return 0;
    }

    @Override
    public int SaveDocumentInArchive(String userName, String password, String docClassId, String sFilePath, String sSize, String sPageCount, String sDescription, String sOCRContent, byte[] abFile) {
        log.trace((Object)("************ SaveDocumentInArchive(userName=" + userName + ", password, docClassId=" + docClassId + ", sFilePath=" + sFilePath + ", sSize=" + sSize + ", sPageCount=" + sPageCount + ", sDescription=" + sDescription + ", sOCRContent=" + sOCRContent + ", byte[]) ************"));
        return this.SaveDocumentInArchiveWithDomain(userName, password, "", docClassId, sFilePath, sSize, sPageCount, sDescription, sOCRContent, abFile);
    }

    @Override
    public int SaveDocumentInArchiveWithDomain(String userName, String password, String domain, String docClassId, String sFilePath, String sSize, String sPageCount, String sDescription, String sOCRContent, byte[] abFile) {
        Long lFileId;
        block7: {
            log.trace((Object)("************ SaveDocumentInArchiveWithDomain(userName=" + userName + ", password, domain=" + domain + ", docClassId=" + docClassId + ", sFilePath=" + sFilePath + ", sSize=" + sSize + ", sPageCount=" + sPageCount + ", sDescription=" + sDescription + ", sOCRContent=" + sOCRContent + ", byte[]) ************"));
            lFileId = new Long(-1L);
            try {
                Date dt = new Date();
                NDC.push((String)("SaveDocumentInArchive_" + dt.toLocaleString()));
                log.debug((Object)("SaveDocumentInArchive: " + userName + ":" + docClassId + " fileId:" + sFilePath));
                DBManagement dbManagament = new DBManagement();
                DocClassTable docClassTable = DBManagement.getDocClass((String)docClassId);
                ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
                Device device = as.getDeviceForDocumentClass(new Long(docClassId), new String[0]);
                if (device == null) break block7;
                String sFullDirPath = Tools.GetFullDirPath((String)docClassId);
                File uploadedFile = new File(sFilePath);
                String sFileName = uploadedFile.getName();
                String[] sExt = sFileName.split("[.]");
                String newFileName = "";
                File uploadedDir = new File(sFullDirPath);
                File uploadedTempFile = null;
                try {
                    uploadedTempFile = File.createTempFile("IMG", "." + sExt[sExt.length - 1], uploadedDir);
                    newFileName = uploadedTempFile.getName();
                    try {
                        FileService fs = (FileService)SpringContext.getBean(FileService.class);
                        FileSaver saver = fs.getFileSaver();
                        DocumentDefinition fd = new DocumentDefinition();
                        fd.setDocumentClassId(new Long(docClassId));
                        fd.setFileName(sFileName);
                        fd.setDescription(sDescription);
                        fd.setUserName(userName);
                        WfFile wfFile = saver.addFile(fd);
                        File outputFile = new File(wfFile.getFullPath());
                        FileOutputStream fos = new FileOutputStream(outputFile);
                        byte[] buf = new byte[abFile.length];
                        boolean j = false;
                        for (int i = 0; i < abFile.length; ++i) {
                            buf[i] = abFile[i];
                        }
                        fos.write(buf, 0, abFile.length);
                        fos.close();
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        return -4;
                    }
                }
                catch (IOException e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                    return -4;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return -4;
            }
        }
        NDC.pop();
        NDC.remove();
        return lFileId.intValue();
    }

    @Override
    public String GetArchiveDocClasses(String userName, String password) {
        log.trace((Object)("************ GetArchiveDocClasses(userName=" + userName + ", password) ************"));
        return this.GetArchiveDocClassesWithDomain(userName, password, "");
    }

    @Override
    public String GetArchiveDocClassesWithDomain(String userName, String password, String domain) {
        log.trace((Object)("************ GetArchiveDocClassesWithDomain(userName=" + userName + ", password, domain=" + domain + ") ************"));
        String docClasses = "";
        log.debug((Object)("GetArchiveDocClasses:" + userName));
        try {
            DocClassTable docClassTable;
            int i;
            log.debug((Object)("GetArchiveDocClasses:" + userName));
            this.InitializeShark();
            DBManagement dbm = new DBManagement();
            ArrayList alArchiveDocClass = dbm.GetAllDocClasses();
            ArrayList<DocClassTable> alOutDocClasses = new ArrayList<DocClassTable>();
            DocClassTable docClassTable1 = null;
            if (alArchiveDocClass != null) {
                for (i = 0; i < alArchiveDocClass.size(); ++i) {
                    docClassTable1 = docClassTable = (DocClassTable)alArchiveDocClass.get(i);
                    if (Authorization.CheckRight((String)("System.Archive.DocClasses." + docClassTable.getId()), (String)userName, (boolean)false) != 0 && Authorization.CheckRight((String)("System.Archive.DocClasses." + docClassTable.getId()), (String)userName, (boolean)false) != 1) continue;
                    alOutDocClasses.add(docClassTable);
                }
            }
            for (i = 0; i < alOutDocClasses.size(); ++i) {
                docClassTable = (DocClassTable)alArchiveDocClass.get(i);
                docClasses = i != alOutDocClasses.size() - 1 ? docClasses + docClassTable.getId() + ";" + docClassTable.getDocClassName() + "$" : docClasses + docClassTable.getId() + ";" + docClassTable.getDocClassName();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return docClasses;
    }

    @Override
    public String GetArchiveDocClassIndecies(String userName, String password, String docClassId) {
        log.trace((Object)("************ GetArchiveDocClassIndecies(userName=" + userName + ", password, docClassId=" + docClassId + ") ************"));
        return this.GetArchiveDocClassIndeciesWithDomain(userName, password, "", docClassId);
    }

    @Override
    public String GetArchiveDocClassIndeciesWithDomain(String userName, String password, String domain, String docClassId) {
        log.trace((Object)("************ GetArchiveDocClassIndeciesWithDomain(userName=" + userName + ", password, domain=" + domain + ", docClassId=" + docClassId + ") ************"));
        String docClassesIndecies = "";
        log.debug((Object)("GetArchiveDocClassIndecies:" + userName));
        try {
            Date dt = new Date();
            NDC.push((String)("GetArchiveDocClassIndecies_" + dt.toLocaleString()));
            System.out.println("GetArchiveDocClassIndecies:" + userName + ":" + docClassId);
            log.debug((Object)("GetArchiveDocClassIndecies:" + userName + ":" + docClassId));
            this.InitializeShark();
            ArrayList alArchiveDocClassIndecies = null;
            DBManagement dbm = new DBManagement();
            alArchiveDocClassIndecies = DBManagement.GetAllIndecies((String)docClassId);
            if (alArchiveDocClassIndecies != null) {
                for (int i = 0; i < alArchiveDocClassIndecies.size(); ++i) {
                    IndexTable indexTable = (IndexTable)alArchiveDocClassIndecies.get(i);
                    docClassesIndecies = i != alArchiveDocClassIndecies.size() - 1 ? docClassesIndecies + indexTable.getId() + ";" + indexTable.getIndexName() + "$" : docClassesIndecies + indexTable.getId() + ";" + indexTable.getIndexName();
                }
            }
            if (docClassesIndecies != null && !docClassesIndecies.equals("")) {
                log.debug((Object)("docClassesIndecies:" + docClassesIndecies + " ilosc:" + docClassesIndecies.split("$").length));
            } else {
                log.debug((Object)"docClassesIndecies empty");
            }
            log.debug((Object)"GetArchiveDocClassIndecies OK");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        NDC.pop();
        NDC.remove();
        return docClassesIndecies;
    }

    @Override
    public int DeleteFile(String userName, String password, String fileId) {
        log.trace((Object)("************ DeleteFile(userName=" + userName + ", password, fileId=" + fileId + ") ************"));
        return this.DeleteFileWithDomain(userName, password, "", fileId);
    }

    @Override
    public int DeleteFileWithDomain(String userName, String password, String domain, String fileId) {
        log.trace((Object)("************ DeleteFile(userName=" + userName + ", password, domain=" + domain + ", fileId=" + fileId + ") ************"));
        try {
            String documentId = null;
            String docClassId = null;
            DBManagement dbm = new DBManagement();
            ArrayList docClasses = dbm.GetAllDocClasses();
            for (DocClassTable docClassTable : docClasses) {
                DocumentData document = DBManagement.GetDocumentByFileId((String)docClassTable.getId().toString(), (String)fileId);
                if (document == null) continue;
                documentId = String.valueOf(document.getLDocumentId());
                docClassId = String.valueOf(docClassTable.getId().toString());
                break;
            }
            if (documentId != null) {
                FileVersionsManager manager = new FileVersionsManager();
                boolean bResult = manager.removeDocument(new Long(fileId), docClassId, documentId, null);
                if (bResult) {
                    return CONST_INT_WS_OK;
                }
                log.warn((Object)("DeleteFileWithDomain finsihed with code:" + CONST_INT_WS_REMOVE_DOCUMENT_ERROR));
                return CONST_INT_WS_REMOVE_DOCUMENT_ERROR;
            }
            log.info((Object)("DeleteFileWithDomain finsihedwith code:" + CONST_INT_WS_NO_DOCUMENT_ERROR));
            return CONST_INT_WS_NO_DOCUMENT_ERROR;
        }
        catch (Exception e) {
            log.error((Object)("Error in DeleteFileWithDomain:" + e.getMessage()), (Throwable)e);
            return CONST_INT_WS_UNKNOWN_ERROR;
        }
    }

    @Override
    public String DoesDocumentExistInDocClass(String userName, String password, String sClassName, String[] indexes) {
        log.trace((Object)("************ DoesDocumentExistInDocClass(userName=" + userName + ", password, sClassName=" + sClassName + ", String[]) ************"));
        return this.DoesDocumentExistInDocClassWithDomain(userName, password, "", sClassName, indexes);
    }

    @Override
    public String DoesDocumentExistInDocClassWithDomain(String userName, String password, String domain, String sClassName, String[] indexes) {
        String foundId;
        block8: {
            log.trace((Object)("************ DoesDocumentExistInDocClassWithDomain(userName=" + userName + ", password, domain=" + domain + ", sClassName=" + sClassName + ", String[]) ************"));
            foundId = "-1";
            DBManagement dbm = new DBManagement();
            try {
                DocClassTable docClassTable = dbm.getDocClassByName(sClassName);
                if (docClassTable != null && indexes != null) {
                    String docClassId = docClassTable.getId().toString();
                    ArrayList indexesForDocClass = DBManagement.GetAllIndecies((String)docClassId);
                    HashMap<IndexTable, String> hmIndecies = new HashMap<IndexTable, String>();
                    block2: for (int i = 0; i < indexes.length; ++i) {
                        for (int j = 0; j < indexesForDocClass.size(); ++j) {
                            IndexTable indexTable = (IndexTable)indexesForDocClass.get(j);
                            if (indexTable == null) continue;
                            String[] nameAndValueTable = indexes[i].split("=");
                            Long id = indexTable.getId();
                            String indexName = null;
                            if (id != null) {
                                IndexTable help = DBManagement.getIndex((String)id.toString());
                                if (help != null) {
                                    indexName = help.getIndexName();
                                }
                            }
                            if (indexName == null || !indexName.equalsIgnoreCase(nameAndValueTable[0])) continue;
                            hmIndecies.put(indexTable, nameAndValueTable[1]);
                            continue block2;
                        }
                    }
                    ArrayList listOfDocs = DBManagement.SearchDocClass(hmIndecies, (String)docClassId, (String)"admin", (String)"", (String)"", (int)0, (int)0, (int)0, (int)0, (long)0L);
                    if (listOfDocs == null || listOfDocs.size() <= 0) break block8;
                    for (int i = 0; i < listOfDocs.size(); ++i) {
                        Long fileId = ((DocumentData)listOfDocs.get(i)).getLFileId();
                        if (fileId == null) continue;
                        foundId = String.valueOf(fileId);
                        break block8;
                    }
                    break block8;
                }
                log.debug((Object)("Nie istnieje klasa dokumentow o nazwie " + sClassName));
            }
            catch (Exception e) {
                log.error((Object)("Error in DoesDocumentExistInDocClassWithDomain: " + e.getMessage()), (Throwable)e);
            }
        }
        return foundId;
    }

    @Override
    public String GetVersionForFile(String userName, String password, String fileId) {
        log.trace((Object)("************ GetVersionForFile(userName=" + userName + ", password, fileId=" + fileId + ") ************"));
        return this.GetVersionForFileWithDomain(userName, password, "", fileId);
    }

    @Override
    public String GetVersionForFileWithDomain(String userName, String password, String domain, String fileId) {
        log.trace((Object)("************ GetVersionForFileWithDomain(userName=" + userName + ", password, domain=" + domain + ", fileId=" + fileId + ") ************"));
        FileVersionsAccess manager = new FileVersionsAccess();
        try {
            Long lVer;
            String result = "";
            FileVersions fileVersion = manager.getFileVersionByFileId(Long.valueOf(fileId));
            if (fileVersion != null && (lVer = fileVersion.getVersion()) != null) {
                result = String.valueOf(lVer);
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String FindDocuments(String userName, String password, String sClassName, String sFrom, String sTo, String[] indexes) {
        log.trace((Object)("************ FindDocuments(userName=" + userName + ", password, sClassName=" + sClassName + ", sFrom=" + sFrom + ", sTo=" + sTo + ", indexes) ************"));
        return this.FindDocumentsWithDomain(userName, password, "", sClassName, sFrom, sTo, indexes);
    }

    @Override
    public String FindDocumentsWithDomain(String userName, String password, String domain, String sClassName, String sFrom, String sTo, String[] indexes) {
        log.trace((Object)("************ FindDocumentsWithDomain(userName=" + userName + ", password, domain=" + domain + ", sClassName=" + sClassName + ", sFrom=" + sFrom + ", sTo=" + sTo + ", indexes) ************"));
        String fileIds = "";
        DBManagement dbm = new DBManagement();
        try {
            Long lDocClassId;
            DocClassTable docClassTable = dbm.getDocClassByName(sClassName);
            if (docClassTable != null && (lDocClassId = docClassTable.getId()) != null) {
                ArrayList listOfDocs;
                String docClassId = lDocClassId.toString();
                ArrayList indexesForDocClass = DBManagement.GetAllIndecies((String)docClassId);
                HashMap<IndexTable, String> hmIndecies = new HashMap<IndexTable, String>();
                if (indexes != null && indexes.length > 0) {
                    block2: for (int i = 0; i < indexes.length; ++i) {
                        for (int j = 0; j < indexesForDocClass.size(); ++j) {
                            IndexTable indexTable = (IndexTable)indexesForDocClass.get(j);
                            if (indexTable == null) continue;
                            String[] nameAndValueTable = indexes[i].split("=");
                            Long id = indexTable.getId();
                            String indexName = null;
                            if (id != null) {
                                IndexTable help = DBManagement.getIndex((String)id.toString());
                                if (help != null) {
                                    indexName = help.getIndexName();
                                }
                            }
                            if (indexName == null || !indexName.equalsIgnoreCase(nameAndValueTable[0])) continue;
                            hmIndecies.put(indexTable, nameAndValueTable[1]);
                            continue block2;
                        }
                    }
                }
                if ((listOfDocs = DBManagement.SearchDocClass(hmIndecies, (String)docClassId, (String)"admin", (String)sFrom, (String)sTo, (int)0, (int)0, (int)0, (int)0, (long)0L)) != null && listOfDocs.size() > 0) {
                    for (int i = 0; i < listOfDocs.size(); ++i) {
                        DocumentData oneDoc = (DocumentData)listOfDocs.get(i);
                        if (oneDoc == null) continue;
                        long fileId = oneDoc.getLFileId();
                        fileIds = i < listOfDocs.size() - 1 ? fileIds + fileId + ";" : fileIds + fileId;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return fileIds;
    }

    @Override
    public boolean MoveDocumentBetweenDocClasses(String userName, String password, String fileId, String destDocClassName, String copyIndexes) {
        log.trace((Object)("************ MoveDocumentBetweenDocClasses(userName=" + userName + ", password, fileId=" + fileId + ", destDocClassName=" + destDocClassName + ", copyIndexes=" + copyIndexes + ") ************"));
        return this.MoveDocumentBetweenDocClassesWithDomain(userName, password, "", fileId, destDocClassName, copyIndexes);
    }

    @Override
    public boolean MoveDocumentBetweenDocClassesWithDomain(String userName, String password, String domain, String fileId, String destDocClassName, String copyIndexes) {
        log.trace((Object)("************ MoveDocumentBetweenDocClassesWithDomain(userName=" + userName + ", password, domain=" + domain + ", fileId=" + fileId + ", destDocClassName=" + destDocClassName + ", copyIndexes=" + copyIndexes + ") ************"));
        boolean res = false;
        try {
            boolean bCopyIndexes = Boolean.parseBoolean(copyIndexes);
            res = ArchiveServices.MoveDocumentBetweenDocClasses(fileId, destDocClassName, bCopyIndexes);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return res;
    }

    @Override
    public PlusWorkflowDocument GetDocument(String userName, String password, String fileId) {
        log.trace((Object)("************ GetDocument(userName=" + userName + ", password, fileId=" + fileId + ") ************"));
        return this.GetDocumentWithDomain(userName, password, "", fileId);
    }

    @Override
    public PlusWorkflowDocument GetDocumentWithDomain(String userName, String password, String domain, String fileId) {
        log.trace((Object)("************ GetDocumentWithDomain(userName=" + userName + ", password, domain=" + domain + ", fileId=" + fileId + ") ************"));
        PlusWorkflowDocument doc = null;
        try {
            doc = ArchiveServices.GetDocument(fileId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return doc;
    }

    @Override
    public DocumentVersions GetAllDocumentVersions(String userName, String password, String fileId) {
        log.trace((Object)("************ GetAllDocumentVersions(userName=" + userName + ", password, fileId=" + fileId + ") ************"));
        return this.GetAllDocumentVersionsWithDomain(userName, password, "", fileId);
    }

    @Override
    public DocumentVersions GetAllDocumentVersionsWithDomain(String userName, String password, String domain, String fileId) {
        log.trace((Object)("************ GetAllDocumentVersionsWithDomain(userName=" + userName + ", password, domain=" + domain + ", fileId=" + fileId + ") ************"));
        DocumentVersions versions = null;
        try {
            versions = ArchiveServices.GetDocumentVersions(fileId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return versions;
    }

    @Override
    public boolean UpdateDocumentContent(String userName, String password, String fileId, byte[] bytes) {
        log.trace((Object)("************ UpdateDocumentContent(userName=" + userName + ", password, fileId=" + fileId + ", byte[]) ************"));
        return this.UpdateDocumentContentWithDomain(userName, password, "", fileId, bytes);
    }

    @Override
    public boolean UpdateDocumentContentWithDomain(String userName, String password, String domain, String fileId, byte[] bytes) {
        log.trace((Object)("************ UpdateDocumentContentWithDomain(userName=" + userName + ", password, domain=" + domain + ", fileId=" + fileId + ", byte[]) ************"));
        boolean bResult = false;
        try {
            bResult = ArchiveServices.UpdateDocumentContent(fileId, bytes);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bResult;
    }

    @Override
    public int SaveAsNewVersion(String userName, String password, String sFileId, String sFileName, String sPageCount, String sDescription, String sOCRContent, byte[] bytes) {
        log.trace((Object)("************ SaveAsNewVersion(userName=" + userName + ", password, sFileId=" + sFileId + ", sFileName=" + sFileName + ", sPageCount=" + sPageCount + ", sDescription=" + sDescription + ", sOCRContent=" + sOCRContent + ", byte[]) ************"));
        return this.SaveAsNewVersionWithDomain(userName, password, "", sFileId, sFileName, sPageCount, sDescription, sOCRContent, bytes);
    }

    @Override
    public int SaveAsNewVersionWithDomain(String userName, String password, String domain, String sFileId, String sFileName, String sPageCount, String sDescription, String sOCRContent, byte[] bytes) {
        log.trace((Object)("************ SaveAsNewVersionWithDomain(userName=" + userName + ", password, domain=" + domain + ", sFileId=" + sFileId + ", sFileName=" + sFileName + ", sPageCount=" + sPageCount + ", sDescription=" + sDescription + ", sOCRContent=" + sOCRContent + ", byte[]) ************"));
        int newFileId = -1;
        try {
            newFileId = ArchiveServices.SaveAsNewVersion(sFileId, sFileName, sPageCount, sDescription, sOCRContent, userName, bytes);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return newFileId;
    }
}

