/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.objects;

import com.plusmpm.database.files.ExtendedDocumentData;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.constants.DateConstants;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExtendedFile {
    private long docClassId;
    private String docClassName;
    private long documentId;
    private String description;
    private long fileId;
    private String fileName;
    private String sDate;
    private Date date;
    private long size;
    private String owner;

    public ExtendedFile(ExtendedDocumentData edd) {
        this.setDate(edd.getDate());
        this.setDescription(edd.getDescription());
        this.setDocClassId(edd.getLDocClassId());
        this.setDocClassName(edd.getLDocClassName());
        this.setDocumentId(edd.getLDocumentId());
        this.setFileId(edd.getLFileId());
        this.setFileName(edd.getOrg_name());
        this.setOwner(edd.getOwner());
        this.setsDate(edd.getSDocumentDate());
        this.setSize(edd.getSize());
    }

    public ExtendedFile() {
    }

    public ExtendedFile(WfDocument doc) {
        this.setDate(doc.getFile().getFileDate());
        this.setDescription(doc.getFile().getDescription());
        this.setDocClassId(doc.getDocumentClassId());
        this.setDocClassName(doc.getFile().getDocumentClass().getName());
        this.setDocumentId(doc.getId());
        this.setFileId(doc.getFile().getId());
        this.setFileName(doc.getFile().getFileName());
        this.setOwner(doc.getFile().getUploader());
        this.setsDate(this.convertDate(doc.getFile().getFileDate()));
        this.setSize(doc.getFile().getSize());
    }

    private String convertDate(Date expirationDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(DateConstants.DATE_TIME_FORMAT);
        if (expirationDate != null) {
            return sdf.format(expirationDate);
        }
        return "";
    }

    public long getDocClassId() {
        return this.docClassId;
    }

    public void setDocClassId(long docClassId) {
        this.docClassId = docClassId;
    }

    public String getDocClassName() {
        return this.docClassName;
    }

    public void setDocClassName(String docClassName) {
        this.docClassName = docClassName;
    }

    public long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(long documentId) {
        this.documentId = documentId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getFileId() {
        return this.fileId;
    }

    public void setFileId(long fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getsDate() {
        return this.sDate;
    }

    public void setsDate(String sDate) {
        this.sDate = sDate;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}

