/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.CUF.util.extension.ExcelWriter;
import com.plusmpm.CUF.util.extension.JsonMessage;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.plusmpm.util.SharkFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class ExportDTToExcel
extends HttpServlet {
    public static Logger log = Logger.getLogger(ExportDTToExcel.class);
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug((Object)"************************* ExportTable Servlet ****************************");
        try {
            String mode = req.getParameter("mode");
            String extension = req.getParameter("extension");
            String title = req.getParameter("title");
            if (StringUtils.isEmpty((String)title)) {
                title = "Eksport tabeli dynamicznej";
            }
            if (StringUtils.isEmpty((String)mode) || mode.equals("write")) {
                log.debug((Object)"Params:");
                List<String> headers = this.readHeaders(req.getParameter("headers"));
                Map<String, String> headerMappings = this.readHeaderMappings(req.getParameter("headerMappings"));
                List<Map<String, Object>> data = this.readData(req.getParameter("data"));
                log.debug((Object)("title: " + title));
                log.debug((Object)("extension: " + extension));
                Map<String, String> types = this.getVariableTypes(headerMappings.keySet(), req.getParameter("processId"));
                ExcelWriter ew = new ExcelWriter();
                if (types != null) {
                    ew.setExcelTypes(this.convertTypes(types));
                }
                ew.setExtension(extension);
                File tempDir = (File)req.getSession().getServletContext().getAttribute("javax.servlet.context.tempdir");
                File excelFile = File.createTempFile("excel", "." + extension, tempDir);
                log.debug((Object)("Utworzy\u0142em plik tymczasowy: " + excelFile));
                String path = excelFile.getAbsolutePath();
                ew.setHeadersMapping(headerMappings);
                ew.setHeaders(headers.toArray(new String[headers.size()]));
                Long size = ew.generateExcel(data, new FileOutputStream(excelFile));
                JsonMessage jm = new JsonMessage();
                Object[] ret = new Object[]{path, extension, size, title};
                jm.setData(ret);
                ObjectMapper om = new ObjectMapper();
                resp.getWriter().print(om.writeValueAsString((Object)jm));
                resp.getWriter().close();
            } else {
                ServletOutputStream sos = resp.getOutputStream();
                resp.setContentType(this.getContentType(extension));
                String size = req.getParameter("size");
                String path = req.getParameter("path");
                File file = new File(path);
                FileInputStream fis = new FileInputStream(file);
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + title + " - eksport." + extension + "\"");
                IOUtils.copy((InputStream)fis, (OutputStream)sos);
                sos.flush();
                fis.close();
                resp.setContentLength(Integer.valueOf(size).intValue());
                log.debug((Object)("Usuwam plik: " + file));
                file.delete();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private Map<String, Class<?>> convertTypes(Map<String, String> types) {
        HashMap exTypes = new HashMap();
        for (String key : types.keySet()) {
            if (types.get(key).equals("integer")) {
                exTypes.put(key, Integer.class);
                continue;
            }
            if (types.get(key).equals("float")) {
                exTypes.put(key, Double.class);
                continue;
            }
            if (types.get(key).equals("date")) {
                exTypes.put(key, Date.class);
                continue;
            }
            exTypes.put(key, String.class);
        }
        return exTypes;
    }

    private Map<String, String> getVariableTypes(Iterable<String> keySet, String processId) {
        HashMap<String, String> types = new HashMap<String, String>();
        String processDefId = null;
        try {
            processDefId = Shark.getInstance().getAdminInterface().getAdminMisc().getProcessDefinitionId(processId);
        }
        catch (Exception e) {
            return null;
        }
        Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(processDefId);
        WorkflowProcess wp = pack.getWorkflowProcess(processDefId);
        for (String varId : keySet) {
            String type = SharkClientFunctions.getVarTypeForVarId(wp, varId);
            types.put(varId, type);
        }
        return types;
    }

    private List<Map<String, Object>> readData(String sData) throws JsonParseException, JsonMappingException, IOException {
        log.debug((Object)("sData: " + sData));
        ObjectMapper om = new ObjectMapper();
        List data = (List)om.readValue(sData, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        return data;
    }

    private Map<String, String> readHeaderMappings(String sHeaderMappings) throws JsonParseException, JsonMappingException, IOException {
        log.debug((Object)("headerMappings: " + sHeaderMappings));
        ObjectMapper om = new ObjectMapper();
        Map map = (Map)om.readValue(sHeaderMappings, (TypeReference)new TypeReference<Map<String, String>>(){});
        return map;
    }

    private String getContentType(String extension) {
        if (extension.equals("xls")) {
            return "application/vnd.ms-excel";
        }
        return "application/vnd.ms-excel.12";
    }

    private List<String> readHeaders(String sHeaders) throws JsonParseException, JsonMappingException, IOException {
        log.debug((Object)("headers: " + sHeaders));
        ObjectMapper om = new ObjectMapper();
        List list = (List)om.readValue(sHeaders, (TypeReference)new TypeReference<List<String>>(){});
        return list;
    }
}

