/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.CUF.util.extension.SendTemplateEmail;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DiskSpaceNotification
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(DiskSpaceNotification.class);

    @AdvancedTask(name="DiskSpaceNotification", description="DiskSpaceNotification_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void FreeDiskSpaceNotification(@TaskParam(name="DiskPath", description="Lokalizacja na dysku, zalecana sciezka glowna lub katalog") String sDiskPath, @TaskParam(name="TresholdInMB", description="Prog w MB, ponizej ktorego jest wysylane powiadomienie") String sTresholdInMB, @TaskParam(name="Emails", description="Adresy e-mail, na ktore wysylane sa powiadomienia, w przpyadku, gdy liczba wolnego miejsca spadla ponizej progu podanego w parametrze sTresholdInMB") String sEmails, @TaskParam(name="TemplatePath", description="Sciezka do szablonu powiadomienia") String sTemplatePath, @TaskParam(name="Subject", description="Temat powiadomienia") String sSubject) {
        log.trace((Object)("************ FreeDiskSpaceNotification(sDiskPath=" + sDiskPath + ", sTresholdInMB=" + sTresholdInMB + ", sEmails=" + ", sTemplatePath=" + sTemplatePath + ", sSubject=" + sSubject + ") ************"));
        long startTime = new Date().getTime();
        long lTresholdInMB = new Long(-1L);
        long lTresholdInBytes = new Long(-1L);
        long lFreeSpaceInBytes = new Long(-1L);
        File fDiskPath = null;
        HashMap<String, String> putInTemplateMap = null;
        try {
            try {
                lTresholdInMB = Long.parseLong(sTresholdInMB);
                if (lTresholdInMB <= 0L) {
                    throw new CUFException("Limit wolnego miejsca w MB nie jest wartoscia dodatnia");
                }
            }
            catch (NumberFormatException e) {
                taskLog.error((Object)e.getMessage());
                throw new CUFException("Limit wolnego miejsca w MB nie jest wartoscia liczbowa");
            }
            log.info((Object)("Weryfikacja lokalizacji " + sDiskPath + " na dysku lokalnym"));
            fDiskPath = new File(sDiskPath);
            if (!fDiskPath.exists()) {
                throw new CUFException("Lokalizacja " + sDiskPath + " nie istnieje na dysku lokalnym");
            }
            log.info((Object)("Lokalizacja " + sDiskPath + " istnieje na dysku lokalnym"));
            lFreeSpaceInBytes = fDiskPath.getFreeSpace();
            lTresholdInBytes = lTresholdInMB * 1024L * 1024L;
            if (lFreeSpaceInBytes < lTresholdInBytes) {
                log.info((Object)("W lokalizacji " + sDiskPath + " ilosc wolnego miejsca jest mniejsza niz " + lTresholdInMB + " MB. Wysylanie powiadomienia"));
                putInTemplateMap = new HashMap<String, String>();
                putInTemplateMap.put("@DISK_PATH@", sDiskPath);
                putInTemplateMap.put("@DISK_FREE_SPACE@", String.valueOf(Math.round(new Double(lFreeSpaceInBytes / 0x100000L))) + " MB");
                putInTemplateMap.put("@DISK_FREE_SPACE_LIMIT@", String.valueOf(lTresholdInMB) + " MB");
                SendTemplateEmail.Send(sEmails, sTemplatePath, sSubject, putInTemplateMap);
            } else {
                log.info((Object)("W lokalizacji " + sDiskPath + " ilosc wolnego miejsca jest wieksza niz " + lTresholdInMB + " MB"));
            }
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.debug((Object)("Czas wykonywania zadania zaplanowanego FreeDiskSpaceNotification: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

