/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration;

import com.plusmpm.CUF.util.extension.DBService;
import com.plusmpm.CUF.util.extension.ExcelWriter;
import com.plusmpm.CUF.util.extension.QueryUtils;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.cuf.administartion.structure.StructureHelper;
import com.suncode.cuf.database.config.DatabaseConfig;
import com.suncode.cuf.database.config.MSSqlConfig;
import com.suncode.cuf.database.config.OracleConfig;
import com.suncode.cuf.database.config.PostgresConfig;
import com.suncode.cuf.hibernate.HibernateQueryExecutor;
import com.suncode.cuf.hibernate.SessionFactoryBuilder;
import com.suncode.cuf.sql.query.DMLQuery;
import com.suncode.cuf.sql.query.ParamValue;
import com.suncode.cuf.sql.query.type.SqlTypes;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class ExportStructure
extends AbstractAdvancedTask {
    private static Logger log = Logger.getLogger(ExportStructure.class);
    private volatile double progress = 0.0;

    @AdvancedTask(name="exportStructure", description="exportStructure_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void exportStructure(@TaskParam(name="path_to_excel_file", description="path_to_excel_file") String path) throws Exception {
        List<Map<String, Object>> structure = this.getStructure();
        this.progress = 0.5;
        this.generateExcel(structure, path);
        this.progress = 1.0;
    }

    @AdvancedTask(name="exportStructureToDb", description="exportStructureToDb", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void exportStructureToDb(@TaskParam(name="dbtype", description="dbtype_desc") String dbType, @TaskParam(name="dburl", description="dburl") String url, @TaskParam(name="dbport", description="dbport") String port, @TaskParam(name="dbname", description="dbname") String dbName, @TaskParam(name="tablename", description="tablename") String tableName, @TaskParam(name="dbusername", description="dbusername") String userName, @TaskParam(name="dbpass", description="dbpass") String password) throws Exception {
        List<Map<String, Object>> data = this.getStructure();
        this.progress = 0.5;
        DatabaseConfig dbcfg = this.buildDBConfig(dbType, url, port, dbName, userName, password);
        this.exportToDB(data, dbcfg, tableName);
        this.progress = 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToDB(List<Map<String, Object>> data, DatabaseConfig dbcfg, String tableName) {
        String[] columns = this.createColumns();
        Map<String, String> mappings = this.createColumnMappings();
        SessionFactory sf = null;
        try {
            sf = SessionFactoryBuilder.buildSessionFactory(dbcfg);
            if (!this.tableExists(tableName, sf)) {
                this.createExportTable(tableName, columns, sf);
            }
            this.setDataInTable(sf, data, tableName, columns, mappings);
        }
        finally {
            sf.close();
        }
    }

    private void createExportTable(String tableName, String[] columns, SessionFactory sf) {
        HibernateQueryExecutor executor = new HibernateQueryExecutor();
        executor.setSessionFactory(sf);
        String query = this.createExportTableQuery(tableName, columns);
        DMLQuery q = new DMLQuery();
        q.setQuery(query);
        executor.executeUpdate(q);
        log.debug((Object)("Tabela: " + tableName + " zosta\u0142a utworzona pomy\u015blnie"));
    }

    private boolean tableExists(String tableName, SessionFactory sf) {
        DBService dbs = new DBService();
        dbs.setSessionFactory(sf);
        return dbs.tableExists(tableName);
    }

    private void generateExcel(List<Map<String, Object>> structure, String path) throws IOException, ParseException {
        ExcelWriter ew = new ExcelWriter();
        FileOutputStream os = new FileOutputStream(new File(path));
        Map<String, String> headersMapping = this.createHeadersMapping();
        String[] headers = this.createHeaders();
        ew.setExtension("xlsx");
        ew.setHeaders(headers);
        ew.setHeadersMapping(headersMapping);
        ew.generateExcel(structure, os);
    }

    Map<String, String> createHeadersMapping() {
        HashMap<String, String> headersMapping = new HashMap<String, String>();
        headersMapping.put("userName", "Login");
        headersMapping.put("firstName", "Imi\u0119");
        headersMapping.put("lastName", "Nazwisko");
        headersMapping.put("password", "Has\u0142o");
        headersMapping.put("email", "Email");
        headersMapping.put("number", "Nr");
        headersMapping.put("groups", "Grupy");
        headersMapping.put("positionName", "Nazwa stanowiska");
        headersMapping.put("positionSymbol", "Symbol stanowiska");
        headersMapping.put("higherPositionSymbol", "Symbol stanowiska nadrz\u0119dnego");
        headersMapping.put("roles", "Role");
        headersMapping.put("organizationalUnitName", "Nazwa jednostki organizacyjnej");
        headersMapping.put("organizationalUnitSymbol", "Symbol jednostki organizacyjnej");
        headersMapping.put("higherOrganizationalUnitSymbol", "Symbol jednostki nadrz\u0119dnej");
        headersMapping.put("directorPositionSymbol", "Symbol stanowiska kierowniczego");
        return headersMapping;
    }

    private String[] createHeaders() {
        String[] headersOrder = new String[]{"Login", "Imi\u0119", "Nazwisko", "Has\u0142o", "Email", "Nr", "Grupy", "Nazwa stanowiska", "Symbol stanowiska", "Symbol stanowiska nadrz\u0119dnego", "Role", "Nazwa jednostki organizacyjnej", "Symbol jednostki organizacyjnej", "Symbol jednostki nadrz\u0119dnej", "Symbol stanowiska kierowniczego"};
        return headersOrder;
    }

    private List<Map<String, Object>> getStructure() {
        StructureHelper sh = (StructureHelper)SpringContext.getBean(StructureHelper.class);
        return sh.buildStructureMap();
    }

    private void setDataInTable(SessionFactory sf, List<Map<String, Object>> data, String tableName, String[] columns, Map<String, String> mappings) {
        HibernateQueryExecutor executor = new HibernateQueryExecutor();
        List<DMLQuery> inserts = this.buildInserts(tableName, data, columns, mappings);
        Session hs = null;
        Transaction tx = null;
        try {
            hs = sf.getCurrentSession();
            tx = hs.beginTransaction();
            this.deleteAllRows(executor, tableName, hs);
            this.insertRows(executor, hs, inserts);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    private void insertRows(HibernateQueryExecutor executor, Session hs, List<DMLQuery> inserts) {
        for (DMLQuery dmlQuery : inserts) {
            executor.executeUpdate(dmlQuery, hs);
        }
    }

    private void deleteAllRows(HibernateQueryExecutor executor, String tableName, Session hs) {
        DMLQuery deleteQuery = new DMLQuery();
        deleteQuery.setQuery("delete from " + tableName);
        executor.executeUpdate(deleteQuery, hs);
    }

    private List<DMLQuery> buildInserts(String tableName, List<Map<String, Object>> data, String[] columns, Map<String, String> mappings) {
        StringBuilder query = new StringBuilder("insert into ");
        query.append(tableName);
        query.append(" (");
        query.append(StringUtils.join((Object[])columns, (String)","));
        query.append(") values ( :");
        query.append(StringUtils.join((Object[])columns, (String)",:"));
        query.append(" ) ");
        String sQuery = query.toString();
        ArrayList<DMLQuery> inserts = new ArrayList<DMLQuery>();
        for (Map<String, Object> row : data) {
            DMLQuery q = new DMLQuery();
            q.setQuery(sQuery);
            q.setParameters(this.buildParameters(row, columns, mappings));
            inserts.add(q);
        }
        return inserts;
    }

    private List<ParamValue> buildParameters(Map<String, Object> row, String[] columns, Map<String, String> mappings) {
        ArrayList<ParamValue> params = new ArrayList<ParamValue>();
        for (String col : columns) {
            Object v = row.get(mappings.get(col));
            params.add(new ParamValue(col, v, SqlTypes.STRING));
        }
        return params;
    }

    private DatabaseConfig buildDBConfig(String dbType, String url, String port, String dbName, String userName, String password) {
        if (dbType.equalsIgnoreCase("PostgreSQL")) {
            String u = "jdbc:postgresql://" + url + ":" + port + "/" + dbName;
            return new PostgresConfig(u, userName, password);
        }
        if (dbType.equalsIgnoreCase("MSSQL")) {
            String u = "jdbc:sqlserver://" + url + ":" + port + ";useUnicode=true;characterEncoding=UTF-8";
            return new MSSqlConfig(u, userName, password);
        }
        if (dbType.equalsIgnoreCase("OracleDB")) {
            String u = "jdbc:oracle:thin:@" + url + ":" + port + ":" + dbName;
            return new OracleConfig(u, userName, password);
        }
        throw new IllegalArgumentException("Typ bazy danych nie jest wspierwany: " + dbType);
    }

    private String[] createColumns() {
        String[] columns = new String[]{"userid", "firstname", "lastname", "pass", "email", "usernumber", "groups", "posname", "possym", "higherpossym", "roles", "ou", "ousym", "higherousym", "dirpossym"};
        return columns;
    }

    private Map<String, String> createColumnMappings() {
        HashMap<String, String> cols = new HashMap<String, String>();
        cols.put("userid", "userName");
        cols.put("firstname", "firstName");
        cols.put("lastname", "lastName");
        cols.put("pass", "password");
        cols.put("email", "email");
        cols.put("usernumber", "number");
        cols.put("groups", "groups");
        cols.put("posname", "positionName");
        cols.put("possym", "positionSymbol");
        cols.put("higherpossym", "higherPositionSymbol");
        cols.put("roles", "roles");
        cols.put("ou", "organizationalUnitName");
        cols.put("ousym", "organizationalUnitSymbol");
        cols.put("higherousym", "higherOrganizationalUnitSymbol");
        cols.put("dirpossym", "directorPositionSymbol");
        return cols;
    }

    private String createExportTableQuery(String tableName, String[] cols) {
        StringBuilder query = new StringBuilder();
        query.append("create table ");
        query.append(tableName);
        query.append("( ");
        String c = QueryUtils.listToString(Arrays.asList(cols), " varchar(255),");
        query.append(c);
        query.append(" varchar(255),");
        query.append("primary key (username,position_symbol) ");
        query.append(" ) ");
        return query.toString();
    }

    public Double getProgress() {
        return this.progress;
    }
}

