/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.administartion.structure.internal;

import com.suncode.cuf.administartion.structure.StructureHelper;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureHelperImpl
implements StructureHelper {
    @Autowired
    private UserFinder userFinder;
    private String[] joins = new String[]{"positions", "positions.roles", "positions.higherPosition", "positions.organizationalUnit", "positions.organizationalUnit.higherOrganizationalUnit", "positions.organizationalUnit.directorPosition", "groups"};

    @Override
    public List<Map<String, Object>> buildStructureMap() {
        ArrayList<Map<String, Object>> m = new ArrayList<Map<String, Object>>();
        List users = this.userFinder.getAll(this.joins);
        for (User user : users) {
            HashMap<String, Object> o = new HashMap<String, Object>();
            o.put("userName", user.getUserName());
            o.put("firstName", user.getFirstName());
            o.put("lastName", user.getLastName());
            o.put("password", "");
            o.put("email", user.getEmail());
            o.put("number", user.getNumber());
            o.put("groups", this.joinGroupNames(user.getGroups()));
            if (user.getPositions().isEmpty()) {
                this.putEmptyPosition(o);
                m.add(o);
            }
            for (Position p : user.getPositions()) {
                HashMap<String, Object> uu = new HashMap<String, Object>();
                uu.putAll(o);
                uu.put("positionName", p.getName());
                uu.put("positionSymbol", p.getSymbol());
                uu.put("higherPositionSymbol", this.getHigherPositionSymbol(p));
                uu.put("organizationalUnitName", this.getOrganizationalUnitname(p));
                uu.put("organizationalUnitSymbol", this.getOrganizationalUnitSymbol(p));
                uu.put("higherOrganizationalUnitSymbol", this.getHigherOrganizationalUnitSymbol(p));
                uu.put("directorPositionSymbol", this.getDirectorPositionSymbol(p));
                uu.put("roles", this.joinRoleIds(p.getRoles()));
                m.add(uu);
            }
        }
        return m;
    }

    private void putEmptyPosition(Map<String, Object> uu) {
        uu.put("positionName", "");
        uu.put("positionSymbol", "");
        uu.put("higherPositionSymbol", "");
        uu.put("organizationalUnitName", "");
        uu.put("organizationalUnitSymbol", "");
        uu.put("higherOrganizationalUnitSymbol", "");
        uu.put("directorPositionSymbol", "");
        uu.put("roles", "");
    }

    private Object getOrganizationalUnitname(Position p) {
        if (p.getOrganizationalUnit() == null) {
            return "";
        }
        return p.getOrganizationalUnit().getName();
    }

    private String getDirectorPositionSymbol(Position p) {
        if (p.getOrganizationalUnit() == null || p.getOrganizationalUnit().getDirectorPosition() == null) {
            return "";
        }
        return p.getOrganizationalUnit().getDirectorPosition().getSymbol();
    }

    private String getHigherOrganizationalUnitSymbol(Position p) {
        if (p.getOrganizationalUnit() == null || p.getOrganizationalUnit().getHigherOrganizationalUnit() == null) {
            return "";
        }
        return p.getOrganizationalUnit().getHigherOrganizationalUnit().getSymbol();
    }

    private String getOrganizationalUnitSymbol(Position p) {
        if (p.getOrganizationalUnit() == null) {
            return "";
        }
        return p.getOrganizationalUnit().getSymbol();
    }

    private String getHigherPositionSymbol(Position p) {
        if (p.getHigherPosition() == null) {
            return "";
        }
        return p.getHigherPosition().getSymbol();
    }

    private String joinRoleIds(Set<Role> roles) {
        StringBuilder sb = new StringBuilder();
        for (Role role : roles) {
            sb.append(role.getPackageId());
            sb.append(":");
            sb.append(role.getProcessDefId());
            sb.append(":");
            sb.append(role.getRoleId());
            sb.append(";");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private String joinGroupNames(Set<UserGroup> groups) {
        StringBuilder sb = new StringBuilder();
        for (UserGroup group : groups) {
            sb.append(group.getName());
            sb.append(";");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

