/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.DBService;
import com.plusmpm.CUF.util.extension.ExcelReader;
import com.plusmpm.CUF.util.extension.ExtStructureService;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class ImportStructure
extends AbstractAdvancedTask {
    private static Logger log = Logger.getLogger(ImportStructure.class);
    private volatile double progress = 0.0;

    public Double getProgress() {
        return this.progress;
    }

    @AdvancedTask(name="importStructure", description="importStructure", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructure(@TaskParam(name="path_to_excel_file", description="path_to_excel_file") String path, @TaskParam(name="read_mode", description="read_mode_desc") String mode) throws Exception {
        ExtStructureService ss = new ExtStructureService();
        ExcelReader er = new ExcelReader();
        String[] headers = new String[]{"Login", "Imi\u0119", "Nazwisko", "Has\u0142o", "Email", "Nr", "Grupy", "Nazwa stanowiska", "Symbol stanowiska", "Symbol stanowiska nadrz\u0119dnego", "Role", "Nazwa jednostki organizacyjnej", "Symbol jednostki organizacyjnej", "Symbol jednostki nadrz\u0119dnej", "Symbol stanowiska kierowniczego"};
        HashMap<String, Class> types = new HashMap<String, Class>();
        types.put("Nr", Integer.class);
        er.setExcelTypes(types);
        try {
            List<Map<String, Object>> struct = er.readExcel(path, Arrays.asList(headers));
            this.progress = 0.2;
            ss.validateData(struct);
            this.progress = 0.4;
            ss.setMode(mode);
            ss.readStructure(struct);
            this.progress = 1.0;
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
        }
    }

    @AdvancedTask(name="importStructureFromDb", description="importStructureFromDb", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructureFromDb(@TaskParam(name="dbtype", description="dbtype_desc") String dbType, @TaskParam(name="dburl", description="dburl") String url, @TaskParam(name="dbport", description="dbport") String port, @TaskParam(name="dbname", description="dbname") String dbName, @TaskParam(name="tablename", description="tablename") String tableName, @TaskParam(name="dbusername", description="dbusername") String userName, @TaskParam(name="dbpass", description="dbpass") String password, @TaskParam(name="read_mode", description="read_mode_desc") String mode) throws Exception {
        DBService dbs = new DBService();
        SessionFactory sf = dbs.getCustomSessionFactory(dbType, url, port, dbName, userName, password);
        dbs.setSessionFactory(sf);
        List<Map<String, Object>> data = dbs.getDataFromTable(tableName);
        ExtStructureService ss = new ExtStructureService();
        HashMap<String, String> headersMapping = new HashMap<String, String>();
        headersMapping.put("userid", "userid");
        headersMapping.put("firstname", "firstname");
        headersMapping.put("lastname", "lastname");
        headersMapping.put("pass", "pass");
        headersMapping.put("email", "email");
        headersMapping.put("usernumber", "usernumber");
        headersMapping.put("groups", "groups");
        headersMapping.put("posname", "posname");
        headersMapping.put("possym", "possym");
        headersMapping.put("higherpossym", "higherpossym");
        headersMapping.put("roles", "roles");
        headersMapping.put("ou", "ou");
        headersMapping.put("ousym", "ousym");
        headersMapping.put("higherousym", "higherousym");
        headersMapping.put("dirpossym", "dirpossym");
        try {
            ss.setHeaderMapping(headersMapping);
            ss.validateData(data);
            ss.setMode(mode);
            ss.readStructure(data);
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
        }
    }

    @AdvancedTask(name="importStructureFromDb", description="importStructureFromDb", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void importStructureFromDb(@TaskParam(name="dbtype", description="dbtype_desc") String dbType, @TaskParam(name="dburl", description="dburl") String url, @TaskParam(name="dbport", description="dbport") String port, @TaskParam(name="dbname", description="dbname") String dbName, @TaskParam(name="tablename", description="tablename") String tableName, @TaskParam(name="dbusername", description="dbusername") String userName, @TaskParam(name="dbpass", description="dbpass") String password, @TaskParam(name="read_mode", description="read_mode_desc") String mode, @TaskParam(name="columns", description="columns") String columns) throws Exception {
        DBService dbs = new DBService();
        SessionFactory sf = dbs.getCustomSessionFactory(dbType, url, port, dbName, userName, password);
        dbs.setSessionFactory(sf);
        List<Map<String, Object>> data = dbs.getDataFromTable(tableName);
        ExtStructureService ss = new ExtStructureService();
        HashMap<String, String> headersMapping = new HashMap<String, String>();
        String[] cols = columns.split(";");
        headersMapping.put("userid", cols[0]);
        headersMapping.put("firstname", cols[1]);
        headersMapping.put("lastname", cols[2]);
        headersMapping.put("pass", cols[3]);
        headersMapping.put("email", cols[4]);
        headersMapping.put("usernumber", cols[5]);
        headersMapping.put("groups", cols[6]);
        headersMapping.put("posname", cols[7]);
        headersMapping.put("possym", cols[8]);
        headersMapping.put("higherpossym", cols[9]);
        headersMapping.put("roles", cols[10]);
        headersMapping.put("ou", cols[11]);
        headersMapping.put("ousym", cols[12]);
        headersMapping.put("higherousym", cols[13]);
        headersMapping.put("dirpossym", cols[14]);
        try {
            ss.setHeaderMapping(headersMapping);
            ss.validateData(data);
            ss.setMode(mode);
            ss.readStructure(data);
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
        }
    }
}

