/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.i18n;

import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.stereotype.Component;

@Component
public class MessageHelperBean {
    private MessageSource messageSource;
    private MessageSourceAccessor messageSourceAccessor;

    @Autowired
    public MessageHelperBean(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource);
    }

    public String getMessage(String code) {
        return this.messageSourceAccessor.getMessage(code);
    }

    public String getMessage(String code, Object ... args) {
        return this.messageSourceAccessor.getMessage(code, args);
    }

    public String getMessage(String code, Locale locale, Object ... args) {
        return this.messageSourceAccessor.getMessage(code, args, locale);
    }

    public String getOptionalMessage(String code) {
        try {
            return this.messageSourceAccessor.getMessage(code);
        }
        catch (NoSuchMessageException e) {
            return code;
        }
    }

    public String getOptionalMessage(String code, Object ... args) {
        try {
            return this.messageSourceAccessor.getMessage(code, args);
        }
        catch (NoSuchMessageException e) {
            return code;
        }
    }

    public String getOptionalMessage(String code, Locale locale, Object ... args) {
        try {
            return this.messageSourceAccessor.getMessage(code, args, locale);
        }
        catch (NoSuchMessageException e) {
            return code;
        }
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public MessageSourceAccessor getMessageSourceAccessor() {
        return this.messageSourceAccessor;
    }
}

