/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class DateTimeType
extends JsonTypeBase<LocalDateTime> {
    public static final DateTimeType INSTANCE = new DateTimeType();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").toFormatter();

    private DateTimeType() {
        super(LocalDateTime.class, null);
        this.aliasType(Date.class, new TypeBase.Convert<Date, LocalDateTime>(){

            @Override
            public Date fromBase(LocalDateTime value) {
                return value.toDate();
            }

            @Override
            public LocalDateTime toBase(Date value) {
                return LocalDateTime.fromDateFields((Date)value);
            }
        });
        this.converter(String.class, new TypeBase.Convert<String, LocalDateTime>(){

            @Override
            public String fromBase(LocalDateTime value) {
                return value.toString(DATE_TIME_FORMATTER);
            }

            @Override
            public LocalDateTime toBase(String value) {
                return DateTimeType.this.convert(value);
            }
        });
    }

    @Override
    public String name() {
        return "datetime";
    }

    @Override
    public String translationKey() {
        return "Data_i_czas";
    }

    @Override
    protected JsonNode serializeNonNullValue(LocalDateTime value) {
        return TextNode.valueOf((String)this.readAs(value, String.class));
    }

    @Override
    protected LocalDateTime deserializeNonEmptyNode(JsonNode json) {
        return json.isNumber() ? new LocalDateTime(json.asLong()) : LocalDateTime.parse((String)json.asText(), (DateTimeFormatter)DATE_TIME_FORMATTER);
    }

    @Override
    public LocalDateTime convert(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (this.timeInMillis(value)) {
            return new LocalDateTime(Long.parseLong(value));
        }
        return LocalDateTime.parse((String)value, (DateTimeFormatter)DATE_TIME_FORMATTER);
    }

    private boolean timeInMillis(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

